/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.MarkerFillProperties;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IMarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;

public class MarkerFill
extends AbstractTypeSymbolEditor
implements ActionListener,
ChangeListener {
    private final ArrayList<JPanel> tabs = new ArrayList();
    private ColorChooserPanel markerCC;
    private JButton btnChooseMarker;
    private final MarkerFillProperties panelStyle = new MarkerFillProperties();
    private JRadioButton rdGrid;
    private JRadioButton rdRandom;
    private IMarkerSymbol marker = SymbologyLocator.getSymbologyManager().createSimpleMarkerSymbol();
    private JNumberSpinner txtOutlineWidth;
    private JSymbolPreviewButton btnOutline;
    private JSlider sldOutlineTransparency;
    private int outlineAlpha = 255;
    private ILineSymbol outline;
    private JCheckBox useBorder;

    public MarkerFill(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        JPanel myTab = new JPanel(new FlowLayout(0, 10, 10));
        myTab.setName(Messages.getText((String)"marker_fill"));
        GridBagLayoutPanel p = new GridBagLayoutPanel();
        JPanel aux = new JPanel(new FlowLayout(3, 5, 5));
        this.markerCC = new ColorChooserPanel(true);
        this.markerCC.setAlpha(255);
        this.markerCC.addActionListener((ActionListener)this);
        aux.add((Component)this.markerCC);
        p.addComponent(Messages.getText((String)"Color") + ":", (Component)aux);
        this.btnChooseMarker = new JButton(Messages.getText((String)"choose_marker"));
        this.btnChooseMarker.addActionListener((ActionListener)this);
        aux = new JPanel(new FlowLayout(3, 5, 5));
        aux.add((Component)this.btnChooseMarker);
        p.addComponent("", (Component)aux);
        ButtonGroup group = new ButtonGroup();
        this.rdGrid = new JRadioButton(Messages.getText((String)"grid"));
        this.rdGrid.addActionListener(this);
        this.rdRandom = new JRadioButton(Messages.getText((String)"random"));
        this.rdRandom.addActionListener(this);
        group.add(this.rdGrid);
        group.add(this.rdRandom);
        aux = new JPanel(new FlowLayout(3, 5, 5));
        aux.add(this.rdGrid);
        aux.add(this.rdRandom);
        this.rdGrid.setSelected(true);
        p.addComponent("", (Component)aux);
        JPanel myTab2 = new JPanel(new FlowLayout(3, 5, 5));
        GridBagLayoutPanel aux3 = new GridBagLayoutPanel();
        JPanel aux2 = new JPanel();
        this.btnOutline = new JSymbolPreviewButton(2);
        this.btnOutline.setPreferredSize(new Dimension(100, 35));
        aux2.add(this.btnOutline);
        aux3.addComponent((Component)new JBlank(10, 10));
        this.useBorder = new JCheckBox(Messages.getText((String)"use_outline"));
        aux3.addComponent((Component)this.useBorder, (Component)aux2);
        aux3.addComponent((Component)new JBlank(10, 10));
        this.sldOutlineTransparency = new JSlider();
        this.sldOutlineTransparency.setValue(100);
        aux3.addComponent(Messages.getText((String)"outline") + ":", (Component)aux2);
        aux3.addComponent(Messages.getText((String)"outline_opacity") + ":", (Component)this.sldOutlineTransparency);
        this.txtOutlineWidth = new JNumberSpinner(0.0, 25, 0.0, Double.MAX_VALUE, 1.0, 2);
        aux3.addComponent(Messages.getText((String)"outline_width") + ":", (Component)this.txtOutlineWidth);
        myTab2.add((Component)aux3);
        p.addComponent("", (Component)myTab2);
        myTab.add((Component)p);
        this.useBorder.addActionListener(this);
        this.btnOutline.addActionListener(this);
        this.txtOutlineWidth.addActionListener((ActionListener)this);
        this.sldOutlineTransparency.addChangeListener(this);
        this.tabs.add(myTab);
        this.tabs.add(this.panelStyle);
        this.panelStyle.addActionListener(this);
    }

    @Override
    public void refreshControls(ISymbol layer) {
        if (layer == null) {
            System.err.println(this.getClass().getName() + ":: should be unreachable code");
            this.markerCC.setColor(Color.BLACK);
            this.rdGrid.setSelected(true);
            this.rdRandom.setSelected(false);
        } else {
            if (layer instanceof IMarkerFillSymbol) {
                IMarkerFillSymbol mfs = (IMarkerFillSymbol)layer;
                int fillStyle = mfs.getMarkerFillProperties().getFillStyle();
                this.marker = mfs.getMarker();
                this.rdGrid.setSelected(fillStyle == 1);
                this.rdRandom.setSelected(fillStyle == 3);
                this.panelStyle.setModel(mfs.getMarkerFillProperties());
                this.markerCC.setColor(mfs.getFillColor());
            }
            if (layer instanceof IFillSymbol) {
                IFillSymbol fs = (IFillSymbol)layer;
                this.sldOutlineTransparency.removeChangeListener(this);
                this.outline = fs.getOutline();
                this.btnOutline.setSymbol((ISymbol)this.outline);
                this.useBorder.setSelected(fs.hasOutline());
                if (this.outline != null) {
                    this.outlineAlpha = this.outline.getAlpha();
                    this.sldOutlineTransparency.setValue((int)((double)this.outlineAlpha / 255.0 * 100.0));
                    this.txtOutlineWidth.setDouble(this.outline.getLineWidth());
                } else {
                    this.sldOutlineTransparency.setValue(100);
                }
                this.sldOutlineTransparency.addChangeListener(this);
            }
        }
    }

    @Override
    public String getName() {
        return Messages.getText((String)"marker_fill_symbol");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ILineSymbol theOutline;
        ISymbol sym;
        JComponent comp = (JComponent)e.getSource();
        if (comp.equals(this.btnChooseMarker)) {
            ISymbolSelector symSelect = SymbolSelector.createSymbolSelector(this.marker, 1);
            PluginServices.getMDIManager().addWindow((IWindow)symSelect);
            this.marker = (IMarkerSymbol)symSelect.getSelectedObject();
            if (this.marker == null) {
                return;
            }
        }
        if (!(this.marker instanceof IMultiLayerSymbol)) {
            this.marker.setColor(this.markerCC.getColor());
        }
        if (comp.equals(this.btnOutline) && (sym = this.btnOutline.getSymbol()) instanceof ILineSymbol && (theOutline = (ILineSymbol)sym) != null) {
            this.txtOutlineWidth.setDouble(theOutline.getLineWidth());
        }
        this.fireSymbolChangedEvent();
    }

    @Override
    public ISymbol getLayer() {
        IMarkerFillSymbol mfs = SymbologyLocator.getSymbologyManager().createMarkerFillSymbol();
        IMarkerFillPropertiesStyle prop = this.panelStyle.getMarkerFillProperties();
        prop.setFillStyle(this.rdGrid.isSelected() ? 1 : 3);
        try {
            IMarkerSymbol myMarker = (IMarkerSymbol)this.marker.clone();
            mfs.setMarker(myMarker);
        }
        catch (CloneNotSupportedException e) {
            NotificationManager.addWarning((String)"Marker Symbol does not support cloning", (Throwable)e);
        }
        mfs.setFillColor(this.markerCC.getColor());
        mfs.setMarkerFillProperties(prop);
        mfs.setHasOutline(this.useBorder.isSelected());
        this.outline = (ILineSymbol)this.btnOutline.getSymbol();
        if (this.outline != null) {
            this.outline.setLineWidth(this.txtOutlineWidth.getDouble());
            this.outline.setAlpha(this.outlineAlpha);
        }
        mfs.setOutline(this.outline);
        return mfs;
    }

    @Override
    public EditorTool[] getEditorTools() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object s = e.getSource();
        if (s.equals(this.sldOutlineTransparency)) {
            this.outlineAlpha = (int)(255.0 * ((double)this.sldOutlineTransparency.getValue() / 100.0));
        }
        this.outline = (ILineSymbol)this.btnOutline.getSymbol();
        this.fireSymbolChangedEvent();
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof IMarkerFillSymbol;
    }
}

