/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.PictureMarkerView;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureMarker
extends AbstractTypeSymbolEditor
implements ActionListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PictureMarker.class);
    public static final double MARKER_IMAGE_DEFAULT_WIDTH = 18.0;
    protected final PictureMarkerView view = new PictureMarkerView();
    protected List<JPanel> tabs = new ArrayList<JPanel>();
    private FilePickerController picturePicker;
    private FilePickerController selectedPicturePicker;
    protected ColorPickerController colorLinePicker;
    protected ExpressionPickerController xoffsetExpPicker;
    protected ExpressionPickerController yoffsetExpPicker;
    protected ExpressionPickerController rotationExpPicker;
    protected ExpressionPickerController colorExpPicker;
    private ExpressionPickerController sizeExpPicker;

    public PictureMarker(SymbolEditor owner) {
        super(owner);
        this.initComponents();
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.view.lblLabelFileName);
        toolsSwingManager.translate(this.view.lblLabelRotationExpression);
        toolsSwingManager.translate(this.view.lblLabelSelFileName);
        toolsSwingManager.translate(this.view.lblLabelSize);
        toolsSwingManager.translate(this.view.lblLabelRotation);
        toolsSwingManager.translate(this.view.lblLabelX);
        toolsSwingManager.translate(this.view.lblLabelXExpression);
        toolsSwingManager.translate(this.view.lblLabelY);
        toolsSwingManager.translate(this.view.lblLabelYExpression);
        toolsSwingManager.translate((AbstractButton)this.view.chkDrawLineToOffset);
        toolsSwingManager.translate(this.view.lblColorLine);
        toolsSwingManager.translate(this.view.lblLabelSizeExpression);
        toolsSwingManager.translate(this.view.lblLabelXExpression);
        toolsSwingManager.translate(this.view.lblLabelYExpression);
        toolsSwingManager.translate(this.view.lblLabelRotationExpression);
        toolsSwingManager.translate(this.view.lblColorLineExpression);
    }

    protected void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.translate();
        this.picturePicker = toolsSwingManager.createFilePickerController((JTextComponent)this.view.txtPictureFile, this.view.btnPictureFile, null, "PictureMarkerFiles", null, true);
        JPopupMenu menu = this.view.txtPictureFile.getComponentPopupMenu();
        menu.add(expressionSwingManager.createJExpressionBuilderAction((JTextComponent)this.view.txtPictureFile));
        menu.add(expressionSwingManager.createUniqueTemporalFileAction((JTextComponent)this.view.txtPictureFile, "picture", ".png"));
        this.selectedPicturePicker = toolsSwingManager.createFilePickerController((JTextComponent)this.view.txtSelPictureFile, this.view.btnSelPictureFile, null, "PictureMarkerFiles", null, true);
        menu = this.view.txtSelPictureFile.getComponentPopupMenu();
        menu.add(expressionSwingManager.createJExpressionBuilderAction((JTextComponent)this.view.txtSelPictureFile));
        menu.add(expressionSwingManager.createUniqueTemporalFileAction((JTextComponent)this.view.txtSelPictureFile, "picture", ".png"));
        this.picturePicker.addChangeListener(e -> {
            if (this.picturePicker.get() == null) {
                this.selectedPicturePicker.setEnabled(false);
            }
        });
        this.view.txtSize.setModel(new SpinnerNumberModel(5.0, 0.0, Double.POSITIVE_INFINITY, 0.5));
        this.view.txtRotation.setModel(new SpinnerNumberModel(0.0, 0.0, 360.0, 0.5));
        this.view.txtX.setModel(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.view.txtY.setModel(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.colorLinePicker = toolsSwingManager.createColorPickerController((JTextComponent)this.view.txtColorLine, this.view.btnColorLine);
        this.view.txtSizeExp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PictureMarker.this.doSizeExpChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PictureMarker.this.doSizeExpChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PictureMarker.this.doSizeExpChange();
            }
        });
        this.sizeExpPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.view.txtSizeExp, this.view.btnSizeExpression, this.view.btnSizeExpressionBookmarks, this.view.btnSizeExpressionHistory);
        this.xoffsetExpPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.view.txtXOffset, this.view.btnXOffsetExpression, this.view.btnXOffsetExpressionBookmarks, this.view.btnXOffsetExpressionHistory);
        this.yoffsetExpPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.view.txtYOffset, this.view.btnYOffsetExpression, this.view.btnYOffsetExpressionBookmarks, this.view.btnYOffsetExpressionHistory);
        this.rotationExpPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.view.txtRotationExp, this.view.btnRotationExpression, this.view.btnRotationExpressionBookmarks, this.view.btnRotationExpressionHistory);
        this.colorExpPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.view.txtColorLineExp, this.view.btnColorLineExpression, this.view.btnColorLineExpressionBookmarks, this.view.btnColorLineExpressionHistory);
        this.picturePicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.selectedPicturePicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.txtSize.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.txtRotation.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.txtX.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.txtY.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.colorLinePicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.chkDrawLineToOffset.addItemListener(e -> this.fireSymbolChangedEvent());
        this.sizeExpPicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.xoffsetExpPicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.yoffsetExpPicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.rotationExpPicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.colorExpPicker.addChangeListener(e -> this.fireSymbolChangedEvent());
        this.view.setName(this.getName());
        this.tabs.add(this.view);
    }

    private void doSizeExpChange() {
        String txt = this.view.txtSizeExp.getText();
        this.view.txtSize.setEnabled(StringUtils.isBlank((CharSequence)txt));
    }

    @Override
    public ISymbol getLayer() {
        try {
            IPictureMarkerSymbol layer = null;
            if (this.getPictureFile() != null) {
                SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
                layer = symbologyManager.createPictureMarkerSymbol(this.getPictureURL(), this.getSelectedPictureURL());
                layer.setFeature(this.getSampleFeature());
                layer.setSize(this.getSize());
                layer.setOffset((Point2D)new Point2D.Double(this.getX(), this.getY()));
                layer.setLineToOffsetColor(this.getLineToOffsetColor());
                layer.setDrawLineToOffset(this.isSelectedDrawLineToOffset());
                layer.setRotation(Math.toRadians(this.getRotation()));
                layer.setLineToOffsetColorExpression(this.getPhrase(this.getLineToOffsetColorExpression()));
                layer.setOffsetXExpression(this.getPhrase(this.getXOffsetExpression()));
                layer.setOffsetYExpression(this.getPhrase(this.getYOffsetExpression()));
                layer.setRotationExpression(this.getPhrase(this.getRotationExpression()));
                layer.setSizeExpression(this.getPhrase(this.getSizeExpression()));
            }
            return layer;
        }
        catch (Exception e) {
            IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, Messages.getText((String)"failed_acessing_files"), 0);
            return warning;
        }
    }

    protected Color getLineToOffsetColor() {
        return (Color)this.colorLinePicker.get();
    }

    protected boolean isSelectedDrawLineToOffset() {
        return this.view.chkDrawLineToOffset.isSelected();
    }

    protected Expression getSizeExpression() {
        return this.sizeExpPicker.get();
    }

    protected Expression getYOffsetExpression() {
        return this.yoffsetExpPicker.get();
    }

    protected Expression getLineToOffsetColorExpression() {
        return this.colorExpPicker.get();
    }

    protected Expression getXOffsetExpression() {
        return this.xoffsetExpPicker.get();
    }

    protected Expression getRotationExpression() {
        return this.rotationExpPicker.get();
    }

    private String getPhrase(Expression expression) {
        if (expression == null) {
            return null;
        }
        return expression.getPhrase();
    }

    @Override
    public String getName() {
        return Messages.getText((String)"picture_marker_symbol");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[this.tabs.size()]);
    }

    @Override
    public void refreshControls(ISymbol layer) {
        try {
            if (layer == null) {
                this.setValues(1.0, 0.0, 0.0, null, null, "", "", "", null, "", "", false);
            } else {
                IPictureMarkerSymbol sym = (IPictureMarkerSymbol)layer;
                this.setValues(sym.getSize(), sym.getRotation(), sym.getOffset().getX(), sym.getOffset().getY(), sym.getSource(), sym.getSelectedSource(), sym.getSizeExpression(), sym.getOffsetXExpression(), sym.getOffsetYExpression(), sym.getLineToOffsetColor(), sym.getLineToOffsetColorExpression(), sym.getRotationExpression(), sym.isDrawLineToOffset());
                this.fireSymbolChangedEvent();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't refresh picture marker symbol panel.", (Throwable)ex);
        }
    }

    protected void setValues(double size, double xOffset, double yOffset, URL picture, URL selectedPicture, String sizeExpression, String offsetXExpression, String offsetYExpression, Color lineToOffsetColor, String lineToOffsetColorExpression, String rotationExpression, boolean isDrawLineToOffset) {
        this.setValues(size, 0.0, xOffset, yOffset, picture, selectedPicture, sizeExpression, offsetXExpression, offsetYExpression, lineToOffsetColor, lineToOffsetColorExpression, rotationExpression, isDrawLineToOffset);
    }

    protected void setValues(double size, double rotation, double xOffset, double yOffset, URL picture, URL selectedPicture, String sizeExpression, String offsetXExpression, String offsetYExpression, Color lineToOffsetColor, String lineToOffsetColorExpression, String rotationExpression, boolean isDrawLineToOffset) {
        this.setSize(size);
        this.setRotation(Math.toDegrees(rotation));
        this.setX(xOffset);
        this.setY(yOffset);
        this.setPicture(picture);
        this.setSelectedPicture(selectedPicture);
        this.sizeExpPicker.coerceAndSet((Object)sizeExpression);
        this.xoffsetExpPicker.coerceAndSet((Object)offsetXExpression);
        this.yoffsetExpPicker.coerceAndSet((Object)offsetYExpression);
        this.rotationExpPicker.coerceAndSet((Object)rotationExpression);
        this.colorLinePicker.coerceAndSet((Object)lineToOffsetColor);
        this.colorExpPicker.coerceAndSet((Object)lineToOffsetColorExpression);
        this.view.chkDrawLineToOffset.setSelected(isDrawLineToOffset);
    }

    @Override
    public EditorTool[] getEditorTools() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof IPictureMarkerSymbol;
    }

    protected String getPictureFileName() {
        File f = (File)this.picturePicker.get();
        if (f == null) {
            return null;
        }
        return f.getAbsolutePath();
    }

    protected String getSelectedPictureFileName() {
        File f = (File)this.selectedPicturePicker.get();
        if (f == null) {
            return null;
        }
        return f.getAbsolutePath();
    }

    protected URL getPictureURL() {
        return URLUtils.toURL((File)((File)this.picturePicker.get()));
    }

    protected URL getSelectedPictureURL() {
        return URLUtils.toURL((File)((File)this.selectedPicturePicker.get()));
    }

    protected File getPictureFile() {
        File f = (File)this.picturePicker.get();
        return f;
    }

    protected File getSelectedPictureFile() {
        File f = (File)this.selectedPicturePicker.get();
        return f;
    }

    protected double getSize() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtSize.getModel();
        return model.getNumber().doubleValue();
    }

    protected double getRotation() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtRotation.getModel();
        return model.getNumber().doubleValue();
    }

    protected double getX() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtX.getModel();
        return model.getNumber().doubleValue();
    }

    protected double getY() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtY.getModel();
        return model.getNumber().doubleValue();
    }

    protected void setPicture(URL picture) {
        this.picturePicker.set((Object)URLUtils.toFile((URL)picture));
    }

    protected void setSelectedPicture(URL selectedPicture) {
        this.selectedPicturePicker.set((Object)URLUtils.toFile((URL)selectedPicture));
    }

    protected void setSize(double d) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtSize.getModel();
        model.setValue(d);
    }

    protected void setRotation(double degrees) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtRotation.getModel();
        model.setValue(degrees);
    }

    protected void setX(double d) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtX.getModel();
        model.setValue(d);
    }

    protected void setY(double d) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.view.txtY.getModel();
        model.setValue(d);
    }

    protected Color getColorLine() {
        return (Color)this.colorLinePicker.get();
    }

    protected void setColorLine(Color color) {
        this.colorLinePicker.set((Object)color);
    }

    @Override
    public void setFeatureStore(FeatureStore store) {
        if (store == null) {
            return;
        }
        super.setFeatureStore(store);
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        dataSwingManager.configureExpressionBuilder(this.xoffsetExpPicker.getConfig(), store);
        dataSwingManager.configureExpressionBuilder(this.yoffsetExpPicker.getConfig(), store);
        dataSwingManager.configureExpressionBuilder(this.rotationExpPicker.getConfig(), store);
    }
}

