/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.JComboBoxSimpleMarkeStyles;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;

public class SimpleMarker
extends AbstractTypeSymbolEditor
implements ActionListener,
FocusListener {
    private final ArrayList tabs = new ArrayList();
    private ColorChooserPanel jccColor;
    private JNumberSpinner txtSize;
    private JNumberSpinner txtXOffset;
    private JNumberSpinner txtYOffset;
    private JComboBoxSimpleMarkeStyles cmbStyle;
    private JCheckBox chkUseOutline;
    private ColorChooserPanel jccOutlineColor;

    public SimpleMarker(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        JPanel myTab = new JPanel(new FlowLayout(3, 5, 5));
        myTab.setName(Messages.getText((String)"simple_marker"));
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        this.jccColor = new ColorChooserPanel(true);
        this.jccColor.setAlpha(255);
        aux.addComponent(Messages.getText((String)"Color") + ":", (Component)this.jccColor);
        this.txtSize = new JNumberSpinner(5.0, 25, 0.0, Double.MAX_VALUE, 1.0, 2);
        aux.addComponent(Messages.getText((String)"size") + ":", (Component)this.txtSize);
        this.txtXOffset = new JNumberSpinner(0.0, 25, 0.0, Double.MAX_VALUE, 1.0, 2);
        aux.addComponent(Messages.getText((String)"x_offset") + ":", (Component)this.txtXOffset);
        this.txtYOffset = new JNumberSpinner(0.0, 25, 0.0, Double.MAX_VALUE, 1.0, 2);
        aux.addComponent(Messages.getText((String)"y_offset") + ":", (Component)this.txtYOffset);
        this.cmbStyle = new JComboBoxSimpleMarkeStyles();
        aux.addComponent(Messages.getText((String)"marker_style") + ":", (Component)this.cmbStyle);
        this.chkUseOutline = new JCheckBox(Messages.getText((String)"use_outline"));
        aux.addComponent((Component)this.chkUseOutline);
        this.jccOutlineColor = new ColorChooserPanel(true);
        this.jccOutlineColor.setAlpha(255);
        aux.addComponent(Messages.getText((String)"outline_color"), (Component)this.jccOutlineColor);
        aux.setPreferredSize(new Dimension(300, 300));
        myTab.add((Component)aux);
        this.jccColor.setColor(Color.BLACK);
        this.cmbStyle.setSymbolColor(this.jccColor.getColor());
        this.jccColor.addActionListener((ActionListener)this);
        this.txtSize.addActionListener((ActionListener)this);
        this.txtSize.addFocusListener((FocusListener)this);
        this.txtXOffset.addActionListener((ActionListener)this);
        this.txtXOffset.addFocusListener((FocusListener)this);
        this.txtYOffset.addActionListener((ActionListener)this);
        this.txtYOffset.addFocusListener((FocusListener)this);
        this.cmbStyle.addActionListener(this);
        this.chkUseOutline.addActionListener(this);
        this.jccOutlineColor.addActionListener((ActionListener)this);
        this.tabs.add(myTab);
    }

    @Override
    public ISymbol getLayer() {
        ISimpleMarkerSymbol layer = SymbologyLocator.getSymbologyManager().createSimpleMarkerSymbol();
        layer.setColor(this.jccColor.getColor());
        layer.setSize(this.txtSize.getDouble());
        layer.setOffset((Point2D)new Point2D.Double(this.txtXOffset.getDouble(), this.txtYOffset.getDouble()));
        layer.setStyle(((Integer)this.cmbStyle.getSelectedItem()).intValue());
        layer.setOutlined(this.chkUseOutline.isSelected());
        layer.setOutlineColor(this.jccOutlineColor.getColor());
        return layer;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"simple_marker_symbol");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[0]);
    }

    @Override
    public void refreshControls(ISymbol layer) {
        try {
            if (layer == null) {
                System.err.println("SimpleLine.java:: should be unreachable code");
                this.jccColor.setColor(Color.BLACK);
                this.txtSize.setDouble(1.0);
                this.txtXOffset.setDouble(0.0);
                this.txtYOffset.setDouble(0.0);
            } else {
                ISimpleMarkerSymbol sym = (ISimpleMarkerSymbol)layer;
                this.jccColor.setColor(sym.getColor());
                this.txtSize.setDouble(sym.getSize());
                this.txtXOffset.setDouble(sym.getOffset().getX());
                this.txtYOffset.setDouble(sym.getOffset().getY());
                this.cmbStyle.setSymbolColor(sym.getColor());
                this.chkUseOutline.setSelected(sym.hasOutline());
                this.cmbStyle.setOutlineColor(sym.getOutlineColor());
                this.cmbStyle.setSelectedItem(sym.getStyle());
            }
        }
        catch (IndexOutOfBoundsException ioEx) {
            NotificationManager.addWarning((String)"Symbol layer index out of bounds", (Throwable)ioEx);
        }
        catch (ClassCastException ccEx) {
            NotificationManager.addWarning((String)("Illegal casting from " + layer.getClass().getName() + " to ISimpleMarkerSymbol."), (Throwable)ccEx);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireSymbolChangedEvent();
    }

    @Override
    public EditorTool[] getEditorTools() {
        return null;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireSymbolChangedEvent();
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof ISimpleMarkerSymbol;
    }
}

