/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.i18n.Messages;

public class JSymbolPreviewButton
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = -7878718124556977288L;
    private ISymbol prev;
    private boolean pressed;
    private int shapeType;
    private ArrayList<ActionListener> listeners;
    private ActionEvent event;
    private String actionCommand;

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public JSymbolPreviewButton(int shapeType) {
        this(null, shapeType);
    }

    public JSymbolPreviewButton(ISymbol sym, int shapeType) {
        this.addMouseListener(this);
        this.mouseExited(null);
        this.setPreferredSize(new Dimension(150, 20));
        this.shapeType = shapeType;
        this.prev = sym;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        if (g2 != null) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(this.pressed && this.isEnabled() ? Color.GRAY : Color.WHITE);
            g2.drawLine(0, 0, (int)bounds.getWidth(), 0);
            g2.drawLine(0, 0, 0, (int)bounds.getHeight());
            g2.setColor(this.pressed && this.isEnabled() ? Color.WHITE : Color.GRAY);
            g2.drawLine(2, (int)bounds.getHeight(), (int)bounds.getWidth(), (int)bounds.getHeight());
            g2.drawLine((int)bounds.getWidth(), 0, (int)bounds.getWidth(), (int)bounds.getHeight());
            int _margin = 5;
            Rectangle2D.Double r = new Rectangle2D.Double(_margin, _margin, bounds.getWidth() - (double)(2 * _margin), bounds.getHeight() - (double)(2 * _margin));
            if (this.prev != null) {
                try {
                    this.prev.drawInsideRectangle(g2, new AffineTransform(), r.getBounds());
                }
                catch (SymbolDrawingException e) {
                    if (e.getType() == 0) {
                        try {
                            MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, this.prev.getDescription(), 0).drawInsideRectangle(g2, g2.getTransform(), r.getBounds());
                        }
                        catch (SymbolDrawingException symbolDrawingException) {}
                    }
                    throw new Error(Messages.getText((String)"symbol_shapetype_mismatch"));
                }
            }
        }
    }

    public void setSymbol(ISymbol symbol) {
        this.prev = symbol;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            ISymbolSelector sSelect = SymbolSelector.createSymbolSelector(this.prev, this.shapeType);
            PluginServices.getMDIManager().addWindow((IWindow)sSelect);
            if (sSelect.getSelectedObject() != null) {
                this.setSymbol((ISymbol)sSelect.getSelectedObject());
                this.fireActionListeners();
            }
        }
    }

    private void fireActionListeners() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.listeners != null) {
            if (this.event == null) {
                this.event = new ActionEvent(this, 0, this.actionCommand);
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).actionPerformed(this.event);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.pressed = false;
        this.paintImmediately(this.getBounds());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.pressed = true;
        this.paintImmediately(this.getBounds());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pressed) {
            this.mouseClicked(e);
        }
        this.mouseExited(e);
    }

    public ISymbol getSymbol() {
        return this.prev;
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
    }
}

