/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributesSelectionPanel;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.swing.api.JReportBuilder;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.report.swing.impl.ReportSwingImplLibrary;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportBuilderView;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportColumnBuilderController;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportGroupController;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportStyleBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.tools.util.ToolsUtilLocator;

public class DefaultJReportBuilder
extends DefaultJReportBuilderView
implements JReportBuilder {
    private ExpressionPickerController pickerColumnExpression;
    private final ReportSwingManager manager;
    private BookmarksController bookmarksController;
    private HistoryController historyController;
    private FeatureType featureType;
    private DefaultJReportColumnBuilderController columnController;
    private ReportBuilder.StyleBuilder styleTitle;
    private ReportBuilder.StyleBuilder styleSubtitle;
    private DefaultJReportGroupController groupController;
    private ReportBuilder.GroupBuilder actualGroupBuilder;
    private ReportBuilder.ColumnBuilder actualColumnBuilder;
    private FeatureQuery featureQuery;

    public DefaultJReportBuilder(ReportSwingManager manager) {
        this.manager = manager;
        this.featureQuery = null;
        this.initComponent();
    }

    public void setFeatureQuery(FeatureQuery featureQuery) {
        this.featureQuery = featureQuery;
    }

    public boolean checkPanel(StringBuilder msg) {
        int r;
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (this.hasChangesNotSaved() && (r = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_Changes_has_not_been_saved_Are_you_sure_you_want_to_continue"), i18n.getTranslation("_Changes_not_saved"), 0, 3)) == 1) {
            return false;
        }
        boolean ordered = true;
        ListModel groupModel = this.lstGroupColumns.getModel();
        ArrayList<String> builderGroups = new ArrayList<String>();
        for (int i = 0; i < groupModel.getSize(); ++i) {
            DefaultGroupListNode groupNode = (DefaultGroupListNode)((Object)groupModel.getElementAt(i));
            builderGroups.add(((ReportBuilder.GroupBuilder)groupNode.getValue()).getColumnBuilder().getColumnName());
        }
        if (!builderGroups.isEmpty()) {
            FeatureQueryOrder order = this.featureQuery.getOrder();
            ordered = order.size() > 0 ? this.checkOrderInGroups(builderGroups, order) : false;
        }
        if (!ordered) {
            int r2 = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_Group_by_columns_has_not_been_ordered_previously_Do_you_want_them_to_be_ordered"), i18n.getTranslation("_Columns_not_ordered"), 1, 3);
            if (r2 == 0) {
                FeatureQueryOrder cloneOrder;
                ArrayList<String> builderNames = new ArrayList<String>();
                for (String builderGroup : builderGroups) {
                    builderNames.add(builderGroup);
                }
                FeatureQueryOrder order = this.featureQuery.getOrder();
                try {
                    cloneOrder = order.clone();
                    cloneOrder.clear();
                }
                catch (CloneNotSupportedException ex) {
                    ordered = false;
                    return false;
                }
                for (String builderName : builderNames) {
                    cloneOrder.add(builderName);
                }
                this.featureQuery.setOrder(cloneOrder);
                ordered = true;
            } else if (r2 == 1) {
                ordered = true;
            } else if (r2 == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean checkOrderInGroups(ArrayList<String> builderGroups, FeatureQueryOrder queryGroups) {
        if (builderGroups.size() > queryGroups.size()) {
            return false;
        }
        ArrayList<String> queryGroupsList = new ArrayList<String>();
        for (FeatureQueryOrder.FeatureQueryOrderMember member : queryGroups.members()) {
            queryGroupsList.add(member.getAttributeName());
        }
        if (queryGroupsList.containsAll(builderGroups)) {
            List querySubset = queryGroupsList.subList(0, builderGroups.size());
            return builderGroups.equals(querySubset);
        }
        return false;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponent() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager toolsSwinManager = ToolsSwingLocator.getToolsSwingManager();
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        JComponent c = cfgActionsManager.getConfigurableActionsComponent("JReportBuilder", (Object)this);
        this.pnlCfgActions.setLayout(new BorderLayout(0, 0));
        this.pnlCfgActions.add((Component)c, "After");
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.translate();
        this.bookmarksController = toolsSwinManager.createBookmarksController(ReportLocator.getReportManager().getUserDefinedReportBookmarks(), this.btnBookmarks);
        this.historyController = toolsSwinManager.createHistoryController(ReportLocator.getReportManager().getUserDefinedReportHistory(), this.btnHistory);
        this.btnBookmarks.setVisible(false);
        this.btnHistory.setVisible(false);
        this.pickerColumnExpression = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtColumnExpression, this.btnColumnExpression, this.btnColumnExpressionBookmarks, this.btnColumnExpressionHistory);
        DefaultComboBoxModel comboGroupModel = new DefaultComboBoxModel();
        this.cboGroupColumns.setModel(comboGroupModel);
        DefaultComboBoxModel<LabeledValueImpl> comboModel = new DefaultComboBoxModel<LabeledValueImpl>();
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Classic"), (Object)0));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_List"), (Object)1));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Extended_list"), (Object)2));
        this.cboLayout.setModel(comboModel);
        comboModel = new DefaultComboBoxModel();
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_A4_portrait"), (Object)0));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_A4_landscape"), (Object)1));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Legal_portrait"), (Object)2));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Legal_landscape"), (Object)3));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Letter_portrait"), (Object)4));
        comboModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Letter_landscape"), (Object)5));
        this.btnColumnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DefaultJReportBuilder.this.actualColumnBuilder != null) {
                    DefaultJReportBuilder.this.columnController.fetch(DefaultJReportBuilder.this.actualColumnBuilder);
                }
            }
        });
        this.cboPageFormat.setModel(comboModel);
        this.btnReportTitleStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doSelectStyle(DefaultJReportBuilder.this.styleTitle);
            }
        });
        this.btnReportSubtitleStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doSelectStyle(DefaultJReportBuilder.this.styleSubtitle);
            }
        });
        DefaultListModel model = new DefaultListModel();
        this.lstColumns.setModel(model);
        this.lstColumns.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (DefaultJReportBuilder.this.checkColumnControllerHasChangesWithUser()) {
                    super.setSelectionInterval(index0, index1);
                    DefaultJReportBuilder.this.doValueChangeWhenColumnSelected();
                }
            }
        });
        this.btnColumnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doAddColumn();
            }
        });
        Dimension sz = this.getPreferredSize();
        if (sz.height < 370) {
            sz.height = 370;
        }
        if (sz.width < 650) {
            sz.width = 650;
        }
        this.setPreferredSize(sz);
        this.columnController = new DefaultJReportColumnBuilderController(this.txtColumnTitle, this.btnColumnTitleStyle, this.rdoColumnField, this.txtColumnField, this.btnColumnFieldStyle, this.rdoColumnExpression, this.txtColumnExpression, this.btnColumnExpressionHistory, this.btnColumnExpressionBookmarks, this.btnColumnExpression, this.btnColumnExpressionStyle, this.cboClass, this.txtColumnWidth, this.chkColumnFixedWidth, this.txtColumnPattern, this.txtColumnTruncateSuffix, this.btnColumnApply, this.chkGroupByField, this.cboGroupByOperation, this.pickerColumnExpression, this.txtColumnName);
        this.columnController.clean();
        this.columnController.setEnabled(false);
        this.btnColumnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doColumnUp(DefaultJReportBuilder.this.lstColumns);
            }
        });
        this.btnColumnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doColumnDown(DefaultJReportBuilder.this.lstColumns);
            }
        });
        this.btnColumnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultJReportBuilder.this.doRemoveColumn(DefaultJReportBuilder.this.lstColumns);
                DefaultJReportBuilder.this.columnController.clean();
            }
        });
        this.groupController = new DefaultJReportGroupController(this.cboGroupLayout, this.chkStartNewColumn, this.chkStartNewPage);
        DefaultListModel groupModel = new DefaultListModel();
        this.lstGroupColumns.setModel(groupModel);
        this.lstGroupColumns.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DefaultJReportBuilder.this.doValueChangeWhenGroupSelected();
            }
        });
        this.btnGroupColumnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doAddGroupBy();
            }
        });
        this.btnGroupColumnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doColumnUp(DefaultJReportBuilder.this.lstGroupColumns);
            }
        });
        this.btnGroupColumnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doColumnDown(DefaultJReportBuilder.this.lstGroupColumns);
            }
        });
        this.btnGroupColumnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultJReportBuilder.this.doRemoveGroupBy(DefaultJReportBuilder.this.lstGroupColumns);
                DefaultJReportBuilder.this.groupController.clean();
                DefaultJReportBuilder.this.actualGroupBuilder = null;
            }
        });
        this.btnGroupApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultJReportBuilder.this.doGroupApply();
            }
        });
        this.btnColumnsSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportBuilder.this.doSelectFields();
            }
        });
        this.setEnabled(false);
        this.clean();
    }

    public boolean hasChangesNotSaved() {
        return this.columnController.hasChanges();
    }

    private void doSelectFields() {
        FeatureStore store = this.featureType.getStore();
        DefaultFeatureAttributesSelectionPanel panel = new DefaultFeatureAttributesSelectionPanel();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), "Expression builder", null, 3);
        panel.setFeatureType(this.featureType);
        List listColumnNames = this.createListFromColumnsAndFields();
        panel.setSelectedNames(listColumnNames);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            try {
                List columnsToShow = panel.getSelectedNames();
                this.fetchFromSelectedColumnsToShow2Columns(this.featureType, columnsToShow);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void fetchFromSelectedColumnsToShow2Columns(FeatureType ftype, List<String> columnsToShow) {
        DefaultListModel model = (DefaultListModel)this.lstColumns.getModel();
        HashMap<String, DefaultColumnListNode> hmap = new HashMap<String, DefaultColumnListNode>();
        for (int i = 0; i < model.getSize(); ++i) {
            DefaultColumnListNode col = (DefaultColumnListNode)((Object)model.getElementAt(i));
            ReportBuilder.ColumnBuilder value = (ReportBuilder.ColumnBuilder)col.getValue();
            hmap.put(value.getColumnName(), col);
        }
        DefaultListModel<Object> newModel = new DefaultListModel<Object>();
        for (String attrName : columnsToShow) {
            if (hmap.containsKey(attrName)) {
                newModel.addElement(hmap.get(attrName));
                continue;
            }
            if (ftype.getAttributeDescriptor(attrName) == null) continue;
            FeatureAttributeDescriptor attrDescriptor = ftype.getAttributeDescriptor(attrName);
            ReportBuilder.ColumnBuilder fieldColumnBuilder = ReportLocator.getReportManager().createReportBuilder().createColumn();
            fieldColumnBuilder.columnName(attrDescriptor.getName());
            fieldColumnBuilder.title(attrDescriptor.getLabel());
            fieldColumnBuilder.field(attrDescriptor.getName());
            fieldColumnBuilder.dataType(attrDescriptor.getDataType());
            if (attrDescriptor.getDataType() != null && attrDescriptor.getDataType().isNumeric()) {
                fieldColumnBuilder.fieldStyle().horizontalAlign(3);
            }
            DefaultColumnListNode columnBuilderNode = new DefaultColumnListNode(fieldColumnBuilder);
            newModel.addElement((Object)columnBuilderNode);
            DefaultGroupComboNode groupValue = new DefaultGroupComboNode(fieldColumnBuilder);
            DefaultComboBoxModel groupModelCombo = (DefaultComboBoxModel)this.cboGroupColumns.getModel();
            groupModelCombo.addElement(groupValue);
        }
        this.lstColumns.setModel(newModel);
    }

    private List createListFromColumnsAndFields() {
        ArrayList<String> columnsList = new ArrayList<String>();
        ListModel model = this.lstColumns.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            DefaultColumnListNode col = (DefaultColumnListNode)((Object)model.getElementAt(i));
            ReportBuilder.ColumnBuilder value = (ReportBuilder.ColumnBuilder)col.getValue();
            columnsList.add(value.getColumnName());
        }
        return columnsList;
    }

    private void doGroupApply() {
        if (this.actualGroupBuilder == null) {
            return;
        }
        this.groupController.fetch(this.actualGroupBuilder);
    }

    private void doAddGroupBy() {
        DefaultGroupComboNode node = (DefaultGroupComboNode)((Object)this.cboGroupColumns.getSelectedItem());
        if (node == null) {
            return;
        }
        ReportBuilder.ColumnBuilder columnBuilderNode = (ReportBuilder.ColumnBuilder)node.getValue();
        DefaultListModel model = (DefaultListModel)this.lstGroupColumns.getModel();
        ReportBuilder.GroupBuilder groupBuilder = ReportLocator.getReportManager().createReportBuilder().createGroup(columnBuilderNode);
        DefaultGroupListNode lstValue = new DefaultGroupListNode(groupBuilder);
        model.addElement(lstValue);
        this.lstGroupColumns.updateUI();
    }

    private void doColumnUp(JList lstColumns) {
        int moveMe = lstColumns.getSelectedIndex();
        if (moveMe != 0) {
            this.swap(moveMe, moveMe - 1);
            lstColumns.setSelectedIndex(moveMe - 1);
            lstColumns.ensureIndexIsVisible(moveMe - 1);
        }
    }

    private void doColumnDown(JList lstColumns) {
        int moveMe = lstColumns.getSelectedIndex();
        if (moveMe != lstColumns.getModel().getSize() - 1) {
            this.swap(moveMe, moveMe + 1);
            lstColumns.setSelectedIndex(moveMe + 1);
            lstColumns.ensureIndexIsVisible(moveMe + 1);
        }
    }

    private void swap(int a, int b) {
        Object aObject = this.lstColumns.getModel().getElementAt(a);
        Object bObject = this.lstColumns.getModel().getElementAt(b);
        DefaultListModel model = (DefaultListModel)this.lstColumns.getModel();
        model.set(a, bObject);
        model.set(b, aObject);
    }

    private void doRemoveGroupBy(JList lstColumns) {
        ListSelectionModel lsm = lstColumns.getSelectionModel();
        DefaultListModel model = (DefaultListModel)lstColumns.getModel();
        int firstSelected = lsm.getMinSelectionIndex();
        int lastSelected = lsm.getMaxSelectionIndex();
        DefaultListModel removeModel = (DefaultListModel)lstColumns.getModel();
        if (lsm.getMinSelectionIndex() == -1 && lsm.getMaxSelectionIndex() == -1) {
            return;
        }
        removeModel.removeRange(lsm.getMinSelectionIndex(), lsm.getMaxSelectionIndex());
        int size = model.size();
        int currentIndex = lsm.getMinSelectionIndex();
        if (size != 0) {
            if (currentIndex == model.getSize()) {
                --currentIndex;
            }
            lstColumns.setSelectedIndex(currentIndex);
        }
    }

    private void doRemoveColumn(JList lstColumns) {
        int firstSelected;
        ListSelectionModel lsm = lstColumns.getSelectionModel();
        DefaultListModel model = (DefaultListModel)lstColumns.getModel();
        int lastSelected = lsm.getMaxSelectionIndex();
        DefaultListModel removeModel = (DefaultListModel)lstColumns.getModel();
        int actualIndex = lsm.getMinSelectionIndex();
        if (lsm.getMinSelectionIndex() == -1 && lsm.getMaxSelectionIndex() == -1) {
            return;
        }
        int i = firstSelected;
        block0: for (firstSelected = lsm.getMinSelectionIndex(); firstSelected <= lastSelected; ++firstSelected) {
            DefaultColumnListNode item = (DefaultColumnListNode)((Object)model.get(i));
            ReportBuilder.ColumnBuilder toDelete = (ReportBuilder.ColumnBuilder)item.getValue();
            ComboBoxModel comboModel = this.cboGroupColumns.getModel();
            for (int n = 0; n < comboModel.getSize(); ++n) {
                DefaultGroupComboNode col = (DefaultGroupComboNode)((Object)comboModel.getElementAt(n));
                ReportBuilder.ColumnBuilder toCheck = (ReportBuilder.ColumnBuilder)col.getValue();
                if (!toDelete.getColumnName().equals(toCheck.getColumnName())) continue;
                this.cboGroupColumns.removeItem((Object)col);
                continue block0;
            }
        }
        removeModel.removeRange(lsm.getMinSelectionIndex(), lsm.getMaxSelectionIndex());
        int size = model.size();
        if (size != 0 && model.getSize() != 0) {
            if (actualIndex >= model.getSize()) {
                lstColumns.setSelectedIndex(model.getSize() - 1);
            } else {
                lstColumns.setSelectedIndex(actualIndex);
            }
        }
    }

    private boolean checkColumnControllerHasChangesWithUser() {
        if (this.columnController.hasChanges()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            String message = i18n.getTranslation("_Changes_has_not_been_saved_Are_you_sure_you_want_to_continue");
            String title = i18n.getTranslation("_Changes_not_saved");
            int r = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(message, title, 0, 3);
            if (r == 1) {
                return false;
            }
        }
        return true;
    }

    private boolean doValueChangeWhenColumnSelected() {
        DefaultColumnListNode node = (DefaultColumnListNode)((Object)this.lstColumns.getSelectedValue());
        if (node == null) {
            this.actualColumnBuilder = null;
            this.columnController.clean();
            this.columnController.setEnabled(false);
        } else {
            this.actualColumnBuilder = (ReportBuilder.ColumnBuilder)node.getValue();
            this.columnController.put(this.actualColumnBuilder);
            this.columnController.setEnabled(true);
        }
        return true;
    }

    private void doValueChangeWhenGroupSelected() {
        DefaultGroupListNode node = (DefaultGroupListNode)((Object)this.lstGroupColumns.getSelectedValue());
        if (node == null) {
            this.groupController.clean();
            this.groupController.setEnabled(false);
            this.actualGroupBuilder = null;
        } else {
            ReportBuilder.GroupBuilder value;
            this.actualGroupBuilder = value = (ReportBuilder.GroupBuilder)node.getValue();
            this.groupController.put(value);
            this.groupController.setEnabled(true);
        }
    }

    private void doAddColumn() {
        LabeledValue field = (LabeledValue)this.cboFields.getSelectedItem();
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)field.getValue();
        DefaultListModel model = (DefaultListModel)this.lstColumns.getModel();
        ReportBuilder.ColumnBuilder fieldColumnBuilder = ReportLocator.getReportManager().createReportBuilder().createColumn();
        String attrName = attr.getName();
        String possibleName = attr.getName();
        int n = 0;
        while (true) {
            boolean checkName = true;
            for (int i = 0; i < model.getSize(); ++i) {
                DefaultColumnListNode col = (DefaultColumnListNode)((Object)model.getElementAt(i));
                ReportBuilder.ColumnBuilder value = (ReportBuilder.ColumnBuilder)col.getValue();
                if (!StringUtils.equals((CharSequence)possibleName, (CharSequence)value.getColumnName())) continue;
                checkName = false;
            }
            if (checkName) break;
            possibleName = attrName + "_" + n;
            ++n;
        }
        fieldColumnBuilder.columnName(possibleName);
        fieldColumnBuilder.title(attr.getLabel());
        fieldColumnBuilder.field(attr.getName());
        fieldColumnBuilder.dataType(attr.getDataType());
        if (attr.getDataType() != null && attr.getDataType().isNumeric()) {
            fieldColumnBuilder.fieldStyle().horizontalAlign(3);
        }
        DefaultColumnListNode columnBuilderNode = new DefaultColumnListNode(fieldColumnBuilder);
        model.addElement(columnBuilderNode);
        this.lstColumns.updateUI();
        DefaultGroupComboNode groupValue = new DefaultGroupComboNode(fieldColumnBuilder);
        DefaultComboBoxModel groupModelCombo = (DefaultComboBoxModel)this.cboGroupColumns.getModel();
        groupModelCombo.addElement(groupValue);
        int nextIndex = this.cboFields.getSelectedIndex() + 1;
        if (nextIndex <= this.cboFields.getItemCount() - 1) {
            this.cboFields.setSelectedIndex(nextIndex);
        }
    }

    private void doSelectStyle(ReportBuilder.StyleBuilder styleBuilder) {
        DefaultJReportStyleBuilder panel = new DefaultJReportStyleBuilder();
        panel.put(styleBuilder);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), "Expression builder", null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            panel.fetch(styleBuilder);
        }
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        DefaultComboBoxModel<DefaultColumnComboNode> comboModel = new DefaultComboBoxModel<DefaultColumnComboNode>();
        for (FeatureAttributeDescriptor attr : featureType) {
            comboModel.addElement(new DefaultColumnComboNode(attr.getName(), attr));
        }
        this.cboFields.setModel(comboModel);
        FeatureStoreElement storeElement = DALSwingLocator.getSwingManager().createFeatureStoreElement(featureType.getStore());
        this.pickerColumnExpression.getConfig().addElement((Element)storeElement);
    }

    private void translate() {
        Field[] fields;
        ToolsSwingManager toolsSwinManager = ToolsSwingLocator.getToolsSwingManager();
        Class<DefaultJReportBuilderView> theClass = DefaultJReportBuilderView.class;
        for (Field fieldView : fields = theClass.getDeclaredFields()) {
            String theName = fieldView.getName();
            try {
                if (!StringUtils.startsWithAny((CharSequence)theName, (CharSequence[])new CharSequence[]{"tab", "btn", "rdo", "chk", "lbl"}) || !JComponent.class.isAssignableFrom(fieldView.getType())) continue;
                try {
                    JComponent theComponent = (JComponent)fieldView.get(this);
                    toolsSwinManager.translate(theComponent);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        for (int i = 0; i < this.tabReportBuilder.getTabCount(); ++i) {
            String tabName = this.tabReportBuilder.getTitleAt(i);
            String translated = i18n.getTranslation(tabName);
            this.tabReportBuilder.setTitleAt(i, translated);
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource(name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public void put(ReportBuilder reportBuilder) {
        if (reportBuilder == null) {
            this.clean();
            return;
        }
        this.txtReportTitle.setText(reportBuilder.getTitle());
        this.styleTitle = reportBuilder.titleStyle();
        this.txtReportSubtitle.setText(reportBuilder.getSubtitle());
        this.styleSubtitle = reportBuilder.subtitleStyle();
        if (reportBuilder.getMargins() != null) {
            this.txtReportTop.setText(Integer.toString(reportBuilder.getMargins().getTop()));
            this.txtReportBottom.setText(Integer.toString(reportBuilder.getMargins().getBottom()));
            this.txtReportLeft.setText(Integer.toString(reportBuilder.getMargins().getLeft()));
            this.txtReportRight.setText(Integer.toString(reportBuilder.getMargins().getRight()));
        } else {
            this.txtReportTop.setText("5");
            this.txtReportBottom.setText("5");
            this.txtReportLeft.setText("5");
            this.txtReportRight.setText("5");
        }
        this.txtReportColumnsPerPage.setText(Integer.toString(reportBuilder.getColumnsPerPage()));
        this.txtReportDetailHeight.setText(Integer.toString(reportBuilder.getDetailHeight()));
        this.chkReportPrintBackgroundOnOddRows.setSelected(reportBuilder.getPrintBackgroundOnOddRows());
        this.chkReportUseFullPageWith.setSelected(reportBuilder.getUseFullPageWith());
        this.chkReportShowDetailBand.setSelected(reportBuilder.getShowDetailBand());
        this.chkPrintColumnNames.setSelected(reportBuilder.getPrintColumnNames());
        List cols = reportBuilder.getColumns();
        DefaultListModel<DefaultColumnListNode> listModel = new DefaultListModel<DefaultColumnListNode>();
        for (ReportBuilder.ColumnBuilder col : cols) {
            DefaultColumnListNode lstColumn = new DefaultColumnListNode(col);
            listModel.addElement(lstColumn);
        }
        this.lstColumns.setModel(listModel);
    }

    public void clean() {
        this.txtReportTitle.setText("");
        this.txtReportSubtitle.setText("");
        this.chkReportPrintBackgroundOnOddRows.setSelected(true);
        this.chkReportUseFullPageWith.setSelected(true);
        this.chkReportShowDetailBand.setSelected(true);
        this.txtReportDetailHeight.setText("15");
        this.chkPrintColumnNames.setSelected(true);
        this.cboLayout.setSelectedIndex(0);
        this.cboPageFormat.setSelectedIndex(0);
        this.txtReportColumnsPerPage.setText("1");
        this.txtReportTop.setText("1");
        this.txtReportBottom.setText("1");
        this.txtReportLeft.setText("1");
        this.txtReportRight.setText("1");
    }

    public ReportBuilder fetch(ReportBuilder reportBuilder) {
        if (reportBuilder != null) {
            reportBuilder.clean();
        } else {
            reportBuilder = ReportLocator.getReportManager().createReportBuilder();
        }
        reportBuilder.title(this.txtReportTitle.getText());
        reportBuilder.subtitle(this.txtReportSubtitle.getText());
        reportBuilder.printBackgroundOnOddRows(this.chkReportPrintBackgroundOnOddRows.isSelected());
        reportBuilder.useFullPageWith(this.chkReportUseFullPageWith.isSelected());
        reportBuilder.showDetailBand(this.chkReportShowDetailBand.isSelected());
        reportBuilder.detailHeight(Integer.parseInt(this.txtReportDetailHeight.getText()));
        reportBuilder.printColumnNames(this.chkPrintColumnNames.isSelected());
        LabeledValueImpl layoutValue = (LabeledValueImpl)this.cboLayout.getSelectedItem();
        reportBuilder.layout(((Integer)layoutValue.getValue()).intValue());
        LabeledValueImpl pageFormatValue = (LabeledValueImpl)this.cboPageFormat.getSelectedItem();
        reportBuilder.pageFormat(((Integer)pageFormatValue.getValue()).intValue());
        reportBuilder.columnsPerPage(Integer.parseInt(this.txtReportColumnsPerPage.getText()));
        Integer top = Integer.parseInt(this.txtReportTop.getText());
        Integer bottom = Integer.parseInt(this.txtReportBottom.getText());
        Integer left = Integer.parseInt(this.txtReportLeft.getText());
        Integer right = Integer.parseInt(this.txtReportRight.getText());
        reportBuilder.margins(top.intValue(), bottom.intValue(), left.intValue(), right.intValue());
        ListModel model = this.lstColumns.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            DefaultColumnListNode col = (DefaultColumnListNode)((Object)model.getElementAt(i));
            ReportBuilder.ColumnBuilder columnBuilder = reportBuilder.add_column();
            columnBuilder.copyFrom((ReportBuilder.ColumnBuilder)col.getValue());
        }
        ListModel groupModel = this.lstGroupColumns.getModel();
        for (int i = 0; i < groupModel.getSize(); ++i) {
            DefaultGroupListNode groupNode = (DefaultGroupListNode)((Object)groupModel.getElementAt(i));
            ReportBuilder.GroupBuilder groupBuilder = reportBuilder.add_group(((ReportBuilder.GroupBuilder)groupNode.getValue()).getColumnBuilder());
            groupBuilder.copyFrom((ReportBuilder.GroupBuilder)groupNode.getValue());
        }
        return reportBuilder;
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(ReportSwingImplLibrary.class, (String)"/org/gvsig/report/swing/impl/reportbuilder", (String)"reportlib", (String[][])new String[][]{{"report", "reportbuilder-border-edit", "report-builder"}, {"report", "reportbuilder-column-addexpression", "report-builder"}, {"report", "reportbuilder-column-edit", "report-builder"}, {"report", "reportbuilder-style-edit", "report-builder"}});
    }

    private class DefaultGroupListNode
    extends LabeledValueImpl<ReportBuilder.GroupBuilder> {
        public DefaultGroupListNode(ReportBuilder.GroupBuilder groupBuilder) {
            super(groupBuilder.getColumnBuilder().getColumnName(), (Object)groupBuilder);
        }

        public String getLabel() {
            return ((ReportBuilder.GroupBuilder)this.getValue()).getColumnBuilder().getColumnName();
        }
    }

    private class DefaultGroupComboNode
    extends LabeledValueImpl<ReportBuilder.ColumnBuilder> {
        public DefaultGroupComboNode(ReportBuilder.ColumnBuilder columnBuilder) {
            super(columnBuilder.getColumnName(), (Object)columnBuilder);
        }

        public String getLabel() {
            return ((ReportBuilder.ColumnBuilder)this.getValue()).getColumnName();
        }
    }

    private class DefaultColumnListNode
    extends LabeledValueImpl<ReportBuilder.ColumnBuilder> {
        public DefaultColumnListNode(ReportBuilder.ColumnBuilder columnBuilder) {
            super(columnBuilder.getColumnName(), (Object)columnBuilder);
        }

        public String getLabel() {
            return ((ReportBuilder.ColumnBuilder)this.getValue()).getColumnName();
        }
    }

    private class DefaultColumnComboNode
    extends LabeledValueImpl<FeatureAttributeDescriptor> {
        public DefaultColumnComboNode(String label, FeatureAttributeDescriptor attributeDescriptor) {
            super(label, (Object)attributeDescriptor);
        }
    }
}

