/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportbuilder;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportBorderBuilder;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportBuilderView;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportStyleBuilderView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.LabeledValueImpl;

public class DefaultJReportStyleBuilder
extends DefaultJReportStyleBuilderView
implements Component {
    private JComboBox cmbFonts;
    private ColorPickerController pickerTextColor;
    private ColorPickerController pickerBackgroundColor;
    private ReportBuilder.StyleBuilder styleBuilder;
    private ReportBuilder.BorderBuilder borderRight;
    private ReportBuilder.BorderBuilder borderLeft;
    private ReportBuilder.BorderBuilder borderBottom;
    private ReportBuilder.BorderBuilder borderTop;

    public DefaultJReportStyleBuilder() {
        this.initComponents();
    }

    public void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.cboFontName.addItem(new LabeledValueImpl("Arial", (Object)0));
        this.cboFontName.addItem(new LabeledValueImpl("Comic Sans", (Object)1));
        this.cboFontName.addItem(new LabeledValueImpl("Courier New", (Object)2));
        this.cboFontName.addItem(new LabeledValueImpl("Georgia", (Object)3));
        this.cboFontName.addItem(new LabeledValueImpl("Monospaced", (Object)4));
        this.cboFontName.addItem(new LabeledValueImpl("Time New Roman", (Object)5));
        this.cboFontName.addItem(new LabeledValueImpl("Verdana", (Object)6));
        this.spnFontSizes.setValue(10);
        this.pickerTextColor = ToolsSwingLocator.getToolsSwingManager().createColorPickerController((JTextComponent)this.txtTextColor, this.btnTextColor);
        this.pickerBackgroundColor = ToolsSwingLocator.getToolsSwingManager().createColorPickerController((JTextComponent)this.txtBackgroundColor, this.btnBackgroundColor);
        this.cboRotation.addItem(new LabeledValueImpl(i18n.getTranslation("_Left"), (Object)1));
        this.cboRotation.addItem(new LabeledValueImpl(i18n.getTranslation("_None"), (Object)0));
        this.cboRotation.addItem(new LabeledValueImpl(i18n.getTranslation("_Right"), (Object)2));
        this.cboStretching.addItem(new LabeledValueImpl(i18n.getTranslation("_None"), (Object)0));
        this.cboStretching.addItem(new LabeledValueImpl(i18n.getTranslation("_Relative_to_band_height"), (Object)1));
        this.cboStretching.addItem(new LabeledValueImpl(i18n.getTranslation("_Relative_to_tallest_object"), (Object)2));
        this.chkStretchingWithOverflow.setSelected(false);
        this.chkTransparent.setSelected(true);
        this.cboTransparency.addItem(new LabeledValueImpl(i18n.getTranslation("_Opaque"), (Object)0));
        this.cboTransparency.addItem(new LabeledValueImpl(i18n.getTranslation("_Transparency"), (Object)1));
        this.cboVerticalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Bottom"), (Object)1));
        this.cboVerticalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Justified"), (Object)2));
        this.cboVerticalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Middle"), (Object)0));
        this.cboVerticalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Top"), (Object)4));
        this.cboHorizontalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Center"), (Object)1));
        this.cboHorizontalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Justify"), (Object)2));
        this.cboHorizontalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Left"), (Object)0));
        this.cboHorizontalAlign.addItem(new LabeledValueImpl(i18n.getTranslation("_Right"), (Object)3));
        this.btnBorderTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportStyleBuilder.this.doSelectBorderStyle(DefaultJReportStyleBuilder.this.borderTop);
            }
        });
        this.btnBorderLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportStyleBuilder.this.doSelectBorderStyle(DefaultJReportStyleBuilder.this.borderLeft);
            }
        });
        this.btnBorderRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportStyleBuilder.this.doSelectBorderStyle(DefaultJReportStyleBuilder.this.borderRight);
            }
        });
        this.btnBorderBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportStyleBuilder.this.doSelectBorderStyle(DefaultJReportStyleBuilder.this.borderBottom);
            }
        });
        this.translate();
    }

    private void translate() {
        Field[] fields;
        ToolsSwingManager toolsSwinManager = ToolsSwingLocator.getToolsSwingManager();
        Class<DefaultJReportBuilderView> theClass = DefaultJReportBuilderView.class;
        for (Field fieldView : fields = theClass.getDeclaredFields()) {
            String theName = fieldView.getName();
            try {
                if (!StringUtils.startsWithAny((CharSequence)theName, (CharSequence[])new CharSequence[]{"tab", "btn", "rdo", "chk", "lbl"}) || !JComponent.class.isAssignableFrom(fieldView.getType())) continue;
                try {
                    JComponent theComponent = (JComponent)fieldView.get(this);
                    toolsSwinManager.translate(theComponent);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clean() {
    }

    public void fetch(ReportBuilder.StyleBuilder styleBuilder) {
        this.styleBuilder.backgroundColor((Color)this.pickerBackgroundColor.get());
        this.styleBuilder.textColor((Color)this.pickerTextColor.get());
        this.styleBuilder.rotation(((Integer)((LabeledValueImpl)this.cboRotation.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.stretching(((Integer)((LabeledValueImpl)this.cboStretching.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.verticalAlign(((Integer)((LabeledValueImpl)this.cboVerticalAlign.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.horizontalAlign(((Integer)((LabeledValueImpl)this.cboHorizontalAlign.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.transparency(((Integer)((LabeledValueImpl)this.cboTransparency.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.transparent(this.chkTransparent.isSelected());
        this.styleBuilder.stretchingWithOverflow(this.chkStretchingWithOverflow.isSelected());
        this.styleBuilder.font(((Integer)((LabeledValueImpl)this.cboFontName.getSelectedItem()).getValue()).intValue());
        this.styleBuilder.fontSize(((Integer)this.spnFontSizes.getValue()).intValue());
        this.styleBuilder.paddingBottom(Integer.parseInt(this.txtPaddingBottom.getText()));
        this.styleBuilder.paddingLeft(Integer.parseInt(this.txtPaddingLeft.getText()));
        this.styleBuilder.paddingRight(Integer.parseInt(this.txtPaddingRight.getText()));
        this.styleBuilder.paddingTop(Integer.parseInt(this.txtPaddingTop.getText()));
        this.styleBuilder.borderBottom(this.borderBottom);
        this.styleBuilder.borderLeft(this.borderLeft);
        this.styleBuilder.borderRight(this.borderRight);
        this.styleBuilder.borderTop(this.borderTop);
        styleBuilder.copyFrom(this.styleBuilder);
    }

    public void put(ReportBuilder.StyleBuilder styleBuilder) {
        this.styleBuilder = styleBuilder;
        this.borderBottom = styleBuilder.getBorderBottom();
        this.borderLeft = styleBuilder.getBorderLeft();
        this.borderRight = styleBuilder.getBorderRight();
        this.borderTop = styleBuilder.getBorderTop();
        this.pickerBackgroundColor.set((Object)this.styleBuilder.getBackgroundColor());
        this.pickerTextColor.set((Object)this.styleBuilder.getTextColor());
        int rotation = this.styleBuilder.getRotation();
        ComboBoxModel model = this.cboRotation.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(rotation)) continue;
            this.cboRotation.setSelectedIndex(i);
            break;
        }
        int streching = this.styleBuilder.getStretching();
        model = this.cboStretching.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(streching)) continue;
            this.cboStretching.setSelectedIndex(i);
            break;
        }
        int ver = this.styleBuilder.getVerticalAlign();
        model = this.cboVerticalAlign.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(ver)) continue;
            this.cboVerticalAlign.setSelectedIndex(i);
            break;
        }
        int hor = this.styleBuilder.getHorizontalAlign();
        model = this.cboHorizontalAlign.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(hor)) continue;
            this.cboHorizontalAlign.setSelectedIndex(i);
            break;
        }
        this.chkStretchingWithOverflow.setSelected(this.styleBuilder.getStretchingWithOverflow());
        int transparency = this.styleBuilder.getTransparency();
        model = this.cboTransparency.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(transparency)) continue;
            this.cboTransparency.setSelectedIndex(i);
            break;
        }
        this.chkTransparent.setSelected(this.styleBuilder.getTransparent());
        int font = this.styleBuilder.getFont();
        model = this.cboFontName.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
            if (!((Integer)object.getValue()).equals(font)) continue;
            this.cboFontName.setSelectedIndex(i);
            break;
        }
        this.spnFontSizes.setValue(this.styleBuilder.getFontSize());
        this.txtPaddingBottom.setText(String.valueOf(this.styleBuilder.getPaddingBottom()));
        this.txtPaddingLeft.setText(String.valueOf(this.styleBuilder.getPaddingLeft()));
        this.txtPaddingRight.setText(String.valueOf(this.styleBuilder.getPaddingRight()));
        this.txtPaddingTop.setText(String.valueOf(this.styleBuilder.getPaddingTop()));
        this.borderTop = this.styleBuilder.getBorderTop();
        this.borderBottom = this.styleBuilder.getBorderBottom();
        this.borderLeft = this.styleBuilder.getBorderLeft();
        this.borderRight = this.styleBuilder.getBorderRight();
    }

    private void doSelectBorderStyle(ReportBuilder.BorderBuilder borderBuilder) {
        DefaultJReportBorderBuilder panel = new DefaultJReportBorderBuilder();
        panel.put(borderBuilder);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), "Expression builder", null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            panel.fetch(borderBuilder);
        }
    }

    public JComponent asJComponent() {
        return this;
    }
}

