/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.service;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.swing.api.JReportServer;
import org.gvsig.report.swing.impl.reportserver.service.ServiceView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
extends ServiceView
implements PropertiesPage,
ReportServer.LoggerListener {
    private static final Logger LOG = LoggerFactory.getLogger(Service.class);
    private ReportServer server;
    private final PropertyChangeListener configChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Service.this.configChanged();
        }
    };
    private final JReportServer jreportServer;

    public Service(JReportServer jreportServer) {
        this.jreportServer = jreportServer;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtPort);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtTimeout);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtLog);
        swingManager.translate((AbstractButton)this.btnGeneralApply);
        swingManager.translate((AbstractButton)this.btnRestart);
        swingManager.translate((AbstractButton)this.btnStop);
        swingManager.translate(this.lblAutostart);
        swingManager.translate(this.lblMessages);
        swingManager.translate(this.lblPort);
        swingManager.translate(this.lblTimeout);
        IntegerDocumentFilter.install((JTextField)this.txtPort);
        IntegerDocumentFilter.install((JTextField)this.txtTimeout);
        this.btnRestart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Service.this.doRestart();
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Service.this.doStop();
            }
        });
        this.btnGeneralApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Service.this.doApply();
            }
        });
        this.chkAutostart.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ReportServerConfig config = Service.this.getConfig();
                if (config != null) {
                    config.setAutostart(Service.this.chkAutostart.isSelected());
                }
            }
        });
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String iconName = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (theme.exists(iconName)) {
            return theme.get(iconName);
        }
        return super.loadImage(imageName);
    }

    private void doStop() {
        this.server.stop();
    }

    private void doRestart() {
        this.fetch(this.server);
        this.server.stop();
        this.server.start();
    }

    public void doApply() {
        this.fetch(this.server);
    }

    public void setData(Object data) {
        this.setServer((ReportServer)data);
    }

    public void setServer(ReportServer server) {
        if (this.server != null) {
            this.server.removeLogListener((ReportServer.LoggerListener)this);
            this.server.getConfig().removePropertyChangeListener(this.configChangeListener);
        }
        this.server = server;
        if (server == null) {
            this.clearComponents();
            this.setEnabledComponents(false);
            return;
        }
        this.server.addLogListener((ReportServer.LoggerListener)this);
        ReportServerConfig config = this.getConfig();
        this.txtPort.setText(String.valueOf(config.getPort()));
        this.txtTimeout.setText(String.valueOf(config.getTimeout()));
        this.chkAutostart.setSelected(config.getAutostart());
        this.setEnabledComponents(true);
        this.getConfig().addPropertyChangeListener(this.configChangeListener);
    }

    private void configChanged() {
        this.setServer(this.server);
    }

    public ReportServerConfig getConfig() {
        if (this.getServer() == null) {
            return null;
        }
        return this.getServer().getConfig();
    }

    private void fetch(ReportServer server) {
        ReportServerConfig config = this.getConfig();
        if (config == null) {
            return;
        }
        config.setPort(IntegerDocumentFilter.getValue((JTextField)this.txtPort));
        config.setTimeout(IntegerDocumentFilter.getValue((JTextField)this.txtTimeout));
        config.setAutostart(this.chkAutostart.isSelected());
    }

    private void clearComponents() {
        this.txtPort.setText("");
        this.txtTimeout.setText("");
    }

    private void setEnabledComponents(boolean enabled) {
        this.txtPort.setEnabled(enabled);
        this.txtTimeout.setEnabled(enabled);
        this.btnRestart.setEnabled(enabled);
    }

    public void log(int level, String message) {
        String line;
        switch (level) {
            default: {
                line = "[INFO] ";
                break;
            }
            case 1: {
                line = "[WARN] ";
                break;
            }
            case 2: {
                line = "[DEBG] ";
            }
        }
        line = line + message + "\n";
        this.txtLog.append(line);
        this.txtLog.setCaretPosition(this.txtLog.getDocument().getLength());
    }

    public ReportServer getServer() {
        return this.server;
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Service");
    }

    public int getPriority() {
        return 900;
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        this.fetch(this.server);
        return true;
    }

    public boolean whenCancel() {
        return true;
    }
}

