/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante;

import es.unex.sextante.core.ITaskMonitor;
import java.util.Date;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public class SimpleTaskStatusDelegated
implements SimpleTaskStatus {
    private final ITaskMonitor monitor;
    private final SimpleTaskStatus status;
    private long min;
    private long max;

    public SimpleTaskStatusDelegated(ITaskMonitor monitor, String taskName) {
        this.monitor = monitor;
        if (this.monitor != null) {
            this.monitor.setDeterminate(false);
        }
        this.status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(taskName);
        this.status.setAutoremove(true);
    }

    public void addObserver(Observer o) {
        this.status.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.status.deleteObserver(o);
    }

    public void deleteObservers() {
        this.status.deleteObservers();
    }

    public void setTittle(String tittle) {
        this.status.setTitle(tittle);
    }

    public void setTitle(String title) {
        this.status.setTitle(title);
    }

    public void message(String message) {
        this.status.message(message);
        if (this.monitor != null) {
            this.monitor.setProgressText(message);
        }
    }

    public void setRangeOfValues(long min, long max) {
        this.min = min;
        this.max = max;
        this.status.setRangeOfValues(min, max);
        if (this.monitor != null) {
            this.monitor.setDeterminate(true);
        }
    }

    public void setCurValue(long value) {
        this.status.setCurValue(value);
        if (this.monitor != null) {
            this.monitor.setProgress((int)(value - this.min), (int)(this.max - this.min));
        }
    }

    public boolean isCancellationRequested() {
        return this.status.isCancellationRequested();
    }

    public void cancelRequest() {
        this.status.cancelRequest();
    }

    public void terminate() {
        this.status.terminate();
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    public String getTitle() {
        return this.status.getTitle();
    }

    public void cancel() {
        this.status.cancel();
    }

    public String getCode() {
        return this.status.getCode();
    }

    public void abort() {
        this.status.abort();
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    public int getCompleted() {
        return this.status.getCompleted();
    }

    public void remove() {
        this.status.remove();
    }

    public void add() {
        this.status.add();
    }

    public String getLabel() {
        return this.status.getLabel();
    }

    public void setCancellable(boolean cancellable) {
        this.status.setCancellable(cancellable);
    }

    public boolean isCancelled() {
        return this.status.isCancelled() || this.monitor != null && this.monitor.isCanceled();
    }

    public void setAutoremove(boolean autoremove) {
        this.status.setAutoremove(autoremove);
    }

    public boolean isAborted() {
        return this.status.isAborted();
    }

    public boolean isRunning() {
        return this.status.isRunning();
    }

    public boolean getAutoRemove() {
        return this.status.getAutoRemove();
    }

    public Date getLastModification() {
        return this.status.getLastModification();
    }

    public TaskStatusManager getManager() {
        return this.status.getManager();
    }

    public boolean isIndeterminate() {
        return this.status.isIndeterminate();
    }

    public boolean isCancellable() {
        return this.status.isCancellable();
    }

    public void pop() {
        this.status.pop();
    }

    public void push() {
        this.status.push();
    }

    public void setIndeterminate() {
        this.status.setIndeterminate();
    }

    public void restart() {
        this.status.restart();
    }

    public void incrementCurrentValue() {
        this.status.incrementCurrentValue();
    }

    public String getMessage() {
        return this.status.getMessage();
    }

    public String getProgressLabel() {
        return this.status.getProgressLabel();
    }

    public long getCurValue() {
        return this.status.getCurValue();
    }
}

