/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.FeatureImpl;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.operation.tojts.ToJTS;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.DisposableIterator;

public class DALIFeatureIterator
implements IFeatureIterator {
    private final List<IVectorLayerFilter> m_Filters;
    private boolean m_bIsNextConsumed;
    private IFeature m_CurrentValue;
    private boolean m_bFinished;
    private DisposableIterator m_FeatureIterator;

    public DALIFeatureIterator(FLyrVect layer, List<IVectorLayerFilter> filters) {
        block3: {
            this.m_bIsNextConsumed = true;
            this.m_Filters = filters;
            Object set = null;
            FeatureStore featureStore = layer.getFeatureStore();
            try {
                FeatureSelection featureSelection = featureStore.getFeatureSelection();
                set = !featureSelection.isEmpty() ? featureSelection : featureStore.getFeatureSet();
                this.m_FeatureIterator = set.fastIterator();
            }
            catch (DataException e) {
                if (this.m_FeatureIterator != null) {
                    this.m_FeatureIterator.dispose();
                }
                if (set == null) break block3;
                set.dispose();
            }
        }
    }

    public DALIFeatureIterator() {
        this.m_Filters = null;
    }

    private boolean accept(IFeature value) {
        for (IVectorLayerFilter filter : this.m_Filters) {
            if (filter.accept(value, 0)) continue;
            return false;
        }
        return true;
    }

    public boolean moveToNextValid() {
        if (this.m_FeatureIterator == null) {
            return false;
        }
        boolean bFound = false;
        while (!bFound && this.m_FeatureIterator.hasNext()) {
            try {
                Feature f = (Feature)this.m_FeatureIterator.next();
                org.gvsig.fmap.geom.Geometry geometry = f.getDefaultGeometry();
                Geometry geom = (Geometry)geometry.invokeOperation(ToJTS.CODE, null);
                FeatureType type = f.getType();
                Iterator iter = type.iterator();
                ArrayList<Object> objects = new ArrayList<Object>();
                while (iter.hasNext()) {
                    FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)iter.next();
                    String name = descriptor.getName();
                    if (type.getDefaultGeometryAttributeName().equals(name)) continue;
                    objects.add(f.get(name));
                }
                FeatureImpl feature = new FeatureImpl(geom, objects.toArray(new Object[objects.size()]));
                if (!this.accept((IFeature)feature)) continue;
                bFound = true;
                this.m_CurrentValue = feature;
                this.m_bIsNextConsumed = false;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                return false;
            }
        }
        if (!bFound) {
            this.m_bFinished = true;
        }
        return bFound;
    }

    public IFeature next() {
        if (!this.m_bIsNextConsumed) {
            this.m_bIsNextConsumed = true;
            return this.m_CurrentValue;
        }
        if (!this.m_bFinished && this.moveToNextValid()) {
            this.m_bIsNextConsumed = true;
            return this.m_CurrentValue;
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        if (this.m_bFinished) {
            return false;
        }
        if (!this.m_bIsNextConsumed) {
            return true;
        }
        return this.moveToNextValid();
    }

    public void close() {
    }
}

