/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.app.project.documents.view.legend.gui.Quantities;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.app.project.documents.view.legend.gui.VectorialInterval;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialIntervalLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.SimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.SimpleMarkerSymbol;
import org.gvsig.symbology.fmap.rendering.GraduatedSymbolsLegend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraduatedSymbolsPanel
extends VectorialInterval
implements ILegendPanel {
    private static Logger logger = LoggerFactory.getLogger(GraduatedSymbolsPanel.class);
    private static final long serialVersionUID = -263195536343912694L;
    static final double DEFAULT_SYMBOL_MAX_SIZE = 7.0;
    private static final double DEFAULT_SYMBOL_MIN_SIZE = 1.0;
    private JNumberSpinner txtMinSize;
    private JNumberSpinner txtMaxSize;
    private JSymbolPreviewButton btnTemplate;
    private JSymbolPreviewButton btnBackground;
    private int shapeType;
    private GridBagLayoutPanel aux;
    private int templateShapeType = 0;
    private boolean showBackground = true;

    public GraduatedSymbolsPanel() {
        this.showBackground = true;
    }

    public GraduatedSymbolsPanel(boolean showBackground) {
        this.showBackground = showBackground;
    }

    public JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel(new FlowLayout(3));
            this.optionPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"symbol")));
            this.aux = new GridBagLayoutPanel();
            this.aux.addComponent((Component)new JLabel(Messages.getText((String)"size")));
            this.aux.addComponent(Messages.getText((String)"from") + ":", (Component)this.getTxtMinSize());
            this.aux.addComponent(Messages.getText((String)"to") + ":", (Component)this.getTxtMaxSize());
            this.aux.addComponent(Messages.getText((String)"template"), (Component)this.getBtnTemplate());
            this.optionPanel.add((Component)this.aux);
        }
        return this.optionPanel;
    }

    private void getBackgroundPanel() {
        this.aux.addComponent(Messages.getText((String)"background"), (Component)this.getBtnBackground());
    }

    private JSymbolPreviewButton getBtnBackground() {
        if (this.btnBackground == null) {
            this.btnBackground = new JSymbolPreviewButton(3);
            this.btnBackground.setPreferredSize(new Dimension(100, 35));
            ISymbol fillsym = MapContextLocator.getSymbolManager().createSymbol(3, Color.ORANGE);
            this.btnBackground.setSymbol(fillsym);
        }
        return this.btnBackground;
    }

    private JSymbolPreviewButton getBtnTemplate() {
        if (this.btnTemplate == null) {
            this.templateShapeType = GraduatedSymbolsLegend.isPolygonal(this.shapeType) ? 1 : this.shapeType;
            this.btnTemplate = new JSymbolPreviewButton(this.templateShapeType);
            this.btnTemplate.setPreferredSize(new Dimension(100, 35));
        }
        return this.btnTemplate;
    }

    private JNumberSpinner getTxtMaxSize() {
        if (this.txtMaxSize == null) {
            this.txtMaxSize = new JNumberSpinner(25.0, 7, 0.0, 100.0, 1.0, 2);
        }
        return this.txtMaxSize;
    }

    private JNumberSpinner getTxtMinSize() {
        if (this.txtMinSize == null) {
            this.txtMinSize = new JNumberSpinner(3.0, 7, 0.0, 100.0, 1.0, 2);
        }
        return this.txtMinSize;
    }

    public void setData(FLayer lyr, ILegend legend) {
        this.layer = (FLyrVect)lyr;
        try {
            this.shapeType = this.layer.getGeometryType().getType();
        }
        catch (ReadException e) {
            logger.info("Unable to get shapetype while setting data", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Unable_to_set_legend"), Messages.getText((String)"error"), 0);
        }
        this.templateShapeType = GraduatedSymbolsLegend.isPolygonal(this.shapeType) ? 1 : this.shapeType;
        this.getBtnTemplate().setShapeType(this.templateShapeType);
        if (this.showBackground && GraduatedSymbolsLegend.isPolygonal(this.shapeType) && this.btnBackground == null) {
            this.getBackgroundPanel();
            this.getBtnBackground().setShapeType(3);
        }
        if (this.symbolTable != null) {
            this.pnlCenter.remove((Component)this.symbolTable);
        }
        this.getDefaultSymbolPrev(this.templateShapeType);
        this.symbolTable = new SymbolTable((Component)((Object)this), "intervals", this.templateShapeType);
        this.pnlCenter.add((Component)this.symbolTable);
        this.fillFieldNames();
        if (legend instanceof GraduatedSymbolsLegend) {
            this.auxLegend = (GraduatedSymbolsLegend)legend.cloneLegend();
            this.getChkDefaultvalues().setSelected(this.auxLegend.isUseDefaultSymbol());
            this.cmbField.setSelectedItem(this.auxLegend.getClassifyingFieldNames()[0]);
            this.fillTableSkipDefault(this.auxLegend);
            this.getTxtMaxSize().setDouble(((GraduatedSymbolsLegend)this.auxLegend).getMaxSymbolSize());
            this.getTxtMinSize().setDouble(((GraduatedSymbolsLegend)this.auxLegend).getMinSymbolSize());
            if (this.auxLegend.getSymbols().length > 0) {
                this.getBtnTemplate().setSymbol(((GraduatedSymbolsLegend)this.auxLegend).getSymbols()[this.auxLegend.getSymbols().length - 1]);
            } else {
                this.getBtnTemplate().setSymbol(this.newSymbol(this.shapeType, GraduatedSymbolsLegend.isLinear(this.shapeType) ? 3.0 : 10.0));
            }
            if (this.showBackground && GraduatedSymbolsLegend.isPolygonal(this.shapeType)) {
                this.getBtnBackground().setSymbol(((GraduatedSymbolsLegend)this.auxLegend).getBackgroundSymbol());
            }
            if (this.auxLegend.isUseDefaultSymbol()) {
                this.txtNumIntervals.setText(String.valueOf(this.auxLegend.getSymbols().length - 1));
            } else {
                this.txtNumIntervals.setText(String.valueOf(this.auxLegend.getSymbols().length));
            }
        } else {
            this.auxLegend = new GraduatedSymbolsLegend();
            this.getTxtMaxSize().setDouble(7.0);
            this.getTxtMinSize().setDouble(1.0);
            this.auxLegend.setDefaultSymbol(this.newSymbol(this.shapeType, GraduatedSymbolsLegend.isLinear(this.shapeType) ? 3.0 : 10.0));
            this.getBtnTemplate().setSymbol(this.auxLegend.getDefaultSymbol());
            ((GraduatedSymbolsLegend)this.auxLegend).setTemplateShapeType(this.templateShapeType);
        }
        this.cmbIntervalType.setSelectedIndex(this.auxLegend.getIntervalType());
        this.defaultSymbolPrev.setSymbol(this.auxLegend.getDefaultSymbol());
    }

    public String getDescription() {
        return Messages.getText((String)"draw_quantities_using_symbol_size_to_show_relative_values");
    }

    public ILegend getLegend() {
        GraduatedSymbolsLegend gsl = new GraduatedSymbolsLegend((VectorialIntervalLegend)super.getLegend());
        double minSize = this.getTxtMinSize().getDouble();
        gsl.setMinSymbolSize(minSize);
        gsl.setMaxSymbolSize(this.getTxtMaxSize().getDouble());
        try {
            gsl.setShapeType(this.layer.getGeometryType().getType());
        }
        catch (ReadException e) {
            logger.info("Unable to get shapetype while getting legend", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Unable_to_get_legend"), Messages.getText((String)"error"), 0);
        }
        ISymbol sym = this.getBtnTemplate().getSymbol();
        if (sym != null) {
            gsl.setTemplateShapeType(sym.getSymbolType());
            gsl.setDefaultSymbol(sym);
        } else {
            gsl.setTemplateShapeType(this.templateShapeType);
        }
        gsl.useDefaultSymbol(this.getChkDefaultvalues().isSelected());
        if (this.defaultSymbolPrev.getSymbol() != null) {
            gsl.setDefaultSymbol(this.defaultSymbolPrev.getSymbol());
        }
        if (this.showBackground && GraduatedSymbolsLegend.isPolygonal(this.shapeType)) {
            gsl.setBackgroundSymbol(this.btnBackground.getSymbol());
        }
        return gsl;
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"legend-overview-graduated-symbols");
    }

    public Class getParentClass() {
        return Quantities.class;
    }

    public String getTitle() {
        return Messages.getText((String)"graduated_symbols");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return GraduatedSymbolsLegend.class;
    }

    public boolean isSuitableFor(FLayer layer) {
        if (super.isSuitableFor(layer)) {
            FLyrVect lVect = (FLyrVect)layer;
            try {
                return lVect.getGeometryType().getType() != 0;
            }
            catch (ReadException e) {
                ApplicationLocator.getManager().message(Messages.getText((String)"error_trying_to_access_to_the_layer"), 0);
                return false;
            }
        }
        return false;
    }

    private ISymbol newSymbol(int st, double size) {
        if (this.getBtnTemplate().getSymbol() == null) {
            SimpleLineSymbol templateSymbol;
            if (GraduatedSymbolsLegend.isLinear(st)) {
                templateSymbol = new SimpleLineSymbol();
                templateSymbol.setLineWidth(size);
                templateSymbol.setLineColor(Color.DARK_GRAY);
            } else {
                templateSymbol = new SimpleMarkerSymbol();
                ((SimpleMarkerSymbol)templateSymbol).setSize(size);
                ((SimpleMarkerSymbol)templateSymbol).setColor(Color.DARK_GRAY);
            }
            this.getBtnTemplate().setSymbol((ISymbol)templateSymbol);
            return this.newSymbol(st, size);
        }
        ISymbol mySymbol = null;
        try {
            mySymbol = (ISymbol)this.getBtnTemplate().getSymbol().clone();
        }
        catch (CloneNotSupportedException e) {
            ApplicationLocator.getManager().message(Messages.getText((String)"_Unable_to_get_symbol"), 0);
            logger.info("Error: Could not clone symbol", (Throwable)e);
        }
        if (mySymbol instanceof ILineSymbol) {
            ILineSymbol lSym = (ILineSymbol)mySymbol;
            lSym.setLineWidth(size);
        }
        if (mySymbol instanceof IMarkerSymbol) {
            IMarkerSymbol mSym = (IMarkerSymbol)mySymbol;
            mSym.setSize(size);
            if (GraduatedSymbolsLegend.isPolygonal(st)) {
                MarkerFillSymbol fillSymbol = new MarkerFillSymbol();
                fillSymbol.setOutline(null);
                fillSymbol.setFillColor(null);
                fillSymbol.getMarkerFillProperties().setFillStyle(2);
                fillSymbol.setMarker(mSym);
            }
        }
        return mySymbol;
    }

    protected void fillTableValues() {
        this.symbolTable.removeAllItems();
        try {
            IInterval[] arrayIntervalos = this.calculateIntervals();
            if (arrayIntervalos == null) {
                return;
            }
            NumberFormat.getInstance().setMaximumFractionDigits(2);
            this.auxLegend.clear();
            float minSize = (float)this.getTxtMinSize().getDouble();
            float maxSize = (float)this.getTxtMaxSize().getDouble();
            this.shapeType = this.layer.getGeometryType().getType();
            if (GraduatedSymbolsLegend.isPolygonal(this.shapeType)) {
                this.templateShapeType = 1;
            }
            MapContextManager mcm = MapContextLocator.getMapContextManager();
            this.auxLegend = (IVectorialIntervalLegend)mcm.createLegend("VectorialInterval");
            this.auxLegend.setShapeType(this.shapeType);
            this.auxLegend.setIntervalType(this.cmbIntervalType.getSelectedIndex());
            if (this.chkdefaultvalues.isSelected()) {
                this.auxLegend.getDefaultSymbol().setDescription("Default");
                this.auxLegend.addSymbol((Object)"Default", mcm.getSymbolManager().createSymbol(this.templateShapeType));
            }
            int symbolType = this.layer.getGeometryType().getType();
            int numSymbols = 0;
            double step = (maxSize - minSize) / (float)arrayIntervalos.length;
            double size = minSize;
            for (int k = 0; k < arrayIntervalos.length; ++k) {
                int resp;
                IInterval interval = arrayIntervalos[k];
                ISymbol theSymbol = this.newSymbol(symbolType, size);
                this.auxLegend.addSymbol((Object)interval, theSymbol);
                if (++numSymbols > 100 && ((resp = JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getText((String)"mas_de_100_simbolos"), Messages.getText((String)"quiere_continuar"), 0, 2)) == 1 || resp == -1)) {
                    return;
                }
                theSymbol.setDescription(NumberFormat.getInstance().format(interval.getMin()) + " - " + NumberFormat.getInstance().format(interval.getMax()));
                size += step;
            }
            this.fillTableSkipDefault(this.auxLegend);
        }
        catch (ReadException re) {
            logger.info("Error could_not_get_shape_type", (Throwable)re);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"could_not_get_shape_type"), Messages.getText((String)"error"), 0);
        }
        catch (LegendLayerException lle) {
            logger.info("Error failed_computing_intervals", (Throwable)lle);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"failed_computing_intervals"), Messages.getText((String)"error"), 0);
        }
        this.bDelAll.setEnabled(true);
        this.bDel.setEnabled(true);
    }

    public void setShowBackground(boolean sb) {
        this.showBackground = sb;
    }

    public boolean getShowBackground() {
        return this.showBackground;
    }

    private void fillTableSkipDefault(IVectorialIntervalLegend leg) {
        Object[] src_expr = leg.getValues();
        ISymbol[] src_syms = leg.getSymbols();
        String[] src_descs = leg.getDescriptions();
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<String> descs = new ArrayList<String>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (!(src_expr[i] instanceof IInterval)) continue;
            syms.add(src_syms[i]);
            vals.add(src_expr[i]);
            descs.add(src_descs[i]);
        }
        this.symbolTable.fillTableFromSymbolList(syms.toArray(new ISymbol[0]), vals.toArray(new Object[0]), descs.toArray(new String[0]));
    }
}

