/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class SubstringFunction
extends AbstractFunction {
    public SubstringFunction() {
        super("String", "SUBSTRING", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)));
        this.addAlias("SUBSTR");
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String str = this.getStr(args, 0);
        int start = this.getInt(args, 1);
        int len = 0;
        if (args.length == 3 && (len = this.getInt(args, 2)) < 0) {
            throw new IllegalArgumentException("Length must be greater than or equal to 0");
        }
        if (start < 1) {
            len = len + start - 1;
            start = 1;
        }
        String r = StringUtils.substring((String)str, (int)(start - 1));
        if (args.length == 3) {
            r = StringUtils.left((String)r, (int)len);
        }
        return r;
    }
}

