/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.layers;

import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;

public class RasterDrawStrategy {
    public static HashMap<MapContext, HashMap<DefaultFLyrRaster, Boolean>> mapContextStrategy = new HashMap();
    private MapContext mapContext = null;
    private DefaultFLyrRaster lyrRaster = null;

    public RasterDrawStrategy(MapContext mapContext, DefaultFLyrRaster lyrRaster) {
        this.mapContext = mapContext;
        this.lyrRaster = lyrRaster;
    }

    public void stackStrategy() {
        if (this.mapContext == null || this.lyrRaster == null) {
            return;
        }
        ArrayList<FLayer> listLayers = new ArrayList<FLayer>();
        FLayers lyrs = this.mapContext.getLayers();
        listLayers = RasterDrawStrategy.getLayerList(lyrs, listLayers);
        ArrayList<LayerIntersection> extentList = new ArrayList<LayerIntersection>();
        int posFirstRasterLayer = 0;
        int nRasterLayers = 0;
        boolean firstTime = true;
        for (int i = 0; i < listLayers.size(); ++i) {
            FLayer lyr = listLayers.get(i);
            if (firstTime && lyr instanceof DefaultFLyrRaster && lyr.isVisible()) {
                posFirstRasterLayer = i;
                firstTime = false;
            }
            if (!(lyr instanceof DefaultFLyrRaster)) continue;
            ++nRasterLayers;
        }
        if (nRasterLayers == 1) {
            mapContextStrategy.put(this.mapContext, null);
            return;
        }
        if (this.lyrRaster != listLayers.get(posFirstRasterLayer)) {
            if (!(listLayers.get(posFirstRasterLayer) instanceof DefaultFLyrRaster)) {
                return;
            }
            mapContextStrategy.put(this.mapContext, ((DefaultFLyrRaster)listLayers.get(posFirstRasterLayer)).getRasterStrategy());
            return;
        }
        HashMap<DefaultFLyrRaster, Boolean> layersToPaint = new HashMap<DefaultFLyrRaster, Boolean>();
        for (int i = listLayers.size() - 1; i >= 0; --i) {
            DefaultFLyrRaster rLyr;
            FLayer lyr = listLayers.get(i);
            if (!(lyr instanceof DefaultFLyrRaster) || (rLyr = (DefaultFLyrRaster)lyr).getRender() == null || rLyr.getRender().getFilterList() == null || rLyr.getFullEnvelope() == null) continue;
            if (!rLyr.isVisible()) {
                layersToPaint.put(rLyr, new Boolean(false));
                continue;
            }
            if (rLyr.getAffineTransform() != null && (rLyr.getAffineTransform().getShearX() != 0.0 || rLyr.getAffineTransform().getShearY() != 0.0)) {
                layersToPaint.put(rLyr, new Boolean(true));
                continue;
            }
            LayerIntersection li = this.areIntersecting(extentList, rLyr);
            if (i == listLayers.size() - 1 || li == null) {
                Render render;
                boolean colorTableAlpha = false;
                if (rLyr.getRender().getFilterList() != null && (render = rLyr.getRender()) != null && render.getColorTable() != null) {
                    colorTableAlpha = render.getColorTable().hasAlpha();
                }
                extentList.add(new LayerIntersection(rLyr.getFullRasterExtent(), rLyr.existsAlphaBand() || rLyr.isTransparent() || colorTableAlpha));
                layersToPaint.put(rLyr, new Boolean(true));
                continue;
            }
            if (li != null && !li.hasTransparency) {
                layersToPaint.put(rLyr, new Boolean(false));
                continue;
            }
            if (!rLyr.isTransparent()) {
                li.hasTransparency = false;
            }
            layersToPaint.put(rLyr, new Boolean(true));
        }
        mapContextStrategy.put(this.mapContext, layersToPaint);
    }

    public static ArrayList<FLayer> getLayerList(FLayers srcLyrs, ArrayList<FLayer> destLyrs) {
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof DefaultFLyrRaster) {
                destLyrs.add(srcLyrs.getLayer(i));
            }
            if (!(srcLyrs.getLayer(i) instanceof FLayers)) continue;
            destLyrs = RasterDrawStrategy.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
        }
        return destLyrs;
    }

    private LayerIntersection areIntersecting(ArrayList<LayerIntersection> extentList, DefaultFLyrRaster lyr) {
        for (int i = 0; i < extentList.size(); ++i) {
            Extent ex = lyr.getFullRasterExtent();
            Extent ex1 = extentList.get((int)i).extent;
            if (!RasterLocator.getManager().getRasterUtils().isInside(ex, ex1)) continue;
            return extentList.get(i);
        }
        return null;
    }

    public HashMap<DefaultFLyrRaster, Boolean> getStrategy() {
        return mapContextStrategy.get(this.mapContext);
    }

    public class LayerIntersection {
        public Extent extent = null;
        public boolean hasTransparency = false;

        public LayerIntersection(Extent ext, boolean transp) {
            this.extent = ext;
            this.hasTransparency = transp;
        }
    }
}

