/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Print
extends Extension
implements Printable {
    private static Logger logger = LoggerFactory.getLogger(Print.class);
    public static PrinterJob printerJob = PrinterJob.getPrinterJob();
    Rectangle2D.Double aux = null;
    private PrintService[] m_cachePrintServices = null;
    private PrintService m_cachePrintService = null;
    private static LayoutPanel theLayoutPanel = null;

    public void execute(String s) {
        if (s.compareTo("application-print-layout") == 0) {
            this.doPrint((LayoutPanel)PluginServices.getMDIManager().getActiveWindow());
        }
    }

    public void doPrint(final LayoutPanel layoutPanel) {
        theLayoutPanel = layoutPanel;
        try {
            PluginServices.backgroundExecution((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (layoutPanel.getLayoutContext().getAttributes().getType() == 6) {
                        layoutPanel.showPrintDialog(printerJob);
                    } else {
                        layoutPanel.showPrintDialog(null);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.info("Error while showing print dialog.", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Error_while_showing_print_dialog"), Messages.getText((String)"Imprimir"), 0);
        }
    }

    public void setLayout(LayoutPanel layoutp) {
        theLayoutPanel = layoutp;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof LayoutPanel;
    }

    public boolean isEnabled() {
        LayoutPanel f = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        return f != null;
    }

    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"application-print", (Object)this);
    }

    public void openDialogToPrint(LayoutPanel layoutPanel) {
        theLayoutPanel = layoutPanel;
        try {
            if (layoutPanel.getLayoutContext().getAttributes().getType() == 6) {
                layoutPanel.showPrintDialog(printerJob);
            } else {
                layoutPanel.showPrintDialog(null);
            }
        }
        catch (Exception e) {
            System.out.println("Excepci\u00f3n al abrir el di\u00e1logo de impresi\u00f3n: " + e);
            e.printStackTrace();
        }
    }

    public void printLayout(LayoutPanel layoutPanel) {
        theLayoutPanel = layoutPanel;
        try {
            printerJob.setPrintable((Printable)PluginServices.getExtension(Print.class));
            PrintRequestAttributeSet att = layoutPanel.getLayoutContext().getAttributes().toPrintRequestAttributeSet();
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            if (this.m_cachePrintServices == null) {
                this.m_cachePrintServices = PrintServiceLookup.lookupPrintServices(flavor, null);
            }
            PrintService defaultService = null;
            if (this.m_cachePrintService == null) {
                defaultService = PrintServiceLookup.lookupDefaultPrintService();
            }
            if (this.m_cachePrintService == null) {
                this.m_cachePrintService = ServiceUI.printDialog(null, 200, 200, this.m_cachePrintServices, defaultService, flavor, att);
            }
            if (this.m_cachePrintService != null) {
                DocPrintJob jobNuevo = this.m_cachePrintService.createPrintJob();
                PrintJobAdapter pjlistener = new PrintJobAdapter(){

                    @Override
                    public void printDataTransferCompleted(PrintJobEvent e) {
                        System.out.println("Fin de impresi\u00f3n");
                    }
                };
                jobNuevo.addPrintJobListener(pjlistener);
                SimpleDoc doc = new SimpleDoc(PluginServices.getExtension(Print.class), flavor, null);
                jobNuevo.print(doc, att);
            }
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    public void drawShapes(Graphics2D g2) {
        theLayoutPanel.drawLayoutPrint(g2);
    }

    @Override
    public int print(Graphics g, PageFormat format, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        g2d.translate(0, 0);
        theLayoutPanel.obtainRect(true);
        g2d.scale(72.0 / (double)Attributes.DPI, 72.0 / (double)Attributes.DPI);
        if (theLayoutPanel.getLayoutContext().getAttributes().isMargin()) {
            g2d.setClip((int)(theLayoutPanel.getLayoutControl().getRect().getMinX() + FLayoutUtilities.fromSheetDistance(theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[2], theLayoutPanel.getLayoutControl().getAT())), (int)(theLayoutPanel.getLayoutControl().getRect().getMinY() + FLayoutUtilities.fromSheetDistance(theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[0], theLayoutPanel.getLayoutControl().getAT())), (int)(theLayoutPanel.getLayoutControl().getRect().getWidth() - FLayoutUtilities.fromSheetDistance(theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[2] + theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[3], theLayoutPanel.getLayoutControl().getAT())), (int)(theLayoutPanel.getLayoutControl().getRect().getHeight() - FLayoutUtilities.fromSheetDistance(theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[0] + theLayoutPanel.getLayoutContext().getAttributes().getAreaInsets()[1], theLayoutPanel.getLayoutControl().getAT())));
        }
        this.drawShapes(g2d);
        g2d.setTransform(at);
        return 0;
    }
}

