/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.extension.LayoutExtension;
import org.gvsig.app.project.documents.layout.Size;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.utils.XMLEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attributes
implements Persistent,
Cloneable {
    public static final String PERSISTENCE_DEFINITION_NAME = "Attributes";
    public static final String DPI_FIELD = "DPI";
    public static final String DPISCREEN_FIELD = "DPISCREEN";
    public static final String TYPEUNIT_FIELD = "typeUnit";
    public static final String NUMX_FIELD = "numX";
    public static final String NUMY_FIELD = "numY";
    public static final String UNITX_FIELD = "unitX";
    public static final String UNITY_FIELD = "unitY";
    public static final String HASMARGIN_FIELD = "hasMargin";
    public static final String RESOLUTIONSEL_FIELD = "resolutionSel";
    public static final String TYPESEL_FIELD = "typeSel";
    public static final String SELTYPEUNIT_FIELD = "selTypeUnit";
    public static final String SIZEPAPER_FIELD = "sizePaper";
    public static final String AREA_FIELD = "area";
    public static final String SIZEINUNITS_FIELD = "sizeInUnits";
    public static final String ISLANDSEL_FIELD = "isLandSel";
    public static final String DEGREES = "Grados";
    public static final int HIGH = 0;
    public static final int NORMAL = 1;
    public static final int DRAFT = 2;
    public static final double PULGADA = 2.54;
    public static final Size STANDARD_LETTER_PAPER_SIZE = new Size(8.5, 11.0);
    public static final Size STANDARD_FOLIO_PAPER_SIZE = new Size(8.5, 13.0);
    public static final Size STANDARD_LEGAL_PAPER_SIZE = new Size(8.5, 14.0);
    public static final Size STANDARD_TABLOID_PAPER_SIZE = new Size(11.0, 17.0);
    public static final Size METRIC_A0_PAPER_SIZE = new Size(118.9, 84.1);
    public static final Size METRIC_A1_PAPER_SIZE = new Size(84.1, 59.4);
    public static final Size METRIC_A2_PAPER_SIZE = new Size(59.4, 42.0);
    public static final Size METRIC_A3_PAPER_SIZE = new Size(42.0, 29.7);
    public static final Size METRIC_A4_PAPER_SIZE = new Size(29.7, 21.0);
    public static final Size METRIC_A5_PAPER_SIZE = new Size(21.0, 14.8);
    public static final Size ANSI_ENG_A_PAPER_SIZE = new Size(11.0, 8.5);
    public static final Size ANSI_ENG_B_PAPER_SIZE = new Size(17.0, 11.0);
    public static final Size ANSI_ENG_C_PAPER_SIZE = new Size(22.0, 17.0);
    public static final Size ANSI_ENG_D_PAPER_SIZE = new Size(34.0, 22.0);
    public static final Size ANSI_ENG_E_PAPER_SIZE = new Size(44.0, 34.0);
    public static final Size ANSI_ARCH_A_PAPER_SIZE = new Size(12.0, 9.0);
    public static final Size ANSI_ARCH_B_PAPER_SIZE = new Size(18.0, 12.0);
    public static final Size ANSI_ARCH_C_PAPER_SIZE = new Size(24.0, 18.0);
    public static final Size ANSI_ARCH_D_PAPER_SIZE = new Size(36.0, 24.0);
    public static final Size ANSI_ARCH_E_PAPER_SIZE = new Size(42.0, 30.0);
    private Size last_custom_paper_size = new Size(100.0, 100.0);
    public static final int PRINT = 0;
    public static final int CUSTOM = 6;
    public static final int A0 = 5;
    public static final int A1 = 4;
    public static final int A2 = 3;
    public static final int A3 = 2;
    public static final int A4 = 1;
    public static int DPI = 300;
    public static int DPISCREEN = 72;
    private static Point2D defaultGridGap;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private MediaSizeName m_type = MediaSizeName.ISO_A4;
    private OrientationRequested m_Orientation;
    private double m_TypeUnit = Attributes.getConversionFactorToCm(2);
    private String m_NameUnit;
    private Double m_gridGapCmX = null;
    private Double m_gridGapCmY = null;
    private double m_gridGapPxX = 0.0;
    private double m_gridGapPxY = 0.0;
    private boolean hasmargin;
    private int m_resolutionSel = 1;
    private int m_typeSel = 0;
    private int m_selTypeUnit = 2;
    private Size m_sizePaper = new Size(METRIC_A4_PAPER_SIZE.getHeight(), METRIC_A4_PAPER_SIZE.getWidth());
    private double[] area_tblr = new double[]{0.0, 0.0, 0.0, 0.0};
    private Size m_sizeinUnits = this.m_sizePaper;

    public Attributes() {
        this.m_NameUnit = Messages.getText((String)"Centimetros");
        this.m_Orientation = OrientationRequested.LANDSCAPE;
        this.m_type = MediaSizeName.ISO_A4;
        this.resetSizeinUnits();
        this.hasmargin = false;
        this.attributes.add(new Copies(1));
        this.attributes.add(MediaSizeName.ISO_A4);
        this.attributes.add(Sides.ONE_SIDED);
        this.attributes.add(Fidelity.FIDELITY_FALSE);
        this.attributes.add(PrintQuality.NORMAL);
        this.setType(this.m_typeSel);
        this.attributes.add(new MediaPrintableArea(0.0f, 0.0f, (float)(this.getPaperSize().getWidth() * (double)DPISCREEN / 2.54), (float)(this.getPaperSize().getHeight() * (double)DPISCREEN / 2.54), 1000));
    }

    public boolean isLandscape() {
        return this.m_Orientation.getValue() == OrientationRequested.LANDSCAPE.getValue();
    }

    public boolean isPortrait() {
        return this.m_Orientation.getValue() == OrientationRequested.PORTRAIT.getValue();
    }

    public void setSelectedOptions(int typeSel, int units, boolean isLand, boolean margin, int resolution, double[] _area_tplr) {
        this.setType(typeSel);
        this.setUnit(units);
        this.setIsLandScape(isLand);
        this.hasmargin = margin;
        this.setResolution(resolution);
        this.area_tblr = _area_tplr;
    }

    public Size getPaperSize() {
        return this.m_sizePaper;
    }

    public void setPaperSize(Size paperSize) {
        this.m_sizePaper = this.getCorrectedSize(paperSize);
        if (this.getType() == 6) {
            this.last_custom_paper_size = paperSize;
        }
        this.resetSizeinUnits();
    }

    public Size getCustomPaperSize() {
        return this.last_custom_paper_size;
    }

    public PageFormat getPageFormat() {
        PageFormat pf1 = new PageFormat();
        Paper paper = pf1.getPaper();
        paper.setSize(this.m_sizePaper.getWidth() * (double)DPISCREEN / 2.54, this.m_sizePaper.getHeight() * (double)DPISCREEN / 2.54);
        if (this.isLandscape()) {
            pf1.setOrientation(0);
            paper.setImageableArea(this.getInPixels(this.area_tblr[1]), this.getInPixels(this.area_tblr[2]), this.getInPixels(this.m_sizeinUnits.getHeight() - this.area_tblr[0] - this.area_tblr[1]), this.getInPixels(this.m_sizeinUnits.getWidth() - this.area_tblr[2] - this.area_tblr[3]));
        } else {
            pf1.setOrientation(1);
            paper.setImageableArea(this.getInPixels(this.area_tblr[2]), this.getInPixels(this.area_tblr[0]), this.getInPixels(this.m_sizeinUnits.getWidth() - this.area_tblr[2] - this.area_tblr[3]), this.getInPixels(this.m_sizeinUnits.getHeight() - this.area_tblr[0] - this.area_tblr[1]));
        }
        pf1.setPaper(paper);
        return pf1;
    }

    private double getInPixels(double d) {
        return d * ((double)DPISCREEN / 2.54);
    }

    private double getInCM(double d) {
        return d / ((double)DPISCREEN / 2.54);
    }

    public Rectangle2D getArea() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setRect(this.area_tblr[2], this.area_tblr[0], this.m_sizePaper.getWidth() - this.area_tblr[2] - this.area_tblr[3], this.m_sizePaper.getHeight() - this.area_tblr[0] - this.area_tblr[1]);
        return rect;
    }

    public double[] getAreaInsets() {
        return this.area_tblr;
    }

    public void setPageFormat(PageFormat pf) {
        Size portrait_size = new Size(pf.getPaper().getHeight(), pf.getPaper().getWidth());
        this.setType(this.getTypePaper(portrait_size, true));
        if (pf.getOrientation() == 0) {
            this.setIsLandScape(true);
        } else {
            this.setIsLandScape(false);
        }
        this.attributes.add(this.m_Orientation);
        if (this.isLandscape()) {
            this.area_tblr[1] = this.getInCM(pf.getImageableX());
            this.area_tblr[2] = this.getInCM(pf.getImageableY());
            this.area_tblr[0] = portrait_size.getWidth() - this.getInCM(pf.getImageableHeight()) - this.area_tblr[1];
            this.area_tblr[3] = portrait_size.getHeight() - this.getInCM(pf.getImageableWidth()) - this.area_tblr[2];
        } else {
            this.area_tblr[2] = this.getInCM(pf.getImageableX());
            this.area_tblr[0] = this.getInCM(pf.getImageableY());
            this.area_tblr[1] = portrait_size.getHeight() - this.getInCM(pf.getImageableHeight()) - this.area_tblr[0];
            this.area_tblr[3] = portrait_size.getWidth() - this.getInCM(pf.getImageableWidth()) - this.area_tblr[2];
        }
        this.attributes.add(new MediaPrintableArea((float)(this.area_tblr[2] * 10.0), (float)(this.area_tblr[0] * 10.0), (float)(this.getInCM(pf.getImageableWidth()) * 10.0), (float)(this.getInCM(pf.getImageableHeight()) * 10.0), 1000));
    }

    public PrintRequestAttributeSet toPrintRequestAttributeSet() {
        HashPrintRequestAttributeSet resul = new HashPrintRequestAttributeSet();
        this.setType(this.m_typeSel);
        resul.add(this.m_type);
        resul.add(this.m_Orientation);
        Rectangle2D rect = this.getArea();
        resul.add(new MediaPrintableArea((float)(rect.getX() * 10.0), (float)(rect.getY() * 10.0), (float)(rect.getWidth() * 10.0), (float)(rect.getHeight() * 10.0), 1000));
        resul.add(Attributes.toPrintQuality(this.m_resolutionSel));
        return resul;
    }

    public DocAttributeSet toDocAttributes() {
        HashDocAttributeSet resul = new HashDocAttributeSet();
        this.setType(this.m_typeSel);
        resul.add(this.m_type);
        resul.add(this.m_Orientation);
        Rectangle2D rect = this.getArea();
        resul.add(new MediaPrintableArea((float)(rect.getX() * 10.0), (float)(rect.getY() * 10.0), (float)(rect.getWidth() * 10.0), (float)(rect.getHeight() * 10.0), 1000));
        resul.add(Attributes.toPrintQuality(this.m_resolutionSel));
        return resul;
    }

    public PrintAttributes toPrintAttributes() {
        PrintAttributes resul = CompatLocator.getGraphicsUtils().createPrintAttributes();
        if (this.m_resolutionSel == 2) {
            resul.setPrintQuality(0);
        } else if (this.m_resolutionSel == 1) {
            resul.setPrintQuality(1);
        } else if (this.m_resolutionSel == 0) {
            resul.setPrintQuality(2);
        } else {
            throw new UnsupportedOperationException("Unsupported Print Quality: " + this.m_resolutionSel);
        }
        this.setType(this.m_typeSel);
        return resul;
    }

    public PrintRequestAttributeSet toPrintAttributeSet() {
        HashPrintRequestAttributeSet resul = new HashPrintRequestAttributeSet();
        this.setType(this.m_typeSel);
        resul.add(this.m_type);
        resul.add(this.m_Orientation);
        Rectangle2D rect = this.getArea();
        resul.add(new MediaPrintableArea((float)(rect.getX() * (double)DPISCREEN / 2.54), (float)(rect.getY() * (double)DPISCREEN / 2.54), (float)(rect.getWidth() * (double)DPISCREEN / 2.54), (float)(rect.getHeight() * (double)DPISCREEN / 2.54), 1000));
        resul.add(Attributes.toPrintQuality(this.m_resolutionSel));
        return resul;
    }

    public boolean isMargin() {
        return this.hasmargin;
    }

    public int getResolution() {
        return this.m_resolutionSel;
    }

    public void setResolution(int i) {
        this.m_resolutionSel = i;
        switch (i) {
            case 0: {
                DPI = 600;
                break;
            }
            case 1: {
                DPI = 300;
                break;
            }
            case 2: {
                DPI = 72;
            }
        }
        this.attributes.add(Attributes.toPrintQuality(i));
    }

    public static PrintQuality toPrintQuality(int quality) {
        switch (quality) {
            case 0: {
                return PrintQuality.HIGH;
            }
            case 1: {
                return PrintQuality.NORMAL;
            }
            case 2: {
                return PrintQuality.DRAFT;
            }
        }
        return PrintQuality.NORMAL;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    public int getType() {
        return this.m_typeSel;
    }

    public void setHGridGrapCm(double d) {
        this.m_gridGapCmX = new Double(d);
    }

    public double getHGridGapCm() {
        if (this.m_gridGapCmX == null) {
            this.m_gridGapCmX = new Double(Attributes.getDefaultGridGap().getX());
        }
        return this.m_gridGapCmX;
    }

    public double getVGridGapCm() {
        if (this.m_gridGapCmY == null) {
            this.m_gridGapCmY = new Double(Attributes.getDefaultGridGap().getY());
        }
        return this.m_gridGapCmY;
    }

    public void setVGridGrapCm(double d) {
        this.m_gridGapCmY = new Double(d);
    }

    public void setIsLandScape(boolean b) {
        this.m_Orientation = b ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT;
        this.setType(this.m_typeSel);
    }

    public void setType(int t) {
        this.m_typeSel = t;
        switch (t) {
            case 0: {
                this.m_type = (MediaSizeName)this.attributes.get(Media.class);
                this.setPaperSize(METRIC_A4_PAPER_SIZE);
                break;
            }
            case 1: {
                this.m_type = MediaSizeName.ISO_A4;
                this.setPaperSize(METRIC_A4_PAPER_SIZE);
                break;
            }
            case 2: {
                this.m_type = MediaSizeName.ISO_A3;
                this.setPaperSize(METRIC_A3_PAPER_SIZE);
                break;
            }
            case 3: {
                this.m_type = MediaSizeName.ISO_A2;
                this.setPaperSize(METRIC_A2_PAPER_SIZE);
                break;
            }
            case 4: {
                this.m_type = MediaSizeName.ISO_A1;
                this.setPaperSize(METRIC_A1_PAPER_SIZE);
                break;
            }
            case 5: {
                this.m_type = MediaSizeName.ISO_A0;
                this.setPaperSize(METRIC_A0_PAPER_SIZE);
                break;
            }
            case 6: {
                this.m_type = MediaSizeName.PERSONAL_ENVELOPE;
                this.setPaperSize(this.last_custom_paper_size);
            }
        }
        this.attributes.add(this.m_type);
    }

    public void setPaperSizeInUnits(Size sizeInUnits) {
        this.setPaperSize(new Size(sizeInUnits.getHeight() * this.m_TypeUnit, sizeInUnits.getWidth() * this.m_TypeUnit));
    }

    public Size getPaperSizeinUnits(boolean isLand, int type) {
        Size size = null;
        switch (type) {
            case 0: {
                if (isLand) {
                    size = new Size(METRIC_A4_PAPER_SIZE.getWidth(), METRIC_A4_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A4_PAPER_SIZE;
                break;
            }
            case 1: {
                if (isLand) {
                    size = new Size(METRIC_A4_PAPER_SIZE.getWidth(), METRIC_A4_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A4_PAPER_SIZE;
                break;
            }
            case 2: {
                if (isLand) {
                    size = new Size(METRIC_A3_PAPER_SIZE.getWidth(), METRIC_A3_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A3_PAPER_SIZE;
                break;
            }
            case 3: {
                if (isLand) {
                    size = new Size(METRIC_A2_PAPER_SIZE.getWidth(), METRIC_A2_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A2_PAPER_SIZE;
                break;
            }
            case 4: {
                if (isLand) {
                    size = new Size(METRIC_A1_PAPER_SIZE.getWidth(), METRIC_A1_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A1_PAPER_SIZE;
                break;
            }
            case 5: {
                if (isLand) {
                    size = new Size(METRIC_A0_PAPER_SIZE.getWidth(), METRIC_A0_PAPER_SIZE.getHeight());
                    break;
                }
                size = METRIC_A0_PAPER_SIZE;
                break;
            }
            case 6: {
                size = this.isLandscape() ? new Size(this.last_custom_paper_size.getWidth() * this.m_TypeUnit, this.last_custom_paper_size.getHeight() * this.m_TypeUnit) : new Size(this.last_custom_paper_size.getHeight() * this.m_TypeUnit, this.last_custom_paper_size.getWidth() * this.m_TypeUnit);
            }
        }
        Size resp = new Size(size.getHeight() / this.m_TypeUnit, size.getWidth() / this.m_TypeUnit);
        return resp;
    }

    public int getUnit() {
        return this.m_selTypeUnit;
    }

    @Deprecated
    public int getSelTypeUnit() {
        return this.getUnit();
    }

    public String getNameUnit() {
        return this.m_NameUnit;
    }

    public void setUnit(int sel) {
        Logger logger = LoggerFactory.getLogger(LayoutExtension.class);
        logger.debug("setUnit: " + sel);
        this.m_selTypeUnit = sel;
        this.m_TypeUnit = Attributes.getConversionFactorToCm(sel);
        this.resetSizeinUnits();
        this.m_NameUnit = PluginServices.getText((Object)this, (String)MapContext.getDistanceNames()[sel]);
    }

    private void resetSizeinUnits() {
        Size correctedSize = this.getCorrectedSize(this.m_sizePaper);
        this.m_sizeinUnits = new Size(correctedSize.getHeight() / this.m_TypeUnit, correctedSize.getWidth() / this.m_TypeUnit);
    }

    public double toUnits(double d) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String s = String.valueOf(nf.format(d));
        s = s.replace(',', '.');
        return Double.valueOf(s) / this.m_TypeUnit;
    }

    public double fromUnits(double d) {
        return d * this.m_TypeUnit;
    }

    public double getPixXCm(Rectangle2D rect) {
        double value = this.m_sizePaper.getWidth();
        double cm = Attributes.getConversionFactorToCm(2);
        double unidades = 0.0;
        unidades = (rect.getMaxX() - rect.getMinX()) / (value / cm);
        return unidades;
    }

    public void calculateGridGapX(Rectangle2D rect) {
        double unidades;
        double width = this.m_sizePaper.getWidth();
        double numberOfGaps = width / this.getHGridGapCm();
        this.m_gridGapPxX = unidades = (rect.getMaxX() - rect.getMinX()) / numberOfGaps;
    }

    public void calculateGridGapY(Rectangle2D rect) {
        double unidades;
        double height = this.m_sizePaper.getHeight();
        double numberOfGaps = height / this.getVGridGapCm();
        this.m_gridGapPxY = unidades = (rect.getMaxY() - rect.getMinY()) / numberOfGaps;
    }

    private double getPaperSizeRatio() {
        double resp = 1.0;
        resp = this.isLandscape() ? this.m_sizePaper.getWidth() / this.m_sizePaper.getHeight() : this.m_sizePaper.getHeight() / this.m_sizePaper.getWidth();
        return resp;
    }

    public void obtainRect(boolean isPrint, Rectangle2D rect, int w, int h) {
        double value1 = 0.0;
        double value2 = 0.0;
        if (!isPrint) {
            rect = this.isLandscape() ? this.getRectangleLandscape(rect, w, h) : this.getRectanglePortrait(rect, w, h);
        } else {
            value1 = this.m_sizePaper.getWidth();
            value2 = this.m_sizePaper.getHeight();
            rect.setRect(0.0, 0.0, value1 / 2.54 * (double)DPI, value2 / 2.54 * (double)DPI);
        }
        this.calculateGridGapX(rect);
        this.calculateGridGapY(rect);
    }

    public Rectangle2D.Double getRectangleLandscape(Rectangle2D rect, int w, int h) {
        Rectangle2D.Double rectaux = new Rectangle2D.Double();
        int x0 = (int)rect.getMinX();
        int y0 = (int)rect.getMinY();
        int newHeight = h - 2 * y0;
        int newWidth = (int)((double)newHeight * this.getPaperSizeRatio());
        if ((int)((double)(h - 2 * y0) * this.getPaperSizeRatio()) > w - 2 * x0) {
            newWidth = w - 2 * x0;
            newHeight = (int)((double)newWidth / this.getPaperSizeRatio());
        }
        rectaux.setRect(x0, y0, newWidth, newHeight);
        return rectaux;
    }

    public Size getPaperSizeInUnits() {
        return this.m_sizeinUnits;
    }

    @Deprecated
    public Size getSizeInUnits() {
        return this.getPaperSizeInUnits();
    }

    public Rectangle2D.Double getRectanglePortrait(Rectangle2D rect, int w, int h) {
        Rectangle2D.Double rectaux = new Rectangle2D.Double();
        int x0 = (int)rect.getMinX();
        int y0 = (int)rect.getMinY();
        int newWidth = w - 2 * x0;
        int newHeight = (int)((double)newWidth * this.getPaperSizeRatio());
        if ((int)((double)(w - 2 * x0) * this.getPaperSizeRatio()) > h - 2 * y0) {
            newHeight = h - 2 * y0;
            newWidth = (int)((double)newHeight / this.getPaperSizeRatio());
        }
        rectaux.setRect(x0, y0, newWidth, newHeight);
        return rectaux;
    }

    private Size getCorrectedSize(Size size) {
        Size result = this.isLandscape() && size.getWidth() < size.getHeight() || this.isPortrait() && size.getHeight() < size.getWidth() ? new Size(size.getWidth(), size.getHeight()) : size;
        return result;
    }

    private Size getCorrectedSize(double height, double width) {
        Size result = this.isLandscape() && width < height || this.isPortrait() && height < width ? new Size(width, height) : new Size(height, width);
        return result;
    }

    private int getTypePaper(Size size, boolean is_portrait) {
        double width;
        double height;
        double tol = 1.0;
        if (size.getHeight() < size.getWidth()) {
            height = size.getWidth();
            width = size.getHeight();
        } else {
            width = size.getWidth();
            height = size.getHeight();
        }
        double conversionFactor = 2.54 / (double)DPISCREEN;
        if (width * conversionFactor < tol + METRIC_A4_PAPER_SIZE.getWidth() && height * conversionFactor < tol + METRIC_A4_PAPER_SIZE.getHeight()) {
            return 1;
        }
        if (width * conversionFactor < tol + METRIC_A3_PAPER_SIZE.getWidth() && height * conversionFactor < tol + METRIC_A3_PAPER_SIZE.getHeight()) {
            return 2;
        }
        if (width * conversionFactor < tol + METRIC_A2_PAPER_SIZE.getWidth() && height * conversionFactor < tol + METRIC_A2_PAPER_SIZE.getHeight()) {
            return 3;
        }
        if (width * conversionFactor < tol + METRIC_A1_PAPER_SIZE.getWidth() && height * conversionFactor < tol + METRIC_A1_PAPER_SIZE.getHeight()) {
            return 4;
        }
        if (width * conversionFactor < tol + METRIC_A0_PAPER_SIZE.getWidth() && height * conversionFactor < tol + METRIC_A0_PAPER_SIZE.getHeight()) {
            return 5;
        }
        return 1;
    }

    public static void setDefaultGridGap(double hGap, double vGap, String hUnitAbbr, String vUnitAbbr) {
        int hUnit = Attributes.getDistanceAbbrPosition(hUnitAbbr);
        int vUnit = Attributes.getDistanceAbbrPosition(vUnitAbbr);
        double hGapCm = hGap * Attributes.getConversionFactorToCm(hUnit);
        double vGapCm = vGap * Attributes.getConversionFactorToCm(vUnit);
        defaultGridGap = new Point2D.Double(hGapCm, vGapCm);
    }

    public static Point2D getDefaultGridGap() {
        if (defaultGridGap == null) {
            PluginServices pluginServices = PluginsLocator.getManager().getPlugin(LayoutExtension.class);
            XMLEntity xml = null;
            if (pluginServices != null) {
                xml = pluginServices.getPersistentXML();
            }
            double hGap = xml != null && xml.contains("DefaultGridHorizontalGap") ? xml.getDoubleProperty("DefaultGridHorizontalGap") : 1.0;
            double vGap = xml != null && xml.contains("DefaultGridVerticalGap") ? xml.getDoubleProperty("DefaultGridVerticalGap") : 1.0;
            String hUnitName = xml != null && xml.contains("DefaultGridHorizontalGapUnits") ? xml.getStringProperty("DefaultGridHorizontalGapUnits") : "cm";
            String vUnitName = xml != null && xml.contains("DefaultGridVerticalGapUnits") ? xml.getStringProperty("DefaultGridVerticalGapUnits") : "cm";
            int hUnit = Attributes.getDistanceAbbrPosition(hUnitName);
            int vUnit = Attributes.getDistanceAbbrPosition(vUnitName);
            double hGapCm = hGap * Attributes.getConversionFactorToCm(hUnit);
            double vGapCm = vGap * Attributes.getConversionFactorToCm(vUnit);
            defaultGridGap = new Point2D.Double(hGapCm, vGapCm);
        }
        return defaultGridGap;
    }

    public static int getDistanceAbbrPosition(String unitAbbr) {
        ArrayList list = MapContext.DISTANCEABBR;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(unitAbbr)) continue;
            return i;
        }
        return 0;
    }

    public double getVGridGapPx() {
        return this.m_gridGapPxY;
    }

    public double getHGridGapPx() {
        return this.m_gridGapPxX;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(Attributes.class, PERSISTENCE_DEFINITION_NAME, "Attributes persistence definition", null, null);
            definition.addDynFieldInt(DPI_FIELD).setMandatory(true);
            definition.addDynFieldInt(DPISCREEN_FIELD).setMandatory(true);
            definition.addDynFieldDouble(TYPEUNIT_FIELD).setMandatory(true);
            definition.addDynFieldDouble(NUMX_FIELD).setMandatory(false);
            definition.addDynFieldDouble(NUMY_FIELD).setMandatory(false);
            definition.addDynFieldDouble(UNITX_FIELD).setMandatory(true);
            definition.addDynFieldDouble(UNITY_FIELD).setMandatory(true);
            definition.addDynFieldBoolean(HASMARGIN_FIELD).setMandatory(true);
            definition.addDynFieldInt(RESOLUTIONSEL_FIELD).setMandatory(true);
            definition.addDynFieldInt(TYPESEL_FIELD).setMandatory(true);
            definition.addDynFieldInt(SELTYPEUNIT_FIELD).setMandatory(true);
            definition.addDynFieldObject(SIZEPAPER_FIELD).setMandatory(true).setClassOfValue(Size.class);
            definition.addDynFieldArray(AREA_FIELD).setClassOfItems(String.class).setMandatory(true);
            definition.addDynFieldObject(SIZEINUNITS_FIELD).setMandatory(true).setClassOfValue(Size.class);
            definition.addDynFieldBoolean(ISLANDSEL_FIELD).setMandatory(true);
        }
        Size.registerPersistent();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        DPI = state.getInt(DPI_FIELD);
        DPISCREEN = state.getInt(DPISCREEN_FIELD);
        this.m_TypeUnit = state.getDouble(TYPEUNIT_FIELD);
        this.m_gridGapCmX = (Double)state.get(NUMX_FIELD);
        this.m_gridGapCmY = (Double)state.get(NUMY_FIELD);
        this.m_gridGapPxX = (Double)state.get(UNITX_FIELD);
        this.m_gridGapPxY = (Double)state.get(UNITY_FIELD);
        this.hasmargin = state.getBoolean(HASMARGIN_FIELD);
        this.m_resolutionSel = state.getInt(RESOLUTIONSEL_FIELD);
        this.m_typeSel = state.getInt(TYPESEL_FIELD);
        this.m_selTypeUnit = state.getInt(SELTYPEUNIT_FIELD);
        this.m_sizePaper = (Size)state.get(SIZEPAPER_FIELD);
        if (this.m_typeSel == 6) {
            this.last_custom_paper_size = this.m_sizePaper;
        }
        this.area_tblr = state.getDoubleArray(AREA_FIELD);
        this.m_sizeinUnits = (Size)state.get(SIZEINUNITS_FIELD);
        boolean lands = state.getBoolean(ISLANDSEL_FIELD);
        this.setIsLandScape(lands);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(DPI_FIELD, DPI);
        state.set(DPISCREEN_FIELD, DPISCREEN);
        state.set(TYPEUNIT_FIELD, this.m_TypeUnit);
        state.set(NUMX_FIELD, this.m_gridGapCmX);
        state.set(NUMY_FIELD, this.m_gridGapCmY);
        state.set(UNITX_FIELD, this.m_gridGapPxX);
        state.set(UNITY_FIELD, this.m_gridGapPxY);
        state.set(HASMARGIN_FIELD, this.hasmargin);
        state.set(RESOLUTIONSEL_FIELD, this.m_resolutionSel);
        state.set(TYPESEL_FIELD, this.m_typeSel);
        state.set(SELTYPEUNIT_FIELD, this.m_selTypeUnit);
        state.set(SIZEPAPER_FIELD, (Persistent)this.m_sizePaper);
        state.set(AREA_FIELD, this.area_tblr);
        state.set(SIZEINUNITS_FIELD, (Persistent)this.m_sizeinUnits);
        state.set(ISLANDSEL_FIELD, this.isLandscape());
    }

    public static double getConversionFactorToCm(int unit) {
        return 100.0 * MapContext.getDistanceTrans2Meter()[unit];
    }

    public Object clone() {
        Attributes cloned = null;
        try {
            cloned = (Attributes)super.clone();
            cloned.setSelectedOptions(this.getType(), this.getUnit(), this.isLandscape(), this.isMargin(), this.getResolution(), this.getAreaInsets());
            cloned.setPaperSize(this.getPaperSize());
            cloned.setVGridGrapCm(this.getVGridGapCm());
            cloned.setHGridGrapCm(this.getHGridGapCm());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }
}

