/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.HashMap;
import javax.swing.JComponent;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.project.documents.layout.FLayoutDraw;
import org.gvsig.app.project.documents.layout.FLayoutFunctions;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.FLayoutZooms;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.LayoutEvents;
import org.gvsig.app.project.documents.layout.LayoutNotification;
import org.gvsig.app.project.documents.layout.Size;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameEditableVertex;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.PolyLineAdapter;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.LayoutAddBoxListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddCircleListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddLegendListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddLineListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddNorthListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddOverViewListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddPictureListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddPointListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddPolygonListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddPolylineListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddRectangleListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddScaleListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddTextListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutAddViewListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutEditGraphicsListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutPanListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutSelectListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutViewPanListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutViewZoomInListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutViewZoomOutListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutZoomInListenerImpl;
import org.gvsig.app.project.documents.layout.tools.LayoutZoomOutListenerImpl;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutEditBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutMoveBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutPointBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutRectangleByTwoPointsBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutSelectBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutViewMoveBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutViewZoomBehavior;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutZoomBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.ILayoutGraphicListener;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.tools.observer.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayoutControl
extends JComponent
implements LayoutControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLayoutControl.class);
    private static final int DESACTUALIZADO = 4;
    private static final int ACTUALIZADO = 5;
    private static final long serialVersionUID = -8290006366669291510L;
    public static final String PERSISTENCE_DEFINITION_NAME = "LayoutControl";
    private int status = 4;
    private Rectangle2D rectVisible;
    private BufferedImage img = null;
    private BufferedImage imgRuler = null;
    private LayoutContext layoutContext;
    private final Point origin = new Point(50, 50);
    private final Point rectOrigin = new Point(this.origin);
    private final Rectangle2D.Double rect;
    private final Rectangle2D.Double viewPort;
    private FLayoutDraw layoutDraw;
    private FLayoutFunctions layoutFunctions;
    private LayoutBehavior currentLayoutTool;
    private Image imageCursor;
    private final HashMap namesLayoutTools;
    private Point m_FirstPoint;
    private Point m_PointAnt;
    private Point m_LastPoint;
    private LayoutEvents layoutEvents;
    private Point position;
    private GeometryAdapter geometryAdapter;
    private String currentTool;
    private boolean m_bCancelDrawing;
    private final Rectangle reSel;
    private boolean isReSel;
    private FLayoutZooms layoutZooms;
    private static final Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, new int[256], 0, 16)), new Point(0, 0), "invisiblecursor");

    public DefaultLayoutControl() {
        this.rect = new Rectangle2D.Double(this.rectOrigin.x, this.rectOrigin.y, 400.0, 300.0);
        this.viewPort = new Rectangle2D.Double();
        this.layoutDraw = null;
        this.layoutFunctions = null;
        this.currentLayoutTool = null;
        this.imageCursor = null;
        this.namesLayoutTools = new HashMap();
        this.m_FirstPoint = new Point(0, 0);
        this.m_PointAnt = new Point(0, 0);
        this.m_LastPoint = new Point(0, 0);
        this.geometryAdapter = new PolyLineAdapter();
        this.m_bCancelDrawing = false;
        this.reSel = null;
        this.isReSel = true;
    }

    public void initialize(LayoutPanel layoutPanel) {
        this.setFocusable(true);
        this.layoutDraw = new FLayoutDraw(layoutPanel);
        this.layoutEvents = new LayoutEvents(layoutPanel);
        this.layoutZooms = new FLayoutZooms(layoutPanel);
        this.layoutFunctions = new FLayoutFunctions(layoutPanel);
        this.addComponentListener(this.layoutEvents);
        this.addMouseMotionListener(this.layoutEvents);
        this.addMouseListener(this.layoutEvents);
        LayoutPanListenerImpl lpl = new LayoutPanListenerImpl(layoutPanel);
        this.addLayoutTool("layoutpan", new LayoutMoveBehavior(lpl));
        LayoutZoomInListenerImpl lzil = new LayoutZoomInListenerImpl(layoutPanel);
        this.addLayoutTool("layoutzoomin", new LayoutZoomBehavior(lzil));
        LayoutZoomOutListenerImpl lzol = new LayoutZoomOutListenerImpl(layoutPanel);
        this.addLayoutTool("layoutzoomout", new LayoutZoomBehavior(lzol));
        LayoutAddViewListenerImpl lavl = new LayoutAddViewListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddview", new LayoutRectangleByTwoPointsBehavior(lavl));
        LayoutAddOverViewListenerImpl laovl = new LayoutAddOverViewListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddoverview", new LayoutRectangleByTwoPointsBehavior(laovl));
        LayoutAddPictureListenerImpl lapl = new LayoutAddPictureListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddpicture", new LayoutRectangleByTwoPointsBehavior(lapl));
        LayoutAddNorthListenerImpl lanorthl = new LayoutAddNorthListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddnorth", new LayoutRectangleByTwoPointsBehavior(lanorthl));
        LayoutAddScaleListenerImpl lasl = new LayoutAddScaleListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddscale", new LayoutRectangleByTwoPointsBehavior(lasl));
        LayoutAddLegendListenerImpl lall = new LayoutAddLegendListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddlegend", new LayoutRectangleByTwoPointsBehavior(lall));
        LayoutAddTextListenerImpl latl = new LayoutAddTextListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddtext", new LayoutRectangleByTwoPointsBehavior(latl));
        LayoutAddBoxListenerImpl labl = new LayoutAddBoxListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddbox", new LayoutRectangleByTwoPointsBehavior(labl));
        LayoutAddPointListenerImpl lapointl = new LayoutAddPointListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddpoint", new LayoutPointBehavior(lapointl));
        LayoutAddLineListenerImpl lalinel = new LayoutAddLineListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddline", new LayoutPointBehavior(lalinel));
        LayoutAddPolygonListenerImpl lapolygonl = new LayoutAddPolygonListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddpolygon", new LayoutPointBehavior(lapolygonl));
        LayoutAddPolylineListenerImpl lapolylinel = new LayoutAddPolylineListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddpolyline", new LayoutPointBehavior(lapolylinel));
        LayoutAddCircleListenerImpl lacirclel = new LayoutAddCircleListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddcircle", new LayoutPointBehavior(lacirclel));
        LayoutAddRectangleListenerImpl larectanglel = new LayoutAddRectangleListenerImpl(layoutPanel);
        this.addLayoutTool("layoutaddrectangle", new LayoutPointBehavior(larectanglel));
        LayoutViewPanListenerImpl lvpl = new LayoutViewPanListenerImpl(layoutPanel);
        this.addLayoutTool("layoutviewpan", new LayoutViewMoveBehavior(lvpl));
        LayoutViewZoomInListenerImpl lvzil = new LayoutViewZoomInListenerImpl(layoutPanel);
        this.addLayoutTool("layoutviewzoomin", new LayoutViewZoomBehavior(lvzil));
        LayoutViewZoomOutListenerImpl lvzol = new LayoutViewZoomOutListenerImpl(layoutPanel);
        this.addLayoutTool("layoutviewzoomout", new LayoutViewZoomBehavior(lvzol));
        LayoutSelectListenerImpl lselectl = new LayoutSelectListenerImpl(layoutPanel);
        this.addLayoutTool("layoutselect", new LayoutSelectBehavior(lselectl));
        LayoutEditGraphicsListenerImpl leditl = new LayoutEditGraphicsListenerImpl(layoutPanel);
        this.addLayoutTool("layoutedit", new LayoutEditBehavior(leditl));
    }

    @Override
    public String getCurrentTool() {
        return this.currentTool;
    }

    @Override
    public void addLayoutTool(String name, LayoutBehavior tool) {
        this.namesLayoutTools.put(name, tool);
        tool.setLayoutControl(this);
    }

    @Override
    public LayoutBehavior getLayoutTool(String name) {
        return (LayoutBehavior)this.namesLayoutTools.get(name);
    }

    @Override
    public void setLayoutContext(LayoutContext lc) {
        this.layoutContext = lc;
        this.layoutContext.addObserver(this);
        this.fullRect();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.clipVisibleRect((Graphics2D)g);
        Rectangle rClip = g.getClipBounds();
        if (rClip == null) {
            LOGGER.debug("clip = null");
        }
        switch (this.status) {
            case 4: {
                if (this.getWidth() == 0) {
                    return;
                }
                this.img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                this.imgRuler = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics gimag = this.img.getGraphics();
                Graphics gimgRuler = this.imgRuler.getGraphics();
                this.clipVisibleRect((Graphics2D)gimag);
                this.layoutDraw.drawLayout((Graphics2D)gimag, this.img);
                g.setClip(rClip);
                this.layoutDraw.drawRectangle((Graphics2D)g);
                g.drawImage(this.img, 0, 0, this);
                g.setClip(rClip);
                this.layoutDraw.drawGrid((Graphics2D)gimgRuler);
                this.layoutDraw.drawRuler((Graphics2D)gimgRuler, Color.black);
                this.setStatus(5);
                this.repaint();
                break;
            }
            case 5: {
                this.layoutDraw.drawRectangle((Graphics2D)g);
                if (this.currentLayoutTool != null) {
                    this.currentLayoutTool.paintComponent(g);
                } else {
                    g.drawImage(this.img, 0, 0, this);
                    this.layoutDraw.drawHandlers((Graphics2D)g, Color.black);
                }
                g.setClip(rClip);
                this.drawCursor(g);
            }
        }
    }

    private void setStatus(int s) {
        this.status = s;
    }

    private void clipVisibleRect(Graphics2D g2d) {
        this.rectVisible = this.getVisibleRect();
        g2d.clipRect((int)this.rectVisible.getMinX(), (int)this.rectVisible.getMinY(), (int)this.rectVisible.getWidth(), (int)this.rectVisible.getHeight());
    }

    @Override
    public BufferedImage getImgRuler() {
        return this.imgRuler;
    }

    @Override
    public void fullRect() {
        Rectangle2D.Double r = new Rectangle2D.Double(this.origin.x, this.origin.y, this.getWidth(), this.getHeight());
        r = this.layoutContext.getAttributes().isLandscape() ? this.layoutContext.getAttributes().getRectangleLandscape(r, this.getWidth(), this.getHeight()) : this.layoutContext.getAttributes().getRectanglePortrait(r, this.getWidth(), this.getHeight());
        this.setRect(r);
        this.refresh();
    }

    @Override
    public Rectangle2D.Double getRect() {
        return (Rectangle2D.Double)this.rect.clone();
    }

    @Override
    public void setRect(Rectangle2D r) {
        this.rect.setRect(r);
        Rectangle bounds = this.getBounds();
        if (this.rect.getWidth() > 0.0 && ((RectangularShape)bounds).getWidth() > 0.0) {
            this.layoutDraw.initializeAffineTransform();
            AffineTransform at = this.layoutContext.getAT();
            if (at != null) {
                Rectangle2D.Double newVp = new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
                this.viewPort.setRect(FLayoutUtilities.toSheetRect(newVp, at));
            }
        }
    }

    @Override
    public BufferedImage getImage() {
        return this.img;
    }

    private void drawCursor(Graphics g) {
        if (this.imageCursor != null && this.position != null) {
            Point pAdjusted = this.position;
            g.drawImage(this.imageCursor, (int)pAdjusted.getX() - 16, (int)pAdjusted.getY() - 16, this);
        }
    }

    @Override
    public void setMapCursor(Image image) {
        this.imageCursor = image;
    }

    @Override
    public void setTool(String toolName) {
        LayoutBehavior layoutTool;
        this.currentLayoutTool = layoutTool = (LayoutBehavior)this.namesLayoutTools.get(toolName);
        this.currentLayoutTool.setLayoutControl(this);
        this.currentTool = toolName;
        this.setMapCursor(layoutTool.getImageCursor());
        if (this.getCurrentLayoutTool().getListener() instanceof ILayoutGraphicListener) {
            this.geometryAdapter = ((ILayoutGraphicListener)((Object)this.getCurrentLayoutTool().getListener())).createGeometryAdapter();
        }
        if (this.getCurrentTool().equals("layoutedit")) {
            this.startEdit();
        } else {
            this.stopEdit();
        }
    }

    @Override
    public void setDefaultTool() {
        PluginsLocator.getMainFrame().setSelectedTool("selection-select-by-rectangle-layout");
        this.setTool("layoutselect");
    }

    @Override
    public void startEdit() {
        IFFrame[] fframes;
        for (IFFrame frame : fframes = this.layoutContext.getFFrames()) {
            if (!(frame instanceof IFFrameEditableVertex)) continue;
            if (frame.getSelected() != 0) {
                ((IFFrameEditableVertex)((Object)frame)).startEditing();
                continue;
            }
            ((IFFrameEditableVertex)((Object)frame)).stopEditing();
        }
        this.refresh();
    }

    @Override
    public void stopEdit() {
        IFFrame[] fframes;
        boolean refresh = false;
        for (IFFrame frame : fframes = this.layoutContext.getFFrames()) {
            if (!(frame instanceof IFFrameEditableVertex) || !((IFFrameEditableVertex)((Object)frame)).isEditing()) continue;
            ((IFFrameEditableVertex)((Object)frame)).stopEditing();
            refresh = true;
        }
        if (refresh) {
            this.refresh();
        }
    }

    @Override
    public Point getRectOrigin() {
        return this.rectOrigin;
    }

    @Override
    public FLayoutDraw getLayoutDraw() {
        return this.layoutDraw;
    }

    @Override
    public LayoutBehavior getCurrentLayoutTool() {
        return this.currentLayoutTool;
    }

    @Override
    public Point getFirstPoint() {
        return this.m_FirstPoint;
    }

    @Override
    public Point getPointAnt() {
        return this.m_PointAnt;
    }

    @Override
    public Point getLastPoint() {
        return this.m_LastPoint;
    }

    @Override
    public void setFirstPoint() {
        this.m_FirstPoint = this.position;
    }

    @Override
    public void setPointAnt() {
        this.m_PointAnt = this.position;
    }

    @Override
    public void setLastPoint() {
        this.m_LastPoint = this.position;
    }

    @Override
    public void setPosition(Point point2) {
        this.position = this.layoutContext.isAdjustingToGrid() && this.getCurrentLayoutTool().isAdjustable() ? FLayoutUtilities.getPointGrid(point2, this.layoutContext.getAttributes().getHGridGapCm(), this.layoutContext.getAttributes().getVGridGapCm(), this.layoutContext.getAT()) : point2;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public AffineTransform getAT() {
        return this.layoutContext.getAT();
    }

    @Override
    public GeometryAdapter getGeometryAdapter() {
        return this.geometryAdapter;
    }

    @Override
    public void delLastPoint() {
        this.getGeometryAdapter().delLastPoint();
    }

    @Override
    public int addGeometryAdapterPoint() {
        return this.getGeometryAdapter().addPoint(FLayoutUtilities.toSheetPoint(this.getPosition(), this.getAT()));
    }

    @Override
    public void setGeometryAdapterPoinPosition() {
        this.getGeometryAdapter().pointPosition(FLayoutUtilities.toSheetPoint(this.getPosition(), this.getAT()));
    }

    @Override
    public void clearMouseImage() {
        this.setCursor(transparentCursor);
    }

    @Override
    public void refresh() {
        AffineTransform at = this.calculateTransformFromViewport();
        if (at != null) {
            Size s = this.getLayoutContext().getAttributes().getPaperSize();
            Rectangle2D.Double paperRect = new Rectangle2D.Double(0.0, 0.0, s.getWidth(), s.getHeight());
            Rectangle2D.Double newRect = FLayoutUtilities.fromSheetRect(paperRect, at);
            this.setRect(newRect);
        }
        this.setStatus(4);
        this.invalidate();
        this.repaint();
    }

    protected AffineTransform calculateTransformFromViewport() {
        Rectangle bounds = this.getBounds();
        if (((RectangularShape)bounds).getWidth() > 0.0 && this.viewPort.getHeight() > 0.0) {
            AffineTransform at = new AffineTransform();
            double scale1 = ((RectangularShape)bounds).getHeight() / this.viewPort.getHeight() * 1.0;
            double scale2 = ((RectangularShape)bounds).getWidth() / this.viewPort.getWidth() * 1.0;
            double scale = (scale1 + scale2) / 2.0;
            AffineTransform scaleAt = new AffineTransform();
            AffineTransform translationAt = new AffineTransform();
            translationAt.setToTranslation(-this.viewPort.getMinX(), -this.viewPort.getMinY());
            scaleAt.setToScale(scale, scale);
            at.concatenate(scaleAt);
            at.concatenate(translationAt);
            return at;
        }
        return null;
    }

    @Override
    public synchronized boolean isDrawingCancelled() {
        return this.m_bCancelDrawing;
    }

    @Override
    public synchronized void setCancelDrawing(boolean b) {
        this.m_bCancelDrawing = b;
        for (int i = 0; i < this.layoutContext.getFFrames().length; ++i) {
            IFFrame fframe = this.layoutContext.getFFrame(i);
            if (fframe instanceof IFFrameUseFMap && ((IFFrameUseFMap)fframe).getMapContext() == null) continue;
        }
    }

    @Override
    public Rectangle getReSel() {
        return this.reSel;
    }

    @Override
    public boolean isReSel() {
        return this.isReSel;
    }

    @Override
    public void setIsReSel(boolean b) {
        this.isReSel = b;
    }

    @Override
    public void viewFull() throws ReadException {
        IFFrame[] fframes;
        for (IFFrame fframe1 : fframes = this.layoutContext.getSelectedFFrames()) {
            if (!(fframe1 instanceof IFFrameUseFMap)) continue;
            IFFrameUseFMap fframe = (IFFrameUseFMap)fframe1;
            if (fframe.getMapContext() != null) {
                fframe.fullExtent();
            }
            fframe.refresh();
        }
        this.refresh();
    }

    @Override
    public FLayoutZooms getLayoutZooms() {
        return this.layoutZooms;
    }

    @Override
    public FLayoutFunctions getLayoutFunctions() {
        return this.layoutFunctions;
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    @Override
    public void setGeometryAdapter(GeometryAdapter adapter) {
        this.geometryAdapter = adapter;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void update(Observable observable, Object notification) {
        LayoutNotification layoutNotification;
        if (notification != null && notification instanceof LayoutNotification && null != (layoutNotification = (LayoutNotification)notification).getType()) {
            switch (layoutNotification.getType()) {
                case "layout_validated": {
                    this.status = 5;
                    break;
                }
                case "layout_invalidated": {
                    this.status = 4;
                    break;
                }
                case "layout_refresh": {
                    this.refresh();
                    break;
                }
            }
        }
    }
}

