/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.BitSet;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameEditableVertex;
import org.gvsig.app.project.documents.layout.geometryadapters.CircleAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameGraphics
extends FFrame
implements IFFrameEditableVertex {
    private static final GeometryManager GEOMETRY_MANAGER = GeometryLocator.getGeometryManager();
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameGraphics";
    private static final String TYPE_FIELD = "type";
    private static final String SYMBOL_FIELD = "symbol";
    private static final String GEOMETRYADAPTER_FIELD = "geometryAdapter";
    private static double TOL = 0.2;
    protected GeometryType geometryType = null;
    private ISymbol symbol = null;
    private Color color = null;
    private GeometryAdapter geometryAdapter;
    private GeometryAdapter geometryEdit;
    private boolean editing = false;
    private double size = 0.5;
    private BitSet index = new BitSet();
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    public void setGeometryAdapter(GeometryAdapter geom) {
        this.geometryAdapter = geom;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void update(int type, AffineTransform at) {
        this.setType(type);
        if (this.color == null) {
            this.color = Color.black;
        }
        this.symbol = this.mapContextManager.getSymbolManager().createSymbol(type);
        if (this.symbol instanceof IMarkerSymbol) {
            this.symbol.setColor(Color.BLACK);
        }
        if (this.symbol instanceof IFillSymbol) {
            ((IFillSymbol)this.symbol).setHasFill(false);
        }
    }

    public ISymbol getFSymbol() {
        return this.symbol;
    }

    public void setSymbol(ISymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double rect = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), rect.getCenterX(), rect.getCenterY());
        if (this.intersects(rv, rect)) {
            g.setColor(Color.black);
            this.geometryAdapter.draw(g, at, this.symbol);
            if (this.editing) {
                g.setColor(Color.red);
                this.geometryAdapter.drawVertex(g, at);
            }
        }
        g.rotate(Math.toRadians(-this.getRotation()), rect.getCenterX(), rect.getCenterY());
    }

    public void updateNum() {
    }

    public int getNum() {
        return 0;
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"Graficos") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void setSize(double size) {
        this.size = size;
        Rectangle2D r = this.geometryAdapter.getBounds2D();
        super.setBoundBox(new Rectangle2D.Double(r.getX() - size, r.getY() - size, size * 2.0, size * 2.0));
    }

    public GeometryType getType() {
        return this.geometryType;
    }

    public void setType(int type) {
        try {
            this.geometryType = GEOMETRY_MANAGER.getGeometryType(type, 0);
        }
        catch (GeometryTypeNotSupportedException e) {
            LOG.error("Error setting the geometry type", (Throwable)e);
        }
        catch (GeometryTypeNotValidException e) {
            LOG.error("Error setting the geometry type", (Throwable)e);
        }
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        AffineTransform aT = new AffineTransform();
        if (this.getBoundBox().getWidth() != 0.0) {
            double w = r.getWidth() / this.getBoundBox().getWidth();
            double h = r.getHeight() / this.getBoundBox().getHeight();
            AffineTransform trans2 = AffineTransform.getTranslateInstance(r.getX(), r.getY());
            aT.concatenate(trans2);
            AffineTransform scale1 = AffineTransform.getScaleInstance(w, h);
            aT.concatenate(scale1);
            AffineTransform trans1 = AffineTransform.getTranslateInstance(-this.getBoundBox().getX(), -this.getBoundBox().getY());
            aT.concatenate(trans1);
            this.geometryAdapter.applyTransform(aT);
            this.size = aT.getScaleX() * this.size;
        }
        super.setBoundBox(r);
    }

    @Override
    public void startEditing() {
        this.editing = true;
    }

    @Override
    public void stopEditing() {
        this.editing = false;
    }

    @Override
    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public void pointReleased(Point2D point, GeometryAdapter geom) {
        this.index.clear();
        this.geometryAdapter = geom;
        Rectangle2D r = this.geometryAdapter.getBounds2D();
        super.setBoundBox(r);
    }

    @Override
    public void pointPressed(Point2D point) {
        Rectangle2D.Double rect = this.getBoundBox();
        try {
            this.geometryEdit = (GeometryAdapter)this.geometryAdapter.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Error clonning the geometry", (Throwable)e);
        }
        Point2D[] points = this.geometryEdit.getPoints();
        Point2D.Double pAux1 = new Point2D.Double();
        this.index.clear();
        for (int i = 0; i < points.length; ++i) {
            if (this.getRotation() != 0.0) {
                AffineTransform af = AffineTransform.getRotateInstance(Math.toRadians(-this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
                af.transform(point, pAux1);
                if (!(points[i].distance(pAux1) <= TOL)) continue;
                this.index.set(i);
                continue;
            }
            if (!(points[i].distance(point) <= TOL)) continue;
            this.index.set(i);
        }
    }

    @Override
    public void pointDragged(Point2D point) {
        int j = this.index.nextSetBit(0);
        while (j >= 0) {
            if (this.getRotation() != 0.0) {
                Rectangle2D.Double rect = this.getBoundBox();
                AffineTransform af = AffineTransform.getRotateInstance(Math.toRadians(-this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
                af.transform(point, point);
            }
            this.geometryEdit.changePoint(j, point);
            j = this.index.nextSetBit(j + 1);
        }
        this.geometryEdit.end();
    }

    @Override
    public void paint(Graphics2D g, AffineTransform at) {
        if (this.geometryEdit != null) {
            Rectangle2D.Double rect = this.getBoundingBox(at);
            if (this.getRotation() != 0.0) {
                g.rotate(Math.toRadians(this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
                this.geometryEdit.paint(g, at, false);
                g.rotate(Math.toRadians(-this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
            } else {
                this.geometryEdit.paint(g, at, false);
            }
        }
    }

    @Override
    public GeometryAdapter getGeometry() {
        return this.geometryEdit;
    }

    public void initialize() {
    }

    @Override
    public int getContains(Point2D p) {
        if (this.geometryAdapter instanceof CircleAdapter) {
            if (this.ne.contains(p.getX(), p.getY())) {
                return 2;
            }
            if (this.se.contains(p.getX(), p.getY())) {
                return 4;
            }
            if (this.so.contains(p.getX(), p.getY())) {
                return 6;
            }
            if (this.no.contains(p.getX(), p.getY())) {
                return 8;
            }
            if (this.getBoundingBox(null).contains(p.getX(), p.getY())) {
                return 9;
            }
            return 0;
        }
        return super.getContains(p);
    }

    @Override
    public void drawHandlers(Graphics2D g) {
        if (this.geometryAdapter instanceof CircleAdapter) {
            int size = 10;
            Rectangle2D.Double r = this.getBoundingBox(null);
            Point2D.Double p = new Point2D.Double();
            g.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
            AffineTransform atRotate = new AffineTransform();
            atRotate.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
            g.fillRect((int)((RectangularShape)r).getX() - size, (int)((RectangularShape)r).getY() - size, size, size);
            atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)size, ((RectangularShape)r).getY() - (double)size), p);
            this.no.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getMaxX(), (int)((RectangularShape)r).getY() - size, size, size);
            atRotate.transform(new Point2D.Double(r.getMaxX(), ((RectangularShape)r).getY() - (double)size), p);
            this.ne.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)((RectangularShape)r).getX() - size, (int)r.getMaxY(), size, size);
            atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)size, r.getMaxY()), p);
            this.so.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getMaxX(), (int)r.getMaxY(), size, size);
            atRotate.transform(new Point2D.Double(r.getMaxX(), r.getMaxY()), p);
            this.se.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.rotate(Math.toRadians(-this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
        } else {
            super.drawHandlers(g);
        }
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes printingProperties) {
        Rectangle2D.Double rect = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
        g.setColor(Color.black);
        this.geometryAdapter.print(g, at, this.symbol, printingProperties);
        if (this.editing) {
            g.setColor(Color.red);
            this.geometryEdit.drawVertex(g, at);
        }
        g.rotate(Math.toRadians(-this.getRotation()), rect.x + rect.width / 2.0, rect.y + rect.height / 2.0);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameGraphics.class, PERSISTENCE_DEFINITION_NAME, "FFrameGraphics persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrame"));
            definition.addDynFieldInt(TYPE_FIELD).setMandatory(true);
            definition.addDynFieldObject(SYMBOL_FIELD).setMandatory(true).setClassOfValue(ISymbol.class);
            definition.addDynFieldObject(GEOMETRYADAPTER_FIELD).setClassOfValue(GeometryAdapter.class);
        }
        GeometryAdapter.registerPersistent();
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        try {
            this.geometryType = GEOMETRY_MANAGER.getGeometryType(state.getInt(TYPE_FIELD), 0);
        }
        catch (GeometryTypeNotSupportedException e) {
            LOG.error("Error loading the geometry type", (Throwable)e);
        }
        catch (GeometryTypeNotValidException e) {
            LOG.error("Error loading the geometry type", (Throwable)e);
        }
        this.symbol = (ISymbol)state.get(SYMBOL_FIELD);
        this.geometryAdapter = (GeometryAdapter)state.get(GEOMETRYADAPTER_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(TYPE_FIELD, this.geometryType.getType());
        state.set(SYMBOL_FIELD, (Persistent)this.symbol);
        state.set(GEOMETRYADAPTER_FIELD, (Persistent)this.geometryAdapter);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FFrameGraphics resp = (FFrameGraphics)super.clone();
        GeometryAdapter nga = null;
        if (this.geometryAdapter != null) {
            nga = (GeometryAdapter)this.geometryAdapter.clone();
        }
        resp.setGeometryAdapter(nga);
        resp.index = (BitSet)this.index.clone();
        return resp;
    }
}

