/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.FFrameGrid;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.fframes.ListViewModel;
import org.gvsig.app.project.documents.layout.fframes.gui.EnvelopePanel;
import org.gvsig.app.project.documents.layout.fframes.gui.JPRotation;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.AbstractFFrameDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameGridDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFrameDialog;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;

public class FFrameViewDialog
extends AbstractFFrameDialog
implements IFFrameDialog,
SingletonWindow {
    private static final long serialVersionUID = -7223804566537544559L;
    private final LayoutManager layoutManager;
    private JLabel lViews = null;
    private JScrollPane jScrollPane = null;
    private JList liViews = null;
    private JCheckBox chbSyncLayers = null;
    private JButton bAceptar = null;
    private JButton bCancelar = null;
    private JLabel lCalidad = null;
    private JComboBox cbCalidad = null;
    private ViewDocument m_projectView = null;
    private final Rectangle2D rect = new Rectangle2D.Double();
    private FFrameView fframeview = null;
    private boolean isAcepted = false;
    private JPRotation rotation = null;
    private JButton bGrid = null;
    private JCheckBox chbShowGrid = null;
    private JPanel pnlFirstRow = null;
    private JCheckBox chbSyncExtent = null;
    private WindowInfo windowInfo = null;
    private GridBagLayoutPanel pnlSyncGroup = null;
    private GridBagLayoutPanel pnlScaleTypeGroup = null;
    private ButtonGroup grpScaleType = null;
    private JRadioButton btnNormalScale = null;
    private JRadioButton btnFixedScale = null;
    private JRadioButton btnFixedExtent = null;
    private JTextField fldScale = null;
    private EnvelopePanel pnlExtent = null;
    private JButton btConfigView = null;
    private JPanel pnlScale = null;
    private ViewDocument createdView = null;
    private FFrameView newFFrameView = null;
    private FFrameGrid fframeGrid = null;

    public FFrameViewDialog(LayoutPanel layoutPanel, IFFrame frame) {
        super(layoutPanel, frame);
        this.fframeview = (FFrameView)frame;
        this.fframeGrid = (FFrameGrid)this.fframeview.getGrid();
        this.initComponents();
        this.layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 5, 5);
        int row = 0;
        c.gridx = 0;
        c.gridy = row++;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 21;
        c.gridwidth = 0;
        this.add((Component)this.getFirstRowPnl(), c);
        c.insets = insets;
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 0;
        c.fill = 2;
        GridBagLayoutPanel pnl = this.getPnlSyncGroup();
        pnl.addComponent((Component)this.getChbSyncLayers(), insets);
        pnl.addComponent((Component)this.getChbSyncExtent(), insets);
        this.add((Component)pnl, c);
        this.getGrpScaleType().add(this.getBtnNormalScale());
        this.getGrpScaleType().add(this.getBtnFixedScale());
        this.getGrpScaleType().add(this.getBtnFixedExtent());
        pnl = this.getPnlScaleTypeGroup();
        pnl.addComponent((Component)this.getBtnNormalScale(), insets);
        pnl.addComponent((Component)this.getPnlScale(), insets);
        pnl.addComponent((Component)this.getBtnFixedExtent(), new Insets(5, 5, 0, 5));
        pnl.addComponent((Component)this.getPnlExtent(), 2, new Insets(0, 5, 5, 5));
        if (this.fframeview.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE) {
            this.getBtnFixedScale().setSelected(true);
            this.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE);
            this.getChbSyncExtent().setEnabled(false);
        } else if (this.fframeview.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT) {
            this.getBtnFixedExtent().setSelected(true);
            this.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT);
            this.getChbSyncExtent().setEnabled(false);
        } else {
            this.getBtnNormalScale().setSelected(true);
            this.setScaleType(IFFrameUseFMap.SCALE_TYPE.NORMAL);
        }
        c.gridy = row++;
        this.add((Component)pnl, c);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.add((Component)this.getLCalidad(), c);
        c.gridx = 1;
        c.gridwidth = 0;
        this.add((Component)this.getCbCalidad(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.add((Component)this.getChbShowGrid(), c);
        c.gridx = 1;
        c.gridwidth = 0;
        this.add((Component)this.getBGrid(), c);
        JPanel acceptCancelPnl = new JPanel(new GridBagLayout());
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        acceptCancelPnl.add((Component)this.getbAceptar(), c);
        c.gridx = 1;
        acceptCancelPnl.add((Component)this.getBCancelar(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.anchor = 22;
        c.gridwidth = 0;
        this.add((Component)acceptCancelPnl, c);
    }

    @Override
    public void setRectangle(Rectangle2D r) {
        this.rect.setRect(r);
    }

    private JPanel getFirstRowPnl() {
        if (this.pnlFirstRow == null) {
            this.pnlFirstRow = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            Insets insets = new Insets(5, 5, 5, 5);
            Insets insetsTop = new Insets(12, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsTop;
            c.anchor = 19;
            this.pnlFirstRow.add((Component)this.getLViews(), c);
            c.gridx = 1;
            this.pnlFirstRow.add((Component)this.getScrolledViewList(), c);
            c.insets = insets;
            c.gridx = 2;
            c.gridheight = 2;
            this.pnlFirstRow.add((Component)this.getPRotation(), c);
            c.anchor = 22;
            c.gridy = 1;
            c.gridx = 1;
            c.gridheight = 1;
            this.pnlFirstRow.add((Component)this.getBtnConfigView(), c);
        }
        return this.pnlFirstRow;
    }

    private JButton getBtnConfigView() {
        UsabilitySwingManager manager = ToolsSwingLocator.getUsabilitySwingManager();
        this.btConfigView = manager.createJButton(Messages.getText((String)"Configure_view"));
        this.btConfigView.addActionListener(e -> {
            ViewDocument view = this.getSelectedView();
            if (view != null) {
                IWindow propWin = view.getPropertiesWindow();
                ApplicationManager manager1 = ApplicationLocator.getManager();
                manager1.getUIManager().addWindow(propWin);
            }
        });
        return this.btConfigView;
    }

    private JLabel getLViews() {
        if (this.lViews == null) {
            this.lViews = new JLabel();
            this.lViews.setText(Messages.getText((String)"Vista"));
        }
        return this.lViews;
    }

    private JScrollPane getScrolledViewList() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getViewList());
            this.jScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.jScrollPane;
    }

    private JList getViewList() {
        if (this.liViews == null) {
            ListViewModel listmodel = new ListViewModel();
            listmodel.addCreateNewViewObj();
            if (listmodel.addViews()) {
                JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Some_views_excluded_from_list_because_have_editing_layers"), Messages.getText((String)"propiedades_marco_vista"), 2);
            }
            this.liViews = new JList();
            this.liViews.setModel(listmodel);
            this.liViews.setSelectedIndex(0);
            for (int i = 1; i < this.liViews.getModel().getSize(); ++i) {
                DefaultViewDocument pvaux;
                if (this.fframeview.getMapContext() == null || !(pvaux = (DefaultViewDocument)this.liViews.getModel().getElementAt(i)).getMapContext().equals((Object)this.fframeview.getMapContext())) continue;
                this.liViews.setSelectedIndex(i);
                this.m_projectView = (DefaultViewDocument)this.liViews.getModel().getElementAt(i);
            }
        }
        return this.liViews;
    }

    protected ViewDocument getSelectedView() {
        Object selected = this.getViewList().getSelectedValue();
        ViewDocument view = null;
        if (selected instanceof ViewDocument) {
            view = (ViewDocument)selected;
        } else if (selected == ListViewModel.CREATE_NEW_VIEW_OBJECT) {
            view = this.createdView == null ? this.createView() : this.createdView;
        }
        return view;
    }

    private ViewDocument createView() {
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        this.createdView = (ViewDocument)viewManager.createDocument();
        ProjectManager.getInstance().getCurrentProject().addDocument((Document)this.createdView);
        return this.createdView;
    }

    private void deleteView() {
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ProjectManager.getInstance().getCurrentProject().removeDocument((Document)this.createdView);
        this.createdView = null;
    }

    private JCheckBox getChbSyncLayers() {
        if (this.chbSyncLayers == null) {
            this.chbSyncLayers = new JCheckBox();
            this.chbSyncLayers.setText(Messages.getText((String)"Synchronize_layers"));
            this.chbSyncLayers.setSelected(this.fframeview.getLayerSynced());
            this.chbSyncLayers.addActionListener(e -> {
                if (this.chbSyncLayers.isSelected()) {
                    JOptionPane.showMessageDialog(this, Messages.getText((String)"Warning_Enabling_layer_synchronization_will_discard_any_change_not_present_in_associated_view"), Messages.getText((String)"Warning_Layer_sync"), 2);
                }
            });
        }
        return this.chbSyncLayers;
    }

    private JCheckBox getChbSyncExtent() {
        if (this.chbSyncExtent == null) {
            this.chbSyncExtent = new JCheckBox();
            this.chbSyncExtent.setText(Messages.getText((String)"Synchronize_extents"));
            this.chbSyncExtent.setSelected(this.fframeview.getExtentSynced());
        }
        return this.chbSyncExtent;
    }

    protected void disableChbSyncExtent() {
        this.getChbSyncExtent().setEnabled(false);
        this.getChbSyncExtent().setToolTipText(Messages.getText((String)"Extent_cant_be_synchronized_when_using_fixed_scale_or_fixed_extent"));
    }

    protected void enableChbSyncExtent() {
        this.getChbSyncExtent().setEnabled(true);
        this.getChbSyncExtent().setToolTipText(null);
    }

    private JButton getbAceptar() {
        if (this.bAceptar == null) {
            this.bAceptar = new JButton();
            this.bAceptar.setText(Messages.getText((String)"Aceptar"));
            this.bAceptar.addActionListener(e -> {
                this.newFFrameView = (FFrameView)this.layoutManager.createFrame("FFrameView");
                this.newFFrameView.setLayoutContext(this.fframeview.getLayoutContext());
                ViewDocument v = this.getSelectedView();
                if (v != null) {
                    this.m_projectView = v;
                }
                this.newFFrameView.setView(v);
                this.newFFrameView.setBoundBox(FLayoutUtilities.toSheetRect(this.rect, this.layoutPanel.getLayoutControl().getAT()));
                this.newFFrameView.setRotation(this.getPRotation().getRotation());
                this.newFFrameView.setHasToc(true);
                this.newFFrameView.setLayerSynced(this.getChbSyncLayers().isSelected());
                this.newFFrameView.setExtentSynced(this.getChbSyncExtent().isEnabled() && this.getChbSyncExtent().isSelected());
                try {
                    if (this.getBtnFixedScale().isSelected()) {
                        Double d = Double.parseDouble(this.getFldScale().getText());
                        this.newFFrameView.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE, d);
                    } else if (this.getBtnFixedExtent().isSelected()) {
                        Envelope envelope = this.getPnlExtent().getEnvelope();
                        if (envelope != null) {
                            this.newFFrameView.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT, envelope);
                        } else {
                            this.newFFrameView.setScaleType(IFFrameUseFMap.SCALE_TYPE.NORMAL);
                        }
                    } else {
                        this.newFFrameView.setScaleType(IFFrameUseFMap.SCALE_TYPE.NORMAL);
                    }
                }
                catch (Exception ex) {
                    this.newFFrameView.setScaleType(IFFrameUseFMap.SCALE_TYPE.NORMAL);
                }
                if (this.createdView != null && this.createdView != this.getSelectedView()) {
                    this.deleteView();
                }
                if (this.fframeGrid != null) {
                    this.newFFrameView.setGrid(this.fframeGrid);
                }
                if (this.m_projectView != null) {
                    this.newFFrameView.setView(this.m_projectView);
                    this.newFFrameView.setQuality(this.getCbCalidad().getSelectedIndex());
                    if (this.newFFrameView.getGrid() != null) {
                        ((FFrameGrid)this.newFFrameView.getGrid()).setFFrameDependence(this.newFFrameView);
                    }
                    this.newFFrameView.showGrid(this.getChbShowGrid().isSelected());
                    this.newFFrameView.setBoundBox(FLayoutUtilities.toSheetRect(this.rect, this.layoutPanel.getLayoutControl().getAT()));
                }
                this.isAcepted = true;
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
                this.notifyDialogClosed();
                PluginsLocator.getMainFrame().refreshControls();
                this.layoutPanel.getLayoutControl().setDefaultTool();
                this.fireActionEvent(new ActionEvent(this, 1, "accept"));
            });
        }
        return this.bAceptar;
    }

    private JButton getBCancelar() {
        if (this.bCancelar == null) {
            this.bCancelar = new JButton();
            this.bCancelar.setText(Messages.getText((String)"Cancelar"));
            this.bCancelar.addActionListener(e -> {
                if (this.createdView != null) {
                    this.deleteView();
                }
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
                this.notifyDialogClosed();
            });
        }
        return this.bCancelar;
    }

    private JLabel getLCalidad() {
        if (this.lCalidad == null) {
            this.lCalidad = new JLabel();
            this.lCalidad.setText(Messages.getText((String)"calidad"));
        }
        return this.lCalidad;
    }

    private JComboBox getCbCalidad() {
        if (this.cbCalidad == null) {
            this.cbCalidad = new JComboBox();
            this.cbCalidad.addItem(Messages.getText((String)"presentacion"));
            this.cbCalidad.addItem(Messages.getText((String)"borrador"));
            this.cbCalidad.setSelectedIndex(this.fframeview.getQuality());
        }
        return this.cbCalidad;
    }

    @Override
    public WindowInfo getWindowInfo() {
        if (this.windowInfo == null) {
            this.windowInfo = new WindowInfo(1);
            this.windowInfo.setHeight(620);
            this.windowInfo.setWidth(600);
            this.windowInfo.setTitle(Messages.getText((String)"propiedades_marco_vista"));
        }
        return this.windowInfo;
    }

    @Override
    public boolean getIsAcepted() {
        return this.isAcepted;
    }

    private JPRotation getPRotation() {
        if (this.rotation == null) {
            this.rotation = new JPRotation();
            this.rotation.setRotation(this.fframeview.getRotation());
        }
        return this.rotation;
    }

    @Override
    public IFFrame getFFrame() {
        return this.newFFrameView;
    }

    private JButton getBGrid() {
        if (this.bGrid == null) {
            this.bGrid = new JButton();
            this.bGrid.setText(Messages.getText((String)"configurar"));
            this.bGrid.addActionListener(e -> {
                FFrameGridDialog fframeGridDialog;
                if (this.fframeGrid == null) {
                    this.fframeGrid = (FFrameGrid)this.layoutManager.createFrame("FFrameGrid");
                }
                if ((fframeGridDialog = (FFrameGridDialog)this.layoutManager.createFFrameDialog(this.fframeGrid, this.layoutPanel)) != null) {
                    fframeGridDialog.setMapContext(this.getSelectedView().getMapContext());
                    fframeGridDialog.setFrameRotation(this.getPRotation().getRotation());
                    ApplicationLocator.getManager().getUIManager().addWindow((IWindow)fframeGridDialog);
                }
                this.fframeGrid = (FFrameGrid)fframeGridDialog.getFFrame();
            });
        }
        return this.bGrid;
    }

    private JCheckBox getChbShowGrid() {
        if (this.chbShowGrid == null) {
            this.chbShowGrid = new JCheckBox();
            this.chbShowGrid.setSelected(this.fframeview.isShowGrid());
            this.chbShowGrid.setText(Messages.getText((String)"Show_grid"));
            this.chbShowGrid.addActionListener(e -> {
                JCheckBox cb;
                if (e.getSource() instanceof JCheckBox && (cb = (JCheckBox)e.getSource()).isSelected() && this.fframeGrid == null) {
                    FFrameGrid fFrameGrid = (FFrameGrid)this.layoutManager.createFrame("FFrameGrid");
                }
            });
        }
        return this.chbShowGrid;
    }

    private GridBagLayoutPanel getPnlSyncGroup() {
        if (this.pnlSyncGroup == null) {
            this.pnlSyncGroup = new GridBagLayoutPanel();
            this.pnlSyncGroup.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"Synchronization_of_the_view_and_the_frame_view")));
        }
        return this.pnlSyncGroup;
    }

    private GridBagLayoutPanel getPnlScaleTypeGroup() {
        if (this.pnlScaleTypeGroup == null) {
            this.pnlScaleTypeGroup = new GridBagLayoutPanel();
            this.pnlScaleTypeGroup.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"Fixed_scale_and_extent")));
        }
        return this.pnlScaleTypeGroup;
    }

    private ButtonGroup getGrpScaleType() {
        if (this.grpScaleType == null) {
            this.grpScaleType = new ButtonGroup();
        }
        return this.grpScaleType;
    }

    private JRadioButton getBtnNormalScale() {
        if (this.btnNormalScale == null) {
            this.btnNormalScale = new JRadioButton(Messages.getText((String)"Non_fixed"));
            this.btnNormalScale.addActionListener(e -> {
                this.setScaleType(IFFrameUseFMap.SCALE_TYPE.NORMAL);
                this.enableChbSyncExtent();
            });
        }
        return this.btnNormalScale;
    }

    private JRadioButton getBtnFixedScale() {
        if (this.btnFixedScale == null) {
            this.btnFixedScale = new JRadioButton(Messages.getText((String)"Fixed_scale"));
            this.btnFixedScale.addActionListener(e -> {
                this.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE);
                this.disableChbSyncExtent();
            });
        }
        return this.btnFixedScale;
    }

    private JPanel getPnlScale() {
        if (this.pnlScale == null) {
            this.pnlScale = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            this.pnlScale.add(this.getBtnFixedScale());
            c.anchor = 21;
            c.gridx = 1;
            c.insets = new Insets(0, 25, 0, 5);
            c.anchor = 22;
            this.pnlScale.add((Component)this.getLblScale(), c);
            c.gridx = 2;
            c.insets = new Insets(0, 5, 0, 5);
            c.anchor = 21;
            this.pnlScale.add((Component)this.getFldScale(), c);
        }
        return this.pnlScale;
    }

    private JTextField getFldScale() {
        if (this.fldScale == null) {
            this.fldScale = new JTextField(8);
            if (this.fframeview != null && this.fframeview.getMapContext() != null && this.fframeview.getMapContext().getViewPort().getEnvelope() != null) {
                this.fldScale.setText(Double.toString(this.fframeview.getMapContext().getScaleView()));
            }
        }
        return this.fldScale;
    }

    private JLabel getLblScale() {
        return new JLabel(Messages.getText((String)"1__"));
    }

    private JRadioButton getBtnFixedExtent() {
        if (this.btnFixedExtent == null) {
            this.btnFixedExtent = new JRadioButton(Messages.getText((String)"Fixed_extent"));
            this.btnFixedExtent.addActionListener(e -> {
                this.setScaleType(IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT);
                this.disableChbSyncExtent();
            });
        }
        return this.btnFixedExtent;
    }

    private EnvelopePanel getPnlExtent() {
        if (this.pnlExtent == null) {
            this.pnlExtent = new EnvelopePanel();
            if (this.fframeview != null && this.fframeview.getMapContext() != null && this.fframeview.getMapContext().getViewPort().getEnvelope() != null) {
                this.pnlExtent.setEnvelope(this.fframeview.getMapContext().getViewPort().getEnvelope());
            }
        }
        return this.pnlExtent;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public Object getWindowModel() {
        return this.fframeview;
    }

    protected void setScaleType(IFFrameUseFMap.SCALE_TYPE type) {
        if (null == type) {
            return;
        }
        switch (type) {
            case NORMAL: {
                this.getFldScale().setEditable(false);
                this.getFldScale().setEnabled(false);
                this.getPnlExtent().setEditable(false);
                this.getPnlExtent().setEnabled(false);
                break;
            }
            case FIXED_SCALE: {
                this.getFldScale().setEditable(true);
                this.getFldScale().setEnabled(true);
                this.getPnlExtent().setEditable(false);
                this.getPnlExtent().setEnabled(false);
                break;
            }
            case FIXED_EXTENT: {
                this.getFldScale().setEditable(false);
                this.getFldScale().setEnabled(false);
                this.getPnlExtent().setEditable(true);
                this.getPnlExtent().setEnabled(true);
                break;
            }
        }
    }

    protected IFFrameUseFMap.SCALE_TYPE getSelectedScaleType() {
        if (this.getBtnFixedScale().isSelected()) {
            return IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE;
        }
        if (this.getBtnFixedExtent().isSelected()) {
            return IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT;
        }
        return IFFrameUseFMap.SCALE_TYPE.NORMAL;
    }
}

