/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.geometryadapters;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.app.project.documents.layout.geometryadapters.CircleAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.PointAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.PolyLineAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.PolygonAdapter;
import org.gvsig.app.project.documents.layout.geometryadapters.RectangleAdapter;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class GeometryAdapter
implements Persistent,
Cloneable {
    public static final String PERSISTENCE_DEFINITION_NAME = "GeometryAdapter";
    private static final String POINTS_FIELD = "points";
    protected static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private List<Point2D> points = new ArrayList<Point2D>();
    private Geometry geometry;

    public int addPoint(Point2D point) {
        this.points.add(point);
        return this.points.size();
    }

    public void end() {
        this.obtainShape(this.points.get(this.points.size() - 1));
    }

    protected void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public abstract void obtainShape(Point2D var1);

    public void applyTransform(AffineTransform at) {
        for (int i = 0; i < this.points.size(); ++i) {
            at.transform(this.points.get(i), this.points.get(i));
        }
        this.geometry.transform(at);
    }

    public void draw(Graphics2D g, AffineTransform at, ISymbol symbol) {
        symbol.draw(g, at, this.geometry, null, null);
    }

    public void print(Graphics2D g, AffineTransform at, ISymbol symbol, PrintAttributes properties) {
        Geometry geom = this.getGeometry();
        symbol.print(g, at, geom, properties);
    }

    public abstract void paint(Graphics2D var1, AffineTransform var2, boolean var3);

    public abstract void pointPosition(Point2D var1);

    public Geometry getGeometry(AffineTransform at) {
        Geometry clonedGeom = this.geometry.cloneGeometry();
        clonedGeom.transform(at);
        return clonedGeom;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Point2D[] getPoints() {
        return this.points.toArray(new Point2D[0]);
    }

    public void drawVertex(Graphics2D g, AffineTransform at) {
        Point2D[] ps = this.getPoints();
        Point2D[] pointRes = new Point2D[ps.length];
        at.transform(ps, 0, pointRes, 0, ps.length);
        int d = 3;
        for (int i = 0; i < pointRes.length; ++i) {
            g.fillRect((int)pointRes[i].getX() - d, (int)pointRes[i].getY() - d, d * 2, d * 2);
        }
    }

    public void changePoint(int pos, Point2D point) {
        this.points.set(pos, point);
    }

    public void setPoints(Point2D[] points) {
        this.points = new ArrayList<Point2D>();
        for (int i = 0; i < points.length; ++i) {
            this.points.add(points[i]);
        }
    }

    public void delLastPoint() {
        if (this.points.size() > 0) {
            this.points.remove(this.points.size() - 1);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GeometryAdapter cloneAdapter = (GeometryAdapter)super.clone();
        ArrayList<Point2D.Double> clonedPoints = new ArrayList<Point2D.Double>();
        for (Point2D point : this.points) {
            clonedPoints.add(new Point2D.Double(point.getX(), point.getY()));
        }
        cloneAdapter.setPoints(clonedPoints.toArray(new Point2D[0]));
        cloneAdapter.geometry = this.geometry.cloneGeometry();
        return cloneAdapter;
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D r = this.geometry.getBounds2D();
        double w = r.getWidth();
        double h = r.getHeight();
        double x = r.getX();
        double y = r.getY();
        boolean modified = false;
        if (r.getWidth() < 0.5) {
            modified = true;
            w = 0.5;
            x -= 0.25;
        }
        if (r.getHeight() < 0.5) {
            modified = true;
            h = 0.5;
            y -= 0.25;
        }
        if (modified) {
            return new Rectangle2D.Double(x, y, w, h);
        }
        return r;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(GeometryAdapter.class, PERSISTENCE_DEFINITION_NAME, "GeometryAdapter persistence definition", null, null);
            definition.addDynFieldList(POINTS_FIELD).setClassOfItems(Point2D.class).setMandatory(true);
        }
        CircleAdapter.registerPersistent();
        PointAdapter.registerPersistent();
        PolygonAdapter.registerPersistent();
        PolyLineAdapter.registerPersistent();
        RectangleAdapter.registerPersistent();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.points = state.getList(POINTS_FIELD);
        this.obtainShape(this.points.get(this.points.size() - 1));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(POINTS_FIELD, this.points);
    }
}

