/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.geometryadapters;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.app.project.documents.layout.geometryadapters.PolyLineAdapter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointAdapter
extends PolyLineAdapter {
    public static final String PERSISTENCE_DEFINITION_NAME = "PointAdapter";
    private static final Logger logger = LoggerFactory.getLogger(PointAdapter.class);

    @Override
    public void paint(Graphics2D g, AffineTransform at, boolean andLastPoint) {
    }

    @Override
    public void obtainShape(Point2D p) {
        try {
            Point point = geomManager.createPoint(p.getX(), p.getY(), 0);
            this.setGeometry((Geometry)point);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a point", (Throwable)e);
        }
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D r = this.getGeometry(new AffineTransform()).getBounds2D();
        double w = r.getWidth();
        double h = r.getHeight();
        double x = r.getX();
        double y = r.getY();
        boolean modified = false;
        if (r.getWidth() < 0.5) {
            modified = true;
            w = 1.0;
            x -= 0.25;
        }
        if (r.getHeight() < 0.5) {
            modified = true;
            h = 1.0;
        }
        if (modified) {
            return new Rectangle2D.Double(x, y, w, h);
        }
        return r;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(PointAdapter.class, PERSISTENCE_DEFINITION_NAME, "Point Adapter persistence definition", null, null);
            definition.extend(manager.getDefinition("GeometryAdapter"));
        }
    }
}

