/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.extension.Print;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.layout.DefaultLayoutControl;
import org.gvsig.app.project.documents.layout.DefaultLayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.LayoutPanelListener;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFramePanel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.gui.MapProperties;
import org.gvsig.app.project.documents.layout.gui.dialogs.FConfigLayoutDialog;
import org.gvsig.app.project.documents.view.toc.gui.TOC;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.utils.GenericFileFilter;
import org.gvsig.utils.XMLEntity;

public class DefaultLayoutPanel
extends LayoutPanel {
    private static final long serialVersionUID = 916830228032567624L;
    private static final int DEFAULT_HEIGHT = 450;
    private static final int DEFAULT_WIDTH = 700;
    public static final String PERSISTENCE_DEFINITION_NAME = "LayoutPanel";
    private static final String LAYOUTCONTEXT_OBJECT = "LayoutContext";
    private static final String LAYOUTDOCUMENT_OBJECT = "LayoutDocument";
    public static final String PDF_AND_PS_FILECHOOSER = "PDF_AND_PS_FILECHOOSER";
    public static File defaultPDFFolderPath;
    private MapProperties m_propertiesLayout = null;
    private PrintService[] m_cachePrintServices = null;
    private PrintService m_cachePrintService = null;
    protected LayoutDocument layoutDocument = null;
    private Doc doc = null;
    private PrintRequestAttributeSet att = null;
    private WindowInfo m_viewInfo = null;
    private boolean bShowIconTag = false;
    private LayoutControl layoutControl = null;
    private LayoutContext layoutContext = null;
    private LayoutManager layoutManager = null;
    private JPanel leftPanel;
    private TOC toc = null;
    private JSplitPane splitPane;
    private int lastPanePos = 150;
    private Boolean b_isTocEnabled = null;

    public DefaultLayoutPanel() {
        DefaultLayoutControl defaultLayoutControl = new DefaultLayoutControl();
        this.layoutControl = defaultLayoutControl;
        defaultLayoutControl.initialize(this);
        this.initComponents();
    }

    public void setDocument(Document document) {
        this.layoutDocument = (LayoutDocument)document;
        this.setLayoutContext(this.layoutDocument.getLayoutContext());
        this.setName(document.getName());
        this.layoutDocument.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("name")) {
                    PluginServices.getMDIManager().getWindowInfo((IWindow)DefaultLayoutPanel.this).setTitle(PluginServices.getText((Object)this, (String)"Mapa") + " : " + (String)evt.getNewValue());
                }
            }
        });
        this.setToc();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        if (this.isTocEnabled()) {
            this.leftPanel = new JPanel(new BorderLayout());
            this.splitPane = new JSplitPane(1, this.leftPanel, this.layoutControl.getComponent());
            this.splitPane.setResizeWeight(0.2);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.setToc();
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)this.layoutControl.getComponent(), "Center");
        }
        this.layoutControl.getComponent().setDoubleBuffered(true);
    }

    private boolean isTocEnabled() {
        if (this.b_isTocEnabled == null) {
            XMLEntity entity = PluginsLocator.getManager().getPlugin((Object)this).getPersistentXML();
            this.b_isTocEnabled = entity.contains("DefaultShowLayoutToc") ? Boolean.valueOf(entity.getBooleanProperty("DefaultShowLayoutToc")) : Boolean.valueOf(true);
        }
        return this.b_isTocEnabled;
    }

    protected void createToc() {
        if (this.toc == null) {
            this.toc = new TOC();
        }
        this.toc.setMapContext(this.getLayoutContext().getTocModel());
        this.leftPanel.removeAll();
        this.leftPanel.add((Component)this.toc);
    }

    protected void setToc() {
        if (this.isTocEnabled() && this.getLayoutContext() != null) {
            if (this.getLayoutContext().getTocModel() != null) {
                this.createToc();
            } else if (this.toc != null) {
                this.leftPanel.remove((Component)this.toc);
            }
            this.getLayoutContext().addTocObserver((observable, notification) -> {
                if (null != notification.getType()) {
                    switch (notification.getType()) {
                        case ITEM_UPDATED: {
                            if (this.toc == null) break;
                            this.toc.repaint();
                            break;
                        }
                        case MODEL_CHANGED: {
                            if (this.toc == null) break;
                            this.toc.refresh();
                            break;
                        }
                        case MODEL_SET: {
                            MapContext mapContext = notification.getModel();
                            if (mapContext != null) {
                                this.createToc();
                                break;
                            }
                            if (this.toc == null) break;
                            this.leftPanel.remove((Component)this.toc);
                            this.leftPanel.repaint();
                            break;
                        }
                    }
                }
            });
        }
    }

    public void showPagePropertiesWindow(PrinterJob job) {
        PageFormat pf1 = this.layoutContext.getAttributes().getPageFormat();
        pf1 = job.pageDialog(pf1);
        this.layoutContext.getAttributes().setPageFormat(pf1);
        this.layoutControl.refresh();
    }

    @Override
    public void obtainRect(boolean isPrint) {
        Rectangle2D.Double r = this.layoutControl.getRect();
        this.layoutContext.getAttributes().obtainRect(isPrint, r, this.getWidth(), this.getHeight());
        this.layoutControl.setRect(r);
    }

    @Override
    public void showFConfig() {
        FConfigLayoutDialog m_configLayout = new FConfigLayoutDialog(this);
        I18nManager i18n = ToolsLocator.getI18nManager();
        ((WindowManager_v2)ToolsSwingLocator.getWindowManager()).showWindow((JComponent)m_configLayout, i18n.getTranslation("Preparar_pagina"), WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    @Override
    public boolean showFProperties() {
        if (this.layoutDocument == null) {
            this.layoutDocument = new DefaultLayoutDocument();
            this.layoutDocument.setName(this.getName());
        }
        this.m_propertiesLayout = new MapProperties(this.layoutDocument);
        PluginServices.getMDIManager().addWindow((IWindow)this.m_propertiesLayout);
        return this.m_propertiesLayout.isAccepted();
    }

    @Override
    public void showPrintDialog(PrinterJob job) {
        if (job != null) {
            job.printDialog();
            try {
                job.setPrintable((Printable)PluginServices.getExtension(Print.class));
                job.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        } else {
            this.att = this.layoutContext.getAttributes().toPrintRequestAttributeSet();
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            if (this.m_cachePrintServices == null) {
                this.m_cachePrintServices = PrintServiceLookup.lookupPrintServices(flavor, null);
            }
            PrintService defaultService = null;
            if (this.m_cachePrintService == null) {
                defaultService = PrintServiceLookup.lookupDefaultPrintService();
            }
            this.m_cachePrintService = this.m_cachePrintService == null ? ServiceUI.printDialog(null, 200, 200, this.m_cachePrintServices, defaultService, flavor, this.att) : ServiceUI.printDialog(null, 200, 200, this.m_cachePrintServices, this.m_cachePrintService, flavor, this.att);
            if (this.m_cachePrintService != null) {
                DocPrintJob jobNuevo = this.m_cachePrintService.createPrintJob();
                PrintJobAdapter pjlistener = new PrintJobAdapter(){

                    @Override
                    public void printDataTransferCompleted(PrintJobEvent e) {
                        DefaultLayoutPanel.this.layoutControl.fullRect();
                    }
                };
                jobNuevo.addPrintJobListener(pjlistener);
                try {
                    Class<?> repClass = Class.forName(flavor.getRepresentationClassName());
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("unknown representation class");
                }
                IExtension printData = PluginServices.getExtension(Print.class);
                this.doc = new SimpleDoc(printData, flavor, null);
                try {
                    jobNuevo.print(this.doc, this.att);
                }
                catch (PrintException pe) {
                    NotificationManager.addError((Throwable)pe);
                }
            }
        }
    }

    @Override
    public IFFramePanel createFFrameDialog(IFFrame fframe) {
        return this.layoutManager.createFFrameDialog(fframe, this);
    }

    public WindowInfo getWindowInfo() {
        if (this.m_viewInfo == null) {
            this.m_viewInfo = new WindowInfo(7);
            this.m_viewInfo.setWidth(700);
            this.m_viewInfo.setHeight(450);
            this.m_viewInfo.setTitle(PluginServices.getText((Object)this, (String)"Mapa") + " : " + this.layoutDocument.getName());
        }
        return this.m_viewInfo;
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    @Override
    public LayoutControl getLayoutControl() {
        return this.layoutControl;
    }

    public void windowActivated() {
        IFFrame[] frames;
        if (this.layoutControl.getRect().getWidth() <= 0.0) {
            this.layoutControl.fullRect();
        } else {
            this.layoutControl.refresh();
        }
        PluginServices.getMainFrame().getStatusBar().setMessage("units", PluginServices.getText((Object)this, (String)this.layoutContext.getAttributes().getNameUnit()));
        if (!this.layoutControl.getComponent().isRequestFocusEnabled()) {
            this.layoutControl.getComponent().setRequestFocusEnabled(true);
        }
        for (IFFrame frame : frames = this.layoutContext.getFFrames()) {
            if (!(frame instanceof LayoutPanelListener)) continue;
            ((LayoutPanelListener)frame).windowActivated();
        }
        this.requestFocus();
        this.layoutControl.getComponent().requestFocus();
    }

    public Object getWindowModel() {
        return this.layoutDocument;
    }

    public Document getDocument() {
        return this.layoutDocument;
    }

    public void windowClosed() {
        IFFrame[] frames;
        for (IFFrame frame : frames = this.layoutContext.getFFrames()) {
            if (!(frame instanceof LayoutPanelListener)) continue;
            ((LayoutPanelListener)frame).windowClosed();
        }
    }

    public void backColorChanged(ColorEvent e) {
    }

    @Override
    public void layoutToPDF(File file) {
        this.layoutControl.getLayoutDraw().toPDF(file);
    }

    @Override
    public void layoutToPDF(String suggestedName) {
        GenericFileFilter pdfFilter = new GenericFileFilter("pdf", PluginServices.getText((Object)this, (String)"pdf"));
        JFileChooser jfc = new JFileChooser(PDF_AND_PS_FILECHOOSER, defaultPDFFolderPath);
        if (suggestedName != null) {
            jfc.setSelectedFile(new File(suggestedName));
        }
        jfc.addChoosableFileFilter((FileFilter)pdfFilter);
        jfc.setFileFilter((FileFilter)pdfFilter);
        if (jfc.showSaveDialog((Component)PluginServices.getMainFrame()) == 0) {
            File f = jfc.getSelectedFile();
            File faux = f.getName().endsWith(".pdf") || f.getName().endsWith(".PDF") ? f : new File(f.getPath() + ".pdf");
            this.layoutToPDF(faux);
        }
    }

    @Override
    public void layoutToPS(String suggestedName) {
        GenericFileFilter pdfFilter = new GenericFileFilter("ps", PluginServices.getText((Object)this, (String)"ps"));
        JFileChooser jfc = new JFileChooser(PDF_AND_PS_FILECHOOSER, defaultPDFFolderPath);
        if (suggestedName != null) {
            jfc.setSelectedFile(new File(suggestedName));
        }
        jfc.addChoosableFileFilter((FileFilter)pdfFilter);
        jfc.setFileFilter((FileFilter)pdfFilter);
        if (jfc.showSaveDialog((Component)PluginServices.getMainFrame()) == 0) {
            File f = jfc.getSelectedFile();
            File faux = f.getName().endsWith(".ps") || f.getName().endsWith(".PS") ? f : new File(f.getPath() + ".ps");
            this.layoutControl.getLayoutDraw().toPS(faux);
        }
    }

    @Override
    public void layoutToPDF() {
        this.layoutToPDF((String)null);
    }

    @Override
    public void layoutToPS() {
        this.layoutToPS(null);
    }

    @Override
    public boolean isShowIconTag() {
        return this.bShowIconTag;
    }

    @Override
    public void setShowIconTag(boolean modeDebug) {
        this.bShowIconTag = modeDebug;
    }

    public void update(Observable observable, Object notification) {
        this.layoutContext.updateFFrames();
        this.layoutControl.refresh();
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(LAYOUTCONTEXT_OBJECT, (Persistent)this.layoutContext);
        state.set(LAYOUTDOCUMENT_OBJECT, (Persistent)this.layoutDocument);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.layoutContext = (LayoutContext)state.get(LAYOUTCONTEXT_OBJECT);
        this.setDocument((LayoutDocument)state.get(LAYOUTDOCUMENT_OBJECT));
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultLayoutPanel.class, PERSISTENCE_DEFINITION_NAME, "Layout panel persistence definition", null, null);
            definition.addDynFieldObject(LAYOUTCONTEXT_OBJECT).setClassOfValue(LayoutContext.class).setMandatory(true);
            definition.addDynFieldObject(LAYOUTDOCUMENT_OBJECT).setClassOfValue(LayoutDocument.class).setMandatory(true);
        }
    }

    public WindowLayout getWindowLayout() {
        return null;
    }

    public void setWindowLayout(WindowLayout layout) {
    }

    private void setLayoutContext(LayoutContext theLayoutcontext) {
        this.layoutContext = theLayoutcontext;
        this.layoutControl.setLayoutContext(theLayoutcontext);
        this.layoutContext.getAttributes().calculateGridGapX(this.layoutControl.getRect());
        this.layoutContext.getAttributes().calculateGridGapY(this.layoutControl.getRect());
        this.layoutControl.setDefaultTool();
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    @Override
    public void drawLayoutPrint(Graphics2D g2) {
        IFFrame[] fframes;
        this.layoutControl.setCancelDrawing(false);
        double scale = this.layoutControl.getRect().height / this.layoutContext.getAttributes().getPaperSize().getHeight() * 1.0;
        AffineTransform escalado = new AffineTransform();
        AffineTransform translacion = new AffineTransform();
        translacion.setToTranslation(this.layoutControl.getRect().getMinX(), this.layoutControl.getRect().getMinY());
        escalado.setToScale(scale, scale);
        this.layoutControl.getAT().setToIdentity();
        this.layoutControl.getAT().concatenate(translacion);
        this.layoutControl.getAT().concatenate(escalado);
        this.layoutContext.getAttributes().calculateGridGapX(this.layoutControl.getRect());
        this.layoutContext.getAttributes().calculateGridGapY(this.layoutControl.getRect());
        for (IFFrame fframe : fframes = this.layoutContext.getFFrames()) {
            fframe.print(g2, this.layoutControl.getAT(), null, this.layoutContext.getAttributes().toPrintAttributes());
        }
    }

    @Override
    public void hideToc() {
        if (this.isTocEnabled()) {
            this.lastPanePos = this.splitPane.getDividerLocation();
            this.splitPane.setDividerLocation(0);
        }
    }

    @Override
    public void showToc() {
        if (this.isTocEnabled()) {
            this.splitPane.setDividerLocation(this.lastPanePos);
        }
    }
}

