/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionParameters;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutReportActionParametersImpl
implements LayoutReportActionParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutReportActionParametersImpl.class);
    private final String LAYOUT_REPORT_BUFFER_SIZE = "bufferSize";
    private final String LAYOUT_REPORT_CENTER_TO_CURRENT_ROW = "centerToCurrentRow";
    private final String LAYOUT_REPORT_DEFAULT_TEMPLATE_NAME = "layout";
    private final String LAYOUT_REPORT_LABEL = "label";
    private final String LAYOUT_REPORT_NAME = "name";
    private final String LAYOUT_REPORT_TEMPLATE_NAME = "templateName";
    private final String LAYOUT_REPORT_HIGHLIGHT_RECORD = "highlightRecord";
    private final String LAYOUT_REPORT_HIGHLIGHT_SYMBOL = "highlightSymbol";
    private final String LAYOUT_REPORT_SYMBOL_TO_RECORD = "applySymbolToRecord";
    private final String LAYOUT_REPORT_SYMBOL_TO_EVERYTHING_EXCEPT_RECORD = "applySymbolToEverythinfExceptRecord";
    private final String LAYOUT_REPORT_TYPE = "type";
    private final String LAYOUT_REPORT_VIEW_TAG = "viewTag";
    private final String LAYOUT_REPORT_USE_INTERNAL_PDF_VIEWER = "useInternalPdfViewer";
    private final String LAYOUT_REPORT_ZOOM_TO_CURRENT_ROW = "zoomToCurrentRow";
    private String identifier;
    private String label;
    private boolean centerToCurrentRow;
    private boolean zoomToCurrentRow;
    private double bufferSize;
    private boolean useInternalPdfViewer;
    private boolean highlightRecord;
    private String viewTag;
    private ISymbol highlightSymbol;
    private String highlightSymbolSerialized;
    private boolean applySymbolToRecord;
    private boolean applySymbolToEverythingExceptRecord;
    private String templateName;

    LayoutReportActionParametersImpl() {
    }

    LayoutReportActionParametersImpl(String name) {
        this.identifier = name;
        this.label = name;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isCenterToCurrentRow() {
        return this.centerToCurrentRow;
    }

    @Override
    public void setCenterToCurrentRow(boolean centerToCurrentRow) {
        this.centerToCurrentRow = centerToCurrentRow;
    }

    @Override
    public boolean isZoomToCurrentRow() {
        return this.zoomToCurrentRow;
    }

    @Override
    public void setZoomToCurrentRow(boolean zoomToCurrentRow) {
        this.zoomToCurrentRow = zoomToCurrentRow;
    }

    @Override
    public double getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(double bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isHighlightRecord() {
        return this.highlightRecord;
    }

    @Override
    public void setHighlightRecord(boolean b) {
        this.highlightRecord = b;
    }

    @Override
    public boolean isApplySymbolToRecord() {
        return this.applySymbolToRecord;
    }

    @Override
    public void setApplySymbolToRecord(boolean b) {
        this.applySymbolToRecord = b;
    }

    @Override
    public boolean isApplySymbolToEverythingExceptRecord() {
        return this.applySymbolToEverythingExceptRecord;
    }

    @Override
    public void setApplySymbolToEverythingExceptRecord(boolean b) {
        this.applySymbolToEverythingExceptRecord = b;
    }

    @Override
    public boolean isUseInternalPdfViewer() {
        return this.useInternalPdfViewer;
    }

    @Override
    public void setUseInternalPdfViewer(boolean useIntervalPdfViewer) {
        this.useInternalPdfViewer = useIntervalPdfViewer;
    }

    @Override
    public String getViewTag() {
        return this.viewTag;
    }

    @Override
    public void setViewTag(String viewTag) {
        this.viewTag = viewTag;
    }

    @Override
    public ISymbol getHighlightSymbol(FeatureStore featureStore) {
        if (this.highlightSymbol == null) {
            this.highlightSymbol = LayoutReportActionParametersImpl.createSymbol(featureStore, this.highlightSymbolSerialized);
        }
        return this.highlightSymbol;
    }

    @Override
    public void setHighlightSymbol(ISymbol symbol) {
        this.highlightSymbol = symbol;
        this.highlightSymbolSerialized = null;
    }

    @Override
    public String getHighlightSymbolSerialized() {
        if (this.highlightSymbolSerialized == null) {
            this.highlightSymbolSerialized = LayoutReportActionParametersImpl.createSymbolSerialized(this.highlightSymbol);
        }
        return this.highlightSymbolSerialized;
    }

    @Override
    public void setHighlightSymbolSerialized(String symbol) {
        this.highlightSymbolSerialized = symbol;
        this.highlightSymbol = null;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    private static ISymbol createSymbol(FeatureStore featureStore, String s) {
        FeatureAttributeDescriptor geomAttr = featureStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute();
        if (geomAttr == null) {
            return null;
        }
        int geomType = geomAttr.getGeomType().getType();
        try {
            if (StringUtils.isBlank((CharSequence)s)) {
                return MapContextLocator.getMapContextManager().createSymbol(geomType);
            }
            byte[] bytes = Hex.decodeHex((char[])s.toCharArray());
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ISymbol symbol = (ISymbol)persistenceManager.getObject((InputStream)in);
            return symbol;
        }
        catch (DecoderException ex) {
            return MapContextLocator.getMapContextManager().createSymbol(geomType);
        }
    }

    private static String createSymbolSerialized(ISymbol symbol) {
        try {
            if (symbol == null) {
                return null;
            }
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            PersistentState state = persistenceManager.getState((Object)symbol);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            persistenceManager.saveState(state, (OutputStream)out);
            return Hex.encodeHexString((byte[])out.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't persist symbol", ex);
        }
    }

    public void fromJson(JsonObject json) {
        JsonNumber theSize;
        this.templateName = json.getString("templateName", "layout");
        this.identifier = json.getString("name", null);
        this.label = json.getString("label", this.identifier);
        this.highlightRecord = json.getBoolean("highlightRecord", true);
        this.highlightSymbol = null;
        this.highlightSymbolSerialized = json.getString("highlightSymbol", null);
        this.applySymbolToRecord = json.getBoolean("applySymbolToRecord", false);
        this.applySymbolToEverythingExceptRecord = json.getBoolean("applySymbolToEverythinfExceptRecord", false);
        this.centerToCurrentRow = json.getBoolean("centerToCurrentRow", true);
        this.zoomToCurrentRow = json.getBoolean("zoomToCurrentRow", true);
        this.bufferSize = 0.0;
        if (json.containsKey((Object)"bufferSize") && (theSize = json.getJsonNumber("bufferSize")) != null) {
            this.bufferSize = theSize.doubleValue();
        }
        this.setViewTag(json.getString("viewTag", null));
        this.useInternalPdfViewer = json.getBoolean("useInternalPdfViewer", true);
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder jsonBuilder = org.gvsig.json.Json.createObjectBuilder();
        jsonBuilder.add("name", this.identifier);
        jsonBuilder.add("type", "Layout");
        jsonBuilder.add("label", this.label);
        jsonBuilder.add("templateName", this.templateName);
        if (this.highlightSymbol != null) {
            jsonBuilder.add("highlightSymbol", this.getHighlightSymbolSerialized());
        }
        jsonBuilder.add("centerToCurrentRow", this.centerToCurrentRow);
        jsonBuilder.add("zoomToCurrentRow", this.zoomToCurrentRow);
        jsonBuilder.add("bufferSize", this.bufferSize);
        jsonBuilder.add("highlightRecord", this.highlightRecord);
        jsonBuilder.add("applySymbolToRecord", this.applySymbolToRecord);
        jsonBuilder.add("applySymbolToEverythinfExceptRecord", this.applySymbolToEverythingExceptRecord);
        jsonBuilder.add("viewTag", this.viewTag);
        jsonBuilder.add("useInternalPdfViewer", this.useInternalPdfViewer);
        return jsonBuilder;
    }

    @Override
    public void save(FeatureStore store, LayoutDocument layout) throws IOException {
        ResourcesStorage.Resource resource = null;
        ResourcesStorage.Resource resourceLayout = null;
        boolean persistentIndependentSave = false;
        try {
            ResourcesStorage resources = store.getResourcesStorage();
            String resourceName = this.getResourceName(resources, this.identifier);
            if (resourceName == null) {
                resourceName = this.getNextResourceName(resources, "report");
            }
            String theTemplateName = this.templateName;
            if (StringUtils.isBlank((CharSequence)this.templateName)) {
                theTemplateName = "Layout";
                if (StringUtils.contains((CharSequence)resourceName, (CharSequence)resources.getSeparator())) {
                    theTemplateName = StringUtils.replaceIgnoreCase((String)resourceName, (String)(resources.getSeparator() + "report"), (String)(resources.getSeparator() + "Layout"));
                }
                this.templateName = theTemplateName;
            }
            resource = resources.getResource(resourceName);
            IOUtils.write((String)this.toJson().toString(), (OutputStream)resource.asOutputStream(), (Charset)StandardCharsets.UTF_8);
            if (layout != null) {
                persistentIndependentSave = layout.isPersistIndependent();
                resourceLayout = resources.getResource(theTemplateName);
                PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                layout.setPersistIndependent(true);
                PersistentState persistentState = persistenceManager.getState((Object)layout.getMainWindow());
                persistenceManager.saveState(persistentState, resourceLayout.asOutputStream());
            }
            if (layout != null) {
                layout.setPersistIndependent(persistentIndependentSave);
            }
        }
        catch (PersistenceException ex) {
            try {
                throw new IOException("Can't persist LayoutReportActionParameters", ex);
            }
            catch (Throwable throwable) {
                if (layout != null) {
                    layout.setPersistIndependent(persistentIndependentSave);
                }
                IOUtils.closeQuietly(resource);
                IOUtils.closeQuietly(resourceLayout);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)resource);
        IOUtils.closeQuietly(resourceLayout);
    }

    private String getNextResourceName(ResourcesStorage resources, String resourceName) {
        List reports = resources.getResources(resourceName);
        if (reports == null || reports.isEmpty()) {
            return resourceName;
        }
        int n = -1;
        for (ResourcesStorage.Resource report : reports) {
            if (StringUtils.contains((CharSequence)report.getName(), (CharSequence)resources.getSeparator())) {
                String[] s = StringUtils.split((String)report.getName(), (String)resources.getSeparator());
                n = Math.max(n, Integer.parseInt(s[0]));
                continue;
            }
            n = 0;
        }
        if (n < 0) {
            return resourceName;
        }
        return String.valueOf(++n) + resources.getSeparator() + resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceName(ResourcesStorage resources, String reportName) {
        block11: {
            try {
                List reportsResources;
                if (resources == null || (reportsResources = resources.getResources("report")) == null || reportsResources.isEmpty()) break block11;
                for (ResourcesStorage.Resource resource : reportsResources) {
                    InputStream is = null;
                    try {
                        is = resource.asInputStream();
                        JsonObject json = Json.createReader((InputStream)is).readObject();
                        String name = json.getString("name", null);
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)reportName)) {
                            String string = resource.getName();
                            return string;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't load report form resource (" + resource.getURL() + ")", (Throwable)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    DisposeUtils.disposeQuietly((Object)resource);
                }
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)resources);
            }
        }
        return null;
    }
}

