/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.FLayoutGraphics;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameGroupSelectable;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.AbstractLayoutToolListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;

public class LayoutSelectListenerImpl
extends AbstractLayoutToolListener
implements LayoutMoveListener,
Observable {
    public static final Image icrux = PluginServices.getIconTheme().get("cursor-selection-complex").getImage();
    private ArrayList lastSelect = new ArrayList();
    private final ObservableHelper observers = new ObservableHelper();

    public LayoutSelectListenerImpl(LayoutPanel layoutPanel) {
        super(layoutPanel);
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
    }

    @Override
    public void drag(PointEvent event) {
    }

    @Override
    public Image getImageCursor() {
        return icrux;
    }

    @Override
    public boolean cancelDrawing() {
        return true;
    }

    @Override
    public void press(PointEvent event) throws BehaviorException {
        IFFrame[] fframes;
        Point2D m_pointSelected = event.getPoint();
        this.layoutPanel.getLayoutControl().setIsReSel(true);
        for (IFFrame fframe : fframes = this.layoutPanel.getLayoutContext().getFFrames()) {
            if (m_pointSelected != null) {
                if (!event.getEvent().isShiftDown()) {
                    if (fframe.isSelected()) {
                        fframe.setSelected(m_pointSelected, event.getEvent());
                    }
                } else if (fframe instanceof IFFrameGroupSelectable) {
                    fframe.setSelected(m_pointSelected, event.getEvent());
                }
            }
            if (!fframe.isSelected()) continue;
            this.layoutPanel.getLayoutControl().setIsReSel(false);
        }
        if (this.layoutPanel.getLayoutControl().getLastPoint() != null && this.layoutPanel.getLayoutControl().getFirstPoint() != null) {
            this.layoutPanel.getLayoutControl().getLastPoint().setLocation(this.layoutPanel.getLayoutControl().getFirstPoint());
        }
        if (event.getEvent().getClickCount() < 2) {
            this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_validated"));
            this.layoutPanel.repaint();
        }
    }

    @Override
    public void release(PointEvent event) throws BehaviorException {
        this.layoutPanel.getLayoutControl().getLayoutFunctions().setSelect();
        this.layoutPanel.getLayoutControl().refresh();
        this.layoutPanel.getLayoutControl().setIsReSel(false);
    }

    @Override
    public void click(PointEvent event) {
        int index = 0;
        if (event.getEvent().getButton() == 1) {
            Point2D m_pointSelected = event.getPoint();
            IFFrame[] fframes = this.layoutPanel.getLayoutContext().getFFrames();
            if (fframes.length > 0) {
                ArrayList<IFFrame> listSelect = new ArrayList<IFFrame>();
                for (IFFrame fframe : fframes) {
                    if (fframe.getContains(m_pointSelected) == 0) continue;
                    listSelect.add(fframe);
                }
                if (!listSelect.isEmpty()) {
                    for (int k = 0; k < listSelect.size(); ++k) {
                        if (!((IFFrame)listSelect.get(k)).isSelected()) continue;
                        index = listSelect.size() - k;
                        break;
                    }
                    if (!FLayoutUtilities.isEqualList(listSelect, this.lastSelect) || index > listSelect.size() - 1) {
                        index = 0;
                    }
                    for (IFFrame fframe : fframes) {
                        if (!event.getEvent().isShiftDown()) {
                            fframe.setSelected(false);
                            continue;
                        }
                        if (!fframe.isSelected() || fframe.getContains(m_pointSelected) == 0) continue;
                        fframe.setSelected(false);
                    }
                    ((IFFrame)listSelect.get(listSelect.size() - 1 - index)).setSelected(true);
                    ++index;
                    this.lastSelect = listSelect;
                }
                this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_validated"));
                this.layoutPanel.repaint();
                if (event.getEvent().getClickCount() > 1) {
                    FLayoutGraphics flg = new FLayoutGraphics(this.layoutPanel);
                    flg.openFrameDialog();
                    this.layoutPanel.getLayoutContext().updateFFrames();
                    this.layoutPanel.getLayoutContext().notifAllObservers();
                }
            }
            PluginServices.getMainFrame().enableControls();
        }
    }

    @Override
    public void move(PointEvent event) throws BehaviorException {
        IFFrame[] fframes;
        Point2D p = event.getPoint();
        for (IFFrame fframe : fframes = this.layoutPanel.getLayoutContext().getSelectedFFrames()) {
            Image cursor = fframe.getContains(p) != 0 ? fframe.getMapCursor(p) : this.getImageCursor();
            if (cursor == null) continue;
            this.layoutPanel.getLayoutControl().setMapCursor(cursor);
        }
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }
}

