/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutManager;
import org.gvsig.app.project.documents.layout.LayoutControl;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutRectangleByTwoPointsBehavior;
import org.gvsig.layout.mapbox.fframe.FFrameMapBox;
import org.gvsig.layout.mapbox.fframe.FFrameMapBoxFactory;
import org.gvsig.layout.mapbox.model.CellImpl;
import org.gvsig.layout.mapbox.model.MapBoxModel;
import org.gvsig.layout.mapbox.model.SelectionCellImpl;
import org.gvsig.layout.mapbox.panel.FFrameMapBoxPanel;
import org.gvsig.layout.mapbox.panel.menu.AddColumnMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.AddRowMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.CombineCellsMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.EditMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.InsertColumnMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.InsertRowMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.RemoveCellsMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.RemoveColumnMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.RemoveRowMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.SplitCellsHorizontallyMapBoxMenuEntry;
import org.gvsig.layout.mapbox.panel.menu.SplitCellsVerticallyMapBoxMenuEntry;
import org.gvsig.layout.mapbox.tools.LayoutAddMapBoxListenerImpl;
import org.gvsig.layout.mapbox.tools.LayoutEditMapBoxBehavior;
import org.gvsig.layout.mapbox.tools.LayoutEditMapBoxListenerImpl;

public class MapBoxUtils {
    static void register(DefaultLayoutManager layoutManager) {
        layoutManager.registerFrameFactory(new FFrameMapBoxFactory());
        layoutManager.registerFFrameDialog("FFrameMapBox", FFrameMapBoxPanel.class);
        IconThemeHelper.registerIcon((String)"action", (String)"layout-insert-mapbox", MapBoxUtils.class);
    }

    static void addLayoutAddMapBoxTool(LayoutPanel layoutPanel, LayoutControl control) {
        if (control.getLayoutTool("layoutaddmapbox") != null) {
            return;
        }
        LayoutAddMapBoxListenerImpl labl = new LayoutAddMapBoxListenerImpl(layoutPanel);
        control.addLayoutTool("layoutaddmapbox", new LayoutRectangleByTwoPointsBehavior(labl));
    }

    public static void addLayoutEditMapBoxTool(LayoutPanel layoutPanel, LayoutControl control) {
        if (control.getLayoutTool("layouteditmapbox") != null) {
            return;
        }
        LayoutEditMapBoxListenerImpl leditMapBoxListener = new LayoutEditMapBoxListenerImpl(layoutPanel);
        control.addLayoutTool("layouteditmapbox", new LayoutEditMapBoxBehavior(leditMapBoxListener));
    }

    static void registerPersistence() {
        FFrameMapBox.registerPersistent();
        MapBoxModel.registerPersistent();
        SelectionCellImpl.registerPersistent();
        CellImpl.registerPersistent();
    }

    static void registerContextMenuOptions() {
        LayoutManager layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        layoutManager.registerLayoutMenuAction("CombineCells", CombineCellsMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("SplitCellsVertically", SplitCellsVerticallyMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("SplitCellsHorizontally", SplitCellsHorizontallyMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("InsertColumnMapBoxMenuEntry", InsertColumnMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("AddColumnMapBoxMenuEntry", AddColumnMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("InsertRowMapBoxMenuEntry", InsertRowMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("AddRowMapBoxMenuEntry", AddRowMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("RemoveColumnMapBoxMenuEntry", RemoveColumnMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("RemoveRowMapBoxMenuEntry", RemoveRowMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("RemoveCellsMapBoxMenuEntry", RemoveCellsMapBoxMenuEntry.class);
        layoutManager.registerLayoutMenuAction("EditMapBoxMenuEntry", EditMapBoxMenuEntry.class);
    }
}

