/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.jdbc.panels;

import javax.swing.JComponent;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.jdbc.NewLayerJDBCProviderParameters;
import org.gvsig.newlayer.prov.jdbc.panels.GeometryIndexPanelLayout;
import org.gvsig.newlayer.spi.NewLayerPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryIndexPanel
extends GeometryIndexPanelLayout
implements NewLayerProviderPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryIndexPanel.class);
    private final NewLayerJDBCProviderParameters parameters;
    private final NewLayerWizard wizard;

    public GeometryIndexPanel(NewLayerWizard wizard, NewLayerJDBCProviderParameters parameters) {
        this.parameters = parameters;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Create_spatial_index_header") + "</html>");
        this.chkCreateGeometryIndex.setText(i18nManager.getTranslation("_Crear_indice_espacial_sobre_las_columnas_de_tipo_geometria"));
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Create_spatial_index");
    }

    public boolean validatePanel() throws NewLayerPanelValidationException {
        return true;
    }

    public void enterPanel() {
        String providerName = this.parameters.getExplorerParameters().getProviderName();
        DataManager dataManager = DALLocator.getDataManager();
        DataStoreProviderFactory storeProviderFactory = dataManager.getStoreProviderFactory(providerName);
        FeatureStoreProviderFactory providerFactory = (FeatureStoreProviderFactory)storeProviderFactory;
        if (providerFactory.allowSpatialIndexSupport()) {
            int index = this.parameters.getFeatureType().getDefaultGeometryAttributeIndex();
            if (index < 0) {
                this.chkCreateGeometryIndex.setEnabled(false);
                this.chkCreateGeometryIndex.setSelected(false);
            } else {
                this.chkCreateGeometryIndex.setEnabled(true);
                this.chkCreateGeometryIndex.setSelected(true);
            }
            this.chkCreateGeometryIndex.setSelected(this.parameters.getCreateIndexInGeometryRow());
        } else {
            this.chkCreateGeometryIndex.setEnabled(false);
            this.chkCreateGeometryIndex.setSelected(false);
        }
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setCreateIndexInGeometryRow(this.chkCreateGeometryIndex.isSelected());
    }

    public JComponent asJComponent() {
        return this;
    }

    public boolean getCreateIndexInGeometryRow() {
        return this.chkCreateGeometryIndex.isSelected();
    }
}

