/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.i18n.Messages;

public class LabelClassPreview
extends JPanel {
    private static final long serialVersionUID = 3788548343944220354L;
    private Dimension sz = new Dimension(100, 200);
    private ILabelClass labelClass;

    @Override
    public Dimension getPreferredSize() {
        Dimension sz = this.labelClass == null ? this.sz : this.labelClass.getBounds().getSize();
        int w = sz.width;
        int h = sz.height;
        if (w > 300) {
            w = 300;
        }
        if (h > 200) {
            h = 200;
        }
        sz.setSize(w, h);
        return sz;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.labelClass == null) {
            return;
        }
        Rectangle r = this.getBounds();
        r.setLocation(0, 0);
        g.setColor(Color.white);
        ((Graphics2D)g).fill(r);
        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        g.setColor(Color.black);
        ((Graphics2D)g).draw(r);
        ILabelStyle sty = this.labelClass.getLabelStyle();
        if (sty != null) {
            int fc = sty.getFieldCount();
            String[] texts = new String[fc];
            for (int i = 0; i < texts.length; ++i) {
                texts[i] = Messages.getText((String)"text_field") + " " + (i + 1);
            }
            this.labelClass.setTexts(texts);
        } else {
            this.labelClass.setTexts(new String[]{Messages.getText((String)"text_field")});
        }
        ITextSymbol sym = this.labelClass.getTextSymbol();
        Font myFont = new Font(sym.getFont().getName(), sym.getFont().getStyle(), 35);
        AffineTransform saveAT = ((Graphics2D)g).getTransform();
        saveAT.translate(0.0, r.getCenterY());
        ((Graphics2D)g).setTransform(saveAT);
        FontRenderContext frc = new FontRenderContext(saveAT, false, true);
        g.setFont(myFont);
        String text = Messages.getText((String)"text_field");
        if (sym.isDrawWithHalo()) {
            BasicStroke haloStroke = new BasicStroke(sym.getHaloWidth());
            char[] charText = new char[text.length()];
            text.getChars(0, charText.length, charText, 0);
            GlyphVector glyph = myFont.layoutGlyphVector(frc, charText, 0, charText.length, 4);
            g.setColor(sym.getHaloColor());
            ((Graphics2D)g).setStroke(haloStroke);
            ((Graphics2D)g).draw(glyph.getOutline());
        }
        g.setColor(sym.getTextColor());
        g.drawString(Messages.getText((String)"text_field"), 0, 0);
    }

    public void setLabelClass(ILabelClass labelClass) {
        this.labelClass = labelClass;
    }
}

