/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.app.gui.styling.SingleStyleSelectorFilter;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.app.gui.styling.StyleSelector;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.DuplicateLayersMode;
import org.gvsig.labeling.gui.layerproperties.IPlacementProperties;
import org.gvsig.labeling.gui.layerproperties.MiniMapContext;
import org.gvsig.labeling.gui.layerproperties.MultiShapePlacementProperties;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.labeling.placements.MultiShapePlacementConstraints;
import org.gvsig.labeling.placements.PlacementManager;
import org.gvsig.labeling.placements.PointLabelPositioner;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.tools.persistence.Persistent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementProperties
extends JPanel
implements IPlacementProperties,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(PlacementProperties.class);
    private static final long serialVersionUID = 1022470370547576765L;
    private PointLabelPositioner defaultPointStyle = new PointLabelPositioner(new int[]{2, 2, 1, 3, 2, 3, 3, 2}, Messages.getText((String)"prefer_top_right_all_allowed"));
    public IPlacementConstraints constraints;
    private PointLabelPositioner pointStyle = null;
    private int shapeType;
    private JPanel pnlContent = null;
    private JPanel pnlCenter = null;
    private JPanel orientationPanel;
    private DuplicateLayersMode duplicateLabelsMode;
    private JRadioButton rdBtnHorizontal;
    private JRadioButton rdBtnParallel;
    private JRadioButton rdBtnFollowingLine;
    private JRadioButton rdBtnPerpendicular;
    private JPanel positionPanel;
    private MiniMapContext preview;
    private ArrayList<String> linePositionItem = new ArrayList();
    private JPanel polygonSettingsPanel;
    private JRadioButton rdBtnAlwaysHorizontal;
    private JRadioButton rdBtnAlwaysStraight;
    private GridBagLayoutPanel pointSettingsPanel;
    private JRadioButton rdBtnOffsetLabelHorizontally;
    private JRadioButton rdBtnOffsetLabelOnTopPoint;
    private StylePreviewer stylePreview;
    private JButton btnChangeLocation;
    private JPanel locationPanel;
    private JComboBox cmbLocationAlongLines;
    private JRadioButton chkBellow;
    private JRadioButton chkOnTheLine;
    private JRadioButton chkAbove;
    private JComboBox cmbOrientationSystem;
    private JLabelHTML lblPointPosDesc = new JLabelHTML("");
    IPlacementConstraints oldConstraints;
    private JCheckBox chkFitInsidePolygon;
    private boolean initialized = false;

    public PlacementProperties(IPlacementConstraints constraints, int shapeType) {
        this.initialize(constraints, shapeType, this.getPnlDuplicateLabels());
    }

    PlacementProperties(IPlacementConstraints costraints, int shapeType, DuplicateLayersMode duplicatesMode) {
        this.initialize(costraints, shapeType, duplicatesMode);
        this.refreshComponents();
        this.initialized = true;
    }

    private void refreshComponents() {
        this.getChkOnTheLine().setSelected(this.constraints.isOnTheLine());
        this.getChkAbove().setSelected(this.constraints.isAboveTheLine());
        this.getChkBelow().setSelected(this.constraints.isBelowTheLine());
        this.getRdBtnHorizontal().setSelected(this.constraints.isHorizontal());
        this.getRdBtnParallel().setSelected(this.constraints.isParallel());
        this.getRdBtnFollowingLine().setSelected(this.constraints.isFollowingLine());
        this.getRdBtnPerpendicular().setSelected(this.constraints.isPerpendicular());
        this.getCmbOrientationSystem().setSelectedIndex(this.constraints.isPageOriented() ? 1 : 0);
        if (this.constraints.isOnTopOfThePoint()) {
            this.getRdOffsetLabelOnTopPoint().setSelected(true);
        } else if (this.constraints.isAroundThePoint()) {
            this.getRdOffsetLabelHorizontally().setSelected(true);
        }
        if (this.constraints.isAtTheBeginingOfLine()) {
            this.getCmbLocationAlongLines().setSelectedIndex(1);
        } else if (this.constraints.isInTheMiddleOfLine()) {
            this.getCmbLocationAlongLines().setSelectedIndex(0);
        } else if (this.constraints.isAtTheEndOfLine()) {
            this.getCmbLocationAlongLines().setSelectedIndex(2);
        } else if (this.constraints.isAtBestOfLine()) {
            this.getCmbLocationAlongLines().setSelectedIndex(3);
        }
        this.getChkFitInsidePolygon().setSelected(this.constraints.isFitInsidePolygon());
        if (this.constraints.isHorizontal()) {
            this.getRdBtnAlwaysHorizontal().setSelected(true);
        } else if (this.constraints.isParallel()) {
            this.getRdBtnAlwaysStraight().setSelected(true);
        }
        int dupMode = this.constraints.getDuplicateLabelsMode();
        this.duplicateLabelsMode.setMode(dupMode);
        this.getPreview().setConstraints(this.constraints);
    }

    private void initialize(IPlacementConstraints constraints, int shapeType, DuplicateLayersMode duplicatesMode) {
        this.duplicateLabelsMode = duplicatesMode;
        this.shapeType = shapeType;
        this.oldConstraints = this.constraints;
        if (constraints != null) {
            this.constraints = (IPlacementConstraints)LabelClassUtils.clone((Persistent)constraints);
            if (constraints instanceof PointPlacementConstraints) {
                PointLabelPositioner positioneer = ((PointPlacementConstraints)constraints).getPositioner();
                if (positioneer != null) {
                    this.setPointStyle(positioneer);
                }
                this.lblPointPosDesc.setText(this.getPointStyle().getDescription());
            }
        } else {
            try {
                this.constraints = PlacementManager.createPlacementConstraints(shapeType);
            }
            catch (Exception e) {
                logger.error("While initializing placement constraints.", (Throwable)e);
                return;
            }
        }
        this.getPnlDuplicateLabels().setMode(this.constraints.getDuplicateLabelsMode());
        this.linePositionItem.add(Messages.getText((String)"in_the_middle"));
        this.linePositionItem.add(Messages.getText((String)"at_begin"));
        this.linePositionItem.add(Messages.getText((String)"at_end"));
        this.linePositionItem.add(Messages.getText((String)"at_best"));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(410, 380));
        this.add((Component)this.getPnlContent(), "Center");
    }

    public WindowInfo getWindowInfo() {
        WindowInfo viewInfo = new WindowInfo(9);
        viewInfo.setWidth(440);
        viewInfo.setHeight(520);
        viewInfo.setTitle(Messages.getText((String)"placement_properties"));
        return viewInfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new BorderLayout());
            this.pnlContent.add((Component)this.getPnlCenter(), "Center");
            this.pnlContent.add((Component)((Object)this.getPnlDuplicateLabels()), "South");
        }
        return this.pnlContent;
    }

    private DuplicateLayersMode getPnlDuplicateLabels() {
        if (this.duplicateLabelsMode == null) {
            this.duplicateLabelsMode = new DuplicateLayersMode(this);
        }
        return this.duplicateLabelsMode;
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel();
            GeometryType gt = null;
            try {
                gt = GeometryLocator.getGeometryManager().getGeometryType(this.shapeType, 0);
            }
            catch (Exception e) {
                logger.error("While getting panel.", (Throwable)e);
                return null;
            }
            if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
                this.pnlCenter.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"point_settings")));
                this.pnlCenter.add((Component)this.getPointSettingsPanel());
            } else if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
                this.pnlCenter.setLayout(new BorderLayout());
                this.pnlCenter.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"line_settings")));
                JPanel aux = new JPanel(new GridLayout(1, 2));
                aux.add(this.getOrientationPanel());
                aux.add(this.getPositionPanel());
                this.pnlCenter.add((Component)aux, "Center");
                this.pnlCenter.add((Component)this.getLocationPanel(), "South");
            } else if (gt.isTypeOf(3) || gt.isTypeOf(9)) {
                this.pnlCenter.setLayout(new BorderLayout());
                this.pnlCenter.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"polygon_settings")));
                this.pnlCenter.add((Component)this.getPolygonSettingsPanel(), "Center");
            }
        }
        return this.pnlCenter;
    }

    private JPanel getLocationPanel() {
        if (this.locationPanel == null) {
            this.locationPanel = new JPanel(new FlowLayout(3));
            this.locationPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"location")));
            this.locationPanel.add(new JLabel(Messages.getText((String)"location_along_the_lines") + ":"));
            this.locationPanel.add(this.getCmbLocationAlongLines());
        }
        return this.locationPanel;
    }

    private JComboBox getCmbLocationAlongLines() {
        if (this.cmbLocationAlongLines == null) {
            this.cmbLocationAlongLines = new JComboBox<String>(this.linePositionItem.toArray(new String[this.linePositionItem.size()]));
            this.cmbLocationAlongLines.addActionListener(this);
        }
        return this.cmbLocationAlongLines;
    }

    private PointLabelPositioner getPointStyle() {
        if (this.pointStyle == null) {
            this.pointStyle = this.defaultPointStyle;
            this.lblPointPosDesc.setText(this.pointStyle.getDescription());
        }
        return this.pointStyle;
    }

    private void setPointStyle(PointLabelPositioner pointStyle) {
        this.pointStyle = pointStyle;
    }

    private GridBagLayoutPanel getPointSettingsPanel() {
        if (this.pointSettingsPanel == null) {
            this.pointSettingsPanel = new GridBagLayoutPanel();
            this.pointSettingsPanel.addComponent((Component)this.getRdOffsetLabelHorizontally());
            JPanel aux = new JPanel();
            aux.add((Component)this.getStylePreviewer());
            JPanel aux2 = new JPanel();
            aux2.setLayout(new BoxLayout(aux2, 1));
            aux2.add(this.lblPointPosDesc);
            aux2.add((Component)new JBlank(20, 5));
            aux2.add(this.getBtnChangeLocation());
            aux.add(aux2);
            this.pointSettingsPanel.addComponent("", (Component)aux);
            this.pointSettingsPanel.addComponent("", (Component)new JLabel(Messages.getText((String)"label-point-priority-help")));
            this.pointSettingsPanel.addComponent((Component)this.getRdOffsetLabelOnTopPoint());
            ButtonGroup group = new ButtonGroup();
            group.add(this.getRdOffsetLabelHorizontally());
            group.add(this.getRdOffsetLabelOnTopPoint());
        }
        return this.pointSettingsPanel;
    }

    private JButton getBtnChangeLocation() {
        if (this.btnChangeLocation == null) {
            this.btnChangeLocation = new JButton(Messages.getText((String)"change_location"));
            this.btnChangeLocation.addActionListener(this);
        }
        return this.btnChangeLocation;
    }

    private StylePreviewer getStylePreviewer() {
        if (this.stylePreview == null) {
            this.stylePreview = new StylePreviewer();
            this.stylePreview.setStyle((IStyle)this.getPointStyle());
            this.stylePreview.setPreferredSize(new Dimension(80, 80));
        }
        return this.stylePreview;
    }

    private JRadioButton getRdOffsetLabelOnTopPoint() {
        if (this.rdBtnOffsetLabelOnTopPoint == null) {
            this.rdBtnOffsetLabelOnTopPoint = new JRadioButton(Messages.getText((String)"offset_labels_on_top_of_the_points"));
        }
        return this.rdBtnOffsetLabelOnTopPoint;
    }

    private JRadioButton getRdOffsetLabelHorizontally() {
        if (this.rdBtnOffsetLabelHorizontally == null) {
            this.rdBtnOffsetLabelHorizontally = new JRadioButton(Messages.getText((String)"offset_labels_horizontally"));
        }
        return this.rdBtnOffsetLabelHorizontally;
    }

    private JPanel getPolygonSettingsPanel() {
        if (this.polygonSettingsPanel == null) {
            this.polygonSettingsPanel = new JPanel(new BorderLayout(10, 10));
            JPanel aux = new JPanel();
            aux.setLayout(new BoxLayout(aux, 1));
            aux.add((Component)new JBlank(10, 10));
            aux.add(this.getRdBtnAlwaysHorizontal());
            aux.add((Component)new JBlank(10, 10));
            aux.add(this.getRdBtnAlwaysStraight());
            aux.add((Component)new JBlank(10, 50));
            this.polygonSettingsPanel.add((Component)this.getPreview(), "Center");
            this.polygonSettingsPanel.add((Component)aux, "East");
            ButtonGroup group = new ButtonGroup();
            group.add(this.getRdBtnAlwaysHorizontal());
            group.add(this.getRdBtnAlwaysStraight());
            this.polygonSettingsPanel.add((Component)this.getChkFitInsidePolygon(), "South");
        }
        return this.polygonSettingsPanel;
    }

    private JCheckBox getChkFitInsidePolygon() {
        if (this.chkFitInsidePolygon == null) {
            this.chkFitInsidePolygon = new JCheckBox(Messages.getText((String)"fit_inside_polygon"));
            this.chkFitInsidePolygon.addActionListener(this);
        }
        return this.chkFitInsidePolygon;
    }

    private JRadioButton getRdBtnAlwaysStraight() {
        if (this.rdBtnAlwaysStraight == null) {
            this.rdBtnAlwaysStraight = new JRadioButton(Messages.getText((String)"always_straight"));
            this.rdBtnAlwaysStraight.addActionListener(this);
        }
        return this.rdBtnAlwaysStraight;
    }

    private JRadioButton getRdBtnAlwaysHorizontal() {
        if (this.rdBtnAlwaysHorizontal == null) {
            this.rdBtnAlwaysHorizontal = new JRadioButton(Messages.getText((String)"always_horizontal"));
            this.rdBtnAlwaysHorizontal.addActionListener(this);
        }
        return this.rdBtnAlwaysHorizontal;
    }

    private JPanel getPositionPanel() {
        if (this.positionPanel == null) {
            this.positionPanel = new JPanel(new BorderLayout());
            this.positionPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"position")));
            GridBagLayoutPanel aux2 = new GridBagLayoutPanel();
            JPanel aux = new JPanel(new GridLayout(4, 1));
            aux.add(this.getChkAbove());
            this.getChkAbove().setSelected(true);
            aux.add(this.getChkOnTheLine());
            aux.add(this.getChkBelow());
            ButtonGroup group = new ButtonGroup();
            group.add(this.getChkAbove());
            group.add(this.getChkOnTheLine());
            group.add(this.getChkBelow());
            aux2.addComponent((Component)aux);
            aux2.addComponent(Messages.getText((String)"orientation_system"), (Component)this.getCmbOrientationSystem());
            this.positionPanel.add((Component)this.getPreview(), "Center");
            this.positionPanel.add((Component)aux2, "South");
        }
        return this.positionPanel;
    }

    private MiniMapContext getPreview() {
        if (this.preview == null) {
            this.preview = new MiniMapContext(this.shapeType);
        }
        return this.preview;
    }

    private JComboBox getCmbOrientationSystem() {
        if (this.cmbOrientationSystem == null) {
            this.cmbOrientationSystem = new JComboBox<String>(new String[]{Messages.getText((String)"line"), Messages.getText((String)"page")});
            this.cmbOrientationSystem.setSelectedIndex(1);
            this.cmbOrientationSystem.addActionListener(this);
        }
        return this.cmbOrientationSystem;
    }

    private JRadioButton getChkBelow() {
        if (this.chkBellow == null) {
            this.chkBellow = new JRadioButton(Messages.getText((String)"below"));
            this.chkBellow.addActionListener(this);
        }
        return this.chkBellow;
    }

    private JRadioButton getChkOnTheLine() {
        if (this.chkOnTheLine == null) {
            this.chkOnTheLine = new JRadioButton(Messages.getText((String)"on_the_line"));
            this.chkOnTheLine.addActionListener(this);
        }
        return this.chkOnTheLine;
    }

    private JRadioButton getChkAbove() {
        if (this.chkAbove == null) {
            this.chkAbove = new JRadioButton(Messages.getText((String)"above"));
            this.chkAbove.addActionListener(this);
        }
        return this.chkAbove;
    }

    private JPanel getOrientationPanel() {
        if (this.orientationPanel == null) {
            this.orientationPanel = new JPanel(new BorderLayout());
            this.orientationPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"orientation")));
            GridBagLayoutPanel auxp = new GridBagLayoutPanel();
            auxp.addComponent((Component)this.getRdBtnHorizontal());
            auxp.addComponent((Component)this.getRdBtnParallel());
            auxp.addComponent((Component)this.getRdBtnFollowingLine());
            auxp.addComponent((Component)this.getRdBtnPerpendicular());
            this.orientationPanel.add((Component)auxp, "North");
            ButtonGroup group = new ButtonGroup();
            group.add(this.getRdBtnHorizontal());
            group.add(this.getRdBtnParallel());
            group.add(this.getRdBtnFollowingLine());
            group.add(this.getRdBtnPerpendicular());
        }
        return this.orientationPanel;
    }

    private JRadioButton getRdBtnParallel() {
        if (this.rdBtnParallel == null) {
            this.rdBtnParallel = new JRadioButton(Messages.getText((String)"parallel"));
            this.rdBtnParallel.addActionListener(this);
        }
        return this.rdBtnParallel;
    }

    private JRadioButton getRdBtnFollowingLine() {
        if (this.rdBtnFollowingLine == null) {
            this.rdBtnFollowingLine = new JRadioButton(Messages.getText((String)"following_line"));
            this.rdBtnFollowingLine.addActionListener(this);
        }
        return this.rdBtnFollowingLine;
    }

    private JRadioButton getRdBtnPerpendicular() {
        if (this.rdBtnPerpendicular == null) {
            this.rdBtnPerpendicular = new JRadioButton(Messages.getText((String)"perpedicular"));
            this.rdBtnPerpendicular.addActionListener(this);
        }
        return this.rdBtnPerpendicular;
    }

    private JRadioButton getRdBtnHorizontal() {
        if (this.rdBtnHorizontal == null) {
            this.rdBtnHorizontal = new JRadioButton(Messages.getText((String)"horizontal"));
            this.rdBtnHorizontal.addActionListener(this);
        }
        return this.rdBtnHorizontal;
    }

    public void applyConstraints() throws GeometryException {
        int mode = 0;
        GeometryType gt = null;
        gt = GeometryLocator.getGeometryManager().getGeometryType(this.shapeType, 0);
        if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
            if (this.getRdOffsetLabelOnTopPoint().isSelected()) {
                mode = 6;
            } else if (this.getRdOffsetLabelHorizontally().isSelected()) {
                mode = 5;
            }
            ((PointPlacementConstraints)this.constraints).setPositioner((PointLabelPositioner)this.stylePreview.getStyle());
        } else if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
            mode = this.getRdBtnFollowingLine().isSelected() ? 11 : (this.getRdBtnParallel().isSelected() ? 10 : (this.getRdBtnPerpendicular().isSelected() ? 12 : 9));
            this.constraints.setAboveTheLine(this.getChkAbove().isSelected());
            this.constraints.setBelowTheLine(this.getChkBelow().isSelected());
            this.constraints.setOnTheLine(this.getChkOnTheLine().isSelected());
            this.constraints.setPageOriented(this.getCmbOrientationSystem().getSelectedIndex() == 1);
            int i = this.getCmbLocationAlongLines().getSelectedIndex();
            if (i == 0) {
                i = 14;
            } else if (i == 1) {
                i = 15;
            } else if (i == 2) {
                i = 13;
            } else if (i == 3) {
                i = 16;
            }
            this.constraints.setLocationAlongTheLine(i);
        } else if (gt.isTypeOf(3) || gt.isTypeOf(9)) {
            mode = 9;
            if (this.getRdBtnAlwaysHorizontal().isSelected()) {
                mode = 9;
            } else if (this.getRdBtnAlwaysStraight().isSelected()) {
                mode = 10;
            }
            this.constraints.setFitInsidePolygon(this.getChkFitInsidePolygon().isSelected());
        }
        this.constraints.setPlacementMode(mode);
        this.constraints.setDuplicateLabelsMode(this.duplicateLabelsMode.getMode());
    }

    private void setComponentEnabled(Component c, boolean b) {
        if (c instanceof JComponent) {
            JComponent c1 = (JComponent)c;
            for (int i = 0; i < c1.getComponentCount(); ++i) {
                this.setComponentEnabled(c1.getComponent(i), b);
            }
        }
        c.setEnabled(b);
    }

    @Override
    public IPlacementConstraints getPlacementConstraints() {
        return this.constraints;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        boolean okPressed = "OK".equals(e.getActionCommand());
        boolean cancelPressed = "CANCEL".equals(e.getActionCommand());
        if (okPressed || cancelPressed) {
            if (okPressed) {
                try {
                    this.applyConstraints();
                }
                catch (GeometryException e1) {
                    logger.error("While applying constraints.", (Throwable)e1);
                }
            }
            if ("CANCEL".equals(e.getActionCommand())) {
                this.constraints = this.oldConstraints;
            }
            ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
            return;
        }
        if (!c.equals(this.rdBtnAlwaysHorizontal) && !c.equals(this.rdBtnAlwaysStraight)) {
            if (c.equals(this.rdBtnHorizontal)) {
                this.setComponentEnabled(this.getPositionPanel(), false);
                this.setComponentEnabled(this.getLocationPanel(), false);
            } else if (c.equals(this.rdBtnParallel) || c.equals(this.rdBtnPerpendicular)) {
                this.setComponentEnabled(this.getLocationPanel(), true);
                this.setComponentEnabled(this.getPositionPanel(), true);
                this.getCmbOrientationSystem().setEnabled(true);
            } else if (c.equals(this.rdBtnFollowingLine)) {
                this.setComponentEnabled(this.getLocationPanel(), true);
                this.setComponentEnabled(this.getPositionPanel(), true);
                this.getCmbOrientationSystem().setSelectedItem(Messages.getText((String)"line"));
                this.getCmbOrientationSystem().setEnabled(false);
            } else if (c.equals(this.btnChangeLocation)) {
                StyleSelector stySel = new StyleSelector((IStyle)this.getPointStyle(), 1, (SelectorFilter)new SingleStyleSelectorFilter(PointLabelPositioner.class));
                ApplicationLocator.getManager().getUIManager().addWindow((IWindow)stySel);
                IStyle sty = (IStyle)stySel.getSelectedObject();
                if (sty != null) {
                    this.stylePreview.setStyle(sty);
                    this.lblPointPosDesc.setText(sty.getDescription());
                }
            } else if (c == this.getChkFitInsidePolygon() || c == this.getPnlDuplicateLabels()) {
                // empty if block
            }
        }
        this.applyToPreview();
        CompRefreshThread st = new CompRefreshThread(this.getPnlContent(), 500);
        st.start();
    }

    private void applyToPreview() {
        if (this.preview != null) {
            try {
                if (this.initialized) {
                    this.applyConstraints();
                }
            }
            catch (GeometryException e) {
                logger.error("While applying constraints.", (Throwable)e);
            }
            this.preview.setConstraints(this.constraints);
        }
    }

    public static IPlacementProperties createPlacementProperties(IPlacementConstraints placementConstraints, int shapeType) {
        return PlacementProperties.createPlacementProperties(placementConstraints, shapeType, null);
    }

    protected static IPlacementProperties createPlacementProperties(IPlacementConstraints placementConstraints, int geotype, DuplicateLayersMode duplicatesMode) {
        JPanel pp = null;
        if (geotype == 0 || geotype == 6) {
            try {
                pp = new MultiShapePlacementProperties((MultiShapePlacementConstraints)placementConstraints);
            }
            catch (Exception e) {
                logger.error("While creating MultiShapePlacementProperties", (Throwable)e);
            }
        } else {
            pp = new PlacementProperties(placementConstraints, geotype, null);
        }
        ((JPanel)pp).add((Component)new AcceptCancelPanel((ActionListener)((Object)pp), (ActionListener)((Object)pp)), "South");
        return pp;
    }

    class CompRefreshThread
    extends Thread {
        private int waitt = 0;
        private Component compo = null;

        public CompRefreshThread(Component co, int t) {
            this.compo = co;
            this.waitt = t;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.waitt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CompRefreshThread.this.compo.repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private class JLabelHTML
    extends JLabel {
        private static final long serialVersionUID = -5031405572546951108L;

        public JLabelHTML(String text) {
            super(text);
            this.setPreferredSize(new Dimension(250, 60));
        }

        @Override
        public void setText(String text) {
            super.setText("<html>" + text + "</html>");
        }
    }
}

