/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import org.apache.batik.ext.awt.geom.PathLength;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;

public abstract class AbstractLinePlacement
implements ILabelPlacement {
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    private final ArrayList<LabelLocationMetrics> guessed = new ArrayList();
    private static final double TOLERANCE = 0.01;

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints pc, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        this.guessed.clear();
        Geometry shp = geom.cloneGeometry();
        shp.transform(vp.getAffineTransform());
        PathLength pathLen = new PathLength((Shape)shp);
        LabelLocationMetrics initial = this.initialLocation(lc, pc, pathLen, cancel);
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        double theta = initial.getRotation();
        double xOffset = 0.0;
        double yOffset = 0.0;
        Rectangle bounds = lc.getBounds();
        if (pc.isPageOriented()) {
            double sinTheta;
            Point2D anchor;
            if (theta > 1.5707963267948966) {
                anchor = initial.getAnchor();
                double cosTheta = Math.cos(theta -= Math.PI);
                sinTheta = Math.sin(theta);
                double width = ((RectangularShape)bounds).getWidth();
                double height = ((RectangularShape)bounds).getHeight() * 1.1;
                initial.getAnchor().setLocation(anchor.getX() - cosTheta * width + sinTheta * height, anchor.getY() - sinTheta * width - cosTheta * height);
            } else if (theta < -1.5707963267948966) {
                anchor = initial.getAnchor();
                double cosTheta = Math.cos(theta += Math.PI);
                sinTheta = Math.sin(theta);
                double width = ((RectangularShape)bounds).getWidth();
                double height = ((RectangularShape)bounds).getHeight() * 1.1;
                initial.getAnchor().setLocation(anchor.getX() - cosTheta * width + sinTheta * height, anchor.getY() - sinTheta * width - cosTheta * height);
            }
        }
        if (pc.isBelowTheLine() || pc.isOnTheLine() || pc.isAboveTheLine()) {
            double h = ((RectangularShape)bounds).getHeight() * 0.5;
            xOffset += h * Math.sin(theta);
            yOffset += h * Math.cos(theta);
            Point2D initialAnchor = initial.getAnchor();
            if (pc.isBelowTheLine()) {
                Point2D.Double anchor = new Point2D.Double(initialAnchor.getX() + -xOffset, initialAnchor.getY() + yOffset);
                this.guessed.add(0, new LabelLocationMetrics((Point2D)anchor, theta, false));
            }
            if (pc.isOnTheLine()) {
                this.guessed.add(0, new LabelLocationMetrics(initial.getAnchor(), theta, false));
            }
            if (pc.isAboveTheLine()) {
                Point2D.Double anchor = new Point2D.Double(initialAnchor.getX() + xOffset, initialAnchor.getY() + -yOffset);
                this.guessed.add(0, new LabelLocationMetrics((Point2D)anchor, theta, false));
            }
        } else {
            this.guessed.add(0, initial);
        }
        return this.guessed;
    }

    abstract LabelLocationMetrics initialLocation(ILabelClass var1, IPlacementConstraints var2, PathLength var3, Cancellable var4);
}

