/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.LinePlacementConstraints;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.labeling.placements.PolygonPlacementConstraints;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractPlacementConstraints
implements Cloneable,
IPlacementConstraints {
    public static final String PLACEMENT_CONSTRAINTS_PERSISTENCE_NAME = "PLACEMENT_CONSTRAINTS_PERSISTENCE_NAME";
    private int duplicateLabelsMode = 4;
    private int placementMode;
    private boolean belowTheLine;
    private boolean aboveTheLine;
    private boolean onTheLine;
    private boolean pageOriented;
    private int locationAlongLine;
    private boolean fitInsidePolygon;

    public void setDuplicateLabelsMode(int mode) {
        if (mode != 2 && mode != 3 && mode != 4) {
            throw new IllegalArgumentException("Only REMOVE_DUPLICATE_LABELS, ONE_LABEL_PER_FEATURE or ONE_LABEL_PER_FEATURE_PARTS allowed");
        }
        this.duplicateLabelsMode = mode;
    }

    public void setPlacementMode(int mode) {
        if (this instanceof PointPlacementConstraints && mode != 5 && mode != 6 && mode != 7 && mode != 8) {
            throw new IllegalArgumentException("Only OFFSET_HORIZONTALY_AROUND_THE_POINT, ON_TOP_OF_THE_POINT, AT_SPECIFIED_ANGLE or AT_ANGLE_SPECIFIED_BY_A_FIELD allowed for points: " + mode);
        }
        if (this instanceof PolygonPlacementConstraints && mode != 9 && mode != 10) {
            throw new IllegalArgumentException("Only HORIZONTAL, or PARALLEL allowed for polygons: " + mode);
        }
        if (this instanceof LinePlacementConstraints && mode != 9 && mode != 10 && mode != 11 && mode != 12) {
            throw new IllegalArgumentException("Only HORIZONTAL, PARALLEL,FOLLOWING_LINE, or PERPENDICULAR allowed for lines: " + mode);
        }
        this.placementMode = mode;
    }

    public boolean isHorizontal() {
        return this.placementMode == 9;
    }

    public boolean isPerpendicular() {
        return this.placementMode == 12;
    }

    public boolean isFollowingLine() {
        return this.placementMode == 11;
    }

    public boolean isParallel() {
        return this.placementMode == 10;
    }

    public int getDuplicateLabelsMode() {
        return this.duplicateLabelsMode;
    }

    public boolean isOnTopOfThePoint() {
        return this.placementMode == 6;
    }

    public boolean isBelowTheLine() {
        return this.belowTheLine;
    }

    public boolean isAboveTheLine() {
        return this.aboveTheLine;
    }

    public boolean isOnTheLine() {
        return this.onTheLine;
    }

    public boolean isPageOriented() {
        return this.pageOriented;
    }

    public void setOnTheLine(boolean b) {
        this.onTheLine = b;
    }

    public void setPageOriented(boolean b) {
        this.pageOriented = b;
    }

    public void setBelowTheLine(boolean b) {
        this.belowTheLine = b;
    }

    public void setAboveTheLine(boolean b) {
        this.aboveTheLine = b;
    }

    public boolean isAtTheEndOfLine() {
        return this.locationAlongLine == 13;
    }

    public boolean isAtTheBeginingOfLine() {
        return this.locationAlongLine == 15;
    }

    public boolean isInTheMiddleOfLine() {
        return this.locationAlongLine == 14;
    }

    public boolean isAtBestOfLine() {
        return this.locationAlongLine == 16;
    }

    public boolean isAroundThePoint() {
        return this.placementMode == 5;
    }

    public boolean isFitInsidePolygon() {
        return this.fitInsidePolygon;
    }

    public void setFitInsidePolygon(boolean b) {
        this.fitInsidePolygon = b;
    }

    public void setLocationAlongTheLine(int location) {
        if (location != 14 && location != 15 && location != 13 && location != 16) {
            throw new IllegalArgumentException("Only IPlacementConstraints.AT_THE_MIDDLE_OF_THE_LINE, IPlacementConstraints.AT_THE_BEGINING_OF_THE_LINE, or IPlacementConstraints.AT_THE_END_OF_THE_LINE, or IPlacementConstraints.AT_BEST_OF_LINE values are allowed");
        }
        this.locationAlongLine = location;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("duplicateLabelsMode", this.getDuplicateLabelsMode());
        state.set("placementMode", this.placementMode);
        state.set("locationAlongLine", this.locationAlongLine);
        state.set("belowTheLine", this.isBelowTheLine());
        state.set("aboveTheLine", this.isAboveTheLine());
        state.set("onTheLine", this.isOnTheLine());
        state.set("pageOriented", this.isPageOriented());
        state.set("fitInsidePolygon", this.isFitInsidePolygon());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDuplicateLabelsMode(state.getInt("duplicateLabelsMode"));
        this.setPlacementMode(state.getInt("placementMode"));
        this.locationAlongLine = state.getInt("locationAlongLine");
        this.setBelowTheLine(state.getBoolean("belowTheLine"));
        this.setAboveTheLine(state.getBoolean("aboveTheLine"));
        this.setOnTheLine(state.getBoolean("onTheLine"));
        this.setPageOriented(state.getBoolean("pageOriented"));
        this.setFitInsidePolygon(state.getBoolean("fitInsidePolygon"));
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PLACEMENT_CONSTRAINTS_PERSISTENCE_NAME) == null) {
            DynStruct definition = manager.addDefinition(AbstractPlacementConstraints.class, PLACEMENT_CONSTRAINTS_PERSISTENCE_NAME, "PLACEMENT_CONSTRAINTS_PERSISTENCE_NAME Persistence definition", null, null);
            definition.addDynFieldBoolean("belowTheLine").setMandatory(true);
            definition.addDynFieldBoolean("aboveTheLine").setMandatory(true);
            definition.addDynFieldBoolean("onTheLine").setMandatory(true);
            definition.addDynFieldBoolean("pageOriented").setMandatory(true);
            definition.addDynFieldBoolean("fitInsidePolygon").setMandatory(true);
            definition.addDynFieldInt("duplicateLabelsMode").setMandatory(true);
            definition.addDynFieldInt("placementMode").setMandatory(true);
            definition.addDynFieldInt("locationAlongLine").setMandatory(true);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            AbstractPlacementConstraints clone = (AbstractPlacementConstraints)this.getClass().newInstance();
            clone.aboveTheLine = this.aboveTheLine;
            clone.belowTheLine = this.belowTheLine;
            clone.duplicateLabelsMode = this.duplicateLabelsMode;
            clone.fitInsidePolygon = this.fitInsidePolygon;
            clone.locationAlongLine = this.locationAlongLine;
            clone.onTheLine = this.onTheLine;
            clone.pageOriented = this.pageOriented;
            clone.placementMode = this.placementMode;
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }
}

