/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.expressionevaluator.GeometryExpressionEvaluatorLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.util.Bitmask;
import org.gvsig.tools.util.PropertiesSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBuilderBase
implements SQLBuilder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SQLBuilderBase.class);
    protected SQLBuilder.SelectBuilder select;
    protected SQLBuilder.UpdateBuilder update;
    protected SQLBuilder.MergeBuilder merge;
    protected SQLBuilder.InsertBuilder insert;
    protected SQLBuilder.DeleteBuilder delete;
    protected SQLBuilder.AlterTableBuilder alter_table;
    protected SQLBuilder.CreateTableBuilder create_table;
    protected SQLBuilder.GrantBuilder grant;
    protected SQLBuilder.DropTableBuilder drop_table;
    protected SQLBuilder.UpdateTableStatisticsBuilder update_table_statistics;
    protected SQLBuilder.CreateIndexBuilder create_index;
    protected SQLBuilder.DropIndexBuilder drop_index;
    protected SQLBuilder.TableNameBuilder table_name;
    protected GeometryExpressionBuilder expressionBuilder;
    protected String defaultSchema;
    protected boolean supportSchemas;
    protected boolean hasSpatialFunctions;
    protected GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType;
    protected boolean allowAutomaticValues;
    private static Map<Pair<Integer, Integer>, String> sqlgeometrytypes = null;
    protected String constant_true = "(1=1)";
    protected String constant_false = "(1<>1)";
    protected String type_boolean = "BOOLEAN";
    protected String type_byte = "TINYINT";
    protected String type_bytearray = "BYTEA";
    protected String type_geometry = "TEXT";
    protected String type_char = "CHARACTER(1)";
    protected String type_date = "DATE";
    protected String type_double = "DOUBLE PRECISION";
    protected String type_decimal_ps = "NUMERIC({0,Number,##########},{1,Number,##########})";
    protected String type_decimal_p = "NUMERIC({0,Number,##########})";
    protected String type_float = "REAL";
    protected String type_int = "INT";
    protected String type_long = "BIGINT";
    protected String type_string = "TEXT";
    protected String type_string_0 = "VARCHAR";
    protected String type_string_p = "VARCHAR({0,Number,#######})";
    protected String type_time = "TIME";
    protected String type_timestamp = "TIMESTAMP";
    protected String type_version = "VARCHAR(30)";
    protected String type_URI = "TEXT";
    protected String type_URL = "TEXT";
    protected String type_FILE = "TEXT";
    protected String type_FOLDER = "TEXT";
    protected String STMT_DELETE_FROM_table_WHERE_expresion = "DELETE FROM {0} WHERE {1}";
    protected String STMT_DELETE_FROM_table = "DELETE FROM {0}";
    protected String STMT_INSERT_INTO_table_columns_VALUES_values = "INSERT INTO {0} ( {1} ) VALUES ( {2} )";
    protected String STMT_MERGE_INTO_table_KEY_column_columns_VALUES_values = "MERGE INTO {0} ( {1} )  KEY( {2} ) VALUES ( {3} )";
    protected String STMT_UPDATE_TABLE_STATISTICS_table = "VACUUM ANALYZE {0}";
    protected String STMT_DROP_TABLE_table = "DROP TABLE {0}";
    protected String STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_schema = {0} AND f_table_name = {1}";
    protected String STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_name = {0}";
    protected String STMT_UPDATE_table_SET_columnsAndValues_WHERE_expresion = "UPDATE {0} SET {1} WHERE {2}";
    protected String STMT_UPDATE_table_SET_columnsAndValues = "UPDATE {0} SET {1}";
    protected String STMT_GRANT_privileges_ON_table_TO_role = "GRANT {0} ON {1} TO {2}";
    protected String[] aggregateFunctionNames = new String[]{"MAX", "MIN", "COUNT", "SUM"};

    public SQLBuilderBase() {
        this.expressionBuilder = GeometryExpressionEvaluatorLocator.getManager().createExpressionBuilder();
        this.expressionBuilder.setProperty("SQLBUILDER", (Object)this);
        this.hasSpatialFunctions = false;
        this.supportSchemas = true;
        this.geometrySupportType = GeometryExpressionBuilderHelper.GeometrySupportType.WKT;
        this.defaultSchema = "public";
        this.allowAutomaticValues = true;
    }

    public void setProperties(Class filter, Object ... values) {
        this.expressionBuilder.setProperties(filter, values);
        this.setProperties((ExpressionBuilder.Visitable)this, filter, values);
    }

    public void setProperties(ExpressionBuilder.Visitable visitable, Class filter, Object ... values) {
        if (visitable == null) {
            return;
        }
        if (visitable instanceof PropertiesSupport) {
            for (int i = 0; i < values.length; i += 2) {
                ((PropertiesSupport)visitable).setProperty((String)values[i], values[i + 1]);
            }
        }
        visitable.accept(v -> {
            if (v instanceof PropertiesSupport) {
                for (int i = 0; i < values.length; i += 2) {
                    ((PropertiesSupport)v).setProperty((String)values[i], values[i + 1]);
                }
            }
        }, (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(filter));
    }

    public String quote_for_identifiers() {
        return "\"";
    }

    public String quote_for_strings() {
        return "'";
    }

    public String as_identifier(String id) {
        String quote = this.quote_for_identifiers();
        if (id.startsWith(quote)) {
            return id;
        }
        return quote + id + quote;
    }

    public String as_clob(String s) {
        int chunkSize = 1024;
        StringBuilder builder = new StringBuilder();
        builder.append("(CAST('");
        for (int i = 0; i < s.length(); i += chunkSize) {
            String chunk = s.substring(i, Math.min(s.length(), i + chunkSize));
            if (i > 0) {
                builder.append("' AS NCLOB) || CAST('");
            }
            builder.append(StringUtils.replace((String)chunk, (String)"'", (String)"''"));
        }
        builder.append("' AS NCLOB))");
        return builder.toString();
    }

    public String as_string(String s) {
        String quote = this.quote_for_strings();
        if (s.startsWith(quote)) {
            return s;
        }
        return quote + s + quote;
    }

    public String as_string(byte[] data) {
        return this.expressionBuilder.bytearray_0x(data);
    }

    public String as_string(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public String as_string(Number value) {
        return Objects.toString(value);
    }

    public String as_string(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof CharSequence) {
            return this.as_string(value.toString());
        }
        if (value instanceof Number) {
            return this.as_string((Number)value);
        }
        if (value instanceof Boolean) {
            return this.as_string((Boolean)value);
        }
        if (value instanceof byte[]) {
            return this.as_string((byte[])value);
        }
        throw new IllegalArgumentException("Can't support type of value '" + value.getClass().getName() + "'.");
    }

    public GeometryExpressionBuilder expression() {
        return this.expressionBuilder;
    }

    public boolean has_spatial_functions() {
        return this.hasSpatialFunctions;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType geometry_support_type() {
        return this.geometrySupportType;
    }

    protected GeometryExpressionBuilder createExpressionBuilder() {
        return GeometryExpressionEvaluatorLocator.getManager().createExpressionBuilder();
    }

    public Object srs_id(IProjection projection) {
        String abrev = projection.getAbrev();
        return abrev.split(":")[1].trim();
    }

    public String default_schema() {
        return this.defaultSchema;
    }

    public boolean support_schemas() {
        return this.supportSchemas;
    }

    public String sqltype(int type, int size, int precision, int scale, int geomType, int geomSubtype) {
        switch (type) {
            case 1: {
                return this.type_boolean;
            }
            case 3: {
                return this.type_char;
            }
            case 2: {
                return this.type_byte;
            }
            case 4: {
                return this.type_int;
            }
            case 5: {
                return this.type_long;
            }
            case 6: {
                return this.type_float;
            }
            case 7: {
                return this.type_double;
            }
            case 19: {
                if (precision < 1) {
                    precision = 20;
                }
                if (scale < 1) {
                    return MessageFormat.format(this.type_decimal_p, precision);
                }
                return MessageFormat.format(this.type_decimal_ps, precision, scale);
            }
            case 8: {
                if (size < 0) {
                    return this.type_string;
                }
                if (size == 0) {
                    return this.type_string_0;
                }
                if (size < 4096) {
                    return MessageFormat.format(this.type_string_p, size);
                }
                return this.type_string;
            }
            case 9: {
                return this.type_date;
            }
            case 10: {
                return this.type_time;
            }
            case 11: {
                return this.type_timestamp;
            }
            case 12: {
                return this.type_bytearray;
            }
            case 66: {
                return this.type_geometry;
            }
            case 18: {
                return this.type_version;
            }
            case 17: {
                return this.type_URI;
            }
            case 16: {
                return this.type_URL;
            }
            case 13: {
                return this.type_FILE;
            }
            case 14: {
                return this.type_FOLDER;
            }
        }
        return null;
    }

    public Object sqlgeometrytype(int type, int subtype) {
        if (sqlgeometrytypes == null) {
            sqlgeometrytypes = new HashMap<Pair<Integer, Integer>, String>();
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)1, (Object)0), "POINT");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)1, (Object)1), "POINTZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)1, (Object)2), "POINTM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)1, (Object)3), "POINTZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)18, (Object)0), "LINESTRING");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)18, (Object)1), "LINESTRINGZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)18, (Object)2), "LINESTRINGM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)18, (Object)3), "LINESTRINGZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)19, (Object)0), "POLYGON");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)19, (Object)1), "POLYGONZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)19, (Object)2), "POLYGONM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)19, (Object)3), "POLYGONZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)7, (Object)0), "MULTIPOINT");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)7, (Object)1), "MULTIPOINTZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)7, (Object)2), "MULTIPOINTM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)7, (Object)3), "MULTIPOINTZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)21, (Object)0), "MULTILINESTRING");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)21, (Object)1), "MULTILINESTRINGZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)21, (Object)2), "MULTILINESTRINGM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)21, (Object)3), "MULTILINESTRINGZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)8, (Object)0), "MULTILINESTRING");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)8, (Object)1), "MULTILINESTRINGZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)8, (Object)2), "MULTILINESTRINGM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)8, (Object)3), "MULTILINESTRINGZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)22, (Object)0), "MULTIPOLYGON");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)22, (Object)1), "MULTIPOLYGONZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)22, (Object)2), "MULTIPOLYGONM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)22, (Object)3), "MULTIPOLYGONZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)9, (Object)0), "MULTIPOLYGON");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)9, (Object)1), "MULTIPOLYGONZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)9, (Object)2), "MULTIPOLYGONM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)9, (Object)3), "MULTIPOLYGONZM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)0, (Object)0), "GEOMETRY");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)0, (Object)1), "GEOMETRYZ");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)0, (Object)2), "GEOMETRYM");
            sqlgeometrytypes.put((Pair<Integer, Integer>)new ImmutablePair((Object)0, (Object)3), "GEOMETRYZM");
        }
        return sqlgeometrytypes.get(new ImmutablePair((Object)type, (Object)subtype));
    }

    public Object sqlgeometrydimension(int type, int subtype) {
        switch (subtype) {
            case 1: {
                return 3;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 2;
    }

    public SQLBuilder.SelectColumnBuilder column() {
        return this.createSelectColumnBuilder();
    }

    public SQLBuilder.TableNameBuilder createTableNameBuilder() {
        return new TableNameBuilderBase();
    }

    protected SQLBuilder.SelectColumnBuilder createSelectColumnBuilder() {
        return new SelectColumnBuilderBase(this);
    }

    protected SQLBuilder.UpdateColumnBuilder createUpdateColumnBuilder() {
        return new UpdateColumnBuilderBase();
    }

    protected SQLBuilder.InsertColumnBuilder createInsertColumnBuilder() {
        return new InsertColumnBuilderBase();
    }

    protected SQLBuilder.OrderByBuilder createOrderByBuilder() {
        return new OrderByBuilderBase();
    }

    protected SQLBuilder.FromBuilder createFromBuilder() {
        return new FromBuilderBase();
    }

    public SQLBuilder.SelectBuilder createSelectBuilder() {
        return new SelectBuilderBase();
    }

    protected SQLBuilder.UpdateBuilder createUpdateBuilder() {
        return new UpdateBuilderBase();
    }

    protected SQLBuilder.DeleteBuilder createDeleteBuilder() {
        return new DeleteBuilderBase();
    }

    protected SQLBuilder.GrantBuilder createGrantBuilder() {
        return new GrantBuilderBase();
    }

    protected SQLBuilder.GrantRoleBuilder createGrantRoleBuilder(SQLBuilder.TableNameBuilder table, String role) {
        return new GrantRoleBuilderBase(table, role);
    }

    protected SQLBuilder.DropTableBuilder createDropTableBuilder() {
        return new DropTableBuilderBase();
    }

    protected SQLBuilder.CreateTableBuilder createCreateTableBuilder() {
        return new CreateTableBuilderBase();
    }

    protected SQLBuilder.AlterTableBuilder createAlterTableBuilder() {
        return new AlterTableBuilderBase(this);
    }

    protected SQLBuilder.InsertBuilder createInsertBuilder() {
        return new InsertBuilderBase();
    }

    protected SQLBuilder.MergeBuilder createMergeBuilder() {
        return new MergeBuilderBase();
    }

    protected SQLBuilder.UpdateTableStatisticsBuilder createUpdateTableStatisticsBuilder() {
        return new UpdateTableStatisticsBuilderBase();
    }

    public SQLBuilder.CreateIndexBuilder createCreateIndexBuilder() {
        return new CreateIndexBuilderBase();
    }

    public SQLBuilder.DropIndexBuilder createDropIndexBuilder() {
        return new DropIndexBuilderBase();
    }

    public SQLBuilder.SelectBuilder select() {
        if (this.select == null) {
            this.select = this.createSelectBuilder();
        }
        return this.select;
    }

    public SQLBuilder.UpdateBuilder update() {
        if (this.update == null) {
            this.update = this.createUpdateBuilder();
        }
        return this.update;
    }

    public SQLBuilder.UpdateTableStatisticsBuilder update_table_statistics() {
        if (this.update_table_statistics == null) {
            this.update_table_statistics = this.createUpdateTableStatisticsBuilder();
        }
        return this.update_table_statistics;
    }

    public SQLBuilder.DropTableBuilder drop_table() {
        if (this.drop_table == null) {
            this.drop_table = this.createDropTableBuilder();
        }
        return this.drop_table;
    }

    public SQLBuilder.CreateIndexBuilder create_index() {
        if (this.create_index == null) {
            this.create_index = this.createCreateIndexBuilder();
        }
        return this.create_index;
    }

    public SQLBuilder.DropIndexBuilder drop_index() {
        if (this.drop_index == null) {
            this.drop_index = this.createDropIndexBuilder();
        }
        return this.drop_index;
    }

    public SQLBuilder.DeleteBuilder delete() {
        if (this.delete == null) {
            this.delete = this.createDeleteBuilder();
        }
        return this.delete;
    }

    public SQLBuilder.InsertBuilder insert() {
        if (this.insert == null) {
            this.insert = this.createInsertBuilder();
        }
        return this.insert;
    }

    public SQLBuilder.MergeBuilder merge() {
        if (this.merge == null) {
            this.merge = this.createMergeBuilder();
        }
        return this.merge;
    }

    public SQLBuilder.TableNameBuilder table_name() {
        if (this.table_name == null) {
            this.table_name = this.createTableNameBuilder();
        }
        return this.table_name;
    }

    public SQLBuilder.AlterTableBuilder alter_table() {
        if (this.alter_table == null) {
            this.alter_table = this.createAlterTableBuilder();
        }
        return this.alter_table;
    }

    public SQLBuilder.CreateTableBuilder create_table() {
        if (this.create_table == null) {
            this.create_table = this.createCreateTableBuilder();
        }
        return this.create_table;
    }

    public SQLBuilder.GrantBuilder grant() {
        if (this.grant == null) {
            this.grant = this.createGrantBuilder();
        }
        return this.grant;
    }

    public SQLBuilder.Column column(String name) {
        ColumnBase col = new ColumnBase(null, name);
        return col;
    }

    public SQLBuilder.Column column(SQLBuilder.TableNameBuilder table, String name) {
        ColumnBase col = new ColumnBase(table, name);
        return col;
    }

    public SQLBuilder.Column column_from(ExpressionBuilder.Variable variable) {
        SQLBuilder.Column c = null;
        c = variable instanceof SQLBuilder.Column ? this.column(((SQLBuilder.Column)variable).table(), variable.name()) : this.column(variable.name());
        c.copyPropertiesFrom((PropertiesSupport)variable);
        return c;
    }

    public SQLBuilder.Column column_from(SQLBuilder.TableNameBuilder table, ExpressionBuilder.Variable variable) {
        SQLBuilder.Column c = this.column(table, variable.name());
        c.copyPropertiesFrom((PropertiesSupport)variable);
        return c;
    }

    protected JoinBase createJoin(String type, SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value expression) {
        return new JoinBase(type, table, expression);
    }

    public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
        if (this.select != null) {
            this.select.accept(visitor, filter);
        }
        if (this.update != null) {
            this.update.accept(visitor, filter);
        }
        if (this.insert != null) {
            this.insert.accept(visitor, filter);
        }
        if (this.merge != null) {
            this.merge.accept(visitor, filter);
        }
        if (this.delete != null) {
            this.delete.accept(visitor, filter);
        }
        if (this.alter_table != null) {
            this.alter_table.accept(visitor, filter);
        }
        if (this.create_table != null) {
            this.create_table.accept(visitor, filter);
        }
        if (this.drop_table != null) {
            this.drop_table.accept(visitor, filter);
        }
        if (this.table_name != null) {
            this.table_name.accept(visitor, filter);
        }
    }

    public Formatter formatter() {
        return this.expression().formatter();
    }

    public String toString() {
        return this.toString(this.formatter());
    }

    public String toString(Formatter formatter) {
        if (this.select != null) {
            return this.select.toString(formatter);
        }
        if (this.update != null) {
            return this.update.toString(formatter);
        }
        if (this.insert != null) {
            return this.insert.toString(formatter);
        }
        if (this.merge != null) {
            return this.merge.toString(formatter);
        }
        if (this.delete != null) {
            return this.delete.toString(formatter);
        }
        if (this.alter_table != null) {
            return this.alter_table.toString(formatter);
        }
        if (this.create_table != null) {
            return this.create_table.toString(formatter);
        }
        if (this.drop_table != null) {
            return this.drop_table.toString(formatter);
        }
        if (this.update_table_statistics != null) {
            return this.update_table_statistics.toString(formatter);
        }
        if (this.create_index != null) {
            return this.create_index.toString(formatter);
        }
        if (this.drop_index != null) {
            return this.drop_index.toString(formatter);
        }
        if (this.table_name != null) {
            return this.table_name.toString(formatter);
        }
        return "";
    }

    public SQLBuilder.CountBuilder count() {
        return new CountBuilderBase();
    }

    public List<ExpressionBuilder.Parameter> parameters() {
        ArrayList<ExpressionBuilder.Parameter> params = new ArrayList<ExpressionBuilder.Parameter>();
        this.accept(value -> params.add((ExpressionBuilder.Parameter)value), (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(ExpressionBuilder.Parameter.class));
        return params;
    }

    public List<ExpressionBuilder.Variable> variables() {
        final ArrayList<ExpressionBuilder.Variable> vars = new ArrayList<ExpressionBuilder.Variable>();
        this.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value) {
                if (!vars.contains((ExpressionBuilder.Variable)value)) {
                    vars.add((ExpressionBuilder.Variable)value);
                }
            }
        }, (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(ExpressionBuilder.Variable.class));
        return vars;
    }

    public List<String> parameters_names() {
        ArrayList<String> params = new ArrayList<String>();
        for (ExpressionBuilder.Parameter param : this.parameters()) {
            String s;
            switch (param.type()) {
                case 0: {
                    Object theValue = param.value();
                    if (theValue == null) {
                        s = "null";
                        break;
                    }
                    if (theValue instanceof String) {
                        s = "'" + (String)theValue + "'";
                        break;
                    }
                    s = theValue.toString();
                    break;
                }
                default: {
                    s = "\"" + param.name() + "\"";
                }
            }
            params.add(s);
        }
        return params;
    }

    public List<String> variables_names() {
        ArrayList<String> vars = new ArrayList<String>();
        for (ExpressionBuilder.Variable var : this.variables()) {
            vars.add(var.name());
        }
        Collections.sort(vars);
        return vars;
    }

    public boolean isAggregateFunction(String funcname) {
        for (String aggregateFunctionName : this.aggregateFunctionNames) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)aggregateFunctionName, (CharSequence)funcname)) continue;
            return true;
        }
        return false;
    }

    public int getMaxRecomendedSQLLength() {
        return 2048;
    }

    public String getConstrainName(SQLBuilder.TableNameBuilder table, String columnName, String constrainType) {
        String constraint_name = table.getName() + "_" + constrainType + "_" + columnName;
        return constraint_name;
    }

    public class UpdateTableStatisticsBuilderBase
    extends AbstractStatement
    implements SQLBuilder.UpdateTableStatisticsBuilder {
        protected SQLBuilder.TableNameBuilder table;

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.table != null) {
                this.table.accept(visitor, filter);
            }
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            String sql;
            ArrayList<String> sqls = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)SQLBuilderBase.this.STMT_UPDATE_TABLE_STATISTICS_table) && !StringUtils.isEmpty((CharSequence)(sql = MessageFormat.format(SQLBuilderBase.this.STMT_UPDATE_TABLE_STATISTICS_table, this.table.toString(formatter))))) {
                sqls.add(sql);
            }
            return sqls;
        }
    }

    public class InsertBuilderBase
    extends AbstractStatement
    implements SQLBuilder.InsertBuilder {
        protected List<SQLBuilder.InsertColumnBuilder> columns;
        protected SQLBuilder.TableNameBuilder table;

        public InsertBuilderBase() {
            this.columns = new ArrayList<SQLBuilder.InsertColumnBuilder>();
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.table != null) {
                    this.table.accept(visitor, filter);
                }
                for (SQLBuilder.InsertColumnBuilder column : this.columns) {
                    column.accept(visitor, filter);
                }
            }
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public SQLBuilder.InsertColumnBuilder column() {
            SQLBuilder.InsertColumnBuilder column = SQLBuilderBase.this.createInsertColumnBuilder();
            this.columns.add(column);
            return column;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builderColumns = new StringBuilder();
            StringBuilder builderValues = new StringBuilder();
            boolean first = true;
            for (SQLBuilder.InsertColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builderColumns.append(", ");
                }
                builderColumns.append(SQLBuilderBase.this.as_identifier(column.getName()));
            }
            first = true;
            for (SQLBuilder.InsertColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builderValues.append(", ");
                }
                builderValues.append(column.toString(formatter));
            }
            String sql = MessageFormat.format(SQLBuilderBase.this.STMT_INSERT_INTO_table_columns_VALUES_values, this.table.toString(formatter), builderColumns.toString(), builderValues.toString());
            return sql;
        }
    }

    public class MergeBuilderBase
    extends InsertBuilderBase
    implements SQLBuilder.MergeBuilder {
        protected List<String> keycolumns = new ArrayList<String>();

        public SQLBuilder.MergeBuilder key(String id) {
            this.keycolumns.add(id);
            return this;
        }

        @Override
        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builderKeyColumns = new StringBuilder();
            StringBuilder builderColumns = new StringBuilder();
            StringBuilder builderValues = new StringBuilder();
            boolean first = true;
            for (SQLBuilder.InsertColumnBuilder insertColumnBuilder : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builderColumns.append(", ");
                }
                builderColumns.append(SQLBuilderBase.this.as_identifier(insertColumnBuilder.getName()));
            }
            first = true;
            for (String string : this.keycolumns) {
                if (first) {
                    first = false;
                } else {
                    builderKeyColumns.append(", ");
                }
                builderKeyColumns.append(SQLBuilderBase.this.as_identifier(string));
            }
            first = true;
            for (SQLBuilder.InsertColumnBuilder insertColumnBuilder : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builderValues.append(", ");
                }
                builderValues.append(insertColumnBuilder.toString(formatter));
            }
            String sql = MessageFormat.format(SQLBuilderBase.this.STMT_MERGE_INTO_table_KEY_column_columns_VALUES_values, this.table.toString(formatter), builderColumns.toString(), builderKeyColumns.toString(), builderValues.toString());
            return sql;
        }
    }

    public class InsertColumnBuilderBase
    extends AbstractStatement
    implements SQLBuilder.InsertColumnBuilder {
        protected ExpressionBuilder.Variable name;
        protected ExpressionBuilder.Value value;

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.name != null) {
                    this.name.accept(visitor, filter);
                }
                if (this.value != null) {
                    this.value.accept(visitor, filter);
                }
            }
        }

        public SQLBuilder.InsertColumnBuilder name(String name) {
            this.name = SQLBuilderBase.this.expression().variable(name);
            return this;
        }

        public SQLBuilder.InsertColumnBuilder with_value(ExpressionBuilder.Value value) {
            this.value = value;
            return this;
        }

        public String getName() {
            return this.name.name();
        }

        public ExpressionBuilder.Value getValue() {
            return this.value;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            return this.value.toString(formatter);
        }
    }

    public class CreateTableBuilderBase
    extends AbstractStatement
    implements SQLBuilder.CreateTableBuilder {
        protected SQLBuilder.TableNameBuilder table;
        protected List<SQLBuilder.ColumnDescriptor> columns;

        public CreateTableBuilderBase() {
            this.columns = new ArrayList<SQLBuilder.ColumnDescriptor>();
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.table != null) {
                this.table.accept(visitor, filter);
            }
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public CreateTableBuilderBase add_column(FeatureAttributeDescriptor fad) {
            this.columns.add(new ColumnDescriptorBase(fad));
            return this;
        }

        public CreateTableBuilderBase add_column(String columnName, int type, int size, int precision, int scale, boolean isPk, boolean isIndexed, boolean allowNulls, boolean isAutomatic, Object defaultValue) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            if (isPk || isAutomatic) {
                allowNulls = false;
            }
            this.columns.add(new ColumnDescriptorBase(columnName, type, size, precision, scale, isPk, isIndexed, allowNulls, isAutomatic, defaultValue));
            return this;
        }

        public SQLBuilder.CreateTableBuilder add_geometry_column(String columnName, int type, int subtype, IProjection proj, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            this.columns.add(new ColumnDescriptorBase(columnName, type, subtype, proj, isIndexed, allowNulls));
            return this;
        }

        public SQLBuilder.CreateTableBuilder add_geometry_column(String columnName, int type, int subtype, Object srsdbcode, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            this.columns.add(new ColumnDescriptorBase(columnName, type, subtype, srsdbcode, isIndexed, allowNulls));
            return this;
        }

        public SQLBuilder.ColumnDescriptor getColumnDescriptor(String columnName) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                return null;
            }
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (!columnName.equals(column.getName())) continue;
                return column;
            }
            return null;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" (");
            boolean first = true;
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
                builder.append(" ");
                if (column.isAutomatic() && column.getType() == 4) {
                    builder.append("SERIAL");
                } else if (column.isAutomatic() && column.getType() == 5) {
                    builder.append("BIGSERIAL");
                } else {
                    builder.append(SQLBuilderBase.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                }
                if (column.getDefaultValue() == null) {
                    if (column.allowNulls()) {
                        builder.append(" DEFAULT NULL");
                    }
                } else {
                    builder.append(" DEFAULT '");
                    builder.append(Objects.toString(column.getDefaultValue(), ""));
                    builder.append("'");
                }
                if (column.isPrimaryKey()) {
                    builder.append(" NOT NULL");
                    builder.append(" PRIMARY KEY");
                } else if (column.allowNulls()) {
                    builder.append(" NULL");
                } else {
                    builder.append(" NOT NULL");
                }
                if (StringUtils.isNotBlank((CharSequence)column.getForeignkeyTableName())) {
                    if (column.isCategorized()) {
                        builder.append(" /* DICCIONARIO: ");
                        builder.append(SQLBuilderBase.this.expression().identifier(column.getForeignkeyTableName()));
                        builder.append(" */");
                    } else {
                        builder.append(" /* ENTIDAD: ");
                        builder.append(SQLBuilderBase.this.expression().identifier(column.getForeignkeyTableName()));
                        builder.append(" */");
                    }
                }
                if (!column.isForeignKey()) continue;
                builder.append(", ");
                builder.append("FOREIGN KEY (");
                builder.append(column.getName());
                builder.append(") REFERENCES ");
                builder.append(SQLBuilderBase.this.expression().identifier(column.getForeignkeyTableName()));
                builder.append("(");
                builder.append(SQLBuilderBase.this.expression().identifier(column.getForeignkeyFieldName()));
                builder.append(")");
            }
            builder.append(" )");
            sqls.add(builder.toString());
            return sqls;
        }
    }

    public class AlterTableBuilderBase
    extends AbstractStatement
    implements SQLBuilder.AlterTableBuilder {
        protected SQLBuilder.TableNameBuilder table;
        protected List<String> drops;
        protected List<SQLBuilder.ColumnDescriptor> adds;
        @Deprecated
        protected List<SQLBuilder.ColumnDescriptor> alters;
        protected List<Pair<Bitmask, SQLBuilder.ColumnDescriptor>> operations;
        protected List<Pair<String, String>> renames;
        protected String drop_primary_key_column;
        protected final SQLBuilderBase sqlbuilder;

        public AlterTableBuilderBase(SQLBuilderBase sqlbuilder) {
            this.sqlbuilder = sqlbuilder;
            this.drops = new ArrayList<String>();
            this.adds = new ArrayList<SQLBuilder.ColumnDescriptor>();
            this.alters = new ArrayList<SQLBuilder.ColumnDescriptor>();
            this.operations = new ArrayList<Pair<Bitmask, SQLBuilder.ColumnDescriptor>>();
            this.renames = new ArrayList<Pair<String, String>>();
        }

        public List<Pair<Bitmask, SQLBuilder.ColumnDescriptor>> getOperations() {
            return this.operations;
        }

        public boolean isEmpty() {
            return this.drops.isEmpty() && this.adds.isEmpty() && this.alters.isEmpty() && this.operations.isEmpty() && this.renames.isEmpty();
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.table != null) {
                this.table.accept(visitor, filter);
            }
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public SQLBuilder.AlterTableBuilder drop_column(String columnName) {
            this.drops.add(columnName);
            return this;
        }

        public SQLBuilder.AlterTableBuilder drop_primary_key(String columnName) {
            this.drop_primary_key_column = columnName;
            return this;
        }

        public SQLBuilder.AlterTableBuilder add_column(FeatureAttributeDescriptor fad) {
            this.adds.add(new ColumnDescriptorBase(fad));
            return this;
        }

        public SQLBuilder.AlterTableBuilder add_column(String columnName, int type, int size, int precision, int scale, boolean isPk, boolean isIndexed, boolean allowNulls, boolean isAutomatic, Object defaultValue, boolean allowIndexDuplicateds) {
            if (isPk || isAutomatic) {
                allowNulls = false;
            }
            this.adds.add(new ColumnDescriptorBase(columnName, type, size, precision, scale, isPk, isIndexed, allowNulls, isAutomatic, defaultValue, allowIndexDuplicateds));
            return this;
        }

        public SQLBuilder.AlterTableBuilder add_geometry_column(String columnName, int type, int subtype, IProjection proj, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            this.adds.add(new ColumnDescriptorBase(columnName, type, subtype, proj, isIndexed, allowNulls));
            return this;
        }

        public SQLBuilder.AlterTableBuilder add_geometry_column(String columnName, int type, int subtype, Object srsdbcode, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            this.adds.add(new ColumnDescriptorBase(columnName, type, subtype, srsdbcode, isIndexed, allowNulls));
            return this;
        }

        protected void update_or_add_alters(ColumnDescriptorBase column) {
            int i;
            for (i = 0; i < this.alters.size(); ++i) {
                SQLBuilder.ColumnDescriptor prevColumn = this.alters.get(i);
                if (!prevColumn.getName().equalsIgnoreCase(column.getName())) continue;
                this.alters.set(i, column);
                break;
            }
            if (i >= this.alters.size()) {
                this.alters.add(column);
            }
        }

        public SQLBuilder.AlterTableBuilder alter_column(Bitmask operation, FeatureAttributeDescriptor fad) {
            ColumnDescriptorBase column = new ColumnDescriptorBase(fad);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
            }
            if (operation.isEmpty()) {
                operation.setBit(1);
            }
            this.operations.add((Pair<Bitmask, SQLBuilder.ColumnDescriptor>)new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public SQLBuilder.AlterTableBuilder alter_column(Bitmask operation, String columnName, int type, int size, int precision, int scale, boolean isPk, boolean isIndexed, boolean allowNulls, boolean isAutomatic, Object defaultValue, boolean allowIndexDuplicateds) {
            if ((isPk || isAutomatic) && allowNulls) {
                allowNulls = false;
                operation.setBit(4);
            }
            ColumnDescriptorBase column = new ColumnDescriptorBase(columnName, type, size, precision, scale, isPk, isIndexed, allowNulls, isAutomatic, defaultValue, allowIndexDuplicateds);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
            }
            if (operation.isEmpty()) {
                operation.setBit(1);
            }
            this.operations.add((Pair<Bitmask, SQLBuilder.ColumnDescriptor>)new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public SQLBuilder.AlterTableBuilder alter_geometry_column(Bitmask operation, String columnName, int type, int subtype, IProjection proj, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            ColumnDescriptorBase column = new ColumnDescriptorBase(columnName, type, subtype, proj, isIndexed, allowNulls);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
            }
            if (operation.isEmpty()) {
                operation.setBit(1);
            }
            operation.setBit(2);
            this.operations.add((Pair<Bitmask, SQLBuilder.ColumnDescriptor>)new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public SQLBuilder.AlterTableBuilder alter_geometry_column(Bitmask operation, String columnName, int type, int subtype, Object srsdbcode, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            ColumnDescriptorBase column = new ColumnDescriptorBase(columnName, type, subtype, srsdbcode, isIndexed, allowNulls);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
            }
            operation.setBit(2);
            this.operations.add((Pair<Bitmask, SQLBuilder.ColumnDescriptor>)new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public SQLBuilder.AlterTableBuilder rename_column(String source, String target) {
            this.renames.add((Pair<String, String>)new ImmutablePair((Object)source, (Object)target));
            return this;
        }

        protected String getConstrainName(String constrainType, String columnName) {
            return this.sqlbuilder.getConstrainName(this.table, columnName, constrainType);
        }

        protected List<String> alter_table_add_primarykey_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ADD CONSTRAINT ");
            builder.append("IF NOT EXISTS ");
            builder.append(SQLBuilderBase.this.as_identifier(this.getConstrainName("PK", column.getName())));
            builder.append(" PRIMARY KEY( ");
            builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
            builder.append(" )");
            sqls.add(builder.toString());
            return sqls;
        }

        protected List<String> alter_table_drop_primarykey_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" DROP CONSTRAINT ");
            builder.append("IF EXISTS ");
            builder.append(SQLBuilderBase.this.as_identifier(this.getConstrainName("PK", column.getName())));
            return Collections.singletonList(builder.toString());
        }

        protected List<String> create_index_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            SQLBuilder.CreateIndexBuilder createIndex = this.sqlbuilder.createCreateIndexBuilder();
            if (column.isGeometry()) {
                createIndex.spatial();
            }
            createIndex.if_not_exist();
            createIndex.name(SQLBuilderBase.this.as_identifier(this.getConstrainName("IDX", column.getName())));
            createIndex.column(column.getName());
            createIndex.table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getName());
            if (!column.allowIndexDuplicateds()) {
                createIndex.unique();
            }
            return createIndex.toStrings();
        }

        protected List<String> drop_index_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            SQLBuilder.DropIndexBuilder dropIndex = this.sqlbuilder.createDropIndexBuilder();
            dropIndex.if_exist();
            dropIndex.name(SQLBuilderBase.this.as_identifier(this.getConstrainName("IDX", column.getName())));
            return dropIndex.toStrings();
        }

        protected List<String> alter_table_alter_column_set_data_type_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ALTER COLUMN ");
            builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
            builder.append(" SET DATA TYPE ");
            if (column.getType() == 4 && column.isAutomatic()) {
                builder.append(" SERIAL");
            } else {
                builder.append(SQLBuilderBase.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
            }
            return Collections.singletonList(builder.toString());
        }

        protected List<String> alter_table_alter_column_set_default_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ALTER COLUMN ");
            builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
            if (column.getDefaultValue() == null) {
                if (column.allowNulls()) {
                    builder.append(" SET DEFAULT NULL");
                } else {
                    builder.append(" DROP DEFAULT");
                }
            } else {
                builder.append(" SET DEFAULT '");
                builder.append(column.getDefaultValue().toString());
                builder.append("'");
            }
            return Collections.singletonList(builder.toString());
        }

        protected List<String> alter_table_alter_column_set_null_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ALTER COLUMN ");
            builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
            if (column.allowNulls()) {
                builder.append(" SET NULL");
            } else {
                builder.append(" SET NOT NULL");
            }
            return Collections.singletonList(builder.toString());
        }

        protected List<String> alter_table_drop_column_sqls(Formatter<ExpressionBuilder.Value> formatter, String columnName) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" DROP COLUMN ");
            builder.append(" IF EXISTS ");
            builder.append(SQLBuilderBase.this.as_identifier(columnName));
            return Collections.singletonList(builder.toString());
        }

        protected List<String> alter_table_add_column_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ADD COLUMN ");
            builder.append(SQLBuilderBase.this.as_identifier(column.getName()));
            builder.append(" ");
            if (column.getType() == 4 && column.isAutomatic()) {
                builder.append(" SERIAL");
            } else {
                builder.append(SQLBuilderBase.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
            }
            if (column.getDefaultValue() == null) {
                if (column.allowNulls()) {
                    builder.append(" DEFAULT NULL");
                }
            } else {
                builder.append(" DEFAULT '");
                builder.append(Objects.toString(column.getDefaultValue(), ""));
                builder.append("'");
            }
            if (column.allowNulls()) {
                builder.append(" NULL");
            } else {
                builder.append(" NOT NULL");
            }
            if (column.isPrimaryKey()) {
                builder.append(" PRIMARY KEY");
            }
            sqls.add(builder.toString());
            if (column.isGeometry()) {
                sqls.addAll(this.alter_column_add_geometry_constraint_sqls(formatter, column));
            }
            if (column.isIndexed()) {
                sqls.addAll(this.create_index_sqls(formatter, column));
            }
            return sqls;
        }

        protected List<String> alter_table_alter_column_rename_sqls(Formatter<ExpressionBuilder.Value> formatter, String oldName, String newName) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ALTER COLUMN ");
            builder.append(SQLBuilderBase.this.as_identifier(oldName));
            builder.append(" RENAME TO ");
            builder.append(SQLBuilderBase.this.as_identifier(newName));
            return Collections.singletonList(builder.toString());
        }

        protected List<String> alter_column_add_geometry_constraint_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            return Collections.EMPTY_LIST;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.isEmpty()) {
                return sqls;
            }
            for (String string : this.drops) {
                sqls.addAll(this.alter_table_drop_column_sqls((Formatter<ExpressionBuilder.Value>)formatter, string));
            }
            for (SQLBuilder.ColumnDescriptor columnDescriptor : this.adds) {
                sqls.addAll(this.alter_table_add_column_sqls((Formatter<ExpressionBuilder.Value>)formatter, columnDescriptor));
            }
            for (Pair pair : this.getOperations()) {
                Bitmask operation = (Bitmask)pair.getLeft();
                SQLBuilder.ColumnDescriptor column = (SQLBuilder.ColumnDescriptor)pair.getRight();
                if (operation.isSetBit(1)) {
                    if (column.isPrimaryKey()) {
                        sqls.addAll(this.alter_table_add_primarykey_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                    } else {
                        sqls.addAll(this.alter_table_drop_primarykey_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                        if (column.isIndexed()) {
                            sqls.addAll(this.create_index_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                        }
                    }
                    sqls.addAll(this.alter_table_alter_column_set_data_type_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                    sqls.addAll(this.alter_table_alter_column_set_default_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                    sqls.addAll(this.alter_table_alter_column_set_null_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                    if (!column.isGeometry()) continue;
                    sqls.addAll(this.alter_column_add_geometry_constraint_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                    continue;
                }
                if (operation.isSetBit(4)) {
                    sqls.addAll(this.alter_table_alter_column_set_null_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(5)) {
                    sqls.addAll(this.alter_table_alter_column_set_data_type_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(6)) {
                    sqls.addAll(this.alter_table_add_primarykey_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(7)) {
                    sqls.addAll(this.alter_table_drop_primarykey_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(3)) {
                    sqls.addAll(this.alter_table_alter_column_set_default_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(8)) {
                    sqls.addAll(this.create_index_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(9)) {
                    sqls.addAll(this.drop_index_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (!operation.isSetBit(2) || !column.isGeometry()) continue;
                sqls.addAll(this.alter_column_add_geometry_constraint_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
            }
            for (Pair pair : this.renames) {
                sqls.addAll(this.alter_table_alter_column_rename_sqls((Formatter<ExpressionBuilder.Value>)formatter, (String)pair.getLeft(), (String)pair.getRight()));
            }
            return sqls;
        }
    }

    public class DropIndexBuilderBase
    extends AbstractStatement
    implements SQLBuilder.DropIndexBuilder {
        protected boolean ifExist;
        protected String indexName;

        public DropIndexBuilderBase() {
            this.ifExist = false;
        }

        public SQLBuilder.DropIndexBuilder if_exist() {
            this.ifExist = true;
            return this;
        }

        public SQLBuilder.DropIndexBuilder name(String name) {
            this.indexName = name;
            return this;
        }

        public SQLBuilder.DropIndexBuilder name(String tableName, String columnName) {
            this.indexName = tableName + "_IDX_" + columnName;
            return this;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            builder.append("DROP INDEX ");
            if (this.ifExist) {
                builder.append("IF EXISTS ");
            }
            builder.append(SQLBuilderBase.this.as_identifier(this.indexName));
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(builder.toString());
            return sqls;
        }
    }

    public class CreateIndexBuilderBase
    extends AbstractStatement
    implements SQLBuilder.CreateIndexBuilder {
        protected boolean ifNotExist;
        protected boolean isUnique;
        protected String indexName;
        protected boolean isSpatial;
        protected SQLBuilder.TableNameBuilder table;
        protected final List<String> columns;
        protected FeatureType type;

        public CreateIndexBuilderBase() {
            this.ifNotExist = false;
            this.isUnique = false;
            this.isSpatial = false;
            this.columns = new ArrayList<String>();
        }

        public SQLBuilder.CreateIndexBuilder unique() {
            this.isUnique = true;
            return this;
        }

        public SQLBuilder.CreateIndexBuilder if_not_exist() {
            this.ifNotExist = true;
            return this;
        }

        public SQLBuilder.CreateIndexBuilder name(String name) {
            this.indexName = name;
            return this;
        }

        public SQLBuilder.CreateIndexBuilder name(String tableName, String columnName) {
            this.indexName = tableName + "_IDX_" + columnName;
            return this;
        }

        public SQLBuilder.CreateIndexBuilder spatial() {
            this.isSpatial = true;
            return this;
        }

        public SQLBuilder.CreateIndexBuilder column(String name) {
            this.columns.add(name);
            return this;
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public void setFeatureType(FeatureType type) {
            this.type = type;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.table != null) {
                this.table.accept(visitor, filter);
            }
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE ");
            if (this.isUnique) {
                builder.append("UNIQUE ");
            }
            builder.append("INDEX ");
            if (this.ifNotExist) {
                builder.append("IF NOT EXISTS ");
            }
            builder.append(SQLBuilderBase.this.as_identifier(this.indexName));
            builder.append(" ON ");
            builder.append(this.table.toString(formatter));
            if (this.isSpatial) {
                builder.append(" USING GIST ");
            }
            builder.append(" ( ");
            boolean is_first_column = true;
            for (String column : this.columns) {
                if (is_first_column) {
                    is_first_column = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column);
            }
            builder.append(" )");
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(builder.toString());
            return sqls;
        }
    }

    public class DeleteBuilderBase
    extends AbstractStatement
    implements SQLBuilder.DeleteBuilder {
        protected GeometryExpressionBuilder where;
        protected SQLBuilder.TableNameBuilder table;

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.table != null) {
                    this.table.accept(visitor, filter);
                }
                if (this.has_where()) {
                    this.where.accept(visitor, filter);
                }
            }
        }

        public GeometryExpressionBuilder where() {
            if (this.where == null) {
                this.where = SQLBuilderBase.this.createExpressionBuilder();
            }
            return this.where;
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public boolean has_where() {
            return this.where != null;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            String sql = this.has_where() ? MessageFormat.format(SQLBuilderBase.this.STMT_DELETE_FROM_table_WHERE_expresion, this.table.toString(formatter), this.where.toString(formatter)) : MessageFormat.format(SQLBuilderBase.this.STMT_DELETE_FROM_table, this.table.toString(formatter));
            return sql;
        }
    }

    public class UpdateBuilderBase
    extends AbstractStatement
    implements SQLBuilder.UpdateBuilder {
        protected GeometryExpressionBuilder where;
        protected List<SQLBuilder.UpdateColumnBuilder> columns;
        protected SQLBuilder.TableNameBuilder table;

        public UpdateBuilderBase() {
            this.columns = new ArrayList<SQLBuilder.UpdateColumnBuilder>();
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.table != null) {
                    this.table.accept(visitor, filter);
                }
                for (SQLBuilder.UpdateColumnBuilder column : this.columns) {
                    column.accept(visitor, filter);
                }
                if (this.has_where()) {
                    this.where.accept(visitor, filter);
                }
            }
        }

        public GeometryExpressionBuilder where() {
            if (this.where == null) {
                this.where = SQLBuilderBase.this.createExpressionBuilder();
            }
            return this.where;
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public SQLBuilder.UpdateColumnBuilder column() {
            SQLBuilder.UpdateColumnBuilder column = SQLBuilderBase.this.createUpdateColumnBuilder();
            this.columns.add(column);
            return column;
        }

        public boolean has_where() {
            return this.where != null;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder columnsAndValues = new StringBuilder();
            boolean first = true;
            for (SQLBuilder.UpdateColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    columnsAndValues.append(", ");
                }
                columnsAndValues.append(SQLBuilderBase.this.as_identifier(column.getName()));
                columnsAndValues.append(" = ");
                columnsAndValues.append(column.getValue().toString(formatter));
            }
            String sql = this.has_where() ? MessageFormat.format(SQLBuilderBase.this.STMT_UPDATE_table_SET_columnsAndValues_WHERE_expresion, this.table.toString(formatter), columnsAndValues.toString(), this.where.toString(formatter)) : MessageFormat.format(SQLBuilderBase.this.STMT_UPDATE_table_SET_columnsAndValues, this.table.toString(formatter), columnsAndValues.toString());
            return sql;
        }
    }

    public class UpdateColumnBuilderBase
    extends InsertColumnBuilderBase
    implements SQLBuilder.UpdateColumnBuilder {
        public SQLBuilder.UpdateColumnBuilder name(String name) {
            return (SQLBuilder.UpdateColumnBuilder)super.name(name);
        }

        public SQLBuilder.UpdateColumnBuilder with_value(ExpressionBuilder.Value value) {
            return (SQLBuilder.UpdateColumnBuilder)super.with_value(value);
        }
    }

    public class GrantBuilderBase
    extends AbstractStatement
    implements SQLBuilder.GrantBuilder {
        protected SQLBuilder.TableNameBuilder table;
        protected Map<String, SQLBuilder.GrantRoleBuilder> roles;

        public GrantBuilderBase() {
            this.roles = new HashMap<String, SQLBuilder.GrantRoleBuilder>();
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.table != null) {
                this.table.accept(visitor, filter);
            }
        }

        public SQLBuilder.GrantRoleBuilder role(String role) {
            SQLBuilder.GrantRoleBuilder roleBuilder = this.roles.get(role);
            if (roleBuilder == null) {
                roleBuilder = SQLBuilderBase.this.createGrantRoleBuilder(this.table(), role);
                this.roles.put(role, roleBuilder);
            }
            return roleBuilder;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            for (SQLBuilder.GrantRoleBuilder role : this.roles.values()) {
                sqls.add(role.toString(formatter));
            }
            return sqls;
        }
    }

    public class GrantRoleBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.GrantRoleBuilder {
        protected SQLBuilder.TableNameBuilder table;
        protected String role;
        protected Set<SQLBuilder.Privilege> privileges;

        public GrantRoleBuilderBase(SQLBuilder.TableNameBuilder table, String role) {
            this.table = table;
            this.role = role;
            this.privileges = new HashSet<SQLBuilder.Privilege>();
        }

        public GrantRoleBuilderBase clone() throws CloneNotSupportedException {
            GrantRoleBuilderBase other = (GrantRoleBuilderBase)super.clone();
            other.table = (SQLBuilder.TableNameBuilder)Cloneable.cloneQuietly((Cloneable)this.table);
            other.privileges = (Set)Cloneable.cloneQuietly(this.privileges);
            return other;
        }

        public SQLBuilder.GrantRoleBuilder privilege(SQLBuilder.Privilege privilege) {
            this.privileges.add(privilege);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder select() {
            this.privileges.add(SQLBuilder.Privilege.SELECT);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder update() {
            this.privileges.add(SQLBuilder.Privilege.UPDATE);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder insert() {
            this.privileges.add(SQLBuilder.Privilege.INSERT);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder delete() {
            this.privileges.add(SQLBuilder.Privilege.DELETE);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder truncate() {
            this.privileges.add(SQLBuilder.Privilege.TRUNCATE);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder reference() {
            this.privileges.add(SQLBuilder.Privilege.REFERENCE);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder trigger() {
            this.privileges.add(SQLBuilder.Privilege.TRIGGER);
            return this;
        }

        public SQLBuilder.GrantRoleBuilder all() {
            this.privileges.add(SQLBuilder.Privilege.ALL);
            return this;
        }

        protected String getPrivilegeName(SQLBuilder.Privilege privilege) {
            switch (privilege) {
                case DELETE: {
                    return "DELETE";
                }
                case INSERT: {
                    return "INSERT";
                }
                case REFERENCE: {
                    return "REFERENCE";
                }
                case SELECT: {
                    return "SELECT";
                }
                case TRIGGER: {
                    return "TRIGGER";
                }
                case TRUNCATE: {
                    return "TRUNCATE";
                }
                case UPDATE: {
                    return "UPDATE";
                }
            }
            return "ALL";
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (SQLBuilder.Privilege privilege : this.privileges) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(this.getPrivilegeName(privilege));
            }
            String sql = MessageFormat.format(SQLBuilderBase.this.STMT_GRANT_privileges_ON_table_TO_role, builder.toString(), this.table.toString(formatter), this.role);
            return sql;
        }
    }

    public class DropTableBuilderBase
    extends AbstractStatement
    implements SQLBuilder.DropTableBuilder {
        protected SQLBuilder.TableNameBuilder table;

        public SQLBuilder.TableNameBuilder table() {
            if (this.table == null) {
                this.table = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.table;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                this.table.accept(visitor, filter);
            }
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String sql : this.toStrings(formatter)) {
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(sql);
            }
            return builder.toString();
        }

        public List<String> toStrings() {
            return this.toStrings(SQLBuilderBase.this.formatter());
        }

        public List<String> toStrings(Formatter formatter) {
            String sql;
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(MessageFormat.format(SQLBuilderBase.this.STMT_DROP_TABLE_table, this.table.toString(formatter)));
            if (!StringUtils.isBlank((CharSequence)SQLBuilderBase.this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table) && !StringUtils.isEmpty((CharSequence)(sql = this.table.has_schema() ? MessageFormat.format(SQLBuilderBase.this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table, SQLBuilderBase.this.as_string(this.table.getSchema()), SQLBuilderBase.this.as_string(this.table.getName())) : MessageFormat.format(SQLBuilderBase.this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table, SQLBuilderBase.this.as_identifier(this.table.getName()))))) {
                sqls.add(sql);
            }
            return sqls;
        }
    }

    public class SelectBuilderBase
    extends AbstractStatement
    implements SQLBuilder.SelectBuilder {
        protected SQLBuilder.FromBuilder from;
        protected GeometryExpressionBuilder where;
        protected long limit;
        protected long offset;
        protected List<SQLBuilder.SelectColumnBuilder> columns;
        protected List<SQLBuilder.OrderByBuilder> order_by;
        protected boolean distinct;
        protected List<ExpressionBuilder.Value> groupColumn;
        protected boolean check_order_and_offset;

        public SelectBuilderBase() {
            this.limit = -1L;
            this.offset = -1L;
            this.check_order_and_offset = true;
            this.columns = new ArrayList<SQLBuilder.SelectColumnBuilder>();
            this.distinct = false;
        }

        public List<ExpressionBuilder.Value> getGroups() {
            return this.groupColumn;
        }

        public List<SQLBuilder.SelectColumnBuilder> getColumns() {
            return Collections.unmodifiableList(this.columns);
        }

        public void remove_column(String columnName) {
            SQLBuilder.SelectColumnBuilder found = null;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (!column.getAlias().equalsIgnoreCase(columnName)) continue;
                found = column;
                break;
            }
            if (found != null) {
                this.columns.remove(found);
            }
        }

        public SQLBuilder.SelectBuilder group_by(ExpressionBuilder.Value ... columns) {
            if (this.groupColumn == null) {
                this.groupColumn = new ArrayList<ExpressionBuilder.Value>();
            }
            for (ExpressionBuilder.Value column : columns) {
                this.groupColumn.add(column);
            }
            return this;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                    column.accept(visitor, filter);
                }
                if (this.has_from()) {
                    this.from.accept(visitor, filter);
                }
                if (this.has_where()) {
                    this.where.accept(visitor, filter);
                }
                if (this.has_order_by()) {
                    for (SQLBuilder.OrderByBuilder order : this.order_by) {
                        order.accept(visitor, filter);
                    }
                }
                if (this.has_group_by()) {
                    for (ExpressionBuilder.Value group : this.groupColumn) {
                        group.accept(visitor, filter);
                    }
                }
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            int i;
            if (this.columns != null) {
                for (i = 0; i < this.columns.size(); ++i) {
                    SQLBuilder.SelectColumnBuilder column = this.columns.get(i);
                    if (column == target) {
                        this.columns.set(i, (SQLBuilder.SelectColumnBuilder)replacement);
                        continue;
                    }
                    column.replace(target, replacement);
                }
            }
            if (this.has_from()) {
                if (this.from == target) {
                    this.from = (SQLBuilder.FromBuilder)replacement;
                } else {
                    this.from.replace(target, replacement);
                }
            }
            if (this.has_where()) {
                if (this.where == target) {
                    this.where = (GeometryExpressionBuilder)replacement;
                } else if (this.where.value() == target) {
                    this.where.value(replacement);
                } else {
                    this.where.value().replace(target, replacement);
                }
            }
            if (this.has_order_by()) {
                for (i = 0; i < this.order_by.size(); ++i) {
                    SQLBuilder.OrderByBuilder order = this.order_by.get(i);
                    if (order == target) {
                        this.order_by.set(i, (SQLBuilder.OrderByBuilder)replacement);
                        continue;
                    }
                    order.replace(target, replacement);
                }
            }
            if (this.has_group_by()) {
                for (i = 0; i < this.groupColumn.size(); ++i) {
                    ExpressionBuilder.Value group = this.groupColumn.get(i);
                    if (group == target) {
                        this.groupColumn.set(i, replacement);
                        continue;
                    }
                    group.replace(target, replacement);
                }
            }
        }

        public SQLBuilder.SelectBuilder distinct() {
            this.distinct = true;
            return this;
        }

        public SQLBuilder.SelectColumnBuilder column() {
            return this.column(SQLBuilderBase.this.createSelectColumnBuilder());
        }

        public SQLBuilder.SelectColumnBuilder column(SQLBuilder.SelectColumnBuilder columnBuilder) {
            this.columns.add(columnBuilder);
            if (this.has_from() && !this.from().table().isEmpty()) {
                SQLBuilder.TableNameBuilder table = (SQLBuilder.TableNameBuilder)CloneableUtils.cloneQuietly((Cloneable)this.from().table());
                columnBuilder.table(table);
            }
            return columnBuilder;
        }

        public SQLBuilder.SelectColumnBuilder column(String name) {
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)column.getName())) continue;
                return column;
            }
            return this.column(SQLBuilderBase.this.createSelectColumnBuilder()).name(name);
        }

        public SQLBuilder.SelectColumnBuilder getColumn(String name) {
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)column.getName())) continue;
                return column;
            }
            return null;
        }

        public SQLBuilder.SelectBuilder remove_all_columns() {
            this.columns = new ArrayList<SQLBuilder.SelectColumnBuilder>();
            return this;
        }

        public boolean has_column(String name) {
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (StringUtils.equals((CharSequence)name, (CharSequence)column.getName())) {
                    return true;
                }
                if (!StringUtils.equals((CharSequence)name, (CharSequence)column.getAlias())) continue;
                return true;
            }
            return false;
        }

        public SQLBuilder.FromBuilder from() {
            if (this.from == null) {
                this.from = SQLBuilderBase.this.createFromBuilder();
            }
            return this.from;
        }

        public boolean has_from() {
            return this.from != null;
        }

        public GeometryExpressionBuilder where() {
            if (this.where == null) {
                this.where = SQLBuilderBase.this.createExpressionBuilder();
            }
            return this.where;
        }

        public boolean has_where() {
            if (this.where == null) {
                return false;
            }
            return this.where.value() != null;
        }

        public SQLBuilder.SelectBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public SQLBuilder.SelectBuilder limit(Long limit) {
            this.limit = limit == null ? -1L : limit;
            return this;
        }

        public boolean has_limit() {
            return this.limit >= 0L;
        }

        public SQLBuilder.SelectBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public boolean has_offset() {
            return this.offset > 0L;
        }

        public SQLBuilder.OrderByBuilder order_by() {
            if (this.order_by == null) {
                this.order_by = new ArrayList<SQLBuilder.OrderByBuilder>();
            }
            SQLBuilder.OrderByBuilder order = SQLBuilderBase.this.createOrderByBuilder();
            this.order_by.add(order);
            return order;
        }

        public SQLBuilder.OrderByBuilder getOrderBy(ExpressionBuilder.Value column) {
            if (this.order_by == null) {
                return null;
            }
            for (SQLBuilder.OrderByBuilder orderByBuilder : this.order_by) {
                if (!orderByBuilder.isColumn(column)) continue;
                return orderByBuilder;
            }
            return null;
        }

        public SQLBuilder.OrderByBuilder getOrderBy(String column) {
            if (this.order_by == null) {
                return null;
            }
            for (SQLBuilder.OrderByBuilder orderByBuilder : this.order_by) {
                if (!orderByBuilder.isColumn(column)) continue;
                return orderByBuilder;
            }
            return null;
        }

        public boolean isGroupBy(String column) {
            if (this.groupColumn == null) {
                return false;
            }
            for (ExpressionBuilder.Value group : this.groupColumn) {
                if (!(group instanceof ExpressionBuilder.Variable) || !StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Variable)group).name(), (CharSequence)column)) continue;
                return true;
            }
            return false;
        }

        public boolean has_order_by() {
            if (this.order_by == null) {
                return false;
            }
            return !this.order_by.isEmpty();
        }

        public boolean has_group_by() {
            if (this.groupColumn == null) {
                return false;
            }
            return !this.groupColumn.isEmpty();
        }

        public boolean has_aggregate_functions() {
            if (this.columns == null || this.columns.isEmpty()) {
                return false;
            }
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (!column.isAggregateFunction()) continue;
                return true;
            }
            return false;
        }

        public void disable_check_order_and_offset() {
            this.check_order_and_offset = false;
        }

        protected boolean isValid(StringBuilder message) {
            if (message == null) {
                message = new StringBuilder();
            }
            if (this.check_order_and_offset && this.has_offset() && !this.has_order_by()) {
                message.append("Can't use OFFSET without an ORDER BY.");
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            if (!this.isValid(builder)) {
                throw new IllegalStateException(builder.toString());
            }
            builder.append("SELECT ");
            if (this.distinct) {
                builder.append("DISTINCT ");
            }
            boolean first = true;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column.toString(formatter));
            }
            if (this.has_from()) {
                builder.append(" FROM ");
                builder.append(this.from.toString(formatter));
            }
            if (this.has_where()) {
                builder.append(" WHERE ");
                builder.append(this.where.toString(formatter));
            }
            if (this.has_group_by()) {
                builder.append(" GROUP BY ");
                builder.append(this.groupColumn.get(0).toString(formatter));
                for (int i = 1; i < this.groupColumn.size(); ++i) {
                    builder.append(", ");
                    builder.append(this.groupColumn.get(i).toString(formatter));
                }
            }
            if (this.has_order_by()) {
                builder.append(" ORDER BY ");
                first = true;
                for (SQLBuilder.OrderByBuilder item : this.order_by) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(item.toString(formatter));
                }
            }
            if (this.has_limit()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
            }
            if (this.has_offset()) {
                builder.append(" OFFSET ");
                builder.append(this.offset);
            }
            return builder.toString();
        }
    }

    public class OrderByBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.OrderByBuilder {
        protected ExpressionBuilder.Value value;
        protected String custom;
        protected boolean ascending;
        protected int nullsMode;

        public OrderByBuilderBase() {
            this.ascending = true;
            this.nullsMode = 1;
        }

        public OrderByBuilderBase clone() throws CloneNotSupportedException {
            OrderByBuilderBase other = (OrderByBuilderBase)super.clone();
            other.value = (ExpressionBuilder.Value)Cloneable.cloneQuietly((Cloneable)this.value);
            return other;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.value != null) {
                this.value.accept(visitor, filter);
            }
        }

        public SQLBuilder.OrderByBuilder column(String name) {
            this.value = SQLBuilderBase.this.expression().variable(name);
            return this;
        }

        public boolean isColumn(String name) {
            if (this.value instanceof ExpressionBuilder.Variable) {
                return StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Variable)this.value).name(), (CharSequence)name);
            }
            return false;
        }

        public boolean isColumn(ExpressionBuilder.Value value) {
            if (value instanceof ExpressionBuilder.Variable) {
                return this.isColumn(((ExpressionBuilder.Variable)value).name());
            }
            return this.value == value;
        }

        public SQLBuilder.OrderByBuilder value(ExpressionBuilder.Value expression) {
            this.value = expression;
            return this;
        }

        public SQLBuilder.OrderByBuilder custom(String order) {
            this.custom = order;
            return this;
        }

        public SQLBuilder.OrderByBuilder ascending() {
            this.ascending = true;
            return this;
        }

        public SQLBuilder.OrderByBuilder ascending(boolean asc) {
            this.ascending = asc;
            return this;
        }

        public SQLBuilder.OrderByBuilder descending() {
            this.ascending = false;
            return this;
        }

        public SQLBuilder.OrderByBuilder nulls(int mode) {
            this.nullsMode = mode;
            return this;
        }

        public int getNullsMode() {
            return this.nullsMode;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (!StringUtils.isEmpty((CharSequence)this.custom)) {
                return this.custom;
            }
            String order_s = this.value.toString(formatter);
            order_s = this.ascending ? order_s + " ASC" : order_s + " DESC";
            switch (this.nullsMode) {
                case 2: {
                    break;
                }
                case 0: {
                    order_s = order_s + " NULLS FIRST";
                    break;
                }
                default: {
                    order_s = order_s + " NULLS LAST";
                }
            }
            return order_s;
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            super.replace(target, replacement);
            if (target == this.value) {
                this.value = replacement;
                return;
            }
            if (this.value == null) {
                return;
            }
            this.value.replace(target, replacement);
        }
    }

    public class SelectColumnBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.SelectColumnBuilder {
        protected SQLBuilder.Column name;
        protected String alias;
        protected ExpressionBuilder.Value value;
        protected boolean asGeometry;
        protected SQLBuilder.TableNameBuilder table;
        protected SQLBuilder sqlbuilder;

        public SelectColumnBuilderBase(SQLBuilder sqlbuilder) {
            this.name = null;
            this.alias = null;
            this.value = null;
            this.asGeometry = false;
            this.sqlbuilder = sqlbuilder;
        }

        public SelectColumnBuilderBase clone() throws CloneNotSupportedException {
            SelectColumnBuilderBase other = (SelectColumnBuilderBase)super.clone();
            other.value = (ExpressionBuilder.Value)Cloneable.cloneQuietly((Cloneable)this.value);
            other.name = (SQLBuilder.Column)Cloneable.cloneQuietly((Cloneable)this.name);
            other.table = (SQLBuilder.TableNameBuilder)Cloneable.cloneQuietly((Cloneable)this.table);
            return other;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.value != null) {
                    this.value.accept(visitor, filter);
                } else if (this.name != null) {
                    this.name.accept(visitor, filter);
                }
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.name != null && this.name == target) {
                if (replacement == null) {
                    this.name = null;
                } else if (replacement instanceof SQLBuilder.Column) {
                    this.name = (SQLBuilder.Column)replacement;
                } else if (replacement instanceof ExpressionBuilder.Variable) {
                    this.name = new ColumnBase(this.table, ((ExpressionBuilder.Variable)replacement).name());
                } else {
                    this.value = replacement;
                }
            }
            if (this.value != null) {
                if (this.value == target) {
                    this.value = replacement;
                } else {
                    this.value.replace(target, replacement);
                }
            }
        }

        public SQLBuilder.SelectColumnBuilder name(String name) {
            return this.name(this.table, name);
        }

        public SQLBuilder.SelectColumnBuilder name(SQLBuilder.TableNameBuilder table, String name) {
            String quote = SQLBuilderBase.this.quote_for_identifiers();
            if (name.startsWith(quote)) {
                name = name.substring(1, name.length() - 1);
            }
            this.table = table;
            this.name = new ColumnBase(this.table, name);
            this.value = null;
            this.asGeometry = false;
            return this;
        }

        public SQLBuilder.SelectColumnBuilder table(SQLBuilder.TableNameBuilder table) {
            this.table = table;
            if (this.name != null) {
                this.name.table(table);
            }
            return this;
        }

        public SQLBuilder.SelectColumnBuilder all() {
            this.name = null;
            this.value = SQLBuilderBase.this.expression().custom((Object)"*");
            this.asGeometry = false;
            return this;
        }

        public SQLBuilder.SelectColumnBuilder as_geometry() {
            this.asGeometry = true;
            return this;
        }

        public SQLBuilder.SelectColumnBuilder value(ExpressionBuilder.Value value) {
            this.value = value;
            return this;
        }

        public SQLBuilder.SelectColumnBuilder as(String alias) {
            this.alias = alias;
            return this;
        }

        public String getName() {
            if (this.name == null) {
                return null;
            }
            return this.name.name();
        }

        public String getAlias() {
            return this.alias;
        }

        public ExpressionBuilder.Value getValue() {
            return this.value;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            if (this.asGeometry) {
                if (this.value == ExpressionBuilder.VALUE_NULL) {
                    builder.append(this.value.toString(formatter));
                } else {
                    switch (SQLBuilderBase.this.expression().geometry_support_type()) {
                        case WKB: {
                            builder.append(SQLBuilderBase.this.expression().ST_AsBinary((ExpressionBuilder.Value)this.name).toString(formatter));
                            break;
                        }
                        case EWKB: {
                            builder.append(SQLBuilderBase.this.expression().ST_AsEWKB((ExpressionBuilder.Value)this.name).toString(formatter));
                            break;
                        }
                        case WKT: {
                            builder.append(SQLBuilderBase.this.expression().ST_AsText((ExpressionBuilder.Value)this.name).toString(formatter));
                            break;
                        }
                        case NATIVE: {
                            builder.append(SQLBuilderBase.this.as_identifier(this.name.toString(formatter)));
                        }
                    }
                }
            } else if (this.value == null) {
                builder.append(this.name.toString(formatter));
            } else {
                builder.append(this.value.toString(formatter));
            }
            if (this.alias != null) {
                builder.append(" AS ");
                builder.append(SQLBuilderBase.this.as_identifier(this.alias));
            }
            return builder.toString();
        }

        public boolean isGeometry() {
            return this.asGeometry;
        }

        public SQLBuilder.TableNameBuilder getTable() {
            return this.table;
        }

        public boolean isAggregateFunction() {
            if (this.value == null) {
                return false;
            }
            if (!(this.value instanceof ExpressionBuilder.Function)) {
                return false;
            }
            String funcname = ((ExpressionBuilder.Function)this.value).name();
            return this.sqlbuilder.isAggregateFunction(funcname);
        }
    }

    public class FromBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.FromBuilder {
        protected SQLBuilder.TableNameBuilder tableName;
        protected String subquery;
        protected String passthrough;
        protected List<SQLBuilder.JoinBuilder> joins;

        public FromBuilderBase() {
            this.tableName = null;
            this.subquery = null;
            this.passthrough = null;
            this.joins = null;
        }

        public FromBuilderBase clone() throws CloneNotSupportedException {
            FromBuilderBase other = (FromBuilderBase)super.clone();
            other.tableName = (SQLBuilder.TableNameBuilder)Cloneable.cloneQuietly((Cloneable)this.tableName);
            if (this.joins != null) {
                for (int i = 0; i < this.joins.size(); ++i) {
                    other.joins.set(i, (JoinBase)this.joins.get(i).clone());
                }
            }
            return other;
        }

        public SQLBuilder.FromBuilder left_join(SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value expression) {
            JoinBase join = SQLBuilderBase.this.createJoin("LEFT", table, expression);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLBuilder.JoinBuilder>();
            }
            this.joins.add(join);
            return this;
        }

        public SQLBuilder.TableNameBuilder table() {
            if (this.tableName == null) {
                this.tableName = SQLBuilderBase.this.createTableNameBuilder();
            }
            return this.tableName;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                if (this.tableName != null) {
                    this.tableName.accept(visitor, filter);
                }
                if (this.joins != null) {
                    for (SQLBuilder.JoinBuilder join : this.joins) {
                        join.accept(visitor, filter);
                    }
                }
            }
        }

        public SQLBuilder.FromBuilder custom(String passthrough) {
            this.passthrough = passthrough;
            return this;
        }

        public SQLBuilder.FromBuilder subquery(String subquery) {
            this.subquery = subquery;
            return this;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (!StringUtils.isEmpty((CharSequence)this.passthrough)) {
                return this.passthrough;
            }
            if (!StringUtils.isEmpty((CharSequence)this.subquery)) {
                return "( " + this.subquery + ") AS _subquery_alias_ ";
            }
            if (this.joins == null || this.joins.isEmpty()) {
                return this.tableName.toString(formatter);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.tableName.toString(formatter));
            for (SQLBuilder.JoinBuilder join : this.joins) {
                builder.append(" ");
                builder.append(join.toString(formatter));
            }
            return builder.toString();
        }

        public List<SQLBuilder.JoinBuilder> getJoins() {
            return this.joins;
        }
    }

    protected class JoinBase
    extends AbstractStatementPart
    implements SQLBuilder.JoinBuilder {
        protected String type;
        protected SQLBuilder.TableNameBuilder table;
        protected ExpressionBuilder.Value expression;

        public JoinBase(String type, SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value expression) {
            this.type = type;
            this.table = table;
            this.expression = expression;
        }

        public JoinBase clone() throws CloneNotSupportedException {
            JoinBase other = (JoinBase)super.clone();
            other.table = (SQLBuilder.TableNameBuilder)Cloneable.cloneQuietly((Cloneable)this.table);
            other.expression = (ExpressionBuilder.Value)Cloneable.cloneQuietly((Cloneable)this.expression);
            return other;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.type.toUpperCase());
            builder.append(" JOIN ");
            builder.append(this.table.toString(formatter));
            builder.append(" ON ");
            builder.append(this.expression.toString(formatter));
            return builder.toString();
        }

        public SQLBuilder.TableNameBuilder getTable() {
            return this.table;
        }

        public String getType() {
            return this.type;
        }

        public ExpressionBuilder.Value getCondition() {
            return this.expression;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.expression != null) {
                this.expression.accept(visitor, filter);
            }
        }
    }

    public class CountBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.CountBuilder {
        protected ExpressionBuilder.Value value;
        protected boolean distinct;
        protected boolean all;

        public CountBuilderBase() {
            this.value = null;
            this.distinct = false;
            this.all = false;
        }

        public CountBuilderBase clone() throws CloneNotSupportedException {
            CountBuilderBase other = (CountBuilderBase)super.clone();
            other.value = (ExpressionBuilder.Value)Cloneable.cloneQuietly((Cloneable)this.value);
            return other;
        }

        public SQLBuilder.CountBuilder all() {
            this.all = true;
            return this;
        }

        public SQLBuilder.CountBuilder column(ExpressionBuilder.Value value) {
            this.value = value;
            return this;
        }

        public SQLBuilder.CountBuilder distinct() {
            this.distinct = true;
            return this;
        }

        public String toString() {
            return this.toString(SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.all) {
                return "COUNT(*)";
            }
            if (this.distinct) {
                return MessageFormat.format("COUNT(DISTINCT {0})", this.value.toString(formatter));
            }
            return MessageFormat.format("COUNT({0})", this.value.toString(formatter));
        }
    }

    public class TableNameBuilderBase
    extends AbstractStatementPart
    implements SQLBuilder.TableNameBuilder {
        public String tableName;
        public String schemaName;
        private String databaseName;
        private FeatureType featureType;

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            }
        }

        public SQLBuilder.TableNameBuilder database(String name) {
            this.databaseName = name;
            return this;
        }

        public SQLBuilder.TableNameBuilder schema(String name) {
            if (SQLBuilderBase.this.support_schemas()) {
                this.schemaName = name;
            }
            return this;
        }

        public SQLBuilder.TableNameBuilder name(String name) {
            this.tableName = name;
            return this;
        }

        protected String databaseName2provider() {
            return this.databaseName;
        }

        protected String schemaName2provider() {
            return this.schemaName;
        }

        protected String tableName2provider() {
            return this.tableName;
        }

        public String getDatabase() {
            return this.databaseName;
        }

        public String getSchema() {
            return this.schemaName;
        }

        public String getName() {
            return this.tableName;
        }

        public boolean has_schema() {
            if (!SQLBuilderBase.this.support_schemas()) {
                return false;
            }
            return StringUtils.isNotBlank((CharSequence)this.schemaName);
        }

        public boolean has_name() {
            return StringUtils.isNotBlank((CharSequence)this.tableName);
        }

        public boolean has_database() {
            return StringUtils.isNotBlank((CharSequence)this.databaseName);
        }

        public boolean isEmpty() {
            return !this.has_database() && !this.has_schema() && !this.has_name();
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.has_database()) {
                if (this.has_schema()) {
                    return SQLBuilderBase.this.as_identifier(this.databaseName2provider()) + "." + SQLBuilderBase.this.as_identifier(this.schemaName2provider()) + "." + SQLBuilderBase.this.as_identifier(this.tableName2provider());
                }
            } else if (this.has_schema()) {
                return SQLBuilderBase.this.as_identifier(this.schemaName2provider()) + "." + SQLBuilderBase.this.as_identifier(this.tableName2provider());
            }
            return SQLBuilderBase.this.as_identifier(this.tableName2provider());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SQLBuilder.TableNameBuilder)) {
                return false;
            }
            SQLBuilder.TableNameBuilder other = (SQLBuilder.TableNameBuilder)obj;
            if (this.has_database() != other.has_database()) {
                return false;
            }
            String thisSchema = null;
            String otherSchema = null;
            if (SQLBuilderBase.this.support_schemas()) {
                thisSchema = this.schemaName;
                if (StringUtils.isBlank((CharSequence)thisSchema)) {
                    thisSchema = SQLBuilderBase.this.default_schema();
                }
                if (StringUtils.isBlank((CharSequence)(otherSchema = other.getSchema()))) {
                    otherSchema = SQLBuilderBase.this.default_schema();
                }
            }
            if (this.has_database()) {
                return StringUtils.equals((CharSequence)this.databaseName, (CharSequence)other.getDatabase()) && StringUtils.equals((CharSequence)thisSchema, (CharSequence)otherSchema) && StringUtils.equals((CharSequence)this.tableName, (CharSequence)other.getName());
            }
            return StringUtils.equals((CharSequence)thisSchema, otherSchema) && StringUtils.equals((CharSequence)this.tableName, (CharSequence)other.getName());
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.toString());
            return hash;
        }

        public void setFeatureType(FeatureType featureType) {
            this.featureType = featureType;
        }

        public FeatureType featureType() {
            return this.featureType;
        }
    }

    public class ColumnBase
    extends ExpressionBuilder.AbstractValue
    implements SQLBuilder.Column {
        private final String name;
        private SQLBuilder.TableNameBuilder table;

        public ColumnBase(SQLBuilder.TableNameBuilder table, String name) {
            this.name = name;
            this.table = table;
        }

        public ColumnBase clone() throws CloneNotSupportedException {
            ColumnBase other = (ColumnBase)super.clone();
            other.table = (SQLBuilder.TableNameBuilder)Cloneable.cloneQuietly((Cloneable)this.table);
            return other;
        }

        public String name() {
            return this.name;
        }

        public SQLBuilder.TableNameBuilder table() {
            return this.table;
        }

        public SQLBuilder.TableNameBuilder table(SQLBuilder.TableNameBuilder table) {
            this.table = table;
            return this.table;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)SQLBuilderBase.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.table == null) {
                return SQLBuilderBase.this.as_identifier(this.name);
            }
            return this.table.toString(formatter) + "." + SQLBuilderBase.this.as_identifier(this.name);
        }

        public int compareTo(ExpressionBuilder.Variable o) {
            return this.name.compareTo(o.name());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionBuilder.Variable)) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.toString(), (CharSequence)((ExpressionBuilder.Variable)obj).toString());
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.toString());
            return hash;
        }

        public void setProperty(String name, Object value) {
            super.setProperty(name, value);
            if (this.table != null) {
                this.table.setProperty(name, value);
            }
        }
    }

    protected class ColumnDescriptorBase
    implements SQLBuilder.ColumnDescriptor {
        private String name;
        private int type;
        private int size;
        private int precision;
        private int scale;
        private boolean isPk;
        private boolean _allowNulls;
        private boolean _allowIndexDuplicateds;
        private boolean _isAutomatic;
        private Object defaultValue;
        private int geom_type;
        private int geom_subtype;
        private Object geom_srsdbcode;
        private Envelope tablebbox;
        private boolean _isIndexed;
        private DataStoreParameters parameters = null;
        private String foreignkeyTableName;
        private String foreignkeyFieldName;
        private boolean categorized;

        public ColumnDescriptorBase(String name, int type, Object defaultValue) {
            this.name = name;
            this.type = type;
            this.size = -1;
            this.precision = -1;
            this.scale = -1;
            this.isPk = false;
            this._allowNulls = true;
            this._isAutomatic = false;
            this.defaultValue = defaultValue;
            this.geom_type = 0;
            this.geom_subtype = 0;
            this.geom_srsdbcode = null;
            this.tablebbox = null;
            this._isIndexed = false;
            this._allowIndexDuplicateds = true;
        }

        public ColumnDescriptorBase(String name, int type, int size, int precision, int scale, boolean isPk, boolean isIndexed, boolean allowNulls, boolean isAutomatic, Object defaultValue) {
            this(name, type, size, precision, scale, isPk, isIndexed, allowNulls, isAutomatic, defaultValue, true);
        }

        public ColumnDescriptorBase(String name, int type, int size, int precision, int scale, boolean isPk, boolean isIndexed, boolean allowNulls, boolean isAutomatic, Object defaultValue, boolean allowIndexDuplicateds) {
            this.name = name;
            this.type = type;
            this.size = size;
            this.precision = precision;
            this.scale = scale;
            this.isPk = isPk;
            this._allowNulls = allowNulls;
            this._isAutomatic = isAutomatic;
            this.defaultValue = defaultValue;
            this.geom_type = 0;
            this.geom_subtype = 0;
            this.geom_srsdbcode = null;
            this.tablebbox = null;
            this._isIndexed = isIndexed;
            this._allowIndexDuplicateds = allowIndexDuplicateds;
        }

        public ColumnDescriptorBase(String name, int geom_type, int geom_subtype, IProjection proj, boolean isIndexed, boolean allowNulls) {
            this.name = name;
            this.type = 66;
            this.size = 0;
            this.precision = 0;
            this.scale = 0;
            this.isPk = false;
            this._allowNulls = allowNulls;
            this._isAutomatic = false;
            this.defaultValue = null;
            this.geom_type = geom_type;
            this.geom_subtype = geom_subtype;
            this.geom_srsdbcode = SQLBuilderBase.this.srs_id(proj);
            this.tablebbox = null;
            this._isIndexed = isIndexed;
            this._allowIndexDuplicateds = true;
        }

        public ColumnDescriptorBase(String name, int geom_type, int geom_subtype, Object srsdbcode, boolean isIndexed, boolean allowNulls) {
            this.name = name;
            this.type = 66;
            this.size = 0;
            this.precision = 0;
            this.scale = 0;
            this.isPk = false;
            this._allowNulls = allowNulls;
            this._isAutomatic = false;
            this.defaultValue = null;
            this.geom_type = geom_type;
            this.geom_subtype = geom_subtype;
            this.geom_srsdbcode = srsdbcode;
            this.tablebbox = null;
            this._isIndexed = isIndexed;
            this._allowIndexDuplicateds = true;
        }

        private ColumnDescriptorBase(FeatureAttributeDescriptor fad) {
            this(fad.getName(), fad.getType(), fad.getDefaultValue());
            this.precision = fad.getPrecision();
            this.size = fad.getSize();
            this.scale = fad.getScale();
            this.isPk = fad.isPrimaryKey();
            this._allowNulls = fad.allowNull();
            this._isAutomatic = fad.isAutomatic();
            this._isIndexed = fad.isIndexed();
            this._allowIndexDuplicateds = fad.allowIndexDuplicateds();
            if (fad.getType() == 66) {
                this.geom_type = fad.getGeomType().getType();
                this.geom_subtype = fad.getGeomType().getSubType();
                this.geom_srsdbcode = this$0.srs_id(fad.getSRS());
                this.tablebbox = null;
                Tags tags = fad.getTags();
                Object xx = tags.get("tablebbox");
                if (xx instanceof Envelope) {
                    this.tablebbox = (Envelope)xx;
                } else if (xx instanceof Geometry) {
                    this.tablebbox = ((Geometry)xx).getEnvelope();
                } else {
                    String s = tags.getString("tablebbox", null);
                    if (StringUtils.isNotBlank((CharSequence)s)) {
                        try {
                            Geometry g = GeometryUtils.createFrom((String)s);
                            if (g != null) {
                                this.tablebbox = g.getEnvelope();
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't parse tablebbox for column '" + s + "'.", (Throwable)ex);
                        }
                    }
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public int getScale() {
            return this.scale;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public boolean isPrimaryKey() {
            return this.isPk;
        }

        public void setIsPrimaryKey(boolean isPk) {
            this.isPk = isPk;
        }

        public boolean allowNulls() {
            return this._allowNulls;
        }

        public void setAllowNulls(boolean allowNulls) {
            this._allowNulls = allowNulls;
        }

        public boolean isAutomatic() {
            return this._isAutomatic;
        }

        public boolean isIndexed() {
            return this._isIndexed;
        }

        public void setIsAutomatic(boolean isAutomatic) {
            this._isAutomatic = isAutomatic;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public int getGeometryType() {
            return this.geom_type;
        }

        public void setGeometryType(int geom_type) {
            this.geom_type = geom_type;
        }

        public int getGeometrySubtype() {
            return this.geom_subtype;
        }

        public void setGeometrySubtype(int geom_subtype) {
            this.geom_subtype = geom_subtype;
        }

        public Object getGeometrySRSId() {
            return this.geom_srsdbcode;
        }

        public void setGeometrySRSId(Object geom_srsid) {
            this.geom_srsdbcode = geom_srsid;
        }

        public boolean isGeometry() {
            return this.type == 66;
        }

        private void setStoreParameters(DataStoreParameters parameters) {
            this.parameters = parameters;
        }

        public DataStoreParameters getStoreParameters() {
            return this.parameters;
        }

        public Envelope getTableBBox() {
            return this.tablebbox;
        }

        public void setTableBBox(Envelope bbox) {
            this.tablebbox = bbox;
        }

        public boolean allowIndexDuplicateds() {
            return this._allowIndexDuplicateds;
        }

        public void setAllowIndexDuplicateds(boolean allowIndexDuplicateds) {
            this._allowIndexDuplicateds = allowIndexDuplicateds;
        }

        public void foreignkey(String tableName, String fieldName) {
            this.foreignkeyTableName = tableName;
            this.foreignkeyFieldName = fieldName;
        }

        public boolean isForeignKey() {
            return StringUtils.isNotBlank((CharSequence)this.foreignkeyTableName) && StringUtils.isNotBlank((CharSequence)this.foreignkeyFieldName);
        }

        public String getForeignkeyFieldName() {
            return this.foreignkeyFieldName;
        }

        public String getForeignkeyTableName() {
            return this.foreignkeyTableName;
        }

        public boolean isCategorized() {
            return this.categorized;
        }

        public void setCategorized(boolean categorized) {
            this.categorized = categorized;
        }
    }

    protected abstract class AbstractStatement
    extends AbstractStatementPart {
        protected AbstractStatement() {
        }

        public ExpressionBuilder.Value clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }

    protected abstract class AbstractStatementPart
    extends ExpressionBuilder.AbstractValue {
        protected AbstractStatementPart() {
        }
    }
}

