/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.memory;

import java.util.Iterator;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFeatureProviderAttributeMapper
implements FeatureProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryFeatureProviderAttributeMapper.class);
    private static final FilteredLogger FLOGGER = new FilteredLogger(LOGGER, "MemoryFeatureProviderAttributeMapper", 10).setInterval(20000L);
    private final FeatureProvider original;
    private final FeatureType myFeatureType;

    public MemoryFeatureProviderAttributeMapper(FeatureProvider original, FeatureType featureType) {
        this.original = original;
        this.myFeatureType = featureType;
    }

    @Override
    public boolean isReadOnly(int i) {
        FeatureAttributeDescriptor attribute = this.myFeatureType.getAttributeDescriptor(i);
        return attribute.getEvaluator() == null;
    }

    @Override
    public Object get(int i) {
        return this.original.get(this.myFeatureType.getAttributeDescriptor(i).getName());
    }

    @Override
    public Object get(String name) {
        return this.original.get(name);
    }

    @Override
    public FeatureProvider getCopy() {
        DefaultFeatureProvider data = new DefaultFeatureProvider(this.myFeatureType);
        data.setOID(this.original.getOID());
        Iterator iter = this.myFeatureType.iterator();
        FeatureType originalType = this.original.getType();
        while (iter.hasNext()) {
            FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)iter.next();
            if (attr.isComputed()) continue;
            if (originalType.get(attr.getName()) == null) {
                FLOGGER.warn("Can't access attribute '" + attr.getName() + "' in original feature.");
                continue;
            }
            data.set(attr.getIndex(), this.original.get(attr.getName()));
        }
        data.setNew(this.original.isNew());
        return data;
    }

    @Override
    public Envelope getDefaultEnvelope() {
        return this.original.getDefaultEnvelope();
    }

    @Override
    public Geometry getDefaultGeometry() {
        return this.original.getDefaultGeometry();
    }

    @Override
    public Object getOID() {
        return this.original.getOID();
    }

    @Override
    public FeatureType getType() {
        return this.myFeatureType;
    }

    @Override
    public boolean isNew() {
        return this.original.isNew();
    }

    @Override
    public boolean isNull(int i) {
        return this.original.isNull(this.myFeatureType.getAttributeDescriptor(i).getName());
    }

    @Override
    public boolean isNull(String name) {
        return this.original.isNull(name);
    }

    @Override
    public void set(int i, Object value) {
        this.original.set(this.myFeatureType.getAttributeDescriptor(i).getName(), value);
    }

    @Override
    public void set(String name, Object value) {
        this.original.set(name, value);
    }

    @Override
    public void setDefaultEnvelope(Envelope extent) {
        this.original.setDefaultEnvelope(extent);
    }

    @Override
    public void setDefaultGeometry(Geometry geom) {
        this.original.setDefaultGeometry(geom);
    }

    @Override
    public void setNew(boolean isNew) {
        this.original.setNew(isNew);
    }

    @Override
    public void setOID(Object oid) {
        this.original.setOID(oid);
    }

    @Override
    public Time getDefaultTime() {
        return this.original.getDefaultTime();
    }

    @Override
    public void setDefaultTime(Time time) {
        this.original.setDefaultTime(time);
    }

    @Override
    public void setExtraValue(int index, Object value) {
        this.original.setExtraValue(index, value);
    }

    @Override
    public Object getExtraValue(int index) {
        return this.original.getExtraValue(index);
    }

    @Override
    public Object getExtraValue(String name) {
        return this.original.getExtraValue(name);
    }

    @Override
    public void setExtraValueNames(String[] extraValueNames) {
        this.original.setExtraValueNames(extraValueNames);
    }

    @Override
    public boolean hasExtraValue(String name) {
        return this.original.hasExtraValue(name);
    }

    @Override
    public boolean isBroken() {
        return false;
    }

    @Override
    public int getDataStatus() {
        return 0;
    }
}

