/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.spi;

import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.spi.AbstractExportParameters;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class AbstractExportParametersGeometry
extends AbstractExportParameters
implements ExportParametersGeometry {
    private IProjection contextProjection;
    private IProjection sourceProjection;
    private IProjection targetProjection;
    private ICoordTrans sourceTransformation;
    private ICoordTrans targetTransformation;
    private int geometryChecks;
    private int geometryChecksAction;
    private boolean tryToFixGeometry;
    private String geometryFieldName;
    private int geometryType;
    private int geometrySubtype;

    public AbstractExportParametersGeometry(ExportServiceFactory factory) {
        super(factory);
    }

    @Override
    public boolean needsSelectTargetProjection() {
        return true;
    }

    @Override
    public void setContextProjection(IProjection projection) {
        this.contextProjection = projection;
    }

    @Override
    public IProjection getContextProjection() {
        return this.contextProjection;
    }

    @Override
    public void setSourceProjection(IProjection sourceProjection) {
        this.sourceProjection = sourceProjection;
    }

    @Override
    public IProjection getSourceProjection() {
        return this.sourceProjection;
    }

    @Override
    public ICoordTrans getSourceTransformation() {
        return this.sourceTransformation;
    }

    @Override
    public void setSourceTransformation(ICoordTrans contextTransformation) {
        this.sourceTransformation = contextTransformation;
    }

    @Override
    public void setTargetProjection(IProjection targetProjection) {
        this.targetProjection = targetProjection;
    }

    @Override
    public IProjection getTargetProjection() {
        if (this.targetProjection == null) {
            return this.sourceProjection;
        }
        return this.targetProjection;
    }

    @Override
    public void setTargetTransformation(ICoordTrans transformation) {
        this.targetTransformation = transformation;
    }

    @Override
    public ICoordTrans getTargetTransformation() {
        return this.targetTransformation;
    }

    @Override
    public int getGeometryChecks() {
        return this.geometryChecks;
    }

    @Override
    public int getGeometryChecksAction() {
        return this.geometryChecksAction;
    }

    @Override
    public boolean getTryToFixGeometry() {
        return this.tryToFixGeometry;
    }

    @Override
    public void setGeometryChecks(int geometryChecks) {
        this.geometryChecks = geometryChecks;
    }

    @Override
    public void setGeometryChecksAction(int geometryChecksAction) {
        this.geometryChecksAction = geometryChecksAction;
    }

    @Override
    public void setTryToFixGeometry(boolean tryToFixGeometry) {
        this.tryToFixGeometry = tryToFixGeometry;
    }

    @Override
    public String getSourceGeometryFieldName() {
        return this.geometryFieldName;
    }

    @Override
    public void setSourceGeometryFieldName(String geometryFieldName) {
        this.geometryFieldName = geometryFieldName;
    }

    @Override
    public int getTargetGeometryTypeAsInt() {
        return this.geometryType;
    }

    @Override
    public int getTargetGeometrySubtype() {
        return this.geometrySubtype;
    }

    @Override
    public void setTargetGeometryType(int geometryType) {
        this.geometryType = geometryType;
    }

    @Override
    public void setTargetGeometrySubtype(int subtype) {
        this.geometrySubtype = subtype;
    }

    @Override
    public void setTargetGeometryType(GeometryType type) {
        this.geometryType = type.getType();
        this.geometrySubtype = type.getSubType();
    }

    @Override
    public GeometryType getTargetGeometryType() {
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            GeometryType type = geomManager.getGeometryType(this.geometryType, this.geometrySubtype);
            return type;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create geoemtry type from type " + this.geometryType + ", subtype " + this.geometrySubtype + ".", ex);
        }
    }

    @Override
    public ExportParameters clone() throws CloneNotSupportedException {
        AbstractExportParametersGeometry clone = (AbstractExportParametersGeometry)super.clone();
        clone.setContextProjection(this.contextProjection);
        clone.setSourceProjection(this.sourceProjection);
        clone.setTargetProjection(this.targetProjection);
        clone.setSourceTransformation(this.sourceTransformation);
        clone.setTargetTransformation(this.targetTransformation);
        clone.setSourceGeometryFieldName(this.geometryFieldName);
        clone.setGeometryChecks(this.geometryChecks);
        clone.setGeometryChecksAction(this.geometryChecksAction);
        clone.setTryToFixGeometry(this.tryToFixGeometry);
        clone.setTargetGeometryType(this.geometryType);
        clone.setTargetGeometrySubtype(this.geometrySubtype);
        return clone;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("AbstractExportParametersGeometry") == null) {
            DynStruct definition = manager.addDefinition(AbstractExportParametersGeometry.class, "AbstractExportParametersGeometry", "AbstractExportParametersGeometry persistence definition", null, null);
            definition.addDynFieldObject("contextProjection").setClassOfValue(IProjection.class);
            definition.addDynFieldObject("sourceProjection").setClassOfValue(IProjection.class);
            definition.addDynFieldObject("targetProjection").setClassOfValue(IProjection.class);
            definition.addDynFieldObject("sourceTransformation").setClassOfValue(ICoordTrans.class);
            definition.addDynFieldObject("targetTransformation").setClassOfValue(ICoordTrans.class);
            definition.addDynFieldInt("geometryChecks");
            definition.addDynFieldInt("geometryChecksAction");
            definition.addDynFieldBoolean("tryToFixGeometry");
            definition.addDynFieldString("geometryFieldName");
            definition.addDynFieldInt("geometryType");
            definition.addDynFieldInt("geometrySubtype");
            definition.extend(manager.getDefinition("AbstractExportParameters"));
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("contextProjection", (Object)this.contextProjection);
        state.set("sourceProjection", (Object)this.sourceProjection);
        state.set("targetProjection", (Object)this.targetProjection);
        state.set("sourceTransformation", (Object)this.sourceTransformation);
        state.set("targetTransformation", (Object)this.targetTransformation);
        state.set("geometryChecks", this.geometryChecks);
        state.set("geometryChecksAction", this.geometryChecksAction);
        state.set("tryToFixGeometry", this.tryToFixGeometry);
        state.set("geometryFieldName", this.geometryFieldName);
        state.set("geometryType", this.geometryType);
        state.set("geometrySubtype", this.geometrySubtype);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.contextProjection = (IProjection)state.get("contextProjection");
        this.sourceProjection = (IProjection)state.get("sourceProjection");
        this.targetProjection = (IProjection)state.get("targetProjection");
        this.sourceTransformation = (ICoordTrans)state.get("sourceTransformation");
        this.targetTransformation = (ICoordTrans)state.get("targetTransformation");
        this.geometryChecks = state.getInt("geometryChecks");
        this.geometryChecksAction = state.getInt("geometryChecksAction");
        this.tryToFixGeometry = state.getBoolean("tryToFixGeometry");
        this.geometryFieldName = state.getString("geometryFieldName");
        this.geometryType = state.getInt("geometryType");
        this.geometrySubtype = state.getInt("geometrySubtype");
    }

    @Override
    public ICoordTrans getTransformationToUse() {
        IProjection sourceProjection;
        FeatureAttributeDescriptor geo_att = this.getSourceFeatureType().getDefaultGeometryAttribute();
        ICoordTrans coord_trans = null;
        IProjection targetProjection = this.getTargetProjection();
        if (geo_att != null && (sourceProjection = geo_att.getSRS()) != null && targetProjection != null && sourceProjection != targetProjection) {
            coord_trans = this.getTargetTransformation() != null ? this.getTargetTransformation() : sourceProjection.getCT(targetProjection);
        }
        return coord_trans;
    }
}

