/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import workbench.console.ConsolePrinter;
import workbench.console.ConsoleSettings;
import workbench.console.TextPrinter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.RowData;
import workbench.util.StringUtil;

public class DataStorePrinter
extends ConsolePrinter {
    private final String longValueSuffix = " (...)";
    private DataStore data;
    private int maxDataLength = Integer.MAX_VALUE;

    public DataStorePrinter(DataStore dataStore) {
        this.data = dataStore;
    }

    public void setMaxDisplaySize(int n) {
        this.maxDataLength = n;
    }

    @Override
    protected String getResultName() {
        if (this.data == null) {
            return null;
        }
        return this.data.getResultName();
    }

    @Override
    protected int getColumnType(int n) {
        return this.data.getColumnType(n);
    }

    @Override
    protected String getColumnName(int n) {
        if (ConsoleSettings.useDisplayNameForColumns()) {
            return this.data.getColumnDisplayName(n);
        }
        return this.data.getColumnName(n);
    }

    @Override
    protected int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    protected Map<Integer, Integer> getColumnSizes() {
        if (!this.doFormat) {
            return null;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.data.getColumnCount(); ++i) {
            int n = this.getMaxDataWidth(i);
            int n2 = this.getDataWidthToUse(n);
            hashMap.put(i, n2);
        }
        return hashMap;
    }

    private int getMaxDataWidth(int n) {
        int n2 = this.getColumnName(n).length();
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            RowData rowData = this.data.getRow(i);
            String string = this.getDisplayValue(rowData, n);
            if (string == null) continue;
            int n3 = string.length();
            if (string.indexOf(10) > -1) {
                String string2 = StringUtil.getLongestLine(string, 25);
                n3 = string2.length();
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return this.getDataWidthToUse(n2);
    }

    private int getDataWidthToUse(int n) {
        if (this.maxDataLength <= 0) {
            return n;
        }
        return Math.min(n, this.maxDataLength);
    }

    @Override
    protected String getDisplayValue(RowData rowData, int n) {
        String string = super.getDisplayValue(rowData, n);
        if (this.maxDataLength <= 0) {
            return string;
        }
        return StringUtil.getMaxSubstring(string, this.maxDataLength - " (...)".length(), " (...)");
    }

    public void printTo(PrintStream printStream) {
        this.printTo(TextPrinter.createPrinter(new PrintWriter(printStream)), null);
    }

    public void printTo(TextPrinter textPrinter) {
        this.printTo(textPrinter, null);
    }

    public void printTo(TextPrinter textPrinter, int[] nArray) {
        int n = nArray == null ? this.data.getRowCount() : nArray.length;
        try {
            this.printHeader(textPrinter);
            for (int i = 0; i < n; ++i) {
                int n2 = nArray == null ? i : nArray[i];
                RowData rowData = this.data.getRow(n2);
                this.printRow(textPrinter, rowData, n2);
            }
            if (this.showRowCount) {
                textPrinter.println();
                textPrinter.println(ResourceMgr.getFormattedString("MsgRows", n));
            }
            textPrinter.flush();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when printing DataStore contents", exception);
        }
    }
}

