/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import workbench.util.StringUtil;

public interface TextPrinter {
    public void print(String var1);

    public void println(String var1);

    public void println();

    public void flush();

    public static TextPrinter createPrinter(final PrintWriter printWriter) {
        return new TextPrinter(){

            @Override
            public void print(String string) {
                printWriter.print(string);
            }

            @Override
            public void println(String string) {
                printWriter.println(string);
            }

            @Override
            public void println() {
                printWriter.println();
            }

            @Override
            public void flush() {
                printWriter.flush();
            }
        };
    }

    public static TextPrinter createPrinter(final StringWriter stringWriter) {
        return new TextPrinter(){

            @Override
            public void print(String string) {
                stringWriter.append(string);
            }

            @Override
            public void println(String string) {
                stringWriter.append(string);
                stringWriter.append(StringUtil.LINE_TERMINATOR);
            }

            @Override
            public void println() {
                stringWriter.append(StringUtil.LINE_TERMINATOR);
            }

            @Override
            public void flush() {
                stringWriter.flush();
            }
        };
    }
}

