/*
 * Decompiled with CFR 0.152.
 */
package workbench.console;

import java.io.IOException;
import workbench.console.JLineWrapper;
import workbench.console.SimpleConsole;
import workbench.console.SystemConsole;
import workbench.console.WbConsole;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class WbConsoleFactory {
    private static WbConsole instance;

    public static synchronized WbConsole getConsole() {
        if (instance == null) {
            if (WbConsoleFactory.useJLine()) {
                try {
                    instance = new JLineWrapper();
                    LogMgr.logDebug(new CallerInfo(){}, "Using JLine");
                    return instance;
                }
                catch (IOException iOException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not create JLineWrapper", iOException);
                    instance = null;
                }
            }
            if (System.console() != null) {
                instance = new SystemConsole();
                LogMgr.logDebug(new CallerInfo(){}, "Using System.console()");
            }
            if (instance == null) {
                instance = new SimpleConsole();
            }
        }
        return instance;
    }

    private static boolean useJLine() {
        return Settings.getInstance().getBoolProperty("workbench.console.use.jline", true);
    }
}

