/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.ComparableDbObject;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class BaseObjectType
implements ComparableDbObject {
    private String catalog;
    private String schema;
    private String typeName;
    private String objectType = "TYPE";
    private String remarks;
    private String source;
    private List<ColumnIdentifier> columns;

    public BaseObjectType(String string, String string2) {
        this.schema = string;
        this.typeName = string2;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public String getObjectName() {
        return this.typeName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.typeName;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.typeName;
    }

    @Override
    public void setName(String string) {
        this.typeName = string;
    }

    public String toString() {
        return this.getObjectName();
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        if (this.source == null && wbConnection != null) {
            return wbConnection.getMetadata().getObjectSource(this);
        }
        return this.source;
    }

    public List<ColumnIdentifier> getAttributes() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return this.columns;
    }

    public void setAttributes(List<ColumnIdentifier> list) {
        this.columns = new ArrayList<ColumnIdentifier>(list);
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    public int getNumberOfAttributes() {
        if (CollectionUtil.isEmpty(this.columns)) {
            return 0;
        }
        return this.columns.size();
    }

    @Override
    public boolean isComparableWith(DbObject dbObject) {
        return this.getClass().equals(dbObject.getClass());
    }

    @Override
    public boolean isEqualTo(DbObject dbObject) {
        if (dbObject instanceof BaseObjectType) {
            BaseObjectType baseObjectType = (BaseObjectType)dbObject;
            if (this.getNumberOfAttributes() != baseObjectType.getNumberOfAttributes()) {
                return false;
            }
            List<ColumnIdentifier> list = baseObjectType.getAttributes();
            for (ColumnIdentifier columnIdentifier : this.getAttributes()) {
                ColumnIdentifier columnIdentifier2 = ColumnIdentifier.findColumnInList(list, columnIdentifier.getColumnName());
                if (columnIdentifier2 == null) {
                    return false;
                }
                if (columnIdentifier.isEqualTo(columnIdentifier2)) continue;
                return false;
            }
            return StringUtil.equalStringOrEmpty(this.remarks, baseObjectType.remarks, false);
        }
        return false;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

