/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import workbench.db.ConnectionProfile;
import workbench.db.JdbcUtils;
import workbench.db.NoConnectionException;
import workbench.db.mssql.SqlServerClassLoader;
import workbench.db.postgres.PostgresUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class DbDriver
implements Comparable<DbDriver> {
    public static final String LIB_SEPARATOR = "|";
    private Driver driverClassInstance;
    private URLClassLoader classLoader;
    protected String name;
    private String driverClass;
    private final List<String> libraryList = new ArrayList<String>();
    private boolean isTemporary;
    private String sampleUrl;

    public DbDriver() {
    }

    public DbDriver(Driver driver) {
        this.driverClassInstance = driver;
        this.name = this.driverClass = driver.getClass().getName();
    }

    public DbDriver(String string) {
        this.setDriverClass(string);
        this.setName(string);
    }

    public DbDriver(String string, String string2, String string3) {
        this.setName(string);
        this.setDriverClass(string2);
        this.setLibrary(string3);
    }

    public boolean isTemporaryDriver() {
        return this.isTemporary;
    }

    public void setTemporary() {
        this.isTemporary = true;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public final void setDriverClass(String string) {
        this.driverClass = StringUtil.trimToNull(string);
        this.driverClassInstance = null;
        this.classLoader = null;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.name != null) {
            stringBuilder.append(this.name);
            stringBuilder.append(" (");
            stringBuilder.append(this.driverClass);
            stringBuilder.append(')');
        } else {
            stringBuilder.append(this.driverClass);
        }
        return stringBuilder.toString();
    }

    public void setLibraryList(List<String> list) {
        this.libraryList.clear();
        if (CollectionUtil.isNonEmpty(list)) {
            this.libraryList.addAll(list);
        }
    }

    public List<String> getRealLibraryList() {
        return Collections.unmodifiableList(this.libraryList);
    }

    public List<String> getLibraryList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.libraryList.size());
        ClasspathUtil classpathUtil = new ClasspathUtil();
        for (String string : this.libraryList) {
            if (string.endsWith("ext")) {
                arrayList.add("ext");
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> splitLibraryList(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        if (string.contains(LIB_SEPARATOR)) {
            return StringUtil.stringToList(string, LIB_SEPARATOR, true, true, false);
        }
        if (!StringUtil.isEmptyString(string)) {
            return StringUtil.stringToList(string, StringUtil.getPathSeparator(), true, true, false);
        }
        return Collections.emptyList();
    }

    public final void setLibrary(String string) {
        this.libraryList.clear();
        this.libraryList.addAll(DbDriver.splitLibraryList(string));
        this.driverClassInstance = null;
        this.classLoader = null;
    }

    public boolean canReadLibrary() {
        if (Settings.getInstance().isTestMode()) {
            return true;
        }
        if (this.isTemporary) {
            return true;
        }
        if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(this.driverClass)) {
            return true;
        }
        ClasspathUtil classpathUtil = new ClasspathUtil();
        WbFile wbFile = classpathUtil.getExtDir();
        if (this.libraryList != null) {
            for (String string : this.libraryList) {
                String string2 = Settings.getInstance().replaceLibDirKey(string);
                if ("ext".equals(string2)) {
                    return true;
                }
                File file = new File(string2);
                if (file.equals(wbFile)) {
                    return true;
                }
                if (file.getParentFile() == null && !(file = new File(Settings.getInstance().getLibDir(), string2)).exists()) {
                    file = new File(wbFile, string2);
                }
                if (file.exists()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDescription();
    }

    public void setSampleUrl(String string) {
        this.sampleUrl = string;
    }

    public String getSampleUrl() {
        return this.sampleUrl;
    }

    public Class loadClassFromDriverLib(String string) throws ClassNotFoundException {
        if (this.isExtDriver()) {
            return Class.forName(string);
        }
        if (this.classLoader == null) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Class<?> clazz = this.classLoader.loadClass(string);
        return clazz;
    }

    public boolean isExtDriver() {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        for (String string : this.libraryList) {
            if (string.contains("%LibDir%")) {
                return false;
            }
            if (string.equals("ext")) {
                return true;
            }
            File file = new File(string);
            if (file.getParentFile() != null && !file.isAbsolute() || classpathUtil.isInExtDir(file)) continue;
            return false;
        }
        return true;
    }

    private URLClassLoader createClassLoader(URL[] uRLArray) {
        if (!"com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(this.driverClass)) {
            return new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
        }
        return new SqlServerClassLoader(this.buildFile(this.libraryList.get(0)), uRLArray, ClassLoader.getSystemClassLoader());
    }

    private synchronized void loadDriverClass() throws ClassNotFoundException, Exception, UnsupportedClassVersionError {
        if (this.driverClassInstance != null) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            Object object;
            if (!this.isExtDriver() && this.classLoader == null && CollectionUtil.isNonEmpty(this.libraryList)) {
                object = new URL[this.libraryList.size()];
                int n = 0;
                for (String string : this.libraryList) {
                    WbFile wbFile = this.buildFile(string);
                    object[n] = wbFile.toURI().toURL();
                    LogMgr.logInfo(callerInfo, "Adding ClassLoader URL=" + ((URL)object[n]).toString());
                    ++n;
                }
                this.classLoader = this.createClassLoader((URL[])object);
            }
            object = null;
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                object = this.classLoader.loadClass(this.driverClass);
            } else {
                LogMgr.logInfo(callerInfo, "Loading driver " + this.driverClass + " through default classloader");
                object = Class.forName(this.driverClass);
            }
            this.driverClassInstance = (Driver)((Class)object).newInstance();
            if (Settings.getInstance().getBoolProperty("workbench.db.registerdriver", false)) {
                try {
                    LogMgr.logDebug(callerInfo, "Registering new driver instance for " + this.driverClass + " with DriverManager");
                    DriverManager.registerDriver(this.driverClassInstance);
                }
                catch (Throwable throwable) {
                    LogMgr.logError(callerInfo, "Error registering driver instance with DriverManager", throwable);
                }
            }
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            LogMgr.logError(callerInfo, "Driver class could not be loaded because it's intended for a different Java version", unsupportedClassVersionError);
            throw unsupportedClassVersionError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogMgr.logError(callerInfo, "Class not found when loading driver through using the classpath: " + this.libraryList, classNotFoundException);
            throw classNotFoundException;
        }
        catch (Throwable throwable) {
            this.classLoader = null;
            LogMgr.logError(callerInfo, "Error loading driver class: " + this.driverClass, throwable);
            throw new Exception("Could not load driver class " + this.driverClass, throwable);
        }
    }

    private WbFile buildFile(String string) {
        String string2 = Settings.getInstance().replaceLibDirKey(string);
        WbFile wbFile = new WbFile(string2);
        if (wbFile.getParentFile() == null) {
            wbFile = new WbFile(Settings.getInstance().getLibDir(), string2);
        }
        return wbFile;
    }

    public DbDriver createCopy() {
        DbDriver dbDriver = new DbDriver();
        dbDriver.driverClass = this.driverClass;
        dbDriver.libraryList.addAll(this.libraryList);
        dbDriver.sampleUrl = this.sampleUrl;
        dbDriver.name = this.name;
        return dbDriver;
    }

    private boolean useEmptyStringForEmptyPassword() {
        return Settings.getInstance().getBoolProperty(this.driverClass + ".use.emptypassword", false);
    }

    private boolean useEmptyStringForEmptyUser() {
        return Settings.getInstance().getBoolProperty(this.driverClass + ".use.emptyuser", false);
    }

    public Connection connect(String string, String string2, String string3, String string4, Properties properties) throws ClassNotFoundException, NoConnectionException, SQLException {
        String string5 = DbDriver.getURLForLogging(string);
        String string6 = DbDriver.getUsernameForLogging(string2);
        CallerInfo callerInfo = new CallerInfo(){};
        Connection connection = null;
        try {
            Object object;
            this.loadDriverClass();
            Properties properties2 = new Properties();
            if (StringUtil.isNonBlank(string2)) {
                properties2.put("user", string2);
            } else if (this.useEmptyStringForEmptyUser()) {
                properties2.put("user", "");
            }
            if (StringUtil.isNonBlank(string3)) {
                properties2.put("password", string3);
            } else if (this.useEmptyStringForEmptyPassword()) {
                properties2.put("password", "");
            }
            if (properties != null) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    String string7 = (String)object.nextElement();
                    if (properties2.containsKey(string7)) continue;
                    String string8 = StringUtil.replaceProperties(properties.getProperty(string7));
                    properties2.put(string7, string8);
                }
            }
            if (string.startsWith("jdbc:mysql") && Settings.getInstance().getBoolProperty("workbench.db.mysql.tablecomments.retrieve", false) && !properties2.containsKey("useInformationSchema")) {
                properties2.setProperty("useInformationSchema", "true");
            }
            this.setAppInfo(properties2, string.toLowerCase(), string4, string2);
            connection = this.driverClassInstance.connect(string, properties2);
            if (this.doSetAppName(string)) {
                if (string.startsWith("jdbc:firebirdsql:")) {
                    System.clearProperty("org.firebirdsql.jdbc.processName");
                }
                if (string.startsWith("jdbc:postgresql") && !properties2.containsKey("ApplicationName")) {
                    PostgresUtil.setApplicationName(connection, this.getProgramName() + " (" + string4 + ")");
                }
                if (string.startsWith("jdbc:sap:") && this.doSetAppName(string)) {
                    connection.setClientInfo("APPLICATION", StringUtil.coalesce(this.getAppName(), "SQL Workbench/J"));
                    connection.setClientInfo("APPLICATIONSOURCE", string4);
                    connection.setClientInfo("APPLICATIONVERSION", ResourceMgr.getBuildNumber().toString());
                    object = System.getProperty("user.name");
                    if (object != null) {
                        connection.setClientInfo("APPLICATIONUSER", (String)object);
                    }
                }
            }
        }
        catch (ClassNotFoundException | UnsupportedClassVersionError throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            LogMgr.logError(callerInfo, "Error connecting to the database using URL=" + string5 + ", username=" + string6, throwable);
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(throwable.getMessage(), throwable);
        }
        if (connection == null) {
            LogMgr.logError(callerInfo, "No connection returned by driver " + this.driverClass + " for URL=" + string5, null);
            throw new NoConnectionException("Driver did not return a connection for url=" + string5);
        }
        return connection;
    }

    public void releaseDriverInstance() {
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logDebug(callerInfo, "Releasing classloader and driver");
        if (this.driverClassInstance != null) {
            try {
                DriverManager.deregisterDriver(this.driverClassInstance);
            }
            catch (SQLException sQLException) {
                LogMgr.logWarning(callerInfo, "Could not de-register driver", sQLException);
            }
            this.driverClassInstance = null;
        }
        this.classLoader = null;
        System.gc();
    }

    private String getAppName() {
        return Settings.getInstance().getProperty("workbench.db.connection.info.programname", null);
    }

    private String getProgramName() {
        String string = this.getAppName();
        if (string != null) {
            return string;
        }
        return "SQL Workbench/J " + ResourceMgr.getBuildNumber();
    }

    private boolean doSetAppName(String string) {
        String string2 = JdbcUtils.getDbIdFromUrl(string);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.connection.set.appname", true);
        return Settings.getInstance().getBoolProperty("workbench.db." + string2 + ".connection.set.appname", bl);
    }

    private void setAppInfo(Properties properties, String string, String string2, String string3) {
        String string4;
        if (!this.doSetAppName(string)) {
            return;
        }
        String string5 = null;
        String string6 = this.getProgramName();
        if (string.startsWith("jdbc:postgresql") && PostgresUtil.supportsAppInfoProperty(this.driverClassInstance.getClass())) {
            string5 = "ApplicationName";
            string6 = string6 + " (" + string2 + ")";
        }
        if (string.startsWith("jdbc:oracle:thin")) {
            string5 = "v$session.program";
            if (string2 != null && !properties.containsKey("v$session.terminal")) {
                properties.put("v$session.terminal", StringUtil.getMaxSubstring(string2, 30));
            }
            if ((string3 = System.getProperty("user.name", null)) != null && !properties.containsKey("v$session.osuser")) {
                properties.put("v$session.osuser", string3);
            }
        }
        if (string.startsWith("jdbc:inetdae")) {
            string5 = "appname";
        }
        if (string.startsWith("jdbc:jtds")) {
            string5 = "APPNAME";
        }
        if (string.startsWith("jdbc:microsoft:sqlserver")) {
            string5 = "ProgramName";
        }
        if (string.startsWith("jdbc:sqlserver:")) {
            string5 = "applicationName";
            if (!properties.containsKey("workstationID") && (string4 = this.getLocalHostname()) != null) {
                properties.put("workstationID", string4);
            }
        }
        if (string.startsWith("jdbc:db2:")) {
            properties.put("clientApplicationInformation", string2);
            string5 = "clientProgramName";
        }
        if (string.startsWith("jdbc:firebirdsql:")) {
            System.setProperty("org.firebirdsql.jdbc.processName", StringUtil.getMaxSubstring(string6, 250));
        }
        if (string.startsWith("jdbc:sybase:tds")) {
            string5 = "APPLICATIONNAME";
        }
        if (string5 == null) {
            string4 = JdbcUtils.getDbIdFromUrl(string);
            string5 = Settings.getInstance().getProperty("workbench.db." + string4 + ".connection.property.appname", null);
        }
        if (string5 != null && !properties.containsKey(string5)) {
            properties.put(string5, string6);
        }
    }

    private String getLocalHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            if (string == null) {
                string = inetAddress.getHostAddress();
            }
            return string;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void commandConnect(String string) throws SQLException, ClassNotFoundException, Exception {
        this.loadDriverClass();
        Properties properties = new Properties();
        LogMgr.logDebug(new CallerInfo(){}, "Sending command URL=" + DbDriver.getURLForLogging(string) + " to database");
        this.driverClassInstance.connect(string, properties);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.driverClass == null) {
            return false;
        }
        if (object instanceof DbDriver) {
            DbDriver dbDriver = (DbDriver)object;
            return StringUtil.equalString(dbDriver.getId(), this.getId());
        }
        if (object instanceof String) {
            return StringUtil.equalString(this.driverClass, (String)object);
        }
        return false;
    }

    protected String getId() {
        StringBuilder stringBuilder = new StringBuilder(this.driverClass == null ? this.name.length() : this.driverClass.length() + this.name.length() + 1);
        stringBuilder.append(this.driverClass == null ? "" : this.driverClass);
        stringBuilder.append('$');
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(DbDriver dbDriver) {
        return this.getId().compareTo(dbDriver.getId());
    }

    public static String getURLForLogging(ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return "";
        }
        return DbDriver.getURLForLogging(connectionProfile.getUrl());
    }

    public static String getURLForLogging(String string) {
        if (string == null) {
            return "";
        }
        if (Settings.getInstance().getObfuscateDbInformation()) {
            return JdbcUtils.extractPrefix(string) + "******";
        }
        return string;
    }

    public static String getUsernameForLogging(String string) {
        if (string == null) {
            return "";
        }
        if (Settings.getInstance().getObfuscateDbInformation()) {
            return "****";
        }
        return string;
    }
}

