/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import workbench.db.DBID;
import workbench.db.JdbcDbSwitcher;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleDatabaseSwitcher;
import workbench.db.postgres.PostgresDatabaseSwitcher;

public interface DbSwitcher {
    public boolean supportsSwitching(WbConnection var1);

    public boolean needsReconnect();

    public boolean switchDatabase(WbConnection var1, String var2) throws SQLException;

    public String getUrlForDatabase(String var1, String var2);

    public List<String> getAvailableDatabases(WbConnection var1);

    public String getCurrentDatabase(WbConnection var1);

    public static class Factory {
        public static DbSwitcher createDatabaseSwitcher(WbConnection wbConnection) {
            if (wbConnection == null) {
                return null;
            }
            DBID dBID = DBID.fromConnection(wbConnection);
            switch (dBID) {
                case Postgres: {
                    return new PostgresDatabaseSwitcher();
                }
                case Oracle: {
                    return new OracleDatabaseSwitcher();
                }
                case SQL_Server: 
                case MySQL: 
                case MariaDB: {
                    return new JdbcDbSwitcher();
                }
            }
            return null;
        }
    }
}

