/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.FKHandler;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;

public class DefaultFKHandler
implements FKHandler {
    protected final WbConnection dbConnection;
    private boolean cancel;
    protected boolean containsStatusCol;
    protected boolean supportsStatus;

    protected DefaultFKHandler(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public boolean containsStatusColumn() {
        return this.containsStatusCol;
    }

    @Override
    public boolean supportsStatus() {
        return this.containsStatusCol;
    }

    @Override
    public DataStore getExportedKeys(TableIdentifier tableIdentifier) throws SQLException {
        return this.getRawKeyList(tableIdentifier, true);
    }

    @Override
    public DataStore getImportedKeys(TableIdentifier tableIdentifier) throws SQLException {
        return this.getRawKeyList(tableIdentifier, false);
    }

    @Override
    public DataStore getForeignKeys(TableIdentifier tableIdentifier, boolean bl) {
        DataStore dataStore = this.getKeyList(tableIdentifier, true, bl);
        return dataStore;
    }

    @Override
    public DataStore getReferencedBy(TableIdentifier tableIdentifier) {
        DataStore dataStore = this.getKeyList(tableIdentifier, false, false);
        return dataStore;
    }

    protected WbConnection getConnection() {
        return this.dbConnection;
    }

    protected DataStore getRawKeyList(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        if (this.dbConnection == null) {
            return null;
        }
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        DatabaseMetaData databaseMetaData = this.dbConnection.getSqlConnection().getMetaData();
        this.cancel = false;
        ResultSet resultSet = bl ? databaseMetaData.getExportedKeys(tableIdentifier2.getRawCatalog(), tableIdentifier2.getRawSchema(), tableIdentifier2.getRawTableName()) : databaseMetaData.getImportedKeys(tableIdentifier2.getRawCatalog(), tableIdentifier2.getRawSchema(), tableIdentifier2.getRawTableName());
        return this.processResult(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataStore processResult(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        DataStore dataStore = new DataStore(resultSet, false);
        boolean bl = this.dbConnection.getDbSettings().useColumnNameForMetadata();
        int n = -1;
        int n2 = -1;
        if (this.containsStatusCol) {
            n = JdbcUtils.getColumnIndex(resultSet, "ENABLED");
            n2 = JdbcUtils.getColumnIndex(resultSet, "VALIDATED");
        }
        try {
            while (resultSet.next()) {
                if (this.cancel) {
                    LogMgr.logWarning(new CallerInfo(){}, "Processing of rows has been cancelled");
                    break;
                }
                int n3 = dataStore.addRow();
                dataStore.setValue(n3, 0, (Object)(bl ? resultSet.getString("PKTABLE_CAT") : resultSet.getString(1)));
                dataStore.setValue(n3, 1, (Object)(bl ? resultSet.getString("PKTABLE_SCHEM") : resultSet.getString(2)));
                dataStore.setValue(n3, 2, (Object)(bl ? resultSet.getString("PKTABLE_NAME") : resultSet.getString(3)));
                dataStore.setValue(n3, 3, (Object)(bl ? resultSet.getString("PKCOLUMN_NAME") : resultSet.getString(4)));
                dataStore.setValue(n3, 4, (Object)(bl ? resultSet.getString("FKTABLE_CAT") : resultSet.getString(5)));
                dataStore.setValue(n3, 5, (Object)(bl ? resultSet.getString("FKTABLE_SCHEM") : resultSet.getString(6)));
                dataStore.setValue(n3, 6, (Object)(bl ? resultSet.getString("FKTABLE_NAME") : resultSet.getString(7)));
                dataStore.setValue(n3, 7, (Object)(bl ? resultSet.getString("FKCOLUMN_NAME") : resultSet.getString(8)));
                dataStore.setValue(n3, 8, (Object)(bl ? resultSet.getInt("KEY_SEQ") : resultSet.getInt(9)));
                int n4 = this.fixRule(bl ? resultSet.getInt("UPDATE_RULE") : resultSet.getInt(10));
                dataStore.setValue(n3, 9, (Object)n4);
                int n5 = this.fixRule(bl ? resultSet.getInt("DELETE_RULE") : resultSet.getInt(11));
                dataStore.setValue(n3, 10, (Object)n5);
                dataStore.setValue(n3, 11, (Object)(bl ? resultSet.getString("FK_NAME") : resultSet.getString(12)));
                dataStore.setValue(n3, 12, (Object)(bl ? resultSet.getString("PK_NAME") : resultSet.getString(13)));
                int n6 = this.fixDeferrableRule(bl ? resultSet.getInt("DEFERRABILITY") : resultSet.getInt(14));
                dataStore.setValue(n3, 13, (Object)n6);
                if (n <= 0) continue;
                dataStore.setValue(n3, n - 1, (Object)resultSet.getString(n));
                dataStore.setValue(n3, n2 - 1, (Object)resultSet.getString(n2));
            }
            dataStore.resetStatus();
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        return dataStore;
    }

    private int fixDeferrableRule(int n) {
        if (n != 5 && n != 6) {
            return 7;
        }
        return n;
    }

    private int fixRule(int n) {
        if (n != 0 && n != 1 && n != 4 && n != 2) {
            return 3;
        }
        return n;
    }

    @Override
    public DataStore createDisplayDataStore(String string, boolean bl) {
        String[] stringArray = new String[]{"FK_NAME", "COLUMN", string, "UPDATE_RULE", "DELETE_RULE", "DEFERRABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12};
        int[] nArray2 = new int[]{25, 10, 30, 10, 12, 12, 15};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        if (this.supportsStatus()) {
            dataStore.addColumn(new ColumnIdentifier("ENABLED", 12, 5));
            dataStore.addColumn(new ColumnIdentifier("VALIDATED", 12, 5));
        }
        if (bl) {
            dataStore.addColumn(new ColumnIdentifier("UPDATE_RULE_VALUE", 4, 1));
            dataStore.addColumn(new ColumnIdentifier("DELETE_RULE_VALUE", 4, 1));
            dataStore.addColumn(new ColumnIdentifier("DEFER_RULE_VALUE", 4, 1));
        }
        return dataStore;
    }

    protected DataStore getKeyList(TableIdentifier tableIdentifier, boolean bl, boolean bl2) {
        if (this.cancel) {
            return null;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        String string = bl ? "REFERENCES" : "REFERENCED BY";
        DataStore dataStore = this.createDisplayDataStore(string, bl2);
        if (tableIdentifier == null) {
            return dataStore;
        }
        DataStore dataStore2 = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = 10;
            int n8 = 9;
            if (bl) {
                dataStore2 = this.getRawKeyList(tableIdentifier, false);
                n6 = 2;
                n5 = 1;
                n4 = 0;
                n3 = 11;
                n2 = 7;
                n = 3;
            } else {
                dataStore2 = this.getRawKeyList(tableIdentifier, true);
                n6 = 6;
                n5 = 5;
                n4 = 4;
                n3 = 11;
                n2 = 3;
                n = 7;
            }
            if (dataStore2 == null) {
                this.cancel = true;
                return null;
            }
            for (int i = 0; i < dataStore2.getRowCount(); ++i) {
                String string2 = dataStore2.getValueAsString(i, n6);
                String string3 = dataStore2.getValueAsString(i, n5);
                String string4 = dataStore2.getValueAsString(i, n4);
                TableIdentifier tableIdentifier2 = new TableIdentifier(string4, string3, string2, false);
                tableIdentifier2.setNeverAdjustCase(true);
                String string5 = tableIdentifier2.getTableExpression(this.dbConnection);
                String string6 = dataStore2.getValueAsString(i, n);
                String string7 = dataStore2.getValueAsString(i, n2);
                String string8 = dataStore2.getValueAsString(i, n3);
                int n9 = dataStore2.getValueAsInt(i, n8, 3);
                String string9 = dbSettings.getRuleDisplay(n9);
                int n10 = dataStore2.getValueAsInt(i, n7, 3);
                String string10 = dbSettings.getRuleDisplay(n10);
                int n11 = dataStore2.getValueAsInt(i, 13, 3);
                String string11 = dbSettings.getRuleDisplay(n11);
                int n12 = dataStore.addRow();
                dataStore.setValue(n12, 0, (Object)string8.trim());
                dataStore.setValue(n12, 1, (Object)string7.trim());
                dataStore.setValue(n12, 2, (Object)(string5 + "." + string6));
                dataStore.setValue(n12, 3, (Object)string9);
                dataStore.setValue(n12, 4, (Object)string10);
                dataStore.setValue(n12, 5, (Object)string11);
                if (bl2) {
                    dataStore.setValue(n12, 9, (Object)n10);
                    dataStore.setValue(n12, 8, (Object)n9);
                    dataStore.setValue(n12, 10, (Object)n11);
                }
                if (this.containsStatusCol) {
                    dataStore.setValue(n12, 6, dataStore2.getValue(i, "ENABLED"));
                    dataStore.setValue(n12, 7, dataStore2.getValue(i, "VALIDATED"));
                }
                if (!this.cancel) continue;
                LogMgr.logWarning(new CallerInfo(){}, "Processing of rows has been cancelled");
                break;
            }
            dataStore.resetStatus();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving foreign keys", exception);
            dataStore.reset();
        }
        return dataStore;
    }

    @Override
    public FKHandler.FkStatusInfo getFkEnabledFlag(TableIdentifier tableIdentifier, String string) {
        return null;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }
}

