/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSearchPath;
import workbench.db.DbSettings;
import workbench.db.GetMetaDataSql;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class JdbcProcedureReader
implements ProcedureReader {
    protected final WbConnection connection;
    protected boolean useSavepoint;

    public JdbcProcedureReader(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public StringBuilder getProcedureHeader(ProcedureDefinition procedureDefinition) {
        return StringUtil.emptyBuilder();
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        Savepoint savepoint = null;
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(new CallerInfo(){}, "Calling getProcedures() using: catalog=" + string + ", schema=" + string2 + ", name=" + string3);
            }
            ResultSet resultSet = this.connection.getSqlConnection().getMetaData().getProcedures(string, string2, string3);
            if (Settings.getInstance().getBoolProperty("workbench.db.procreader.debug", false)) {
                SqlUtil.dumpResultSetInfo("getProcedures()", resultSet.getMetaData());
            }
            DataStore dataStore = this.fillProcedureListDataStore(resultSet);
            if (this.connection.getDbSettings().useGetFunctions()) {
                LogMgr.logDebug(new CallerInfo(){}, "Calling getFunctions() to get additional functions");
                resultSet = this.connection.getSqlConnection().getMetaData().getProcedures(string, string2, string3);
                if (Settings.getInstance().getBoolProperty("workbench.db.procreader.debug", false)) {
                    SqlUtil.dumpResultSetInfo("getFunctions()", resultSet.getMetaData());
                }
                boolean bl = JdbcUtils.getColumnIndex(resultSet, "SPECIFIC_NAME") > -1;
                this.fillProcedureListDataStore(resultSet, dataStore, bl);
                dataStore.sort(JdbcProcedureReader.getProcedureListSort());
            }
            this.connection.releaseSavepoint(savepoint);
            dataStore.resetStatus();
            return dataStore;
        }
        catch (SQLException sQLException) {
            this.connection.rollback(savepoint);
            throw sQLException;
        }
    }

    public DataStore buildProcedureListDataStore(DbMetadata dbMetadata, boolean bl) {
        String[] stringArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (bl) {
            stringArray = new String[]{"PROCEDURE_NAME", "TYPE", dbMetadata.getCatalogTerm().toUpperCase(), dbMetadata.getSchemaTerm().toUpperCase(), "REMARKS", "SPECIFIC_NAME"};
            nArray = new int[]{12, 12, 12, 12, 12, 12};
            nArray2 = new int[]{30, 12, 10, 10, 20, 50};
        } else {
            stringArray = new String[]{"PROCEDURE_NAME", "TYPE", dbMetadata.getCatalogTerm().toUpperCase(), dbMetadata.getSchemaTerm().toUpperCase(), "REMARKS"};
            nArray = new int[]{12, 12, 12, 12, 12};
            nArray2 = new int[]{30, 12, 10, 10, 20};
        }
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        return dataStore;
    }

    public static SortDefinition getProcedureListSort() {
        SortDefinition sortDefinition = new SortDefinition();
        sortDefinition.addSortColumn(2, true);
        sortDefinition.addSortColumn(3, true);
        sortDefinition.addSortColumn(0, true);
        return sortDefinition;
    }

    public DataStore fillProcedureListDataStore(ResultSet resultSet) throws SQLException {
        int n = JdbcUtils.getColumnIndex(resultSet, "SPECIFIC_NAME");
        boolean bl = n > -1;
        DataStore dataStore = this.buildProcedureListDataStore(this.connection.getMetadata(), bl);
        this.fillProcedureListDataStore(resultSet, dataStore, bl);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillProcedureListDataStore(ResultSet resultSet, DataStore dataStore, boolean bl) throws SQLException {
        try {
            while (resultSet.next()) {
                String string = resultSet.getString("PROCEDURE_CAT");
                String string2 = resultSet.getString("PROCEDURE_SCHEM");
                String string3 = resultSet.getString("PROCEDURE_NAME");
                String string4 = resultSet.getString("REMARKS");
                Integer n = this.getProcedureType(resultSet);
                int n2 = dataStore.addRow();
                String string5 = this.stripProcGroupInfo(string3);
                ProcedureDefinition procedureDefinition = new ProcedureDefinition(string, string2, string5, n);
                procedureDefinition.setComment(string4);
                if (bl) {
                    String string6 = resultSet.getString("SPECIFIC_NAME");
                    dataStore.setValue(n2, 5, (Object)string6);
                    procedureDefinition.setSpecificName(string6);
                }
                dataStore.setValue(n2, 2, (Object)string);
                dataStore.setValue(n2, 3, (Object)string2);
                dataStore.setValue(n2, 0, (Object)string5);
                dataStore.setValue(n2, 1, (Object)n);
                dataStore.setValue(n2, 4, (Object)string4);
                dataStore.getRow(n2).setUserObject(procedureDefinition);
            }
            dataStore.resetStatus();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error while retrieving procedures", exception);
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
    }

    protected Integer getProcedureType(ResultSet resultSet) throws SQLException {
        int n = resultSet.getInt("PROCEDURE_TYPE");
        Integer n2 = resultSet.wasNull() || n == 0 ? Integer.valueOf(1) : Integer.valueOf(n);
        return n2;
    }

    public static String convertProcTypeToSQL(int n) {
        switch (n) {
            case 1: {
                return "NO RESULT";
            }
            case 2: {
                return "RESULT";
            }
        }
        return "";
    }

    protected DataStore createProcColsDataStore() {
        String[] stringArray = new String[]{"COLUMN_NAME", "TYPE", "TYPE_NAME", "JDBC Type", "REMARKS", "POSITION"};
        int[] nArray = new int[]{12, 12, 12, 4, 12, 4};
        int[] nArray2 = new int[]{5, 20, 10, 18, 5, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        return dataStore;
    }

    protected String stripProcGroupInfo(String string) {
        if (string == null) {
            return null;
        }
        DbSettings dbSettings = this.connection.getDbSettings();
        if (!dbSettings.getStripProcGroupNumber()) {
            return string;
        }
        String string2 = dbSettings.getProcGroupDelimiter();
        if (StringUtil.isEmptyString(string2)) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    public void readProcedureParameters(ProcedureDefinition procedureDefinition) throws SQLException {
        DataStore dataStore = this.getProcedureColumns(procedureDefinition);
        this.updateProcedureParameters(procedureDefinition, dataStore);
    }

    protected void updateProcedureParameters(ProcedureDefinition procedureDefinition, DataStore dataStore) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 1);
            String string2 = dataStore.getValueAsString(i, 0);
            if (string2 == null) {
                string2 = "";
            }
            String string3 = dataStore.getValueAsString(i, 2);
            int n = dataStore.getValueAsInt(i, 3, 1111);
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2, n);
            columnIdentifier.setArgumentMode(string);
            columnIdentifier.setDbmsType(string3);
            arrayList.add(columnIdentifier);
        }
        procedureDefinition.setParameters(arrayList);
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        boolean bl = procedureDefinition.isFunction() && this.connection.getDbSettings().useGetFunctions();
        DataStore dataStore = this.getProcedureColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), procedureDefinition.getProcedureName(), procedureDefinition.getSpecificName(), bl);
        this.updateProcedureParameters(procedureDefinition, dataStore);
        return dataStore;
    }

    public DataStore getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.getProcedureColumns(string, string2, string3, string4, false);
    }

    private DataStore getProcedureColumns(String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        DataStore dataStore = this.createProcColsDataStore();
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            String string5;
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            resultSet = bl ? this.connection.getSqlConnection().getMetaData().getFunctionColumns(string, string2, string3, "%") : this.connection.getSqlConnection().getMetaData().getProcedureColumns(string, string2, string3, "%");
            if (Settings.getInstance().getBoolProperty("workbench.db.procreader.debug", false)) {
                SqlUtil.dumpResultSetInfo("getProcedureColumns()", resultSet.getMetaData());
            }
            int n = -1;
            boolean bl2 = false;
            if (this.connection.getDbSettings().useSpecificNameForProcedureColumns()) {
                string5 = this.connection.getDbSettings().getSpecificNameColumn();
                n = JdbcUtils.getColumnIndex(resultSet, string5);
                boolean bl3 = bl2 = n > -1 && StringUtil.isNonEmpty(string4);
            }
            while (resultSet.next()) {
                if (bl2 && StringUtil.stringsAreNotEqual(string5 = resultSet.getString(n), string4)) continue;
                this.processProcedureColumnResultRow(dataStore, resultSet);
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.connection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.closeResult(resultSet);
        return dataStore;
    }

    protected void processProcedureColumnResultRow(DataStore dataStore, ResultSet resultSet) throws SQLException {
        this.processProcedureColumnResultRow(dataStore, resultSet, false);
    }

    protected String convertArgModeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "UNKNOWN";
                break;
            }
            case 2: {
                string = "INOUT";
                break;
            }
            case 1: {
                string = "IN";
                break;
            }
            case 4: {
                string = "OUT";
                break;
            }
            case 3: {
                string = "RESULTSET";
                break;
            }
            case 5: {
                string = "RETURN";
                break;
            }
            default: {
                string = NumberStringCache.getNumberString(n);
            }
        }
        return string;
    }

    protected void processProcedureColumnResultRow(DataStore dataStore, ResultSet resultSet, boolean bl) throws SQLException {
        int n;
        int n2 = dataStore.addRow();
        String string = bl ? resultSet.getString(4) : resultSet.getString("COLUMN_NAME");
        dataStore.setValue(n2, 0, (Object)string);
        int n3 = bl ? resultSet.getInt(5) : resultSet.getInt("COLUMN_TYPE");
        String string2 = this.convertArgModeToString(n3);
        dataStore.setValue(n2, 1, (Object)string2);
        int n4 = bl ? resultSet.getInt(6) : resultSet.getInt("DATA_TYPE");
        String string3 = bl ? resultSet.getString(7) : resultSet.getString("TYPE_NAME");
        int n5 = bl ? resultSet.getInt(8) : resultSet.getInt("PRECISION");
        int n6 = bl ? resultSet.getInt(9) : resultSet.getInt("LENGTH");
        int n7 = n = bl ? resultSet.getInt(10) : resultSet.getInt("SCALE");
        if (resultSet.wasNull()) {
            n = -1;
        }
        if (n4 == 1111 && string3.equals("BINARY_INTEGER")) {
            n4 = 4;
        }
        int n8 = 0;
        int n9 = 0;
        if (SqlUtil.isNumberType(n4)) {
            n8 = n5;
            n9 = n == -1 ? 0 : n;
        } else {
            n8 = n6;
            n9 = 0;
        }
        String string4 = bl ? resultSet.getString(13) : resultSet.getString("REMARKS");
        int n10 = -1;
        try {
            n10 = bl ? resultSet.getInt(18) : resultSet.getInt("ORDINAL_POSITION");
        }
        catch (Exception exception) {
            n10 = n2;
        }
        String string5 = this.connection.getMetadata().getDataTypeResolver().getSqlTypeDisplay(string3, n4, n8, n9);
        dataStore.setValue(n2, 5, (Object)n10);
        dataStore.setValue(n2, 2, (Object)string5);
        dataStore.setValue(n2, 3, (Object)n4);
        dataStore.setValue(n2, 4, (Object)string4);
    }

    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        this.readProcedureSource(procedureDefinition, null, null);
    }

    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition, String string, String string2) throws NoConfigException {
        Object object;
        String string3;
        String string4;
        if (procedureDefinition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        String string5 = Settings.getInstance().getInternalEditorLineEnding();
        CharSequence charSequence = this.retrieveProcedureSource(procedureDefinition);
        StringBuilder stringBuilder2 = this.getProcedureHeader(procedureDefinition);
        if (stringBuilder2 != null && stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append(charSequence);
        DelimiterDefinition delimiterDefinition = this.connection.getAlternateDelimiter();
        if (delimiterDefinition != null && !StringUtil.endsWith((CharSequence)stringBuilder, delimiterDefinition.getDelimiter())) {
            if (delimiterDefinition.isSingleLine()) {
                stringBuilder.append(string5);
            }
            stringBuilder.append(delimiterDefinition.getDelimiter());
            if (delimiterDefinition.isSingleLine()) {
                stringBuilder.append(string5);
            }
        }
        if (StringUtil.isNonBlank(string4 = procedureDefinition.getComment()) && StringUtil.isNonBlank(string3 = ((CommentSqlManager)(object = new CommentSqlManager(this.connection.getDbSettings().getDbId()))).getCommentSqlTemplate(procedureDefinition.getObjectType(), "set"))) {
            string3 = string3.replace("%object_name%", procedureDefinition.getProcedureName());
            string3 = string3.replace("%specific_name%", procedureDefinition.getSpecificName());
            string3 = string2 != null ? string3.replace("%schema%", string2) : string3.replace("%schema%", procedureDefinition.getSchema());
            string3 = string != null ? string3.replace("%catalog%", string) : string3.replace("%catalog%", procedureDefinition.getCatalog());
            string3 = string3.replace("%comment%", string4.replace("'", "''"));
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            stringBuilder.append(string5);
            if (!string3.endsWith(";")) {
                stringBuilder.append(delimiterDefinition.getDelimiter());
                if (delimiterDefinition.isSingleLine()) {
                    stringBuilder.append(string5);
                }
            }
        }
        object = stringBuilder;
        boolean bl = this.connection.getDbSettings().getBoolProperty("replacenl.proceduresource", false);
        if (bl) {
            object = StringUtil.replace(stringBuilder.toString(), "\\n", string5);
        }
        procedureDefinition.setSource((CharSequence)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CharSequence retrieveProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        GetMetaDataSql getMetaDataSql = this.connection.getMetadata().getMetaDataSQLMgr().getProcedureSourceSql();
        if (getMetaDataSql == null) {
            throw new NoConfigException("No sql configured to retrieve procedure source");
        }
        String string = this.stripProcGroupInfo(procedureDefinition.getProcedureName());
        StringBuilder stringBuilder = new StringBuilder(500);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            getMetaDataSql.setSchema(procedureDefinition.getSchema());
            getMetaDataSql.setObjectName(string);
            getMetaDataSql.setCatalog(procedureDefinition.getCatalog());
            getMetaDataSql.setSpecificName(procedureDefinition.getSpecificName());
            getMetaDataSql.setInternalId(procedureDefinition.getInternalIdentifier());
            String string2 = getMetaDataSql.getSql();
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logInfo(new CallerInfo(){}, "Retrieving procedure source using query:\n" + string2);
            }
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (string3 == null) continue;
                stringBuilder.append(string3);
            }
            this.connection.releaseSavepoint(savepoint);
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (SQLException sQLException) {
            if (savepoint != null) {
                this.connection.rollback(savepoint);
            }
            LogMgr.logError(new CallerInfo(){}, "Error retrieving procedure source", sQLException);
            stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(sQLException));
            this.connection.rollback(savepoint);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return stringBuilder;
    }

    @Override
    public List<ProcedureDefinition> getProcedureList(String string, String string2, String string3) throws SQLException {
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        DataStore dataStore = this.getProcedures(string, string2, string3);
        ArrayList<ProcedureDefinition> arrayList = new ArrayList<ProcedureDefinition>(dataStore.getRowCount());
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return arrayList;
        }
        dataStore.sortByColumn(0, true);
        int n = dataStore.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string4 = dataStore.getValueAsString(i, 3);
            String string5 = dataStore.getValueAsString(i, 2);
            String string6 = dataStore.getValueAsString(i, 0);
            String string7 = dataStore.getValueAsString(i, 4);
            int n2 = dataStore.getValueAsInt(i, 1, 1);
            ProcedureDefinition procedureDefinition = (ProcedureDefinition)dataStore.getRow(i).getUserObject();
            if (procedureDefinition == null) {
                if (this.connection.getMetadata().isOracle() && string5 != null) {
                    procedureDefinition = ProcedureDefinition.createOracleDefinition(string4, string6, string5, n2, string7);
                } else {
                    procedureDefinition = new ProcedureDefinition(string5, string4, string6, n2);
                    procedureDefinition.setComment(string7);
                }
            }
            if (procedureDefinition == null) continue;
            arrayList.add(procedureDefinition);
        }
        return arrayList;
    }

    @Override
    public ProcedureDefinition findProcedureByName(DbObject dbObject) throws SQLException {
        List<String> list;
        if (dbObject == null) {
            return null;
        }
        String string = dbObject.getSchema();
        String string2 = dbObject.getCatalog();
        if (StringUtil.isNonEmpty(string2) || StringUtil.isNonBlank(string)) {
            List<ProcedureDefinition> list2;
            if (StringUtil.isEmptyString(string2)) {
                string2 = this.connection.getCurrentCatalog();
            }
            if (StringUtil.isEmptyString(string)) {
                string = this.connection.getCurrentSchema();
            }
            if ((list2 = this.getProcedureList(string2, string, dbObject.getObjectName())).size() == 1) {
                return list2.get(0);
            }
            return null;
        }
        if (StringUtil.isEmptyString(string2)) {
            string2 = this.connection.getCurrentCatalog();
        }
        if (CollectionUtil.isEmpty(list = DbSearchPath.Factory.getSearchPathHandler(this.connection).getSearchPath(this.connection, null)) && StringUtil.isEmptyString(string)) {
            list = CollectionUtil.arrayList(this.connection.getCurrentSchema());
        }
        for (String string3 : list) {
            List<ProcedureDefinition> list3 = this.getProcedureList(string2, string3, dbObject.getObjectName());
            if (list3.size() != 1) continue;
            return list3.get(0);
        }
        return null;
    }

    @Override
    public ProcedureDefinition findProcedureDefinition(ProcedureDefinition procedureDefinition) {
        List<ProcedureDefinition> list = null;
        try {
            list = this.getProcedureList(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), procedureDefinition.getProcedureName());
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not read procedures", sQLException);
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        List<String> list2 = procedureDefinition.getParameterTypes();
        if (!this.connection.getDbSettings().supportsFunctionOverloading()) {
            if (list.size() == 1) {
                return list.get(0);
            }
            return null;
        }
        for (ProcedureDefinition procedureDefinition2 : list) {
            procedureDefinition2.readParameters(this.connection);
            List<String> list3 = procedureDefinition2.getParameterTypes();
            if (!list3.equals(list2)) continue;
            return procedureDefinition2;
        }
        return null;
    }

    @Override
    public boolean isRecreateStatement(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) {
            return false;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.connection);
        sQLLexer.setInput(charSequence);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            return false;
        }
        if (sQLToken.getText().equalsIgnoreCase("create or replace")) {
            return true;
        }
        if (sQLToken.getText().equalsIgnoreCase("create or alter")) {
            return true;
        }
        if (sQLToken.getText().equalsIgnoreCase("recreate")) {
            return true;
        }
        if (sQLToken.getText().equalsIgnoreCase("create") && (sQLToken = sQLLexer.getNextToken(false, false)).getText().equalsIgnoreCase("or")) {
            Set<String> set = CollectionUtil.caseInsensitiveSet("replace", "alter");
            sQLToken = sQLLexer.getNextToken(false, false);
            return sQLToken != null && set.contains(sQLToken.getText());
        }
        return false;
    }

    @Override
    public CharSequence getPackageSource(String string, String string2, String string3) {
        return null;
    }

    @Override
    public boolean supportsPackages() {
        return false;
    }

    @Override
    public CharSequence getPackageProcedureSource(ProcedureDefinition procedureDefinition) {
        return null;
    }
}

