/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.BufferedInputStream;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import workbench.db.DbMetadata;
import workbench.db.GetMetaDataSql;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.NumberStringCache;
import workbench.util.VersionNumber;
import workbench.util.WbPersistence;

public class MetaDataSqlManager {
    public static final String FQ_TABLE_NAME_PLACEHOLDER = "%fq_table_name%";
    public static final String FQ_NAME_PLACEHOLDER = "%fq_name%";
    public static final String DDL_TYPEOPTION = "%typeoption%";
    public static final String DDL_IF_NOT_EXISTS = "%if_not_exists%";
    public static final String DDL_IF_EXISTS = "%if_exists%";
    public static final String NAME_PLACEHOLDER = "%name%";
    public static final String SCHEMA_NAME_PLACEHOLDER = "%schema_name%";
    public static final String OBJECT_NAME_PLACEHOLDER = "%object_name%";
    public static final String CATALOG_NAME_PLACEHOLDER = "%catalog_name%";
    public static final String TABLE_NAME_PLACEHOLDER = "%table_name%";
    public static final String TABLE_EXPRESSION_PLACEHOLDER = "%table_expression%";
    public static final String SPECIFIC_NAME_PLACEHOLDER = "%specific_name%";
    public static final String INDEX_TYPE_PLACEHOLDER = "%indextype%";
    public static final String INDEX_NAME_PLACEHOLDER = "%indexname%";
    public static final String FQ_INDEX_NAME_PLACEHOLDER = "%fq_index_name%";
    public static final String PK_NAME_PLACEHOLDER = "%pk_name%";
    public static final String PK_INLINE_DEFINITION = "%pk_definition%";
    public static final String UNIQUE_PLACEHOLDER = "%unique_key%";
    public static final String IDX_DIRECTION_PLACEHOLDER = "%idx_dir%";
    public static final String COLUMN_NAME_PLACEHOLDER = "%column_name%";
    public static final String COLUMN_LIST_PLACEHOLDER = "%columnlist%";
    public static final String CONSTRAINT_NAME_PLACEHOLDER = "%constraint_name%";
    public static final String FK_TARGET_TABLE_PLACEHOLDER = "%targettable%";
    public static final String FK_TARGET_COLUMNS_PLACEHOLDER = "%targetcolumnlist%";
    public static final String FK_UPDATE_RULE = "%fk_update_rule%";
    public static final String FK_DELETE_RULE = "%fk_delete_rule%";
    public static final String FK_MATCH_TYPE = "%fk_match_type%";
    public static final String DEFERRABLE = "%deferrable%";
    public static final String DEFERRED = "%deferred%";
    public static final String GENERAL_SQL = "All";
    public static final String CONS_ENABLED = "%enabled%";
    public static final String CONS_VALIDATED = "%validated%";
    private final String productName;
    private final String dbIdKey;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private GetMetaDataSql procedureSource;
    private GetMetaDataSql viewSource;
    private GetMetaDataSql listTrigger;
    private GetMetaDataSql triggerSource;
    private GetMetaDataSql listIndexes;
    private final Object LOCK = new Object();

    public MetaDataSqlManager(String string, String string2, VersionNumber versionNumber) {
        this.dbIdKey = "$dbid:" + string2;
        this.productName = string.toLowerCase().startsWith("firebird") ? "Firebird" : string;
        if (versionNumber != null) {
            this.majorVersion = versionNumber.getMajorVersion();
            this.minorVersion = versionNumber.getMinorVersion();
        }
    }

    public String getProductName() {
        return this.productName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMetaDataSql getListIndexesSql() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listIndexes == null) {
                HashMap hashMap = this.readStatementTemplates("ListIndexStatements.xml");
                this.listIndexes = this.getEntry(hashMap, "index list");
            }
            return this.listIndexes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMetaDataSql getProcedureSourceSql() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.procedureSource == null) {
                HashMap hashMap = this.readStatementTemplates("ProcSourceStatements.xml");
                this.procedureSource = this.getEntry(hashMap, "procedure source");
            }
            return this.procedureSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMetaDataSql getViewSourceSql() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.viewSource == null) {
                HashMap hashMap = this.readStatementTemplates("ViewSourceStatements.xml");
                this.viewSource = this.getEntry(hashMap, "view source");
            }
            return this.viewSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMetaDataSql getListTriggerSql() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listTrigger == null) {
                HashMap hashMap = this.readStatementTemplates("ListTriggersStatements.xml");
                this.listTrigger = this.getEntry(hashMap, "trigger list");
            }
            return this.listTrigger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetMetaDataSql getTriggerSourceSql() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.triggerSource == null) {
                HashMap hashMap = this.readStatementTemplates("TriggerSourceStatements.xml");
                this.triggerSource = this.getEntry(hashMap, "trigger source");
            }
            return this.triggerSource;
        }
    }

    private GetMetaDataSql getEntry(Map<String, GetMetaDataSql> map, String string) {
        GetMetaDataSql getMetaDataSql = this.getEntryByKey(this.dbIdKey, map);
        if (getMetaDataSql != null) {
            LogMgr.logInfo(new CallerInfo(){}, "Using template for " + string + " based on DBID: [" + this.dbIdKey + "] instead of product name: " + this.productName);
            getMetaDataSql.setMetaDataType(string);
            return getMetaDataSql;
        }
        GetMetaDataSql getMetaDataSql2 = this.getEntryByKey(this.productName, map);
        if (getMetaDataSql2 != null) {
            getMetaDataSql2.setMetaDataType(string);
        }
        return getMetaDataSql2;
    }

    private GetMetaDataSql getEntryByKey(String string, Map<String, GetMetaDataSql> map) {
        String string2 = null;
        GetMetaDataSql getMetaDataSql = null;
        if (this.majorVersion != -1 && this.minorVersion != -1) {
            string2 = string + "-" + NumberStringCache.getNumberString(this.majorVersion) + "." + NumberStringCache.getNumberString(this.minorVersion);
            getMetaDataSql = map.get(string2);
        }
        if (getMetaDataSql != null) {
            return getMetaDataSql;
        }
        if (this.majorVersion != -1) {
            string2 = string + "-" + NumberStringCache.getNumberString(this.majorVersion);
            getMetaDataSql = map.get(string2);
        }
        if (getMetaDataSql != null) {
            return getMetaDataSql;
        }
        return map.get(string);
    }

    private HashMap readStatementTemplates(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(DbMetadata.class.getResourceAsStream(string));
        try {
            object3 = new WbPersistence();
            object2 = ((WbPersistence)object3).readObject(bufferedInputStream);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error reading internal templates file " + string, throwable);
            object2 = null;
        }
        if (object2 instanceof HashMap) {
            object4 = (HashMap)object2;
        }
        if (!((File)(object3 = new File(Settings.getInstance().getConfigDir(), string))).exists()) {
            object = new ClasspathUtil();
            object3 = new File(((ClasspathUtil)object).getJarPath(), string);
        }
        if (!((File)object3).exists()) {
            object3 = new File(string);
        }
        if (((File)object3).exists()) {
            try {
                object = new WbPersistence(((File)object3).getAbsolutePath());
                object2 = ((WbPersistence)object).readObject();
                LogMgr.logInfo(new CallerInfo(){}, "Using SQL queries from user defined file " + ((File)object3).getAbsolutePath());
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Error reading template file " + ((File)object3).getAbsolutePath(), throwable);
            }
            if (object2 instanceof HashMap) {
                object = (HashMap)object2;
                if (object4 != null) {
                    ((HashMap)object4).putAll(object);
                } else {
                    object4 = object;
                }
            }
        } else if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "No user defined template file found for " + string);
        }
        return object4;
    }
}

