/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.firebird.FirebirdSequenceAdjuster;
import workbench.db.h2database.H2SequenceAdjuster;
import workbench.db.hsqldb.HsqlSequenceAdjuster;
import workbench.db.ibm.Db2SequenceAdjuster;
import workbench.db.mssql.SqlServerSequenceAdjuster;
import workbench.db.postgres.PostgresSequenceAdjuster;

public interface SequenceAdjuster {
    public int adjustTableSequences(WbConnection var1, TableIdentifier var2, boolean var3) throws SQLException;

    public static class Factory {
        public static SequenceAdjuster getSequenceAdjuster(WbConnection wbConnection) {
            switch (DBID.fromConnection(wbConnection)) {
                case Postgres: 
                case Greenplum: 
                case Redshift: {
                    return new PostgresSequenceAdjuster();
                }
                case H2: {
                    return new H2SequenceAdjuster();
                }
                case HSQLDB: {
                    if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "2.0")) break;
                    return new HsqlSequenceAdjuster();
                }
                case DB2_LUW: {
                    return new Db2SequenceAdjuster();
                }
                case Firebird: {
                    if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "3.0")) break;
                    return new FirebirdSequenceAdjuster();
                }
                case SQL_Server: {
                    return new SqlServerSequenceAdjuster();
                }
            }
            return null;
        }
    }
}

