/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.DropType;
import workbench.db.ObjectSourceOptions;
import workbench.db.PkDefinition;
import workbench.db.QuoteHandler;
import workbench.db.SequenceReader;
import workbench.db.SynonymDDLHandler;
import workbench.db.TableDefinition;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class TableIdentifier
implements DbObject,
Comparable<TableIdentifier>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String tablename;
    private String schema;
    private String catalog;
    private String server;
    private String owner;
    private boolean isNewTable;
    private boolean tableWasQuoted;
    private boolean serverWasQuoted;
    private boolean catalogWasQuoted;
    private boolean schemaWasQuoted;
    private PkDefinition primaryKey;
    private String type;
    private boolean neverAdjustCase;
    private boolean preserveQuotes;
    private boolean showOnlyTableName;
    private String tableComment;
    private boolean commentWasInitialized;
    private boolean retrieveFkSource;
    private boolean useInlinePK;
    private boolean useInlineFK;
    private boolean useTableNameOnlyInExpression;
    private boolean pkInitialized;
    private boolean isPartitioned;
    private TableIdentifier realTable;
    private ObjectSourceOptions sourceOptions = new ObjectSourceOptions();
    private String tableSpace;

    public TableIdentifier(String string) {
        this.isNewTable = false;
        this.parseTableIdentifier(string);
    }

    public TableIdentifier(String string, char c, char c2) {
        this.isNewTable = false;
        this.parseTableIdentifier(string, c, c2, true, true);
    }

    public TableIdentifier(String string, char c, char c2, boolean bl, boolean bl2) {
        this.isNewTable = false;
        this.parseTableIdentifier(string, c, c2, bl, bl2);
    }

    public TableIdentifier(String string, WbConnection wbConnection) {
        this.isNewTable = false;
        DbSettings dbSettings = wbConnection == null ? null : wbConnection.getDbSettings();
        boolean bl = dbSettings == null ? true : dbSettings.supportsCatalogs();
        boolean bl2 = dbSettings == null ? true : dbSettings.supportsSchemas();
        this.parseTableIdentifier(string, SqlUtil.getCatalogSeparator(wbConnection), SqlUtil.getSchemaSeparator(wbConnection), bl, bl2);
        this.adjustCase(wbConnection);
    }

    public TableIdentifier() {
        this.schema = null;
        this.catalog = null;
        this.tablename = null;
        this.isNewTable = true;
    }

    public TableIdentifier(String string, String string2) {
        this.setCatalog(null);
        this.parseTableIdentifier(string2);
        this.setSchema(string);
    }

    public TableIdentifier(String string, String string2, String string3) {
        this.parseTableIdentifier(string3);
        this.setCatalog(string);
        this.setSchema(string2);
    }

    public TableIdentifier(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.parseTableIdentifier(string3);
        } else {
            this.setTablename(string3);
        }
        this.setCatalog(string);
        this.setSchema(string2);
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public void setIsPartitioned(boolean bl) {
        this.isPartitioned = bl;
    }

    public boolean getUseNameOnly() {
        return this.useTableNameOnlyInExpression;
    }

    public void setUseNameOnly(boolean bl) {
        this.useTableNameOnlyInExpression = bl;
    }

    public TableIdentifier getRealTable() {
        return this.realTable;
    }

    public void setRealTable(TableIdentifier tableIdentifier) {
        this.realTable = tableIdentifier != null ? tableIdentifier.createCopy() : null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getTablespace() {
        return this.tableSpace;
    }

    public void setTablespace(String string) {
        this.tableSpace = string;
    }

    public void setSourceOptions(ObjectSourceOptions objectSourceOptions) {
        if (objectSourceOptions != null) {
            this.sourceOptions = objectSourceOptions;
        }
    }

    public ObjectSourceOptions getSourceOptions() {
        return this.sourceOptions;
    }

    public boolean getUseInlineFK() {
        return this.useInlineFK;
    }

    public void setUseInlineFK(boolean bl) {
        this.useInlineFK = bl;
    }

    public boolean getUseInlinePK() {
        return this.useInlinePK;
    }

    public void setUseInlinePK(boolean bl) {
        this.useInlinePK = bl;
    }

    public boolean isPkInitialized() {
        return this.pkInitialized;
    }

    public void setPkInitialized(boolean bl) {
        this.pkInitialized = bl;
    }

    @Override
    public void setComment(String string) {
        this.commentWasInitialized = true;
        this.tableComment = string;
    }

    @Override
    public String getComment() {
        return this.tableComment;
    }

    public boolean wasQuoted() {
        return this.tableWasQuoted || this.schemaWasQuoted || this.catalogWasQuoted;
    }

    public boolean commentIsDefined() {
        return this.commentWasInitialized;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getTableExpression(wbConnection);
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        if (wbConnection == null) {
            return SqlUtil.quoteObjectname(this.tablename, this.tableWasQuoted);
        }
        return wbConnection.getMetadata().quoteObjectname(this.tablename);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.getTableExpression(wbConnection);
    }

    @Override
    public String getObjectType() {
        if (this.type == null) {
            return "TABLE";
        }
        return this.type.toUpperCase();
    }

    @Override
    public String getObjectName() {
        return this.getTableName();
    }

    public void setPreserveQuotes(boolean bl) {
        this.preserveQuotes = bl;
    }

    public boolean getNeverAdjustCase() {
        return this.neverAdjustCase;
    }

    public void setNeverAdjustCase(boolean bl) {
        this.neverAdjustCase = bl;
    }

    public void checkQuotesNeeded(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return;
        }
        this.schemaWasQuoted = !dbMetadata.isDefaultCase(this.schema);
        this.catalogWasQuoted = !dbMetadata.isDefaultCase(this.catalog);
        this.tableWasQuoted = !dbMetadata.isDefaultCase(this.tablename);
        this.preserveQuotes = this.schemaWasQuoted || this.catalogWasQuoted || this.tableWasQuoted;
    }

    public TableIdentifier createCopy() {
        TableIdentifier tableIdentifier = new TableIdentifier();
        tableIdentifier.isNewTable = this.isNewTable;
        tableIdentifier.pkInitialized = this.pkInitialized;
        tableIdentifier.primaryKey = this.primaryKey == null ? null : this.primaryKey.createCopy();
        tableIdentifier.schema = this.schema;
        tableIdentifier.tablename = this.tablename;
        tableIdentifier.catalog = this.catalog;
        tableIdentifier.server = this.server;
        tableIdentifier.neverAdjustCase = this.neverAdjustCase;
        tableIdentifier.serverWasQuoted = this.serverWasQuoted;
        tableIdentifier.tableWasQuoted = this.tableWasQuoted;
        tableIdentifier.catalogWasQuoted = this.catalogWasQuoted;
        tableIdentifier.schemaWasQuoted = this.schemaWasQuoted;
        tableIdentifier.showOnlyTableName = this.showOnlyTableName;
        tableIdentifier.preserveQuotes = this.preserveQuotes;
        tableIdentifier.type = this.type;
        tableIdentifier.retrieveFkSource = this.retrieveFkSource;
        tableIdentifier.commentWasInitialized = this.commentWasInitialized;
        tableIdentifier.tableComment = this.tableComment;
        tableIdentifier.sourceOptions = this.sourceOptions == null ? null : this.sourceOptions.createCopy();
        tableIdentifier.useInlinePK = this.useInlinePK;
        tableIdentifier.useInlineFK = this.useInlineFK;
        tableIdentifier.owner = this.owner;
        tableIdentifier.realTable = this.realTable == null ? null : this.realTable.createCopy();
        tableIdentifier.useTableNameOnlyInExpression = this.useTableNameOnlyInExpression;
        return tableIdentifier;
    }

    public String getTableExpression() {
        return this.buildTableExpression(QuoteHandler.STANDARD_HANDLER, null, '.', '.');
    }

    public String getTableExpression(char c, char c2) {
        return this.buildTableExpression(QuoteHandler.STANDARD_HANDLER, null, c, c2);
    }

    public int hashCode() {
        return this.getTableExpression().hashCode();
    }

    public String getTableExpression(WbConnection wbConnection) {
        char c = SqlUtil.getCatalogSeparator(wbConnection);
        char c2 = SqlUtil.getSchemaSeparator(wbConnection);
        QuoteHandler quoteHandler = wbConnection == null ? QuoteHandler.STANDARD_HANDLER : wbConnection.getMetadata();
        return this.buildTableExpression(quoteHandler, wbConnection, c, c2);
    }

    protected String buildTableExpression(QuoteHandler quoteHandler, WbConnection wbConnection, char c, char c2) {
        if (this.isNewTable && this.tablename == null) {
            return ResourceMgr.getString("TxtNewTableIdentifier");
        }
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.server != null) {
            stringBuilder.append(SqlUtil.quoteObjectname(this.server, false));
            stringBuilder.append('.');
        }
        if (wbConnection == null) {
            if (this.catalog != null && !this.useTableNameOnlyInExpression) {
                stringBuilder.append(quoteHandler.quoteObjectname(this.catalog, this.preserveQuotes && this.catalogWasQuoted));
                stringBuilder.append(c);
            }
            if (this.schema != null && !this.useTableNameOnlyInExpression) {
                stringBuilder.append(quoteHandler.quoteObjectname(this.schema, this.preserveQuotes && this.schemaWasQuoted));
                stringBuilder.append(c2);
            }
            stringBuilder.append(quoteHandler.quoteObjectname(this.tablename, this.preserveQuotes && this.tableWasQuoted));
        } else {
            DbMetadata dbMetadata = wbConnection.getMetadata();
            this.adjustCase(wbConnection);
            String string = this.getCatalogToUse(wbConnection);
            boolean bl = false;
            if (StringUtil.isNonBlank(string)) {
                bl = true;
                stringBuilder.append(dbMetadata.quoteObjectname(string, this.preserveQuotes && this.catalogWasQuoted));
                stringBuilder.append(c);
            }
            String string2 = this.getSchemaToUse(wbConnection);
            if (bl && StringUtil.isBlank(string2)) {
                string2 = wbConnection.getCurrentSchema();
            }
            if (StringUtil.isNonBlank(string2)) {
                stringBuilder.append(dbMetadata.quoteObjectname(string2, this.preserveQuotes && this.schemaWasQuoted));
                stringBuilder.append(c2);
            }
            stringBuilder.append(dbMetadata.quoteObjectname(this.tablename, this.preserveQuotes && this.tableWasQuoted));
        }
        return stringBuilder.toString();
    }

    public String getSchemaToUse(WbConnection wbConnection) {
        if (this.useTableNameOnlyInExpression) {
            return null;
        }
        if (wbConnection == null) {
            return null;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata.needSchemaInDML(this)) {
            return dbMetadata.getSchemaToUse(this);
        }
        return null;
    }

    public String getCatalogToUse(WbConnection wbConnection) {
        if (this.useTableNameOnlyInExpression) {
            return null;
        }
        if (wbConnection == null) {
            return null;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata.needCatalogInDML(this)) {
            return dbMetadata.getCatalogToUse(this);
        }
        return null;
    }

    public void adjustCatalogAndSchema(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (this.catalog == null && wbConnection.getDbSettings().supportsCatalogs()) {
            this.setCatalog(wbConnection.getCurrentCatalog());
        }
        if (this.schema == null && wbConnection.getDbSettings().supportsSchemas()) {
            this.setSchema(wbConnection.getCurrentSchema());
        }
    }

    public final void adjustCase(WbConnection wbConnection) {
        if (this.neverAdjustCase) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (this.tablename != null && !this.tableWasQuoted) {
            this.tablename = dbMetadata.adjustObjectnameCase(this.tablename);
        }
        if (this.schema != null && !this.schemaWasQuoted) {
            this.schema = dbMetadata.adjustSchemaNameCase(this.schema);
        }
        if (this.catalog != null && !this.catalogWasQuoted) {
            this.catalog = dbMetadata.adjustObjectnameCase(this.catalog);
        }
    }

    public String getQualifiedName() {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (this.server != null) {
            stringBuilder.append(this.server);
            stringBuilder.append('.');
        }
        if (this.catalog != null) {
            stringBuilder.append(this.catalog);
            stringBuilder.append('.');
        }
        if (this.schema != null) {
            stringBuilder.append(this.schema);
            stringBuilder.append('.');
        }
        stringBuilder.append(this.tablename);
        return stringBuilder.toString();
    }

    public String getRawCatalog() {
        return this.catalog;
    }

    public String getRawTableName() {
        return this.tablename;
    }

    public String getRawSchema() {
        return this.schema;
    }

    public String getTableName() {
        if (this.tablename == null) {
            return null;
        }
        if (!this.tableWasQuoted || !this.preserveQuotes) {
            return this.tablename;
        }
        StringBuilder stringBuilder = new StringBuilder(this.tablename.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(this.tablename);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public void checkIsQuoted(DbMetadata dbMetadata) {
        if (dbMetadata.isQuoted(this.server)) {
            this.serverWasQuoted = true;
            this.server = this.server.substring(1, this.server.length() - 1);
        }
        if (dbMetadata.isQuoted(this.tablename)) {
            this.tableWasQuoted = true;
            this.tablename = this.tablename.substring(1, this.tablename.length() - 1);
        }
        if (dbMetadata.isQuoted(this.schema)) {
            this.schemaWasQuoted = true;
            this.schema = this.schema.substring(1, this.schema.length() - 1);
        }
        if (dbMetadata.isQuoted(this.catalog)) {
            this.catalogWasQuoted = true;
            this.catalog = this.catalog.substring(1, this.catalog.length() - 1);
        }
    }

    public final void parseTableIdentifier(String string) {
        this.parseTableIdentifier(string, '.', '.', true, true);
    }

    public final void parseTableIdentifier(String string, char c, char c2, boolean bl, boolean bl2) {
        if (!this.isNewTable && StringUtil.isBlank(string)) {
            throw new IllegalArgumentException("Table name may not be empty");
        }
        if (string == null) {
            this.tablename = null;
            this.schema = null;
            this.catalog = null;
            return;
        }
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(c2, "\"", true);
        wbStringTokenizer.setSourceString(string);
        List<String> list = wbStringTokenizer.getAllTokens();
        switch (list.size()) {
            case 1: {
                this.setCatalog(TableIdentifier.getCatalogPart(string, c));
                this.setTablename(TableIdentifier.getNamePart(string, c));
                break;
            }
            case 2: {
                if (bl2 && bl) {
                    this.setCatalog(TableIdentifier.getCatalogPart(list.get(0), c));
                    this.setSchema(TableIdentifier.getNamePart(list.get(0), c));
                }
                if (bl2 && !bl) {
                    this.setSchema(list.get(0));
                }
                if (bl && !bl2) {
                    this.setCatalog(list.get(0));
                }
                this.setTablename(list.get(1));
                break;
            }
            case 3: {
                this.setCatalog(list.get(0));
                this.setSchema(list.get(1));
                this.setTablename(list.get(2));
                break;
            }
            case 4: {
                this.setServerPart(list.get(0));
                this.setCatalog(list.get(1));
                this.setSchema(list.get(2));
                this.setTablename(list.get(3));
                break;
            }
        }
    }

    protected static String getCatalogPart(String string, char c) {
        if (string == null) {
            return string;
        }
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(c, "\"", true);
        wbStringTokenizer.setSourceString(string);
        List<String> list = wbStringTokenizer.getAllTokens();
        if (list.size() == 2) {
            return list.get(0);
        }
        return null;
    }

    protected static String getNamePart(String string, char c) {
        if (string == null) {
            return string;
        }
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(c, "\"", true);
        wbStringTokenizer.setSourceString(string);
        List<String> list = wbStringTokenizer.getAllTokens();
        if (list.size() == 2) {
            return list.get(1);
        }
        return list.get(0);
    }

    public String getServerPart() {
        return this.server;
    }

    public void setServerPart(String string) {
        this.server = StringUtil.isBlank(string) ? null : string.trim();
    }

    @Override
    public void setName(String string) {
        this.setTablename(string);
    }

    private void setTablename(String string) {
        if (string == null) {
            return;
        }
        this.tableWasQuoted = SqlUtil.isQuotedIdentifier(string.trim());
        this.tablename = SqlUtil.removeObjectQuotes(string).trim();
    }

    @Override
    public String getSchema() {
        if (this.schema == null) {
            return null;
        }
        if (!this.schemaWasQuoted || !this.preserveQuotes) {
            return this.schema;
        }
        StringBuilder stringBuilder = new StringBuilder(this.schema.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(this.schema);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public final void setSchema(String string) {
        if (StringUtil.isBlank(string)) {
            this.schema = null;
        } else {
            this.schemaWasQuoted = SqlUtil.isQuotedIdentifier(string);
            this.schema = SqlUtil.removeObjectQuotes(string);
        }
    }

    @Override
    public String getCatalog() {
        if (this.catalog == null) {
            return null;
        }
        if (!this.catalogWasQuoted || !this.preserveQuotes) {
            return this.catalog;
        }
        StringBuilder stringBuilder = new StringBuilder(this.catalog.length() + 2);
        stringBuilder.append('\"');
        stringBuilder.append(this.catalog);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public final void setCatalog(String string) {
        if (this.isNewTable) {
            return;
        }
        if (StringUtil.isBlank(string)) {
            this.catalog = null;
        } else {
            this.catalogWasQuoted = SqlUtil.isQuotedIdentifier(string);
            this.catalog = SqlUtil.removeObjectQuotes(string);
        }
    }

    public String toString() {
        if (this.isNewTable) {
            if (this.tablename == null) {
                return this.getTableExpression();
            }
            return "(+) " + this.tablename;
        }
        if (this.showOnlyTableName) {
            return this.getTableName();
        }
        return this.getTableExpression();
    }

    public boolean isNewTable() {
        return this.isNewTable;
    }

    public void setNewTable(boolean bl) {
        this.isNewTable = bl;
    }

    public void setShowTablenameOnly(boolean bl) {
        this.showOnlyTableName = bl;
    }

    @Override
    public int compareTo(TableIdentifier tableIdentifier) {
        return this.getTableExpression().compareTo(tableIdentifier.getTableExpression());
    }

    public boolean equals(Object object) {
        if (object instanceof TableIdentifier) {
            TableIdentifier tableIdentifier = (TableIdentifier)object;
            boolean bl = this.isNewTable && tableIdentifier.isNewTable ? true : (this.isNewTable || tableIdentifier.isNewTable ? false : this.getTableExpression().equals(tableIdentifier.getTableExpression()));
            return bl;
        }
        return false;
    }

    public boolean compareNames(TableIdentifier tableIdentifier) {
        boolean bl = !this.neverAdjustCase || !tableIdentifier.neverAdjustCase;
        return TableIdentifier.compareNames(this, tableIdentifier, bl);
    }

    public static boolean compareNames(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2, boolean bl) {
        if (tableIdentifier == null || tableIdentifier2 == null) {
            return false;
        }
        if (tableIdentifier.isNewTable() && tableIdentifier2.isNewTable()) {
            return true;
        }
        if (tableIdentifier.isNewTable() || tableIdentifier2.isNewTable()) {
            return false;
        }
        boolean bl2 = StringUtil.equalStringOrEmpty(tableIdentifier.tablename, tableIdentifier2.tablename, bl);
        if (bl2 && tableIdentifier.schema != null && tableIdentifier2.schema != null) {
            bl2 = StringUtil.equalStringOrEmpty(tableIdentifier.schema, tableIdentifier2.schema, bl);
        }
        if (bl2 && tableIdentifier.catalog != null && tableIdentifier2.catalog != null) {
            bl2 = StringUtil.equalStringOrEmpty(tableIdentifier.catalog, tableIdentifier2.catalog, bl);
        }
        return bl2;
    }

    public String getPrimaryKeyName() {
        if (this.primaryKey == null) {
            return null;
        }
        return this.primaryKey.getPkName();
    }

    public PkDefinition getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PkDefinition pkDefinition) {
        this.primaryKey = pkDefinition;
        this.pkInitialized = true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource(wbConnection, this.retrieveFkSource, wbConnection.getDbSettings().getGenerateTableGrants());
    }

    public CharSequence getSource(WbConnection wbConnection, boolean bl, boolean bl2) throws SQLException {
        CharSequence charSequence;
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata.isExtendedObject(this)) {
            return dbMetadata.getObjectSource(this);
        }
        if ("MATERIALIZED VIEW".equalsIgnoreCase(this.type)) {
            charSequence = dbMetadata.getViewReader().getExtendedViewSource(new TableDefinition(this, null), DropType.none, false);
        } else if (dbMetadata.isSynonym(this)) {
            SynonymDDLHandler synonymDDLHandler = new SynonymDDLHandler();
            charSequence = synonymDDLHandler.getSynonymSource(wbConnection, this, false, DropType.none);
        } else if ("VIEW".equalsIgnoreCase(this.type)) {
            charSequence = dbMetadata.getViewReader().getExtendedViewSource(new TableDefinition(this, null), DropType.none, false);
        } else if (wbConnection.getMetadata().isSequenceType(this.type)) {
            SequenceReader sequenceReader = dbMetadata.getSequenceReader();
            charSequence = sequenceReader != null ? sequenceReader.getSequenceSource(this.getCatalog(), this.getSchema(), this.getTableName()) : null;
        } else {
            TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(wbConnection);
            charSequence = tableSourceBuilder.getTableSource(this, DropType.none, bl, bl2);
        }
        return charSequence;
    }

    public void setRetrieveFkSource(boolean bl) {
        this.retrieveFkSource = bl;
    }

    public static TableIdentifier findTableByName(List<TableIdentifier> list, String string) {
        return TableIdentifier.findTableByName(list, new TableIdentifier(string));
    }

    public static TableIdentifier findTableByName(List<TableIdentifier> list, TableIdentifier tableIdentifier) {
        if (list == null) {
            return null;
        }
        for (TableIdentifier tableIdentifier2 : list) {
            if (!tableIdentifier2.getTableName().equalsIgnoreCase(tableIdentifier.getTableName())) continue;
            return tableIdentifier2;
        }
        return null;
    }

    public static TableIdentifier findTableByNameAndSchema(List<TableIdentifier> list, TableIdentifier tableIdentifier) {
        if (list == null) {
            return null;
        }
        String string = TableIdentifier.getQualifiedName(tableIdentifier);
        for (TableIdentifier tableIdentifier2 : list) {
            String string2 = TableIdentifier.getQualifiedName(tableIdentifier2);
            if (!string2.equalsIgnoreCase(string)) continue;
            return tableIdentifier2;
        }
        return null;
    }

    private static String getQualifiedName(TableIdentifier tableIdentifier) {
        String string = tableIdentifier.getTableName();
        String string2 = tableIdentifier.getSchema();
        if (StringUtil.isEmptyString(string2) && StringUtil.isNonEmpty(tableIdentifier.getCatalog())) {
            string2 = tableIdentifier.getCatalog();
        }
        if (StringUtil.isEmptyString(string2)) {
            return string;
        }
        return string2 + "." + string;
    }

    public static boolean tablesAreEqual(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2, WbConnection wbConnection) {
        if (tableIdentifier == null || tableIdentifier2 == null) {
            return false;
        }
        if (wbConnection == null) {
            return tableIdentifier.equals(tableIdentifier2);
        }
        TableIdentifier tableIdentifier3 = tableIdentifier.createCopy();
        tableIdentifier3.adjustCatalogAndSchema(wbConnection);
        TableIdentifier tableIdentifier4 = tableIdentifier2.createCopy();
        tableIdentifier4.adjustCatalogAndSchema(wbConnection);
        String string = tableIdentifier3.getTableExpression(wbConnection);
        String string2 = tableIdentifier4.getTableExpression(wbConnection);
        return string.equalsIgnoreCase(string2);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

