/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.datacopy;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DropType;
import workbench.db.GenericObjectDropper;
import workbench.db.TableCreator;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.compare.TableDeleteSync;
import workbench.db.compare.TableDiffStatus;
import workbench.db.datacopy.QueryCopySource;
import workbench.db.importer.DataImporter;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.DeleteType;
import workbench.db.importer.RowDataProducer;
import workbench.db.importer.TableStatements;
import workbench.interfaces.BatchCommitter;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.MessageBuffer;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DataCopier
implements BatchCommitter,
ProgressReporter {
    private WbConnection sourceConnection;
    private WbConnection targetConnection;
    private RowDataProducer sourceData;
    private TableIdentifier sourceTable;
    private TableIdentifier targetTable;
    private DataImporter importer = new DataImporter();
    private Map<ColumnIdentifier, ColumnIdentifier> columnMap;
    private List<ColumnIdentifier> targetColumnsForQuery;
    private MessageBuffer messages;
    private MessageBuffer errors;
    private boolean doSyncDelete;
    private boolean ignoreColumnDefaultsForCreate;
    private boolean trimCharData;
    private int maxRows = -1;

    public void reset() {
        this.sourceData = null;
        this.sourceTable = null;
        this.targetTable = null;
        this.sourceConnection = null;
        this.targetColumnsForQuery = null;
        this.targetConnection = null;
        this.columnMap = null;
        this.importer.clearMessages();
        this.messages = new MessageBuffer();
        this.errors = new MessageBuffer();
    }

    public void setTrimCharData(boolean bl) {
        this.trimCharData = bl;
    }

    public void setAdjustSequences(boolean bl) {
        this.importer.setAdjustSequences(bl);
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setIgnoreColumnDefaults(boolean bl) {
        this.ignoreColumnDefaultsForCreate = bl;
    }

    public void setIgnoreIdentityColumns(boolean bl) {
        this.importer.setIgnoreIdentityColumns(bl);
    }

    public void setTransactionControl(boolean bl) {
        this.importer.setTransactionControl(bl);
    }

    public void beginMultiTableCopy(WbConnection wbConnection) throws SQLException {
        this.importer.setConnection(wbConnection);
        this.importer.beginMultiTable();
    }

    public void setUseSavepoint(boolean bl) {
        if (this.importer != null) {
            this.importer.setUseSavepoint(bl);
        }
    }

    public void endMultiTableCopy() {
        this.importer.endMultiTable();
    }

    public RowDataProducer getSource() {
        return this.sourceData;
    }

    public DataReceiver getReceiver() {
        return this.importer;
    }

    public void setKeyColumns(List<ColumnIdentifier> list) {
        this.importer.setKeyColumns(list);
    }

    public void setKeyColumns(String string) {
        this.importer.setKeyColumns(string);
    }

    public void setPerTableStatements(TableStatements tableStatements) {
        this.importer.setPerTableStatements(tableStatements);
    }

    public boolean setMode(String string) {
        return this.setMode(string, this.targetConnection);
    }

    public boolean setMode(String string, WbConnection wbConnection) {
        return this.importer.setMode(string, wbConnection);
    }

    @Override
    public void setReportInterval(int n) {
        this.importer.setReportInterval(n);
    }

    public void setProducer(RowDataProducer rowDataProducer, WbConnection wbConnection, TableIdentifier tableIdentifier) {
        this.sourceConnection = null;
        this.targetConnection = wbConnection;
        this.importer.setConnection(wbConnection);
        this.targetTable = tableIdentifier;
        this.targetColumnsForQuery = null;
        this.sourceData = rowDataProducer;
        this.importer.setProducer(rowDataProducer);
    }

    public void copyFromTable(WbConnection wbConnection, WbConnection wbConnection2, TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2, Map<String, String> map, String string, String string2, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        this.sourceConnection = wbConnection;
        this.targetConnection = wbConnection2;
        this.importer.setConnection(wbConnection2);
        this.sourceTable = tableIdentifier;
        this.targetTable = tableIdentifier2;
        this.targetColumnsForQuery = null;
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.sourceConnection);
        if (!dbObjectFinder.objectExists(tableIdentifier, this.sourceConnection.getMetadata().getSelectableTypes())) {
            this.addError(ResourceMgr.getFormattedString("ErrCopySourceTableNotFound", tableIdentifier.getFullyQualifiedName(this.sourceConnection)));
            throw new SQLException("Table " + tableIdentifier.getTableExpression() + " not found in source connection");
        }
        this.initColumnMapping(map, string2 != null, bl2);
        if (string2 != null) {
            this.createTable(this.columnMap.values(), dropType, bl, string2, bl2);
        }
        this.importer.skipTargetCheck(bl2);
        this.initImporterForTable(string);
    }

    private TableIdentifier findTargetTable() {
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.targetConnection);
        LogMgr.logDebug(new CallerInfo(){}, "Looking for table " + this.targetTable.getQualifiedName() + " in target database");
        TableIdentifier tableIdentifier = dbObjectFinder.findTable(this.targetTable, false);
        if (tableIdentifier == null) {
            TableIdentifier tableIdentifier2 = this.targetTable.createCopy();
            tableIdentifier2.setSchema(tableIdentifier2.getSchemaToUse(this.targetConnection));
            tableIdentifier2.setCatalog(tableIdentifier2.getCatalogToUse(this.targetConnection));
            LogMgr.logDebug(new CallerInfo(){}, "Table " + this.targetTable.getQualifiedName() + " not found. Trying " + tableIdentifier2.getQualifiedName());
            tableIdentifier = dbObjectFinder.findTable(tableIdentifier2, false);
        }
        return tableIdentifier;
    }

    private void createTable(Collection<ColumnIdentifier> collection, DropType dropType, boolean bl, String string, boolean bl2) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        if (dropType == DropType.cascaded || dropType == DropType.regular) {
            object3 = null;
            if (bl2) {
                object3 = this.targetTable.createCopy();
                this.targetTable.adjustCase(this.targetConnection);
            } else {
                object3 = this.findTargetTable();
            }
            if (object3 != null) {
                LogMgr.logInfo(new CallerInfo(){}, "About to drop table " + ((TableIdentifier)object3).getQualifiedName());
                try {
                    object2 = new GenericObjectDropper();
                    object2.setObjects(Collections.singletonList(object3));
                    object2.setCascade(dropType == DropType.cascaded);
                    object2.setConnection(this.targetConnection);
                    object2.dropObjects();
                    this.addMessage(ResourceMgr.getFormattedString("MsgCopyTableDropped", ((TableIdentifier)object3).getFullyQualifiedName(this.targetConnection)));
                }
                catch (SQLException sQLException) {
                    object = ResourceMgr.getFormattedString("MsgCopyErrorDropTable", ((TableIdentifier)object3).getFullyQualifiedName(this.targetConnection), ExceptionUtil.getDisplay(sQLException));
                    if (bl) {
                        this.addMessage((String)object);
                    }
                    this.addError((String)object);
                    throw sQLException;
                }
            } else {
                LogMgr.logInfo(new CallerInfo(){}, "Table " + this.targetTable.getQualifiedName() + " not dropped because it was not found in the target database");
            }
        }
        try {
            object3 = this.importer.getKeyColumns();
            object2 = new ArrayList<ColumnIdentifier>(collection.size());
            for (ColumnIdentifier object42 : collection) {
                ColumnIdentifier columnIdentifier = object42.createCopy();
                String string2 = object42.getColumnName();
                if (bl2) {
                    string2 = this.sourceConnection.getMetadata().removeQuotes(string2);
                    string2 = this.targetConnection.getMetadata().adjustObjectnameCase(string2);
                    columnIdentifier.setColumnName(string2);
                } else {
                    columnIdentifier.adjustQuotes(this.sourceConnection.getMetadata(), this.targetConnection.getMetadata());
                }
                if (object3.size() > 0) {
                    boolean bl3 = this.findColumn((List<ColumnIdentifier>)object3, columnIdentifier.getColumnName()) != null;
                    object42.setIsPkColumn(bl3);
                }
                object2.add(columnIdentifier);
            }
            object = new TableCreator(this.targetConnection, string, this.targetTable, (Collection<ColumnIdentifier>)object2);
            ((TableCreator)object).setUseColumnAlias(true);
            ((TableCreator)object).useDbmsDataType(this.sourceConnection.getDatabaseProductName().equals(this.targetConnection.getDatabaseProductName()));
            ((TableCreator)object).setRemoveDefaults(this.ignoreColumnDefaultsForCreate);
            ((TableCreator)object).createTable();
            TableDefinition tableDefinition = this.targetConnection.getMetadata().getTableDefinition(this.targetTable);
            this.targetTable = tableDefinition.getTable();
            if (this.columnMap != null) {
                this.updateTargetColumns(tableDefinition.getColumns(), this.columnMap.values());
            } else if (this.targetColumnsForQuery != null) {
                this.updateTargetColumns(tableDefinition.getColumns(), this.targetColumnsForQuery);
            }
            this.setDeleteTarget(DeleteType.none);
            this.addMessage(ResourceMgr.getFormattedString("MsgCopyTableCreated", this.targetTable.getFullyQualifiedName(this.targetConnection)) + "\n");
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error when creating target table", sQLException);
            this.addError(ResourceMgr.getFormattedString("MsgCopyErrorCreatTable", this.targetTable.getFullyQualifiedName(this.targetConnection), ExceptionUtil.getDisplay(sQLException)));
            throw sQLException;
        }
    }

    private void updateTargetColumns(List<ColumnIdentifier> list, Collection<ColumnIdentifier> collection) {
        for (ColumnIdentifier columnIdentifier : collection) {
            ColumnIdentifier columnIdentifier2 = this.findColumn(list, columnIdentifier.getDisplayName());
            if (columnIdentifier2 == null) continue;
            columnIdentifier.setColumnName(columnIdentifier2.getColumnName());
            columnIdentifier.setColumnAlias(columnIdentifier2.getDisplayName());
            columnIdentifier.setDbmsType(columnIdentifier2.getDbmsType());
            columnIdentifier.setDataType(columnIdentifier2.getDataType());
            columnIdentifier.setColumnSize(columnIdentifier2.getColumnSize());
            columnIdentifier.setDecimalDigits(columnIdentifier2.getDecimalDigits());
            columnIdentifier.setIsNullable(columnIdentifier2.isNullable());
            columnIdentifier.setIsPkColumn(columnIdentifier2.isPkColumn());
            columnIdentifier.setIsAutoincrement(columnIdentifier2.isAutoincrement());
        }
    }

    public void copyFromQuery(WbConnection wbConnection, WbConnection wbConnection2, String string, TableIdentifier tableIdentifier, List<ColumnIdentifier> list, String string2, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        this.sourceConnection = wbConnection;
        this.targetConnection = wbConnection2;
        this.importer.setConnection(wbConnection2);
        this.sourceTable = null;
        this.targetTable = tableIdentifier;
        this.targetColumnsForQuery = new ArrayList<ColumnIdentifier>(list);
        if (string2 != null) {
            this.createTable(this.targetColumnsForQuery, dropType, bl, string2, bl2);
        }
        this.importer.skipTargetCheck(bl2);
        this.initImporterForQuery(string, bl2);
    }

    public void setRowActionMonitor(RowActionMonitor rowActionMonitor) {
        if (rowActionMonitor != null) {
            this.importer.setRowActionMonitor(rowActionMonitor);
        }
    }

    public void setTableList(List<TableIdentifier> list) {
        this.importer.setTableList(list);
    }

    public void setDeleteTarget(DeleteType deleteType) {
        this.importer.setDeleteTarget(deleteType);
    }

    public boolean getContinueOnError() {
        return this.importer.getContinueOnError();
    }

    public void setContinueOnError(boolean bl) {
        this.importer.setContinueOnError(bl);
    }

    @Override
    public void setUseBatch(boolean bl) {
        this.importer.setUseBatch(bl);
    }

    @Override
    public void setCommitBatch(boolean bl) {
        this.importer.setCommitBatch(bl);
    }

    @Override
    public int getBatchSize() {
        return this.importer.getBatchSize();
    }

    @Override
    public void setBatchSize(int n) {
        this.importer.setBatchSize(n);
    }

    @Override
    public void commitNothing() {
        this.importer.commitNothing();
    }

    @Override
    public void setCommitEvery(int n) {
        this.importer.setCommitEvery(n);
    }

    public void setDoDeleteSync(boolean bl) {
        this.doSyncDelete = bl;
    }

    public void startBackgroundCopy() {
        WbThread wbThread = new WbThread("DataCopier Thread"){

            @Override
            public void run() {
                try {
                    DataCopier.this.startCopy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        wbThread.start();
    }

    public long getAffectedRows() {
        return this.importer.getAffectedRows();
    }

    public boolean isSuccess() {
        return this.importer.isSuccess();
    }

    public long startCopy() throws Exception {
        long l = 0L;
        try {
            this.sourceData.setAbortOnError(!this.importer.getContinueOnError());
            this.importer.startImport();
            l = this.importer.getAffectedRows();
            if (this.doSyncDelete) {
                TableDeleteSync tableDeleteSync = new TableDeleteSync(this.targetConnection, this.sourceConnection);
                Set<String> set = CollectionUtil.caseInsensitiveSet();
                for (ColumnIdentifier columnIdentifier : this.importer.getKeyColumns()) {
                    set.add(columnIdentifier.getColumnName());
                }
                Object object = tableDeleteSync.setTableName(this.sourceTable, this.targetTable, set);
                if (object == TableDiffStatus.OK) {
                    tableDeleteSync.setRowMonitor(this.importer.getRowActionMonitor());
                    tableDeleteSync.setBatchSize(this.getBatchSize());
                    tableDeleteSync.setReportInterval(this.importer.getReportInterval());
                    tableDeleteSync.doSync();
                    long l2 = tableDeleteSync.getDeletedRows();
                    String string = ResourceMgr.getFormattedString("MsgCopyNumRowsDeleted", l2, this.targetTable.getTableName());
                    this.addMessage(string);
                } else {
                    this.addError(ResourceMgr.getFormattedString("ErrDataDiffNoPK", this.targetTable.getTableName()));
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when copying data", exception);
            this.addError(ExceptionUtil.getDisplay(exception));
            this.importer.tableImportError();
            throw exception;
        }
        return l;
    }

    public String getRowsUpdatedMessage() {
        String string = null;
        long l = this.importer.getUpdatedRows();
        if (l > 0L) {
            string = l + " " + ResourceMgr.getString("MsgCopyNumRowsUpdated");
        }
        return string;
    }

    public String getRowsInsertedMessage() {
        long l = this.importer.getInsertedRows();
        String string = null;
        if (l > 0L) {
            string = l + " " + ResourceMgr.getString("MsgCopyNumRowsInserted");
        }
        return string;
    }

    public void cancel() {
        if (this.sourceData != null) {
            this.sourceData.cancel();
        }
    }

    private void initImporterForQuery(String string, boolean bl) throws SQLException {
        if (this.targetColumnsForQuery == null) {
            return;
        }
        if (!bl) {
            List<ColumnIdentifier> list = this.targetConnection.getMetadata().getTableColumns(this.targetTable, this.importer.needsKeyColumnInformation());
            this.updateTargetColumns(list, this.targetColumnsForQuery);
        }
        this.importer.setTargetTable(this.targetTable, this.targetColumnsForQuery, null);
        this.initQuerySource(string);
    }

    private void initImporterForTable(String string) throws SQLException {
        if (this.columnMap == null || this.columnMap.isEmpty()) {
            throw new SQLException("No columns defined");
        }
        int n = this.columnMap.size();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        ArrayList<ColumnIdentifier> arrayList2 = new ArrayList<ColumnIdentifier>(n);
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.sourceConnection, "export", "tabledata");
        StringBuilder stringBuilder = new StringBuilder(n * 25 + 30);
        for (Map.Entry<ColumnIdentifier, ColumnIdentifier> object : this.columnMap.entrySet()) {
            ColumnIdentifier columnIdentifier = object.getKey();
            ColumnIdentifier columnIdentifier2 = object.getValue();
            arrayList2.add(columnIdentifier);
            arrayList.add(columnIdentifier2);
        }
        String string2 = tableSelectBuilder.getSelectForColumns(this.sourceTable, arrayList2, this.maxRows);
        stringBuilder.append(string2);
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(' ');
            String string3 = this.sourceConnection.getParsingUtil().getSqlVerb(string);
            if (!string3.equals("WHERE")) {
                stringBuilder.append(" WHERE ");
            }
            stringBuilder.append(string);
        }
        this.initQuerySource(stringBuilder.toString());
        this.importer.setTargetTable(this.targetTable, arrayList, null);
    }

    private void initQuerySource(String string) {
        QueryCopySource queryCopySource = new QueryCopySource(this.sourceConnection, string);
        queryCopySource.setMaxRows(this.maxRows);
        queryCopySource.setTrimCharData(this.trimCharData);
        this.sourceData = queryCopySource;
        this.importer.setProducer(queryCopySource);
    }

    private List<ColumnIdentifier> getSourceColumns() throws SQLException {
        List<ColumnIdentifier> list = null;
        if (this.sourceTable != null) {
            DbMetadata dbMetadata = this.sourceConnection.getMetadata();
            TableIdentifier tableIdentifier = dbMetadata.resolveSynonym(this.sourceTable);
            list = dbMetadata.getTableColumns(tableIdentifier, false);
        } else if (this.targetColumnsForQuery != null) {
            list = new ArrayList<ColumnIdentifier>(this.targetColumnsForQuery);
        }
        return list;
    }

    private ColumnIdentifier findColumn(List<ColumnIdentifier> list, String string) {
        return ColumnIdentifier.findColumnInList(list, string);
    }

    private void addTargetColumn(ColumnIdentifier columnIdentifier, String string, List<ColumnIdentifier> list) {
        if (columnIdentifier == null) {
            return;
        }
        ColumnIdentifier columnIdentifier2 = this.findColumn(list, string == null ? columnIdentifier.getColumnName() : string);
        if (columnIdentifier2 != null) {
            this.columnMap.put(columnIdentifier, columnIdentifier2);
        } else {
            LogMgr.logWarning(new CallerInfo(){}, "Column " + columnIdentifier.getColumnName() + " not found in target table " + this.targetTable + ". Ignoring mapping!");
            String string2 = ResourceMgr.getFormattedString("ErrCopyTargetColumnNotFound", columnIdentifier.getColumnName());
            this.addMessage(string2);
        }
    }

    private void initColumnMapping(Map<String, String> map, boolean bl, boolean bl2) throws SQLException {
        Object object;
        List<ColumnIdentifier> list = this.getSourceColumns();
        List<ColumnIdentifier> list2 = null;
        if (!bl) {
            if (bl2) {
                list2 = this.sourceConnection.getMetadata().getTableColumns(this.sourceTable, this.importer.needsKeyColumnInformation());
                for (ColumnIdentifier object2 : list2) {
                    Map.Entry<String, String> entry = this.sourceConnection.getMetadata().removeQuotes(object2.getColumnName());
                    object2.setColumnName((String)((Object)entry));
                    object = object2.getColumnAlias();
                    if (object == null) continue;
                    object2.setColumnAlias(this.sourceConnection.getMetadata().removeQuotes((String)object));
                }
            } else {
                list2 = this.targetConnection.getMetadata().getTableColumns(this.targetTable, this.importer.needsKeyColumnInformation());
            }
        }
        this.columnMap = new LinkedHashMap<ColumnIdentifier, ColumnIdentifier>(list.size());
        if (map != null) {
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Object object2;
                object = this.findColumn(list, entry.getKey());
                if (object != null) {
                    if (bl) {
                        object2 = ((ColumnIdentifier)object).createCopy();
                        if (entry.getValue() != null) {
                            ((ColumnIdentifier)object2).setColumnName((String)entry.getValue());
                            ((ColumnIdentifier)object2).adjustQuotes(this.sourceConnection.getMetadata(), this.targetConnection.getMetadata());
                        }
                        ((ColumnIdentifier)object2).setPosition(n);
                        ++n;
                        this.columnMap.put((ColumnIdentifier)object, (ColumnIdentifier)object2);
                        continue;
                    }
                    this.addTargetColumn((ColumnIdentifier)object, (String)entry.getValue(), list2);
                    continue;
                }
                LogMgr.logWarning(new CallerInfo(){}, "Column " + (String)entry.getKey() + " not found in source table " + this.sourceTable + ". Ignoring mapping!");
                object2 = ResourceMgr.getFormattedString("ErrCopySourceColumnNotFound", entry.getKey());
                this.addMessage((String)object2);
            }
        } else {
            for (ColumnIdentifier columnIdentifier : list) {
                if (bl) {
                    this.columnMap.put(columnIdentifier, columnIdentifier.createCopy());
                    continue;
                }
                this.addTargetColumn(columnIdentifier, null, list2);
            }
        }
    }

    public void addError(String string) {
        if (this.errors == null) {
            this.errors = new MessageBuffer();
        }
        if (this.errors.getLength() > 0) {
            this.errors.appendNewLine();
        }
        this.errors.append(string);
    }

    public void addMessage(String string) {
        if (this.messages == null) {
            this.messages = new MessageBuffer();
        }
        if (this.messages.getLength() > 0) {
            this.messages.appendNewLine();
        }
        this.messages.append(string);
    }

    public boolean hasWarnings() {
        return this.importer.hasWarnings();
    }

    public MessageBuffer getMessageBuffer() {
        MessageBuffer messageBuffer = new MessageBuffer();
        if (this.messages != null) {
            messageBuffer.append(this.messages);
            this.messages.clear();
        }
        this.importer.copyMessages(messageBuffer);
        messageBuffer.append(this.errors);
        return messageBuffer;
    }

    public CharSequence getAllMessages() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        if (this.messages != null) {
            stringBuilder.append(this.messages.getBuffer());
            stringBuilder.append('\n');
        }
        stringBuilder.append(this.importer.getMessages());
        if (this.errors != null) {
            stringBuilder.append(this.errors.getBuffer());
        }
        return stringBuilder;
    }

    public static Savepoint setSourceSavepoint(WbConnection wbConnection) throws SQLException {
        if (DataCopier.useSavePointForSourceQuery(wbConnection)) {
            return wbConnection.setSavepoint();
        }
        return null;
    }

    private static boolean useSavePointForSourceQuery(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getAutoCommit()) {
            return false;
        }
        return wbConnection.getDbSettings().useSavePointForDML() && wbConnection.supportsSavepoints() && wbConnection.selectStartsTransaction();
    }
}

