/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.dependency;

import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.firebird.FirebirdDependencyReader;
import workbench.db.hana.HanaDependencyReader;
import workbench.db.hsqldb.HsqlDependencyReader;
import workbench.db.mssql.SqlServerDependencyReader;
import workbench.db.mssql.SqlServerUtil;
import workbench.db.oracle.OracleDependencyReader;
import workbench.db.postgres.PostgresDependencyReader;

public class DependencyReaderFactory {
    public static DependencyReader getReader(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.getMetadata().isOracle()) {
            return new OracleDependencyReader();
        }
        if (wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "8.4")) {
            return new PostgresDependencyReader(wbConnection);
        }
        if (wbConnection.getMetadata().isSqlServer() && SqlServerUtil.isSqlServer2008(wbConnection)) {
            return new SqlServerDependencyReader();
        }
        if (wbConnection.getMetadata().isFirebird()) {
            return new FirebirdDependencyReader();
        }
        if (wbConnection.getMetadata().isHsql()) {
            return new HsqlDependencyReader();
        }
        if (wbConnection.getDbId().equals(DBID.HANA.getId())) {
            return new HanaDependencyReader();
        }
        return null;
    }
}

