/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.File;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Table;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.RowData;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbNumberFormatter;

public class NativeOdsRowDataConverter
extends RowDataConverter {
    private boolean append;
    private SpreadsheetDocument dataFile;
    private Table worksheet;
    private int firstDataRow;

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    @Override
    public StringBuilder getStart() {
        Cell cell;
        int n;
        int n2;
        if (this.append && this.getOutputFile().exists()) {
            this.loadOdsFile();
            this.worksheet = this.dataFile.appendSheet(this.getPageTitle("SQLExport"));
        } else {
            try {
                this.dataFile = this.isTemplate() ? SpreadsheetDocument.newSpreadsheetTemplateDocument() : SpreadsheetDocument.newSpreadsheetDocument();
                n2 = this.dataFile.getSheetCount();
                if (n2 == 0) {
                    this.worksheet = this.dataFile.appendSheet(this.getPageTitle("SQLExport"));
                } else {
                    this.worksheet = this.dataFile.getSheetByIndex(0);
                    this.worksheet.setTableName(this.getPageTitle("SQLExport"));
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not create ODS document");
            }
        }
        if (this.includeColumnComments) {
            this.worksheet.appendRow();
            this.firstDataRow = 1;
            n2 = 0;
            for (n = 0; n < this.metaData.getColumnCount(); ++n) {
                if (!this.includeColumnInExport(n)) continue;
                cell = this.worksheet.getCellByPosition(n2, 0);
                cell.setStringValue(StringUtil.trimQuotes(this.metaData.getColumn(n).getComment()));
                ++n2;
            }
        }
        if (this.writeHeader) {
            this.worksheet.appendRow();
            ++this.firstDataRow;
            n2 = 0;
            for (n = 0; n < this.metaData.getColumnCount(); ++n) {
                if (!this.includeColumnInExport(n)) continue;
                cell = this.worksheet.getCellByPosition(n2, this.firstDataRow - 1);
                cell.setStringValue(SqlUtil.removeObjectQuotes(this.metaData.getColumnDisplayName(n)));
                Font font = cell.getFont();
                font.setSize(font.getSize());
                font.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
                cell.setFont(font);
                ++n2;
            }
        }
        return null;
    }

    private void loadOdsFile() {
        try {
            this.dataFile = SpreadsheetDocument.loadDocument((File)this.getOutputFile());
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not load ODS file", exception);
            this.dataFile = null;
        }
    }

    @Override
    public StringBuilder getEnd(long l) {
        try {
            this.dataFile.save(this.getOutputFile());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    protected String getTimestampFormat() {
        if (this.defaultTimestampFormatter != null) {
            return this.defaultTimestampFormatter.toPattern();
        }
        return "yyyy-MM-dd HH:mm:ss.SSS";
    }

    protected String getDateFormat() {
        if (this.defaultDateFormatter != null) {
            return this.defaultDateFormatter.toPattern();
        }
        return "yyyy-MM-dd";
    }

    protected String getTimeFormat() {
        if (this.defaultTimeFormatter != null) {
            return this.defaultTimeFormatter.toPattern();
        }
        return "HH:mm:ss.SSS";
    }

    private String getFormatForDateTime(Object object) {
        if (object instanceof Timestamp) {
            return this.getTimestampFormat();
        }
        if (object instanceof Date) {
            return this.getDateFormat();
        }
        if (object instanceof Time) {
            return this.getTimeFormat();
        }
        return "yyyy-MM-dd HH:mm:ss.SSS";
    }

    private String getNumberFormat() {
        if (this.defaultNumberFormatter != null) {
            return this.defaultNumberFormatter.toFormatterPattern();
        }
        WbNumberFormatter wbNumberFormatter = new WbNumberFormatter(-1, '.');
        return wbNumberFormatter.toFormatterPattern();
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = rowData.getColumnCount();
        int n2 = 0;
        int n3 = (int)l + this.firstDataRow;
        for (int i = 0; i < n; ++i) {
            if (!this.includeColumnInExport(i)) continue;
            Object object = rowData.getValue(i);
            String string = this.getValueAsFormattedString(rowData, i);
            Cell cell = this.worksheet.getCellByPosition(n2, n3);
            if (object == null && StringUtil.isNonEmpty(this.getNullDisplay())) {
                cell.setStringValue(this.getNullDisplay());
            } else if (object instanceof java.util.Date) {
                cell.setDisplayText(string);
                String string2 = this.getFormatForDateTime(object);
                cell.setFormatString(string2);
                cell.setStringValue(string);
                cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
            } else if (object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
                cell.setDisplayText(string);
            } else if (object instanceof Double || object instanceof Float) {
                cell.setDoubleValue(Double.valueOf(((Number)object).doubleValue()));
                cell.setFormatString(this.getNumberFormat());
                cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
                cell.setDisplayText(string);
            } else {
                cell.setDisplayText(string);
                boolean bl = this.isMultiline(i);
                if (bl) {
                    cell.setTextWrapped(true);
                }
                cell.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
            }
            ++n2;
        }
        return null;
    }

    public boolean isTemplate() {
        return this.hasOutputFileExtension("ots");
    }
}

