/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.awt.Point;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.db.exporter.XlsRowDataConverter;

public class XlsExportWriter
extends ExportWriter {
    public XlsExportWriter(DataExporter dataExporter) {
        super(dataExporter);
        this.canAppendStart = true;
    }

    @Override
    public RowDataConverter createConverter() {
        return new XlsRowDataConverter();
    }

    @Override
    public void configureConverter() {
        super.configureConverter();
        this.converter.setNullString(this.exporter.getNullString());
        XlsRowDataConverter xlsRowDataConverter = (XlsRowDataConverter)this.converter;
        xlsRowDataConverter.setOptimizeColumns(this.exporter.getOptimizeSpreadsheetColumns());
        xlsRowDataConverter.setAppend(this.exporter.getAppendToFile());
        xlsRowDataConverter.setTargetSheetIndex(this.exporter.getTargetSheetIndex());
        xlsRowDataConverter.setTargetSheetName(this.exporter.getTargetSheetName());
        Point point = this.exporter.getSpreadSheetOffset();
        if (point != null) {
            xlsRowDataConverter.setStartOffset(point.y, point.x);
        }
    }

    @Override
    public boolean managesOutput() {
        return true;
    }
}

