/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class HanaTableSourceBuilder
extends TableSourceBuilder {
    public HanaTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (tableIdentifier == null) {
            return;
        }
        if (tableIdentifier.getSourceOptions().isInitialized()) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select table_type \nfrom sys.tables\nwhere table_name = ? \nand schema_name = ?";
        long l = System.currentTimeMillis();
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            LogMgr.logMetadataSql(new CallerInfo(){}, "table type", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                tableIdentifier.getSourceOptions().setTypeModifier(string2);
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving table type took: " + l2 + "ms");
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table type", string, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        tableIdentifier.getSourceOptions().setInitialized();
    }
}

