/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class HanaUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (wbConnection == null) {
            return null;
        }
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            callableStatement = wbConnection.getSqlConnection().prepareCall("{call get_object_definition(?, ?)} ");
            DbMetadata dbMetadata = wbConnection.getMetadata();
            callableStatement.setString(1, dbMetadata.quoteObjectname(dbObject.getSchema()));
            callableStatement.setString(2, dbMetadata.quoteObjectname(dbObject.getObjectName()));
            resultSet = callableStatement.executeQuery();
            if (resultSet.next() && (string = resultSet.getString("OBJECT_CREATION_STATEMENT")) != null) {
                string = string + ";";
            }
            JdbcUtils.closeAll(resultSet, callableStatement);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read object source for " + dbObject.getObjectExpression(wbConnection), exception);
        }
        finally {
            JdbcUtils.closeAll(resultSet, callableStatement);
        }
        return string;
    }
}

