/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListAppender;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;

public class DB2TempTableReader
implements ObjectListAppender {
    private static final String TABLE_TYPE = "GLOBAL TEMPORARY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("TABLE", stringArray)) {
            return false;
        }
        String string4 = "select tabschema, \n       tabname, \n       remarks \nfrom syscat.tables \nwhere type = 'G' ";
        int n = 0;
        int n2 = 0;
        if (string2 != null) {
            string4 = string2.indexOf(37) > -1 ? string4 + "\n  and tabschema like ? " : string4 + "\n  and tabschema = ? ";
            n = 1;
        }
        if (string3 != null) {
            string4 = string3.indexOf(37) > -1 ? string4 + "\n  and tabname like ? " : string4 + "\n  and tabname = ? ";
            n2 = n + 1;
        }
        string4 = string4 + "\nfor read only";
        LogMgr.logMetadataSql(new CallerInfo(){}, "temp tables", string4, string2, string3);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n3 = 0;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            if (n > 0) {
                preparedStatement.setString(n, string2);
            }
            if (n2 > 0) {
                preparedStatement.setString(n2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n4 = dataStore.addRow();
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                dataStore.setValue(n4, 3, (Object)string5);
                dataStore.setValue(n4, 0, (Object)string6);
                dataStore.setValue(n4, 4, (Object)string7);
                dataStore.setValue(n4, 1, (Object)"TABLE");
                TableIdentifier tableIdentifier = new TableIdentifier(null, string5, string6, false);
                tableIdentifier.setType("TABLE");
                tableIdentifier.setNeverAdjustCase(true);
                tableIdentifier.setComment(string7);
                tableIdentifier.getSourceOptions().setTypeModifier(TABLE_TYPE);
                tableIdentifier.getSourceOptions().setInitialized();
                dataStore.getRow(n4).setUserObject(tableIdentifier);
                ++n3;
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "temp tables", string4, string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return n3 > 0;
    }
}

