/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.DBID;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class DB2UniqueConstraintReader
implements UniqueConstraintReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        String string;
        String string2;
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        switch (DBID.fromConnection(wbConnection)) {
            case DB2_LUW: {
                stringBuilder.append("select indname, indschema, constname \n from ( \n  select ind.indname, ind.indschema, tc.constname \n  from syscat.indexes ind \n    join syscat.tabconst tc \n       on ind.tabschema = tc.tabschema \n      and ind.tabname = tc.tabname \n      and tc.constname = ind.indname \n  where type = 'U' \n) t \n where (");
                break;
            }
            case DB2_ZOS: {
                stringBuilder.append("select indname, indschema, constname \nfrom ( \n  select ind.name as indname, ind.creator as indschema, tc.constname  \n  from sysibm.sysindexes ind \n    join sysibm.systabconst tc \n       on ind.tbcreator = tc.tbcreator \n      and ind.tbname = tc.tbname \n      and tc.constname = ind.name \n  where type = 'U' \n ) t\n where (");
            }
            default: {
                return;
            }
        }
        boolean bl = true;
        int n = 0;
        for (IndexDefinition object2 : list) {
            if (!object2.isUnique() || object2.isPrimaryKeyIndex()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" OR ");
            }
            ++n;
            string2 = wbConnection.getMetadata().removeQuotes(object2.getSchema());
            string = wbConnection.getMetadata().removeQuotes(object2.getObjectName());
            stringBuilder.append(" (indname = '");
            stringBuilder.append(string);
            stringBuilder.append("' AND indschema = '");
            stringBuilder.append(string2);
            stringBuilder.append("') ");
        }
        stringBuilder.append(')');
        if (n == 0) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "unique constraints", stringBuilder, new Object[0]);
        Object object3 = null;
        ResultSet resultSet = null;
        try {
            object3 = wbConnection.createStatement();
            ResultSet resultSet2 = object3.executeQuery(stringBuilder.toString());
            while (resultSet2.next()) {
                string2 = resultSet2.getString(1).trim();
                string = resultSet2.getString(2).trim();
                String string3 = resultSet2.getString(3).trim();
                IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string2, string);
                if (indexDefinition == null) continue;
                ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string3);
                indexDefinition.setUniqueConstraint(constraintDefinition);
            }
            JdbcUtils.closeAll(resultSet2, (Statement)object3);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "unique constraints", stringBuilder, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, (Statement)object3);
        }
    }
}

